/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import esecurity.desktop.swt.Device;
import esecurity.desktop.swt.Event;
import esecurity.desktop.swt.Listener;
import esecurity.desktop.swt.Menu;
import esecurity.desktop.swt.Monitor;
import esecurity.desktop.swt.SWTClass;
import esecurity.desktop.swt.SWTFacade;
import esecurity.desktop.swt.Tray;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Display
extends Device {
    private static final Logger logger = LoggerFactory.getLogger(Display.class);

    public static Display getDefault() {
        try {
            Object disp = SWTClass.Display.getRef().callStaticMethod("getDefault", new Object[0]);
            return new Display(disp);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    public Display() {
        try {
            this.innerObject = SWTClass.Display.getRef();
            this.innerObject.init(new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Tray getSystemTray() {
        try {
            Object disp = this.innerObject.callMethod("getSystemTray", new Object[0]);
            return new Tray(disp);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    private Display(Object disp) {
        super(disp);
    }

    public boolean readAndDispatch() {
        try {
            return this.innerObject.callMethodAsBoolean("readAndDispatch", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public boolean sleep() {
        try {
            return this.innerObject.callMethodAsBoolean("sleep", new Object[0]);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return false;
        }
    }

    public void syncExec(Runnable runnable) {
        try {
            this.innerObject.callMethod("syncExec", runnable);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public void asyncExec(Runnable runnable) {
        try {
            this.innerObject.callMethod("asyncExec", runnable);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Monitor getPrimaryMonitor() {
        try {
            Object disp = this.innerObject.callMethod("getPrimaryMonitor", new Object[0]);
            return new Monitor(disp);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }

    public Monitor[] getMonitors() {
        Monitor[] ret;
        try {
            Object[] disp = (Object[])this.innerObject.callMethod("getMonitors", new Object[0]);
            ret = new Monitor[disp.length];
            for (int i = 0; i < disp.length; ++i) {
                ret[i] = new Monitor(disp[i]);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
        return ret;
    }

    public void addFilter(int eventType, Listener listener) {
        try {
            Object p = Proxy.newProxyInstance(SWTFacade.getClassLoader(), new Class[]{SWTClass.Listener.getClss()}, (proxy, method, args) -> {
                logger.debug("Filter  -> " + method.getName());
                listener.handleEvent(new Event(args[0]));
                return null;
            });
            this.innerObject.callMethod("addFilter", eventType, p);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    public Menu getSystemMenu() {
        try {
            Object disp = this.innerObject.callMethod("getSystemMenu", new Object[0]);
            return new Menu(disp);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            return null;
        }
    }
}

