/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;

public class TextInput
extends DOMElement {
    public TextInput(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            TextInput.createElementWithID("input", id, view);
            this.setAttribute("type", "text");
        }
    }

    public TextInput(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("input", id, parentId);
        this.setAttribute("type", "text");
    }

    public TextInput(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("input", id, parent.getId());
        this.setAttribute("type", "text");
    }

    public static TextInput retrieveTextInput(String id, View view) {
        return TextInput.getElementById(id, view);
    }

    public void setText(String text) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + text.length() + 12).append((CharSequence)this.jsToEvaluateElement).append(".value=\"").append(JsUtils.escapeJs(text)).append("\";").toString());
    }

    public String getText() {
        StringBuilder evalueteJsElement = new StringBuilder(this.jsToEvaluateElement.length() + 6).append((CharSequence)this.jsToEvaluateElement).append(".value");
        if (this.isElementPresent(evalueteJsElement.toString())) {
            String value = (String)this.view.evaluate(new StringBuilder(evalueteJsElement.length() + 7).append("return ").append((CharSequence)evalueteJsElement).toString());
            return value == null ? "" : value;
        }
        return "";
    }

    public static TextInput getElementById(String id, View currentView) {
        if (TextInput.exist(id, currentView)) {
            return new TextInput(id, currentView, false);
        }
        return null;
    }

    public void setPlaceholderText(String placeholderText) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + placeholderText.length() + 18).append((CharSequence)this.jsToEvaluateElement).append(".placeholder=\"").append(JsUtils.escapeJs(placeholderText)).append("\";").toString());
    }
}

