/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cache;

import esecurity.dsd.client.cache.CacheProvider;
import esecurity.dsd.core.Domain;
import esecurity.dsd.core.Log;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.http.RESTClient;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

public class CacheUpdater
implements Runnable {
    private CacheProvider instance = null;
    static int execution = 0;

    public CacheUpdater(CacheProvider provider) {
        this.instance = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        CacheUpdater cacheUpdater = this;
        synchronized (cacheUpdater) {
            LinkedHashMap map = new LinkedHashMap();
            Log.logger().info("Cache update");
            Set<String> availableDomains = this.instance.availableDomains();
            if (availableDomains.isEmpty()) {
                return;
            }
            availableDomains.forEach(s -> {
                Queue cfr_ignored_0 = map.putIfAbsent(s, new LinkedList<CacheProvider.Server>(Arrays.asList(CacheProvider.Server.values())));
            });
            for (String domainName : availableDomains) {
                CacheProvider.Server domainServer;
                boolean success = false;
                while ((domainServer = (CacheProvider.Server)((Object)((Queue)map.get(domainName)).poll())) != null && !success) {
                    String domainNameOut = "[".concat(domainName).concat("] ");
                    Object ttlValue = this.instance.getDomainProperties(domainName).getValue("ttl");
                    int ttl = 0;
                    try {
                        ttl = Integer.valueOf(ttlValue.toString());
                    }
                    catch (Throwable t) {
                        ttl = 0;
                    }
                    if (execution >= 1 && ttl >= 1 && execution % ttl != 0) continue;
                    Domain domainProperties = Domain.empty((String)domainName);
                    Log.logger().debug(domainNameOut.concat(" Try Server " + domainServer.name()));
                    try {
                        domainProperties = this.instance.getRemoteProvider(domainServer).getDomainProperties(domainName);
                        Log.logger().debug(domainNameOut.concat(domainServer.name() + "  keys: ").concat(domainProperties.keySet().stream().collect(Collectors.joining(","))));
                        if (!domainProperties.keySet().isEmpty()) {
                            Log.logger().debug("fill cache with keys: ".concat("[".concat(domainProperties.keySet().stream().collect(Collectors.joining(",")).concat("]"))));
                            if (domainProperties.getValue("ttl") == null) {
                                domainProperties.setValue("ttl", (Object)1440);
                            }
                            this.instance.cacheUpdate(CacheProvider.CacheType.PROVIDED, domainName, (PropertyContainer)domainProperties);
                        }
                        success = true;
                    }
                    catch (RESTClient.NotFoundException e404) {
                        Log.logger().warn(domainNameOut.concat(" Not found in ").concat(domainServer.name()));
                    }
                    catch (Exception e1) {
                        Log.logger().error(domainNameOut.concat(domainServer.name() + " Error: '").concat(e1.getMessage()).concat("' cause: '").concat(e1.getCause() != null ? e1.getCause().getMessage() : "").concat("'"), (Throwable)e1);
                    }
                }
            }
            this.instance.dump();
        }
    }

    public void updateDomain(String domain) {
        CacheProvider.Server domainServer;
        Set<String> availableDomains = this.instance.availableDomains();
        if (availableDomains.isEmpty() || !availableDomains.contains(domain)) {
            return;
        }
        LinkedList<CacheProvider.Server> servers = new LinkedList<CacheProvider.Server>(Arrays.asList(CacheProvider.Server.values()));
        boolean success = false;
        while ((domainServer = (CacheProvider.Server)((Object)servers.poll())) != null && !success) {
            String domainNameOut = "[".concat(domain).concat("] ");
            Domain domainProperties = Domain.empty((String)domain);
            Log.logger().debug(domainNameOut.concat(" Try Server " + domainServer.name()));
            try {
                domainProperties = this.instance.getRemoteProvider(domainServer).getDomainProperties(domain);
                Log.logger().debug(domainNameOut.concat(domainServer.name() + "  keys: ").concat(domainProperties.keySet().stream().collect(Collectors.joining(","))));
                if (!domainProperties.keySet().isEmpty()) {
                    Log.logger().debug("fill cache with keys: ".concat("[".concat(domainProperties.keySet().stream().collect(Collectors.joining(",")).concat("]"))));
                    if (domainProperties.getValue("ttl") == null) {
                        domainProperties.setValue("ttl", (Object)1440);
                    }
                    this.instance.cacheUpdate(CacheProvider.CacheType.PROVIDED, domain, (PropertyContainer)domainProperties);
                }
                success = true;
            }
            catch (RESTClient.NotFoundException e404) {
                Log.logger().warn(domainNameOut.concat(" Not found in ").concat(domainServer.name()));
            }
            catch (Exception e1) {
                Log.logger().error(domainNameOut.concat(domainServer.name() + " Error: '").concat(e1.getMessage()).concat("' cause: '").concat(e1.getCause() != null ? e1.getCause().getMessage() : "").concat("'"), (Throwable)e1);
            }
        }
    }

    @Override
    public void run() {
        ++execution;
        execution %= 1440;
        this.update();
    }
}

