/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client.cache;

import esecurity.dsd.client.DomainConfigProvider;
import esecurity.dsd.client.cache.CacheUpdater;
import esecurity.dsd.client.config.RemoteConfigProvider;
import esecurity.dsd.core.ConfigurationMap;
import esecurity.dsd.core.Domain;
import esecurity.dsd.core.DomainProvider;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.Log;
import esecurity.dsd.core.PropertyContainer;
import esecurity.dsd.core.http.DomainHTTPProvider;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CacheProvider
extends Observable
implements DomainProvider {
    private static final String CACHE_UPDATER_JOB_KEY = "cacheUpdater";
    private static final String CACHE_UPDATER_TRIGGER = "updateCacheTrigger";
    public static final String CONTEXT_INSTANCE_CACHE = "cache";
    private CachePool pool = new CachePool();
    private EnumMap<Server, DomainHTTPProvider> remoteProviders = new EnumMap(Server.class);
    private ScheduledExecutorService scheduler = null;

    public Cache getCache(CacheType type, String domain) {
        return this.pool.of(domain, type);
    }

    public DomainHTTPProvider getRemoteProvider(Server servertype) {
        return this.remoteProviders.get((Object)servertype);
    }

    public CacheProvider(List<String> defaultDomains, LocalConfigurationProvider ... configurators) throws Exception {
        List<DomainConfigProvider> domains = Stream.of(configurators).filter(c -> c instanceof DomainConfigProvider).map(c -> (DomainConfigProvider)c).collect(Collectors.toList());
        List remotes = Stream.of(configurators).filter(c -> c instanceof RemoteConfigProvider).map(c -> (RemoteConfigProvider)c).collect(Collectors.toList());
        if (remotes.size() < 2) {
            throw new IllegalArgumentException("Invalid remote configuration. " + remotes.size() + " remotes. Must be almost 2.");
        }
        Collections.sort(remotes);
        DomainHTTPProvider dsn1 = new DomainHTTPProvider((LocalConfigurationProvider)remotes.get(0));
        DomainHTTPProvider dsn2 = new DomainHTTPProvider((LocalConfigurationProvider)remotes.get(1));
        this.remoteProviders.put(Server.DSN1, dsn1);
        this.remoteProviders.put(Server.DSN2, dsn2);
        try {
            Set domainsSet = dsn1.availableDomains();
            if (defaultDomains != null && !defaultDomains.isEmpty()) {
                domainsSet = domainsSet.stream().filter(domain -> defaultDomains.contains(domain)).collect(Collectors.toSet());
            }
            for (String domain2 : domainsSet) {
                this.pool.createDomainIfNotExists(domain2);
            }
        }
        catch (Throwable t) {
            Set domainsSet = dsn2.availableDomains();
            if (defaultDomains != null && !defaultDomains.isEmpty()) {
                domainsSet = domainsSet.stream().filter(domain -> defaultDomains.contains(domain)).collect(Collectors.toSet());
            }
            for (String domain3 : domainsSet) {
                this.pool.createDomainIfNotExists(domain3);
            }
        }
        domains.forEach(this::addDomainProvider);
        this.dump();
    }

    public void addDomain(String domain) {
        this.pool.createDomainIfNotExists(domain);
    }

    private void addDomainProvider(DomainConfigProvider provider) {
        if (provider != null && !this.pool.domains().contains(provider.getDomain())) {
            PropertyContainer configuration = provider.getProvidedConfiguration();
            this.pool.createDomainIfNotExists(provider.getDomain());
            configuration.keySet().forEach(key -> {
                if (provider.getDefaultProvidedKeys().contains(key)) {
                    this.getCache(CacheType.LOCAL_DEFAULT, provider.getDomain()).put((String)key, configuration.getValue(key));
                } else {
                    this.getCache(CacheType.PROVIDED, provider.getDomain()).put((String)key, configuration.getValue(key));
                }
            });
        }
    }

    public Map<String, Object> lookup(String domainName, String ... _keys) {
        Set<String> notInCache;
        ConfigurationMap result = null;
        Set<String> keys = Stream.of(_keys).collect(Collectors.toSet());
        result = new ConfigurationMap();
        if (!this.pool.has(domainName)) {
            this.addDomainProvider(DomainConfigProvider.setup(domainName).build());
        }
        if (!(notInCache = this.getCache(CacheType.LOCAL_DEFAULT, domainName).extract(keys, (PropertyContainer)result)).isEmpty()) {
            notInCache = this.getCache(CacheType.PROVIDED, domainName).extract(notInCache, (PropertyContainer)result);
        }
        return result.getMap();
    }

    public Set<String> availableDomains() {
        return this.pool.domains();
    }

    public PropertyContainer getDomainProperties(String domainName) {
        if (!this.pool.has(domainName)) {
            this.addDomainProvider(DomainConfigProvider.setup(domainName).build());
        }
        HashMap map = new HashMap(this.getCache(CacheType.PROVIDED, domainName).cache);
        this.getCache(CacheType.LOCAL_DEFAULT, domainName).cache.forEach(map::put);
        return new ConfigurationMap(map);
    }

    public void installCacheUpdaterJob(ScheduledExecutorService schedulerExec) throws SecurityException {
        Log.logger().info("Install ScheduledExecutorService.");
        if (schedulerExec != null) {
            this.scheduler = schedulerExec;
            CacheUpdater cacheUpdater = new CacheUpdater(this);
            cacheUpdater.update();
            this.scheduler.scheduleAtFixedRate(cacheUpdater, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    public void dump() {
        this.availableDomains().forEach(domain -> {
            Log.logger().debug("dump domain [".concat((String)domain).concat("]"));
            PropertyContainer dp = this.getDomainProperties((String)domain);
            dp.keySet().forEach(k -> Log.logger().debug("Property: ".concat((String)k).concat(" : '").concat(dp.getValue(k).toString()).concat("'")));
            Log.logger().debug("----");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheUpdate(CacheType provided, String domainName, PropertyContainer domainProperties) {
        Log.logger().info("Update cache for domain ".concat(domainName));
        Cache cache = this.getCache(CacheType.PROVIDED, domainName);
        CacheProvider cacheProvider = this;
        synchronized (cacheProvider) {
            cache.fill(domainProperties);
        }
        this.setChanged();
        Log.logger().info("Notify observers ... ".concat(LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME)));
        this.notifyObservers(new Domain(domainName, domainProperties));
    }

    public void destroy() {
        if (this.scheduler != null && !this.scheduler.isTerminated() && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    static enum Server {
        DSN1,
        DSN2;

    }

    public static class CachePool {
        private Map<String, EnumMap<CacheType, Cache>> pool = new LinkedHashMap<String, EnumMap<CacheType, Cache>>();

        public Cache of(String domain, CacheType type) {
            this.createDomainIfNotExists(domain);
            return this.pool.get(domain).get((Object)type);
        }

        public void createDomainIfNotExists(String domain) {
            if (!this.pool.containsKey(domain)) {
                EnumMap<CacheType, Cache> cache = new EnumMap<CacheType, Cache>(CacheType.class);
                cache.put(CacheType.LOCAL_DEFAULT, new Cache());
                cache.put(CacheType.PROVIDED, new Cache());
                this.pool.put(domain, cache);
            }
        }

        public boolean has(String domain) {
            return this.pool.containsKey(domain);
        }

        public Set<String> domains() {
            return this.pool.keySet();
        }

        public Optional<Cache> findDefaults(String key) {
            return this.pool.values().stream().filter(cache -> ((Cache)cache.get((Object)CacheType.LOCAL_DEFAULT)).has(key)).map(e -> (Cache)e.get((Object)CacheType.LOCAL_DEFAULT)).findFirst();
        }
    }

    static enum CacheType {
        LOCAL_DEFAULT,
        PROVIDED;

    }

    public static class Cache {
        private Map<String, Object> cache = new LinkedHashMap<String, Object>();

        public void fill(Map<String, Object> map) {
            this.cache.putAll(map);
        }

        public void fill(PropertyContainer container) {
            container.keySet().forEach(key -> this.cache.put((String)key, container.getValue(key)));
        }

        public void put(String key, Object value) {
            this.cache.put(key, value);
        }

        public Optional<Object> get(String key) {
            Object v = null;
            if (this.cache.containsKey(key)) {
                v = this.cache.get(key);
            }
            return Optional.ofNullable(v);
        }

        public boolean has(String key) {
            return this.cache.containsKey(key);
        }

        public Set<String> extract(Set<String> keys, PropertyContainer result) {
            if (keys != null) {
                return keys.stream().filter(key -> {
                    boolean canBeAdded = this.cache.containsKey(key);
                    if (canBeAdded) {
                        result.setValue(key, this.cache.get(key));
                    }
                    return !canBeAdded;
                }).collect(Collectors.toSet());
            }
            return Collections.EMPTY_SET;
        }
    }
}

