/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider;

import it.actalis.ellips.capi.http.arubautils.provider.MultipartWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;

public class HttpURLConnectionMultipartWrapper
extends MultipartWrapper {
    private HttpURLConnection conn = null;
    private String boundary = null;
    protected OutputStream output = null;
    private PrintWriter multipartWriter = null;

    private OutputStream getOutput() throws IOException {
        if (this.output == null) {
            this.initOverallMultipart();
        }
        return this.output;
    }

    private PrintWriter getMultipartWriter() throws IOException {
        if (this.multipartWriter == null) {
            this.multipartWriter = new PrintWriter((Writer)new OutputStreamWriter(this.getOutput()), true);
        }
        return this.multipartWriter;
    }

    public HttpURLConnectionMultipartWrapper(HttpURLConnection conn) throws ProtocolException {
        this.conn = conn;
    }

    @Override
    protected void innerInitOverallMultipart() throws IOException {
        this.boundary = "----------------" + Long.toHexString(System.currentTimeMillis());
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.conn.setRequestProperty("Connection", "Keep-Alive");
        this.conn.setRequestProperty("Cache-Control", "no-cache");
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        this.output = this.conn.getOutputStream();
    }

    @Override
    protected OutputStream innerAddMultipartBinarySection(String name, String filename) throws IOException {
        this.output.flush();
        PrintWriter mw = this.getMultipartWriter();
        mw.append("--" + this.boundary).append("\r\n");
        mw.append("Content-Disposition: form-data; name=\"" + name + "\";");
        if (filename != null && !filename.isEmpty()) {
            mw.append(" filename=\"" + filename + "\"");
        }
        mw.append("\r\n");
        mw.append("Content-Type: application/octet-stream").append("\r\n");
        mw.append("Content-Transfer-Encoding: binary").append("\r\n");
        mw.append("\r\n").flush();
        return this.getOutput();
    }

    @Override
    protected void innerFinalizeMultipartSection() throws IOException {
        this.output.flush();
        PrintWriter mw = this.getMultipartWriter();
        mw.append("\r\n").flush();
    }

    @Override
    public void innerFinalizeOverallMultipart() throws IOException {
        this.output.flush();
        PrintWriter mw = this.getMultipartWriter();
        mw.append("--" + this.boundary + "--").append("\r\n").flush();
        mw.close();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.conn.getResponseCode();
    }

    @Override
    protected void innerFinalizeRequestExecution() throws IOException {
        this.output.flush();
        this.output.close();
    }

    @Override
    public InputStream innerGetResponseInputStream() throws IOException {
        return this.conn.getInputStream();
    }
}

