/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import org.slf4j.Logger;

public class TSLUtils {
    public static String extendedNationId(String string) {
        if (string.equalsIgnoreCase("at")) {
            return "Austria";
        }
        if (string.equalsIgnoreCase("be")) {
            return "Belgium";
        }
        if (string.equalsIgnoreCase("bg")) {
            return "Bulgaria";
        }
        if (string.equalsIgnoreCase("cy")) {
            return "Cyprus";
        }
        if (string.equalsIgnoreCase("cz")) {
            return "Czech Republic";
        }
        if (string.equalsIgnoreCase("de")) {
            return "Germany";
        }
        if (string.equalsIgnoreCase("dk")) {
            return "Denmark";
        }
        if (string.equalsIgnoreCase("ee")) {
            return "Estonia";
        }
        if (string.equalsIgnoreCase("gr")) {
            return "Greece";
        }
        if (string.equalsIgnoreCase("es")) {
            return "Spain";
        }
        if (string.equalsIgnoreCase("fi")) {
            return "Finland";
        }
        if (string.equalsIgnoreCase("fr")) {
            return "France";
        }
        if (string.equalsIgnoreCase("hr")) {
            return "Croatia";
        }
        if (string.equalsIgnoreCase("hu")) {
            return "Hungary";
        }
        if (string.equalsIgnoreCase("ie")) {
            return "Ireland";
        }
        if (string.equalsIgnoreCase("is")) {
            return "Iceland";
        }
        if (string.equalsIgnoreCase("it")) {
            return "Italy";
        }
        if (string.equalsIgnoreCase("li")) {
            return "Liechtenstein";
        }
        if (string.equalsIgnoreCase("lt")) {
            return "Lettonia";
        }
        if (string.equalsIgnoreCase("lu")) {
            return "Luxembourg";
        }
        if (string.equalsIgnoreCase("lv")) {
            return "Latvia";
        }
        if (string.equalsIgnoreCase("mt")) {
            return "Malta";
        }
        if (string.equalsIgnoreCase("nl")) {
            return "Netherlands";
        }
        if (string.equalsIgnoreCase("no")) {
            return "Norway";
        }
        if (string.equalsIgnoreCase("pl")) {
            return "Poland";
        }
        if (string.equalsIgnoreCase("pt")) {
            return "Portugal";
        }
        if (string.equalsIgnoreCase("ro")) {
            return "Romania";
        }
        if (string.equalsIgnoreCase("se")) {
            return "Sweden";
        }
        if (string.equalsIgnoreCase("si")) {
            return "Slovenia";
        }
        if (string.equalsIgnoreCase("sk")) {
            return "Slovakia";
        }
        if (string.equalsIgnoreCase("org") || string.equalsIgnoreCase("uk")) {
            return "United Kingdom";
        }
        return "European Community";
    }

    public static String getNationalityFromUrl(String object) {
        if (Util.isNullOrEmpty((String)object)) {
            return "";
        }
        object = object.replace("http://", "");
        if ((object = object.replace("https://", "")).contains("UK_TSL")) {
            return "uk";
        }
        if (((String[])(object = object.split("/"))).length <= 0) {
            return "";
        }
        object = object[0];
        if (((String[])(object = object.split("\\."))).length <= 0) {
            return "";
        }
        return object[((String[])object).length - 1];
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int listDBCertificates(CertDB certDB, String object, Logger logger) throws CertDBException, IOException {
        int n;
        block17: {
            if (logger != null) {
                logger.info("exporting cdb to text file...");
            }
            OutputStreamWriter outputStreamWriter = null;
            try {
                boolean bl = true;
                if (((String)object).isEmpty()) {
                    bl = false;
                }
                if (((File)(object = new File((String)object))).exists()) {
                    ((File)object).delete();
                }
                ((File)object).createNewFile();
                if (!((File)object).exists() || !((File)object).canWrite()) {
                    bl = false;
                }
                CertDBItem[] certDBItemArray = certDB.list(4);
                CertDBItem[] certDBItemArray2 = certDB.list(2);
                CertDBItem[] certDBItemArray3 = certDB.list(1);
                n = 0 + certDBItemArray.length;
                n += certDBItemArray2.length;
                n += certDBItemArray3.length;
                if (bl) {
                    int n2;
                    outputStreamWriter = new FileWriter(((File)object).getAbsoluteFile(), true);
                    outputStreamWriter.write("\n------------------------\nCERTIFICATE INTO DATABASE\n------------------------\n");
                    outputStreamWriter.write("\nROOT CA (" + String.format("%d", certDBItemArray.length) + ")");
                    outputStreamWriter.write("\nINTERMEDIATE CA (" + String.format("%d", certDBItemArray2.length) + ")");
                    outputStreamWriter.write("\nOTHERS (" + String.format("%d", certDBItemArray3.length) + ")");
                    outputStreamWriter.write("\n\nTOTAL CERTIFICATES: " + String.format("%d", n));
                    outputStreamWriter.write("\n//////////////////////////////////////////////////////////////////// ROOT CA:\n");
                    for (n2 = 0; n2 < certDBItemArray.length; ++n2) {
                        outputStreamWriter.write("\t" + String.format("%d", certDBItemArray[n2].getID()) + " " + certDBItemArray[n2].getName() + "\n\t" + certDBItemArray[n2].getSubject() + "\n\n");
                    }
                    outputStreamWriter.write("\n//////////////////////////////////////////////////////////////////// INTERMEDIATE CA:\n");
                    for (n2 = 0; n2 < certDBItemArray2.length; ++n2) {
                        outputStreamWriter.write("\t" + String.format("%d", certDBItemArray2[n2].getID()) + " " + certDBItemArray2[n2].getName() + "\n\t" + certDBItemArray2[n2].getSubject() + "\n\n");
                    }
                    outputStreamWriter.write("\n//////////////////////////////////////////////////////////////////// OTHERS:\n");
                    for (n2 = 0; n2 < certDBItemArray3.length; ++n2) {
                        outputStreamWriter.write("\t" + String.format("%d", certDBItemArray3[n2].getID()) + " " + certDBItemArray3[n2].getName() + "\n\t" + certDBItemArray3[n2].getSubject() + "\n\n");
                    }
                    outputStreamWriter.close();
                }
                if (outputStreamWriter == null) break block17;
            }
            catch (CertDBException certDBException) {
                try {
                    if (logger == null) throw certDBException;
                    logger.error(certDBException.getMessage(), (Throwable)certDBException);
                    throw certDBException;
                    catch (IOException iOException) {
                        if (logger == null) throw iOException;
                        logger.error(iOException.getMessage(), (Throwable)iOException);
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    if (outputStreamWriter == null) throw throwable;
                    try {
                        outputStreamWriter.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                outputStreamWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (logger == null) return n;
        logger.info(n + " certificates exported");
        return n;
    }

    public static Date getLastTSLModifiedDate(String object, NetworkConfig networkConfig, Logger logger) {
        try {
            networkConfig = new UrlClient(networkConfig, logger);
            object = networkConfig.getLastModifiedDate((String)object, null);
            if (((Date)object).compareTo(new Date(0L)) == 0) {
                return null;
            }
            return object;
        }
        catch (Exception exception) {
            if (logger != null) {
                logger.error(exception.getMessage(), (Throwable)exception);
            }
            return null;
        }
    }
}

