/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBUtils;
import it.actalis.ellips.capi.certdb.a;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniSerializableObject;
import it.actalis.vol.utils.Constants;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class CertDBItem
implements IniSerializableObject,
Comparable {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final boolean b = "true".equals(System.getProperty("capi.certdb.verbose", "true"));
    public static final int UNKNOWN = 0;
    public static final int END_ENTITY = 1;
    public static final int INTERMEDIATE_CA = 2;
    public static final int ROOT_CA = 4;
    public static final int ALL_CA = 6;
    public static final int ALL = 7;
    public static final int SUSPECT = 8;
    public static final int TRUSTED = 2;
    public static final int INHERIT = 1;
    public static final int UNTRUSTED = 0;
    public static final int ONLY_SIGN = 1;
    public static final int SIGN = 2;
    public static final int ONLY_CIPH = 4;
    public static final int CIPH = 8;
    public static final int GENERIC = 16;
    public static final int OTHER = 32;
    public static final int ONLY_OTHER = 64;
    public static final int ALL_USAGE_TYPE = 127;
    public static final int SOURCE_TYPE_SYSTEM = 0;
    public static final int SOURCE_TYPE_TSL = 1;
    public static final int SOURCE_TYPE_USER = 2;
    public static final int SOURCE_TYPE_UNKNOWN = 3;
    public static final int SOURCE_TYPE_CAISSUER = 4;
    public static final int SOURCE_TYPE_PRETSL_CAISSUER = 5;
    public static final int SOURCE_TYPE_SIGNER_CERTIFICATE = 6;
    public static final List<Integer> SOURCES_IN_CDB = Arrays.asList(0, 1, 2, 5, 3);
    public static final List<Integer> SOURCES_EXTRA_CDB = Arrays.asList(4, 6);
    public static final List<Integer> SOURCES_TRUSTED = Arrays.asList(0, 1, 2);
    private HashMap<String, Object> c = new HashMap();
    private String d = null;
    private CertDB e = null;
    private byte[] f = null;
    private String g = null;
    private String h = null;
    private String i = null;
    private boolean j = false;
    private String k = "";
    private int l = 3;
    private List<EllipsUsage> m = new ArrayList<EllipsUsage>();
    private boolean n = false;
    public static final String LBL_CERT = "cert";
    public static final String LBL_TYPE = "type";
    public static final String LBL_NAME_UTF = "name.utf";
    public static final String LBL_NAME = "name";
    public static final String LBL_SUBJ = "subj";
    public static final String LBL_ISS = "iss";
    public static final String LBL_USAGE = "usage";
    public static final String LBL_STATUS = "status";
    public static final String LBL_SOURCE = "source";
    public static final String LBL_ELLIPS_USAGES = "ellipsUsages";
    public static final String LBL_TRUST = "trust";
    public static final String LBL_TSLID = "tsl";
    public static final String LBL_REVOKED = "revoked";

    public CertDBItem() {
        this.c = new HashMap();
    }

    public CertDBItem(String string, byte[] byArray) throws CertDBException, CapiException {
        this.a(string, byArray, 2, null);
    }

    public CertDBItem(String string, byte[] byArray, List<EllipsUsage> list) throws CertDBException, CapiException {
        this.a(string, byArray, 2, list);
    }

    private void a(String object, byte[] byArray, int n, List<EllipsUsage> list) throws CapiException {
        if (b) {
            a.debug("Creating a new certDBItem");
        }
        this.d = object;
        this.c = new HashMap();
        this.l = n;
        this.m = new ArrayList<EllipsUsage>();
        object = new Certificate(byArray, b);
        try {
            this.f = ((Certificate)object).getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CapiException("Certificate format unknown or not implemented", 30002, certificateEncodingException);
        }
        this.g = ((Certificate)object).getName();
        this.h = CertDBUtils.getSubjectFromCert((Certificate)object, b);
        this.i = CertDBUtils.getIssuerFromCert((Certificate)object);
        int n2 = CertDBItem.a((Certificate)object);
        this.c.put(LBL_TYPE, Integer.valueOf(n2).toString());
        switch (n2) {
            case 4: {
                this.c.put(LBL_TRUST, Integer.valueOf(2).toString());
                break;
            }
            case 1: 
            case 2: {
                this.c.put(LBL_TRUST, Integer.valueOf(1).toString());
                break;
            }
            default: {
                this.c.put(LBL_TRUST, Integer.valueOf(0).toString());
            }
        }
        if (b) {
            a.debug("evaluating usage value ...");
        }
        n2 = this.a();
        this.c.put(LBL_USAGE, Integer.toString(n2));
        if (b) {
            a.debug("setting usage value to {}", (Object)n2);
        }
        if (list != null) {
            this.m = list;
        } else if ((n2 & 3) == 0) {
            this.addEllipsUsage(EllipsUsage.FEA_SIGNATURE);
        }
        this.c.put(LBL_STATUS, "");
        if (b) {
            a.debug("Created {} with type={} trust={}", new Object[]{this.g, this.getTypeAsString(), this.getTrustAsString()});
        }
    }

    public byte[] getCert(boolean bl) {
        if (bl) {
            return this.f;
        }
        return Base64.encode((byte[])this.f);
    }

    public Certificate getCertificate() throws CapiException {
        byte[] byArray = this.getCert(false);
        return new Certificate(byArray, b);
    }

    public int compareTo(Object object) {
        return this.compareTo((CertDBItem)object);
    }

    public int compareTo(CertDBItem object) {
        object = ((CertDBItem)object).getName();
        String string = this.getName();
        return string.compareTo((String)object);
    }

    public String getName() {
        return this.g;
    }

    public void setName(String string) throws CertDBException {
        this.g = string;
    }

    public String getSubject() {
        return this.h;
    }

    public void setSubjectAndIssuer(Certificate certificate) throws CertDBException {
        this.h = CertDBUtils.getSubjectFromCert(certificate, b);
        this.i = CertDBUtils.getIssuerFromCert(certificate);
    }

    public String getIssuer() {
        return this.i;
    }

    public int getType() throws CertDBException {
        String string = (String)this.c.get(LBL_TYPE);
        if (string == null) {
            throw new CertDBException("Null type", 80000);
        }
        return Integer.parseInt(string);
    }

    public String getTypeAsString() throws CertDBException {
        int n = this.getType();
        switch (n) {
            case 1: {
                return "END_ENTITY";
            }
            case 2: {
                return "INTERMEDIATE_CA";
            }
            case 4: {
                return "ROOT_CA";
            }
            case 8: {
                return "SUSPECT";
            }
        }
        return "UNKNOWN";
    }

    public void setType(int n) throws CertDBException {
        switch (n) {
            case 0: {
                throw new CertDBException("Unknown type not allowed", 80012);
            }
            case 8: {
                throw new CertDBException("CA altered type not allowed", 80008);
            }
            default: {
                throw new CertDBException("Wrong type", 1002);
            }
            case 1: 
            case 2: 
            case 4: 
        }
        if (b) {
            a.debug("Change type to {}", (Object)n);
        }
        this.c.put(LBL_TYPE, Integer.valueOf(n).toString());
    }

    public int guessType() throws CertDBException, CapiException {
        Certificate certificate = new Certificate(this.getCert(false), b);
        return CertDBItem.a(certificate);
    }

    private static int a(Certificate certificate) throws CertDBException, CapiException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (certificate.getBasicConstraints() || (certificate.getKeyUsageBits() & 0x20) > 0) {
            if (b) {
                a.debug("guessType: CA extensions found ");
            }
            bl = true;
        }
        if (certificate.getSubjectDN().equals(certificate.getIssuerDN())) {
            bl2 = true;
            try {
                certificate.getInternalCert().verify(certificate.getInternalCert().getPublicKey());
                bl3 = true;
            }
            catch (Exception exception) {}
        }
        if (bl) {
            if (bl2) {
                if (bl3) {
                    if (b) {
                        a.debug("guessType: cert with CA extensions and self signed, type=ROOT_CA");
                    }
                    return 4;
                }
                if (b) {
                    a.debug("guessType: cert with CA extensions and same subject&issuer NOT self signed, type=SUSPECT");
                }
                return 8;
            }
            if (b) {
                a.debug("guessType: cert with CA extensions and NOT self signed, type=INTERMEDIATE_CA");
            }
            return 2;
        }
        if (bl2) {
            if (bl3) {
                if (b) {
                    a.debug("guessType: cert without CA extensions and self signed, type=UNKNOWN");
                }
                return 0;
            }
            if (b) {
                a.debug("guessType: cert without CA extensions and same subject&issuer NOT self signed, type=UNKNOWN");
            }
            return 0;
        }
        if (b) {
            a.debug("guessType: cert without CA extensions and NOT self signed, type=END_ENTITY");
        }
        return 1;
    }

    public int getTrust() throws CertDBException {
        String string = (String)this.c.get(LBL_TRUST);
        if (string == null) {
            throw new CertDBException("Null trust", 80000);
        }
        return Integer.parseInt(string);
    }

    public String getTrustAsString() throws CertDBException {
        int n = this.getTrust();
        switch (n) {
            case 2: {
                return "TRUSTED";
            }
            case 1: {
                return "INHERIT";
            }
            case 0: {
                return "UNTRUSTED";
            }
        }
        return "UNKNOWN";
    }

    public void setTrust(int n) throws CertDBException {
        if (n < 0 || n > 2) {
            throw new CertDBException("Wrong trust value", 1002);
        }
        if (n == 1) {
            boolean bl = false;
            try {
                Certificate certificate = this.getCertificate();
                if (certificate.getSubjectDN().equals(certificate.getIssuerDN())) {
                    Certificate certificate2 = certificate;
                    certificate2.verify(Util.getBytes(certificate2.getEncoded()));
                    bl = true;
                }
            }
            catch (Exception exception) {}
            if (bl) {
                throw new CertDBException("Cannot set INHERIT trust to self-signed certs", 80009);
            }
        }
        if (b) {
            a.debug("Change trust to {}", (Object)n);
        }
        this.c.put(LBL_TRUST, Integer.valueOf(n).toString());
    }

    public void setRevoked(boolean bl) {
        if (bl) {
            this.c.put(LBL_REVOKED, "1");
            return;
        }
        this.c.remove(LBL_REVOKED);
    }

    public boolean isRevoked() {
        block3: {
            try {
                String string = (String)this.c.get(LBL_REVOKED);
                if (string.equals("1")) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!b) break block3;
                a.debug(exception.getMessage(), (Throwable)exception);
            }
        }
        return false;
    }

    public int getUsage() throws CertDBException {
        String string;
        block5: {
            string = (String)this.c.get(LBL_USAGE);
            try {
                if (string == null || string.equals("")) {
                    if (b) {
                        a.debug("evaluating usage value ...");
                    }
                    int n = this.a();
                    if (b) {
                        a.debug("setting usage value to {}", (Object)n);
                    }
                    string = Integer.valueOf(n).toString();
                    this.n = true;
                }
                this.c.put(LBL_USAGE, string);
            }
            catch (Exception exception) {
                if (!b) break block5;
                a.debug(exception.getMessage(), (Throwable)exception);
            }
        }
        return Integer.parseInt(string);
    }

    public String getUsageAsString() throws CertDBException {
        int n = this.getUsage();
        switch (n) {
            case 1: {
                return "ONLY_SIGN";
            }
            case 2: {
                return "SIGN";
            }
            case 4: {
                return "ONLY_CIPH";
            }
            case 8: {
                return "CIPH";
            }
            case 16: {
                return "GENERIC";
            }
            case 64: {
                return "ONLY_OTHER";
            }
            case 32: {
                return "OTHER";
            }
        }
        return "USAGE UNKNOWN";
    }

    public String getSourceAsString() {
        switch (this.l) {
            case 0: {
                return "system";
            }
            case 1: {
                return "TSL";
            }
            case 3: {
                return "unknown";
            }
            case 2: {
                return "user";
            }
            case 4: {
                return "caIssuer";
            }
            case 5: {
                return "preCAIssuer";
            }
            case 6: {
                return "signerCertificate";
            }
        }
        return "";
    }

    public boolean updateKeyUsage() {
        return this.n;
    }

    final void a(String string) {
        this.d = string;
    }

    @Override
    public String getID() {
        return this.d;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int a() throws CertDBException, CapiException {
        int n;
        String string;
        String string2;
        String string3;
        String[] stringArray;
        boolean bl;
        boolean bl2;
        block63: {
            block70: {
                block69: {
                    block66: {
                        block64: {
                            int n2;
                            int n3;
                            Certificate certificate;
                            block67: {
                                block68: {
                                    block65: {
                                        certificate = new Certificate(this.getCert(false), b);
                                        bl2 = certificate.isCritical(X509Extension.keyUsage.getId());
                                        n3 = certificate.getKeyUsage();
                                        if (b) {
                                            a.debug("evalUsageType: iscritical = {} KeyUsageBits= {}", (Object)bl2, (Object)n3);
                                            a.debug(" KeyUsageBits is {}", (Object)certificate.keyUsageToString(n3));
                                        }
                                        bl = certificate.isCritical(X509Extension.extendedKeyUsage.getId());
                                        stringArray = certificate.getExtendedKeyUsage();
                                        if (a.isDebugEnabled()) {
                                            if (b) {
                                                a.debug("critical = {} ExtendedKeyUsage ", (Object)bl);
                                            }
                                            for (n2 = 0; n2 < stringArray.length; ++n2) {
                                                if (!b) continue;
                                                a.debug("{}:{}", (Object)n2, (Object)stringArray[n2]);
                                            }
                                        }
                                        n2 = 0;
                                        string3 = "1.3.6.1.5.5.7.3.4";
                                        string2 = "1.3.159.5.1";
                                        string = "1.2.840.113583.1.1.5";
                                        if (b) {
                                            a.debug("searching emailProtectionID {}", (Object)string3);
                                        }
                                        for (n = 0; n < stringArray.length; ++n) {
                                            if (!string3.equals(stringArray[n])) continue;
                                            if (b) {
                                                a.debug("found emailProtectionID ");
                                            }
                                            n2 = 1;
                                            break;
                                        }
                                        if (n3 != 0) break block65;
                                        if (stringArray.length <= 0) {
                                            return 16;
                                        }
                                        break block66;
                                    }
                                    if ((n3 & 2) <= 0) break block67;
                                    if (b) {
                                        a.debug("evalUsageType: nonRepudiation set");
                                    }
                                    if (n3 != 2 && n3 != 3) break block68;
                                    if (stringArray.length <= 0) {
                                        if (n3 != 2) {
                                            return 2;
                                        }
                                        if (bl2) {
                                            return 1;
                                        }
                                        return 2;
                                    }
                                    break block69;
                                }
                                if (b) {
                                    a.debug("nonRepudiation SHOULD NOT be combined");
                                }
                                if ((n3 & 0xC) > 0) {
                                    if (b) {
                                        a.debug("nonRepudiation SHOULD NOT be combined with cipher");
                                    }
                                    if (stringArray.length <= 0) {
                                        return 16;
                                    }
                                    break block70;
                                } else if (stringArray.length > 0) {
                                    break block63;
                                } else {
                                    if (bl2) {
                                        return 64;
                                    }
                                    return 32;
                                }
                            }
                            if (certificate.isCNSAuthentication()) {
                                return 16;
                            }
                            if (n3 == 1) {
                                return 2;
                            }
                            if ((n3 & 0xD) > 0) {
                                if (b) {
                                    a.debug("evalUsageType: dataEncipherment|keyEncipherment |digitalSignature set");
                                }
                                if (n3 == 8 || n3 == 4 || n3 == 12 || n3 == 5) {
                                    if (stringArray.length > 0) {
                                        if (n2 != 0) {
                                            if (bl2) {
                                                return 4;
                                            }
                                            return 8;
                                        }
                                        if (bl) {
                                            return 64;
                                        }
                                        return 32;
                                    }
                                    break block64;
                                } else {
                                    if ((n3 & 2) > 0) {
                                        if (b) {
                                            a.debug("nonRepudiation SHOULD NOT be combined");
                                        }
                                        if (stringArray.length <= 0) {
                                            return 16;
                                        }
                                        if (n2 != 0) {
                                            return 16;
                                        }
                                        if (bl) {
                                            return 64;
                                        }
                                        return 32;
                                    }
                                    if (stringArray.length > 0) {
                                        if (n2 != 0) {
                                            if (bl2) {
                                                return 4;
                                            }
                                            return 8;
                                        }
                                        if (bl) {
                                            return 64;
                                        }
                                        return 32;
                                    }
                                    if (bl2) {
                                        return 4;
                                    }
                                    return 8;
                                }
                            }
                            if ((n3 & 0xE) == 0) {
                                if (b) {
                                    a.debug("evalUsageType: no sign&cipher bits set");
                                }
                                if (stringArray.length > 0) {
                                    if (n2 != 0) {
                                        if (bl2) {
                                            return 64;
                                        }
                                        return 32;
                                    }
                                    if (bl) {
                                        return 64;
                                    }
                                    return 32;
                                }
                                if (bl2) {
                                    return 64;
                                }
                                return 32;
                            }
                        }
                        if (b) {
                            a.debug("evalUsageType: generic");
                        }
                        return 16;
                    }
                    n = 0;
                    while (true) {
                        if (n >= stringArray.length) {
                            return 16;
                        }
                        if (!(string3.equals(stringArray[n]) || string2.equals(stringArray[n]) || string.equals(stringArray[n]))) {
                            if (bl) {
                                return 64;
                            }
                            return 32;
                        }
                        ++n;
                    }
                }
                n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        return 2;
                    }
                    if (!(string3.equals(stringArray[n]) || string2.equals(stringArray[n]) || string.equals(stringArray[n]))) {
                        if (bl) {
                            return 64;
                        }
                        return 32;
                    }
                    ++n;
                }
            }
            n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return 16;
                }
                if (!(string3.equals(stringArray[n]) || string2.equals(stringArray[n]) || string.equals(stringArray[n]))) {
                    if (bl) {
                        return 64;
                    }
                    return 32;
                }
                ++n;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (string3.equals(stringArray[n]) || string2.equals(stringArray[n]) || string.equals(stringArray[n])) continue;
            if (bl) {
                return 64;
            }
            return 32;
        }
        if (bl2) {
            return 64;
        }
        return 32;
    }

    public void setStatus(String string) {
        this.c.put(LBL_STATUS, string);
    }

    public String getStatus() {
        return (String)this.c.get(LBL_STATUS);
    }

    @Override
    public void initAsStringHashMap(HashMap<String, IniSerializableObject> hashMap, String string, HashMap<String, String> hashMap2) {
        int n;
        String string2 = hashMap2.get(LBL_ELLIPS_USAGES);
        ArrayList<EllipsUsage> arrayList = new ArrayList<EllipsUsage>();
        if (string2 != null && !string2.equals("")) {
            int n2 = Integer.parseInt(string2);
            for (n = 0; n < EllipsUsage.values().length; ++n) {
                if (n2 - EllipsUsage.values()[n].a >= 0) {
                    arrayList.add(EllipsUsage.values()[n]);
                    n2 -= EllipsUsage.values()[n].a;
                }
                if (n2 == 0) break;
            }
            if (n2 != 0) {
                a.error("ellips usages not valid for entry " + string);
            }
        }
        try {
            this.l = Integer.parseInt(hashMap2.get(LBL_SOURCE));
        }
        catch (Exception exception) {
            this.l = 3;
        }
        try {
            this.a(string, hashMap2.get(LBL_CERT).getBytes(), this.l, arrayList);
        }
        catch (CapiException capiException) {
            a.error("Unable to initialize the entry " + string + " " + capiException.getMessage() + " code: " + capiException.getErrorCode());
        }
        this.c.put(LBL_STATUS, hashMap2.get(LBL_STATUS));
        string2 = string;
        try {
            Integer.parseInt(string);
            n = 0;
            string2 = CertDB.a(this, 0);
            while (hashMap.containsKey(string2)) {
                string2 = CertDB.a(this, ++n);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            a.error("Impossibile inizializzare l'entry: " + exception.getMessage());
        }
        this.d = string2;
    }

    @Override
    public void put(String string, Object object) {
        this.c.put(string, object.toString());
    }

    @Override
    public Object remove(String string) {
        return this.c.remove(string);
    }

    @Override
    public HashMap<String, String> getAsStringHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.c.entrySet()) {
            if (entry.getValue() != null) {
                hashMap.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            hashMap.put(entry.getKey(), "");
        }
        hashMap.put(LBL_CERT, new String(Base64.encode((byte[])this.f)));
        hashMap.put(LBL_SOURCE, "" + this.l);
        hashMap.put(LBL_ELLIPS_USAGES, this.getIniPropertyStringValue(LBL_ELLIPS_USAGES));
        return hashMap;
    }

    @Override
    public String getIniPropertyStringValue(String string) {
        switch (string) {
            case "cert": {
                return new String(Base64.encode((byte[])this.f));
            }
            case "name.utf": 
            case "name": {
                return this.g;
            }
            case "source": {
                return "" + this.l;
            }
            case "ellipsUsages": {
                int n = 0;
                for (EllipsUsage ellipsUsage : this.m) {
                    n += ellipsUsage.value();
                }
                return "" + n;
            }
        }
        Object object = this.c.get(string);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public CertDB getParent() {
        return this.e;
    }

    final void a(CertDB certDB) {
        this.e = certDB;
    }

    public int getSource() {
        return this.l;
    }

    public void setSource(int n) {
        this.l = n;
    }

    public List<EllipsUsage> getEllipsUsages() {
        return this.m;
    }

    public void addEllipsUsage(EllipsUsage ellipsUsage) {
        if (!this.m.contains((Object)ellipsUsage)) {
            this.m.add(ellipsUsage);
        }
    }

    public void addEllipsUsages(List<EllipsUsage> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addEllipsUsage(list.get(i));
        }
    }

    public boolean hasEllipsUsage(EllipsUsage ellipsUsage) {
        return this.m.contains((Object)ellipsUsage);
    }

    public void resetEllipsUsage() {
        this.m.clear();
    }

    public boolean isEqualTo(CertDBItem certDBItem) throws CertDBException {
        if (certDBItem == null) {
            return false;
        }
        if (this.getEllipsUsages().size() != certDBItem.getEllipsUsages().size()) {
            return false;
        }
        for (EllipsUsage ellipsUsage : this.getEllipsUsages()) {
            if (certDBItem.getEllipsUsages().contains((Object)ellipsUsage)) continue;
            return false;
        }
        boolean bl = true & this.getSource() == certDBItem.getSource();
        bl &= this.getTrust() == certDBItem.getTrust();
        bl &= this.getUsage() == certDBItem.getUsage();
        bl &= this.getType() == certDBItem.getType();
        bl &= this.getID().equals(certDBItem.getID());
        bl &= this.getIssuer().equals(certDBItem.getIssuer());
        bl &= this.getName().equals(certDBItem.getName());
        bl &= this.getStatus().equals(certDBItem.getStatus());
        return bl &= this.getSubject().equals(certDBItem.getSubject());
    }

    public static Comparator<CertDBItem> getCompByName() {
        a a2 = new a();
        return a2;
    }

    public String getTslId() {
        return this.k;
    }

    public void setTslId(String string) {
        this.k = string;
    }

    public String toString() {
        String string = "";
        string = string + String.format("  Name: %s\n", this.getName());
        string = string + String.format("  ID: %s\n", this.getID());
        string = string + String.format("  Subject: %s\n", this.getSubject());
        string = string + String.format("  Issuer: %s\n", this.getIssuer());
        string = string + String.format("  Status: %s\n", this.getStatus());
        try {
            string = string + String.format("  Type: %s\n", this.getTypeAsString());
        }
        catch (CertDBException certDBException) {}
        try {
            string = string + String.format("  Trust: %s\n", this.getTrustAsString());
        }
        catch (CertDBException certDBException) {}
        try {
            string = string + String.format("  Usage: %s\n", this.getUsageAsString());
        }
        catch (CertDBException certDBException) {}
        string = string + String.format("  Source: %s\n", this.getSourceAsString());
        string = string + String.format("  Ellips usage: %s\n", this.getEllipsUsages().toString());
        return string;
    }

    public boolean isAdmittedByProfile(ValidationProfile validationProfile) {
        if (validationProfile == null) {
            return false;
        }
        boolean bl = false;
        switch (validationProfile) {
            case QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    bl = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) break;
                bl = true;
                break;
            }
            case CNS_ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (!this.hasEllipsUsage(EllipsUsage.CNS_AUTHENTICATION)) break;
                bl = true;
                break;
            }
            case ADVANCED_ELECTRONIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.FEA_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.CNS_AUTHENTICATION)) break;
                bl = true;
                break;
            }
            case GRAPHOMETRIC_SIGNATURE_PROFILE: {
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_TIME_STAMP)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.QUALIFIED_SIGNATURE_ONLY)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.SEAL_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (this.hasEllipsUsage(EllipsUsage.GRAPHOMETRIC_SIGNATURE)) {
                    bl = true;
                    break;
                }
                if (!this.hasEllipsUsage(EllipsUsage.NOTAR_GRAPHOMETRIC_SIGNATURE)) break;
                bl = true;
            }
        }
        return bl;
    }

    static /* synthetic */ String a(CertDBItem certDBItem) {
        return certDBItem.g;
    }

    public static enum EllipsUsage {
        SEAL_SIGNATURE(100000000),
        QUALIFIED_SIGNATURE_ONLY(10000000),
        QUALIFIED_TIME_STAMP(1000000),
        QUALIFIED_SIGNATURE(100000),
        NOTAR_GRAPHOMETRIC_SIGNATURE(10000),
        GRAPHOMETRIC_SIGNATURE(1000),
        FEA_SIGNATURE(100),
        CNS_AUTHENTICATION(10),
        GENERIC_TRUSTED_ROOT(1);

        private final int a;

        private EllipsUsage(int n2) {
            this.a = n2;
        }

        public final int value() {
            return this.a;
        }
    }
}

