/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class CertDBDiff {
    private ArrayList<CertDBItem> a = new ArrayList();
    private ArrayList<CertDBItem> b = new ArrayList();
    private ArrayList<CertDBItem> c = new ArrayList();
    private ArrayList<CertDBItem> d = new ArrayList();

    public ArrayList<CertDBItem> getUpdatedPre() {
        return this.a;
    }

    public ArrayList<CertDBItem> getUpdatedPost() {
        return this.b;
    }

    public ArrayList<CertDBItem> getAdded() {
        return this.c;
    }

    public ArrayList<CertDBItem> getRemoved() {
        return this.d;
    }

    public void reset() {
        this.a.clear();
        this.b.clear();
        this.c.clear();
        this.d.clear();
    }

    public void copy(CertDBDiff certDBDiff) {
        throw new UnsupportedOperationException();
    }

    public void addAdded(CertDBItem certDBItem) {
        this.c.add(certDBItem);
    }

    public void addRemove(CertDBItem certDBItem) {
        this.d.add(certDBItem);
    }

    public void addUpdated(CertDBItem certDBItem, CertDBItem certDBItem2) {
        this.a.add(certDBItem);
        this.b.add(certDBItem2);
    }

    public boolean hasDiff() {
        return !this.c.isEmpty() || !this.d.isEmpty() || !this.a.isEmpty() || !this.b.isEmpty();
    }

    public void toFile(File file) throws IOException, CertDBException {
        this.toFile(file.getAbsolutePath());
    }

    public void toFile(String object) throws IOException, CertDBException {
        if (!this.hasDiff()) {
            return;
        }
        object = new File((String)object);
        ((File)object).delete();
        BufferedWriter bufferedWriter = null;
        try {
            int n;
            bufferedWriter = new BufferedWriter(new FileWriter((File)object));
            bufferedWriter.write("CDB DIFFERENCE\n\n");
            bufferedWriter.write("--------------\n");
            bufferedWriter.write(String.format("ADDED (%d)\n", this.c.size()));
            bufferedWriter.write("--------------\n");
            Collections.sort(this.c, CertDBItem.getCompByName());
            for (n = 0; n < this.c.size(); ++n) {
                bufferedWriter.write(String.format("added: %s", this.c.get(n).toString()));
                bufferedWriter.write("- - - \n");
            }
            bufferedWriter.write("\n--------------\n");
            bufferedWriter.write(String.format("REMOVED (%d)\n", this.d.size()));
            bufferedWriter.write("--------------\n");
            Collections.sort(this.d, CertDBItem.getCompByName());
            for (n = 0; n < this.d.size(); ++n) {
                bufferedWriter.write(String.format("removed: %s", this.d.get(n).toString()));
                bufferedWriter.write("- - - \n");
            }
            bufferedWriter.write("\n--------------\n");
            bufferedWriter.write(String.format("UPDATED (%d)\n", this.a.size()));
            bufferedWriter.write("--------------\n");
            Collections.sort(this.a, CertDBItem.getCompByName());
            Collections.sort(this.b, CertDBItem.getCompByName());
            for (n = 0; n < this.a.size(); ++n) {
                bufferedWriter.write(String.format("updated pre: %s", this.a.get(n).toString()));
                bufferedWriter.write(String.format("updated post: %s", this.b.get(n).toString()));
                bufferedWriter.write("- - - \n");
            }
        }
        catch (Throwable throwable) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            bufferedWriter.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

