/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.x509.StepX509AIACheck;
import esecurity.validator.steps.core.x509.StepX509ETSIDigestAlgorithmCompliance;
import esecurity.validator.steps.core.x509.StepX509ETSIKeyLengthCompliance;
import esecurity.validator.steps.core.x509.StepX509ExtensionsCheck;
import esecurity.validator.steps.core.x509.StepX509IssuerIdentityCheck;
import esecurity.validator.steps.core.x509.StepX509SubjectDNCheck;
import esecurity.validator.steps.core.x509.StepX509TimestampKeyUsageCompliance;
import esecurity.validator.steps.core.x509.StepX509VersionCompliance;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepX509ETSICompliance
extends SingleValidationSubStepImpl {
    public StepX509ETSICompliance() {
        super(ValidationType.CERTIFICATE);
        this.subSteps.add(new StepX509ETSIDigestAlgorithmCompliance());
        this.subSteps.add(new StepX509TimestampKeyUsageCompliance());
        this.subSteps.add(new StepX509ETSIKeyLengthCompliance());
        this.subSteps.add(new StepX509VersionCompliance());
        this.subSteps.add(new StepX509IssuerIdentityCheck());
        this.subSteps.add(new StepX509SubjectDNCheck());
        this.subSteps.add(new StepX509AIACheck());
        this.subSteps.add(new StepX509ExtensionsCheck());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        MessageLevel messageLevel = StepsUtils.retrieveWorstLevel(linkedList);
        Date date = validationContextParameters.getSignerCertificate().getCert().getInternalCert().getNotBefore();
        if (messageLevel.equals((Object)MessageLevel.ERROR)) {
            if (date.after(Constants.DPCM_CNIPA_45_2009) && date.before(Constants.DPCM_AGID_121_2019)) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.EC0010_NOCNIPA45, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
            }
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.EC0027_NOEIDAS_COMPLIANT, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
        }
        if (linkedList.size() > 0 && date.after(Constants.DPCM_AGID_121_2019)) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.IS0017_ADDITIONAL_INFORMATION, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
        }
        return null;
    }
}

