/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import org.slf4j.Logger;

public class CRLUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void addRefCrl(LinkedList<RefCRL> serializable, CRL cRL, LinkedList<Certificate> linkedList) {
        LinkedList<Certificate> linkedList2 = new LinkedList<Certificate>();
        for (Certificate certificate : linkedList) {
            try {
                Certificate certificate2 = certificate;
                if (!cRL.canUseFor(certificate2, certificate2.getInternalCert().getNotBefore())) continue;
                linkedList2.add(certificate);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        if (linkedList2.isEmpty()) {
            return;
        }
        Object object2 = null;
        boolean bl = false;
        try {
            String string = Utils.calculateDigest(new ByteArrayInputStream(cRL.getInternalCRL().getEncoded()), Constants.SHA256);
            Iterator object3 = ((AbstractSequentialList)((Object)serializable)).iterator();
            while (object3.hasNext()) {
                RefCRL refCRL = (RefCRL)object3.next();
                if (!refCRL.getId().equals(string)) continue;
                object2 = refCRL;
                break;
            }
            if (object2 == null) {
                object2 = new RefCRL();
                ((RefCRL)object2).setId(string);
                ((LinkedList)serializable).add(object2);
            }
            for (Certificate certificate : linkedList) {
                if (!Utils.retrieveCommonName(cRL.getIssuerDN()).equals(certificate.getSubjectCommonName())) continue;
                cRL.verify(certificate.getDerEncoded());
                ((RefCRL)object2).setId(string);
                ((RefCRL)object2).setIssuerDn(cRL.getIssuerDN());
                ((RefCRL)object2).setIdps(cRL.getIdps());
                ((RefCRL)object2).setUpdateDate(cRL.getInternalCRL().getThisUpdate());
                ((RefCRL)object2).setNextUpdate(cRL.getInternalCRL().getNextUpdate());
                bl = true;
                break;
            }
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (CRLException cRLException) {
            a.error(cRLException.getMessage(), (Throwable)cRLException);
        }
        ((RefCRL)object2).setValid(bl);
        for (Certificate certificate : linkedList2) {
            try {
                VerifiedSerial verifiedSerial = new VerifiedSerial();
                serializable = certificate.getSerialNumber();
                verifiedSerial.setSerial(((BigInteger)serializable).toString(16));
                verifiedSerial.setRevoked(cRL.isRevoked(certificate.getSerialNumber()));
                if (verifiedSerial.isRevoked()) {
                    verifiedSerial.setReasonCode(cRL.getReasonCode((BigInteger)serializable));
                    verifiedSerial.setRevocationDate(cRL.getInternalCRL().getRevokedCertificate((BigInteger)serializable).getRevocationDate());
                }
                ((RefCRL)object2).addVerifiedSerial(verifiedSerial);
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
    }
}

