/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl;

import esecurity.tsl.AtrDbItem;
import esecurity.tsl.CertChain;
import esecurity.tsl.CertDbItemFilter;
import esecurity.tsl.ChainEntry;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.tsl.X509ServiceDbItem;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateType;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.io.Closeable;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public abstract class CertDb
implements Closeable {
    private final NetworkConfig networkConfig;
    protected boolean close = false;

    public CertDb(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    public CertChain retrieveCertificateChain(Certificate certificate) {
        return new CertChain(this.retrieveEntry(certificate));
    }

    private ChainEntry retrieveEntry(Certificate object) {
        this.throwExceptionIfClosed();
        Object object2 = this.retrieveServiceTypeIdentifier((Certificate)object);
        object2 = this.retrieveChainEntry((Certificate)object, (TSLServiceTypeIdentifiers)((Object)object2));
        if (this.isFinalEntity((Certificate)object)) {
            return object2;
        }
        object = this.retrieveIssuer((Certificate)object);
        ((ChainEntry)object2).setParent((ChainEntry)object);
        return object2;
    }

    private boolean isFinalEntity(Certificate certificate) {
        return certificate.getCertificateType() == CertificateType.UNKNOWN || certificate.getCertificateType() == CertificateType.ROOT_CA || certificate.getCertificateType() == CertificateType.SELFSIGNED;
    }

    private TSLServiceTypeIdentifiers retrieveServiceTypeIdentifier(Certificate certificate) {
        if (certificate.getCertificateType() == CertificateType.INTERMEDIATE_CA || certificate.getCertificateType() == CertificateType.ROOT_CA) {
            return TSLServiceTypeIdentifiers.CaIssuer;
        }
        return TSLServiceTypeIdentifiers.SignerCertificate;
    }

    private ChainEntry retrieveChainEntry(Certificate certificate, TSLServiceTypeIdentifiers tSLServiceTypeIdentifiers) {
        Object object = this.calculateServiceIdFromSubject(certificate, null);
        if (object != null) {
            object = this.getServiceItems((String)object);
        } else {
            object = new CertDbItemFilter();
            try {
                ((CertDbItemFilter)object).commonName = certificate.getSubjectCommonName();
                if (((CertDbItemFilter)object).commonName == null) {
                    return null;
                }
            }
            catch (CapiException capiException) {
                return null;
            }
            object = this.queryServiceItems((CertDbItemFilter)object);
        }
        if (object != null && !object.isEmpty()) {
            return new ChainEntry((List<ServiceDbItem>)object);
        }
        object = new X509ServiceDbItem(certificate, tSLServiceTypeIdentifiers);
        return new ChainEntry(Collections.singletonList(object));
    }

    private ChainEntry retrieveIssuer(Certificate certificate) {
        Iterator<ServiceDbItem> iterator;
        Object object = this.calculateServiceIdFromAuthority(certificate, null);
        if (object != null) {
            object = this.getServiceItems((String)object);
        } else {
            iterator = new CertDbItemFilter();
            try {
                ((CertDbItemFilter)((Object)iterator)).commonName = certificate.getIssuerCommonName();
            }
            catch (CapiException capiException) {
                return null;
            }
            object = this.queryServiceItems((CertDbItemFilter)((Object)iterator));
            if (object != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    ServiceDbItem serviceDbItem = iterator.next();
                    try {
                        certificate.verify(serviceDbItem.getCert());
                        return this.retrieveEntry(serviceDbItem.getCert());
                    }
                    catch (CapiException capiException) {
                    }
                }
            }
        }
        iterator = null;
        if (object != null && !object.isEmpty()) {
            iterator = ((ServiceDbItem)object.get(0)).getCert();
        } else if (certificate.getCaIssuer() != null) {
            iterator = this.downloadCert(certificate.getCaIssuer());
        }
        if (iterator == null) {
            return null;
        }
        return this.retrieveEntry((Certificate)((Object)iterator));
    }

    private Certificate downloadCert(String object) {
        InputHandler inputHandler = null;
        try {
            inputHandler = DataHandlerBuilder.get().setUrl(new URL((String)object)).setUrlNetConf(this.networkConfig).buildInput();
            object = new Certificate(Util.getBytesFromInputStream(inputHandler.getInputAsNewStream()));
        }
        catch (Exception exception) {
            Util.closeQuietly(inputHandler);
            return null;
        }
        catch (Throwable throwable) {
            Util.closeQuietly(inputHandler);
            throw throwable;
        }
        Util.closeQuietly(inputHandler);
        return object;
    }

    protected String calculateServiceIdFromAuthority(Certificate certificate, String string) {
        if (certificate.getAuthorityKeyIdentifier() != null && certificate.getAuthorityKeyIdentifier().length > 0) {
            return Hex.toHexString((byte[])certificate.getAuthorityKeyIdentifier());
        }
        return string;
    }

    protected String calculateServiceIdFromSubject(Certificate certificate, String string) {
        if (certificate.getSubjectKeyIdentifier() != null && certificate.getSubjectKeyIdentifier().length > 0) {
            return Hex.toHexString((byte[])certificate.getSubjectKeyIdentifier());
        }
        return string;
    }

    protected abstract List<ServiceDbItem> getServiceItems(String var1);

    public abstract void importService(ServiceDbItem var1) throws CapiException;

    public abstract int getServiceCount();

    public abstract List<ServiceDbItem> queryServiceItems(CertDbItemFilter var1);

    public abstract List<ServiceDbItem> queryServiceItems(Certificate var1);

    public abstract List<AtrDbItem> getAtrWhiteList();

    public abstract void removeServiceItem(Certificate var1) throws CapiException;

    public abstract boolean isAtrInWhitelist(String var1);

    public abstract void replaceAtrWhitelist(List<String> var1) throws CapiException;

    public abstract List<AtrDbItem> getAtrBlackList();

    public abstract void removeAtrWhitelist(String var1) throws CapiException;

    public abstract boolean isAtrInBlacklist(String var1);

    public abstract AtrDbItem getWhiteListAtrItem(String var1);

    public abstract AtrDbItem getBlackListAtrItem(String var1);

    public abstract void replaceAtrBlacklist(List<String> var1) throws CapiException;

    public abstract void removeAtrBlacklist(String var1) throws CapiException;

    public abstract void addAtrToBlackList(String var1) throws CapiException;

    public abstract void addAtrToWhiteList(String var1) throws CapiException;

    public boolean containsCertificate(Certificate certificate) {
        Object object = this.calculateServiceIdFromSubject(certificate, null);
        if (object != null) {
            return (object = this.getServiceItems((String)object)) != null && !object.isEmpty();
        }
        object = new CertDbItemFilter();
        try {
            ((CertDbItemFilter)object).commonName = certificate.getSubjectCommonName();
        }
        catch (CapiException capiException) {
            return false;
        }
        object = this.queryServiceItems((CertDbItemFilter)object);
        if (object == null) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)object.next();
            try {
                certificate.verify(serviceDbItem.getCert());
                return true;
            }
            catch (CapiException capiException) {
            }
        }
        return false;
    }

    protected void throwExceptionIfClosed() {
        if (this.close) {
            throw new CapiError("CertDb is closed", 1003);
        }
    }
}

