/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.DataHandlerUtils;
import it.actalis.ellips.capi.datahandlers.outputs.CloudOutputHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class S3OutputHandler
extends CloudOutputHandler {
    public static final int MIN_PART_SIZE = 0x500000;
    protected DataHandler.S3_TYPE s3CloudType = null;
    protected String bucket = null;
    protected String filepath = null;
    protected AmazonS3 s3Client = null;
    protected String uploadId = null;
    protected byte[] partBuffer = new byte[0x500000];
    protected int partBufferIndex = 0;
    protected int partNumber = 1;
    protected List<PartETag> partETags = new ArrayList<PartETag>();

    public DataHandler.S3_TYPE getS3CloudType() {
        return this.s3CloudType;
    }

    protected S3OutputHandler() {
    }

    protected final void initS3OutputHandler(AmazonS3ClientBuilder amazonS3ClientBuilder, String string, String string2, String string3, Long l) {
        if (amazonS3ClientBuilder == null) {
            throw new IllegalArgumentException("Please specify a non-null S3 client builder!");
        }
        this.s3Client = (AmazonS3)amazonS3ClientBuilder.build();
        this.bucket = string;
        this.filepath = string2 == null ? "" : string2;
        this.initCloudOutputHandler(DataHandler.CLOUD_TYPE.S3, string3, l);
        this.s3CloudType = DataHandler.S3_TYPE.GENERIC;
    }

    protected void abortUpload() {
        this.s3Client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name), this.uploadId));
    }

    public S3OutputHandler(AmazonS3ClientBuilder amazonS3ClientBuilder, String string, String string2, String string3, Long l) throws IOException {
        this.initS3OutputHandler(amazonS3ClientBuilder, string, string2, string3, l);
    }

    public S3OutputHandler(AmazonS3ClientBuilder amazonS3ClientBuilder, String string, String string2, String string3) throws IOException {
        this(amazonS3ClientBuilder, string, string2, string3, null);
    }

    @Override
    protected CloudOutputHandler.CloudWriteProxyOutputStream getCloudUnderlyingProxyOutputStream() {
        return new S3WriteProxyOutputStream(this);
    }

    @Override
    protected void initBeforeFirstWrite() throws IOException {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name));
        initiateMultipartUploadRequest = this.s3Client.initiateMultipartUpload(initiateMultipartUploadRequest);
        this.uploadId = initiateMultipartUploadRequest.getUploadId();
    }

    @Override
    protected void finalizeBeforeClosing() throws IOException {
        try {
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name), this.uploadId, this.partETags);
            this.s3Client.completeMultipartUpload(completeMultipartUploadRequest);
            return;
        }
        catch (RuntimeException runtimeException) {
            this.abortUpload();
            throw runtimeException;
        }
    }

    protected class S3WriteProxyOutputStream
    extends CloudOutputHandler.CloudWriteProxyOutputStream {
        private /* synthetic */ S3OutputHandler a;

        protected S3WriteProxyOutputStream(S3OutputHandler s3OutputHandler) {
            this.a = s3OutputHandler;
            super(s3OutputHandler);
        }

        @Override
        public void flush() throws IOException {
            if (this.a.partBufferIndex <= 0) {
                return;
            }
            Object object = this.a.partBufferIndex >= this.a.partBuffer.length ? this.a.partBuffer : Arrays.copyOfRange(this.a.partBuffer, 0, this.a.partBufferIndex);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            try {
                object = new UploadPartRequest().withBucketName(this.a.bucket).withKey(DataHandlerUtils.getS3FileKey(this.a.filepath, this.a.name)).withInputStream((InputStream)byteArrayInputStream).withUploadId(this.a.uploadId).withPartNumber(this.a.partNumber).withPartSize((long)((byte[])object).length);
                this.a.partETags.add(this.a.s3Client.uploadPart((UploadPartRequest)object).getPartETag());
            }
            catch (RuntimeException runtimeException) {
                this.a.abortUpload();
                throw runtimeException;
            }
            byteArrayInputStream.close();
            this.a.partBufferIndex = 0;
            ++this.a.partNumber;
        }

        @Override
        public void write(int n) throws IOException {
            this.a.partBuffer[this.a.partBufferIndex] = (byte)n;
            ++this.a.partBufferIndex;
            if (this.a.partBufferIndex >= this.a.partBuffer.length) {
                this.flush();
            }
        }
    }
}

