/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CertificateStatus;
import esecurity.validator.x509status.X509StatusValidator;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;

public class OCSPX509StatusValidator
implements X509StatusValidator {
    private Logger a;
    private HttpOCSPClient b;
    private OCSPCacheManager c;
    private boolean d;
    private CertDb e;

    public OCSPX509StatusValidator(ValidatorConfig validatorConfig, OCSPCacheManager oCSPCacheManager, Logger logger) throws CapiException {
        this.d = validatorConfig.getBinElement("x509StatusService.cacheEnabled", true);
        this.e = validatorConfig.getCertDB();
        this.b = new HttpOCSPClient(validatorConfig.getNetConfiguration(), logger, this.e);
        this.c = oCSPCacheManager;
        this.a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (logger != null) {
            this.a = logger;
        }
    }

    @Override
    public CertificateStatus checkStatus(Certificate certificate, ValidationDate validationDate) {
        CertificateStatus certificateStatus = new CertificateStatus();
        certificateStatus.setCrlBean(null);
        try {
            if (certificate.getSubjectDN().equalsIgnoreCase(certificate.getIssuerDN())) {
                this.a.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("NO_CHECK");
                CertificateStatus certificateStatus2 = certificateStatus;
                return certificateStatus2;
            }
            if (certificate.isRsVerified()) {
                this.a.debug(I.d() + "e' RsVerified");
                certificateStatus.setCertValid(true);
                certificateStatus.setCrlStatus("VERIFIED SIGNATURE");
                CertificateStatus certificateStatus3 = certificateStatus;
                return certificateStatus3;
            }
            String string = certificate.getOcspUrl();
            if (string == null || string.isEmpty()) {
                this.a.debug("no valid OCSP url found");
                certificateStatus.setCrlStatus("NOT FOUND");
                CertificateStatus certificateStatus4 = certificateStatus;
                return certificateStatus4;
            }
            CertChain certChain = this.e.retrieveCertificateChain(certificate);
            try {
                certificateStatus.setCertCorrupted(certificate.isAltered(certChain.getStartEntry().getParent().getCert()));
            }
            catch (CapiException capiException) {}
            if (certChain.getStartEntry().getParent() == null) {
                this.a.debug(I.d() + "e' selfsigned: non fa la verifica OCSP");
                certificateStatus.setCertValid(false);
                certificateStatus.setInvalidityReason("No chain in CDB");
                CertificateStatus certificateStatus5 = certificateStatus;
                return certificateStatus5;
            }
            certificateStatus.setCertRevoked(false);
            certificateStatus.setCertValid(true);
            certificateStatus.setCrlStatus("OCSP_CHECK");
            certificateStatus.setVerificationType("OCSP");
            OCSPResponse oCSPResponse = null;
            boolean bl = this.d;
            String string2 = null;
            if (bl) {
                try {
                    string2 = OCSPX509StatusValidator.a(certificate);
                }
                catch (CapiException capiException) {
                    this.a.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
            if (bl &= string2 != null) {
                oCSPResponse = this.c.get(string2);
            }
            if (oCSPResponse == null) {
                Certificate certificate2 = certChain.getStartEntry().getParent().getCert();
                oCSPResponse = this.b.sendOCSPRequest(string, certificate.getInternalCert(), certificate2.getInternalCert());
                if (this.d) {
                    this.c.addToCache(string2, oCSPResponse);
                }
                if (this.a.isDebugEnabled()) {
                    this.a.debug("got ocsp response from server for " + string2);
                }
            } else if (this.a.isDebugEnabled()) {
                this.a.debug("got ocsp response from cache for " + string2);
            }
            int n = oCSPResponse.getCertStatus();
            if (n == OCSPResponse.REVOKED) {
                String string3;
                int n2 = oCSPResponse.getReasonCode();
                switch (n2) {
                    case 3: {
                        string3 = "AffiliationChanged";
                        break;
                    }
                    case 2: {
                        string3 = "CACompromise";
                        break;
                    }
                    case 6: {
                        string3 = "CertificateHold";
                        break;
                    }
                    case 5: {
                        string3 = "CessationOfOperation";
                        break;
                    }
                    case 1: {
                        string3 = "KeyCompromise";
                        break;
                    }
                    case 8: {
                        string3 = "RemoveFromCRL";
                        break;
                    }
                    case 4: {
                        string3 = "Superseded";
                        break;
                    }
                    case 0: {
                        string3 = "Unspecified";
                        break;
                    }
                    case 9: {
                        string3 = "PrivilegeWithdrawn";
                        break;
                    }
                    case 10: {
                        string3 = "AACompromise";
                        break;
                    }
                    default: {
                        string3 = "Unknown";
                    }
                }
                if (oCSPResponse.getRevocationTime() != null && validationDate.getDate().before(oCSPResponse.getRevocationTime())) {
                    string3 = string3 + " - After the verification date";
                } else {
                    certificateStatus.setCertRevoked(true);
                    certificateStatus.setCertValid(false);
                }
                certificateStatus.setInvalidityReason(string3);
                certificateStatus.setRevocationReason(Integer.toString(oCSPResponse.getReasonCode()));
                certificateStatus.setRevocationDate(oCSPResponse.getRevocationTime());
                certificateStatus.setCrlStatus("VALID");
            } else if (n == OCSPResponse.GOOD) {
                certificateStatus.setCrlStatus("VALID");
            } else if (n == OCSPResponse.UNKNOWN) {
                certificateStatus.setInvalidityReason("Unknown revocation status");
                certificateStatus.setCrlStatus("NOT FOUND");
            }
        }
        catch (Exception exception) {
            certificateStatus.setCrlStatus("NOT FOUND");
            this.a.error(I.d() + exception.getMessage());
        }
        finally {
            if (this.a.isDebugEnabled()) {
                this.a.debug("CRLX509StatusValidator result:");
                this.a.debug(certificateStatus.toString());
            }
        }
        return certificateStatus;
    }

    private static String a(Certificate certificate) throws CapiException {
        try {
            return DigestUtils.calculateHexString(DigestAlgorithm.SHA512, certificate.getDerEncoded());
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            throw new CapiException("Unable to calculate cert Identifier", 1003, exception);
        }
    }
}

