/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.CRLUtils;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.StreamInputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.ellips.capi.xml.parser.a;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.crypto.dsig.Reference;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class XadesParserHelper {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    private static SignatureInformation a(TransientDocument object, byte[] byArray) {
        for (SignatureInformation signatureInformation : ((TransientDocument)object).getSignerInfo()) {
            if (!Arrays.areEqual((byte[])signatureInformation.getSignatureInfo(), (byte[])byArray)) continue;
            return signatureInformation;
        }
        return null;
    }

    public static void parseXadesEnvelope(TransientDocument transientDocument, SignedXMLEnvelope signedXMLEnvelope, DateFormat dateFormat, boolean bl, boolean bl2, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig) throws Exception {
        String[] stringArray = signedXMLEnvelope.listSigners();
        if (stringArray != null && stringArray.length > 0) {
            transientDocument.setSigned(true);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                Iterator j;
                LinkedList<X509Certificate> linkedList;
                SignatureInformation signatureInformation = null;
                if (!signedXMLEnvelope.isSignatureParsed(i)) {
                    signatureInformation = new SignatureInformation();
                    signatureInformation.setSignatureInfo(signedXMLEnvelope.getRawSignature(i));
                    signatureInformation.setFormat(SignatureFormat.XADES);
                    signatureInformation.setContainerFormat(ContainerFormat.SELF);
                    signatureInformation.setCorrupted(true);
                    linkedList = signedXMLEnvelope.getCertificates(i);
                    if (linkedList != null) {
                        for (X509Certificate object32 : linkedList) {
                            j = Utils.calculateDigest(new ByteArrayInputStream(object32.getEncoded()), Constants.SHA256);
                            RefCertificate refCertificate = new RefCertificate();
                            refCertificate.setId((String)((Object)j));
                            refCertificate.setContent(object32.getEncoded());
                            refCertificate.setCapiCertificate(new Certificate(object32));
                            transientDocument.addCert(refCertificate);
                        }
                        object = new Certificate(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i)));
                        signatureInformation.setSignerName(((Certificate)object).getName());
                        String x509Certificate = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i))), Constants.SHA256);
                        signatureInformation.setRefsCertId(x509Certificate);
                    } else {
                        signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    transientDocument.addSignerInfo(signatureInformation);
                    continue;
                }
                if (bl) {
                    signatureInformation = XadesParserHelper.a(transientDocument, signedXMLEnvelope.getRawSignature(i));
                }
                if (signatureInformation == null) {
                    Object object2;
                    signatureInformation = new SignatureInformation();
                    linkedList = signedXMLEnvelope.getCertificates(i);
                    if (linkedList != null) {
                        for (X509Certificate string : linkedList) {
                            j = Utils.calculateDigest(new ByteArrayInputStream(string.getEncoded()), Constants.SHA256);
                            RefCertificate refCertificate = new RefCertificate();
                            refCertificate.setId((String)((Object)j));
                            refCertificate.setContent(string.getEncoded());
                            refCertificate.setCapiCertificate(new Certificate(string));
                            transientDocument.addCert(refCertificate);
                        }
                        object = new Certificate(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i)));
                        signatureInformation.setSignerName(((Certificate)object).getName());
                        String reference = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)signedXMLEnvelope.getSignerCertificate(i))), Constants.SHA256);
                        signatureInformation.setRefsCertId(reference);
                    } else {
                        signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                    }
                    signatureInformation.setSignatureInfo(signedXMLEnvelope.getRawSignature(i));
                    signatureInformation.setFormat(SignatureFormat.XADES);
                    signatureInformation.setContainerFormat(ContainerFormat.SELF);
                    signatureInformation.setContainsGraphometricInfo(false);
                    for (int j2 = 0; j2 < signedXMLEnvelope.getNumReference(i); ++j2) {
                        Reference n = signedXMLEnvelope.getReferenceInfo(i, j2);
                        if (n.getDigestInputStream() == null) continue;
                        j = new StreamInputHandler(n.getDigestInputStream(), n.getURI());
                        TransientDocument transientDocument2 = ParserUtils.parseDoc((InputHandler)((Object)j), eventHandlerSelector, networkConfig);
                        transientDocument.addRefDoc(transientDocument2);
                        signatureInformation.addRefDoc(new ReferenceDoc(transientDocument2.getId(), bl2));
                    }
                    if (signedXMLEnvelope.getSigningTime(i) != null) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(signedXMLEnvelope.getSigningTime(i));
                            signatureInformation.setSignatureDate(dateFormat.format(date));
                        }
                        catch (ParseException parseException) {
                            a.error(parseException.getMessage(), (Throwable)parseException);
                        }
                    }
                    try {
                        signedXMLEnvelope.verify(i);
                        signatureInformation.setCorrupted(false);
                    }
                    catch (Exception exception) {
                        signatureInformation.setCorrupted(true);
                    }
                    transientDocument.addSignerInfo(signatureInformation);
                    try {
                        object = signedXMLEnvelope.getCounterSignature(i);
                        ((SignedXMLEnvelope)object).listSigners();
                    }
                    catch (CapiException capiException) {
                        object = null;
                    }
                    if (object != null && ((SignedXMLEnvelope)object).listSigners() != null && ((SignedXMLEnvelope)object).listSigners().length > 0) {
                        XadesParserHelper.a(transientDocument, (a)object, signatureInformation, dateFormat);
                    }
                    int streamInputHandler = signedXMLEnvelope.getNumSignatureTimeStamp(i);
                    for (int k = 0; k < streamInputHandler; ++k) {
                        try {
                            byte[] byArray = signedXMLEnvelope.getTimeStamp(i, k);
                            object = signedXMLEnvelope.getSignature(i);
                            if (byArray == null) continue;
                            object2 = DataHandlerBuilder.get().setBytes((byte[])object).buildInput();
                            signatureInformation.addTimeStampToken(TSTUtils.tstToVol(transientDocument, byArray, (InputHandler)object2, "", dateFormat));
                            continue;
                        }
                        catch (CapiException capiException) {}
                    }
                    for (RefCertificate refCertificate : transientDocument.getCerts()) {
                        if (linkedList.contains(refCertificate.getCapiCertificate().getInternalCert())) continue;
                        linkedList.add(refCertificate.getCapiCertificate().getInternalCert());
                    }
                    if (signedXMLEnvelope.getCRLS(i) != null) {
                        for (CRL cRL : signedXMLEnvelope.getCRLS(i)) {
                            CRLUtils.addRefCrl(transientDocument.getCrls(), cRL, linkedList);
                        }
                    }
                    if (signedXMLEnvelope.getBasicOCSPResponses(i) == null) continue;
                    for (BasicOCSPResp basicOCSPResp : signedXMLEnvelope.getBasicOCSPResponses(i)) {
                        object = Utils.calculateDigest(new ByteArrayInputStream(basicOCSPResp.getEncoded()), Constants.SHA256);
                        object2 = new RefOcsp();
                        ((RefOcsp)object2).setId((String)object);
                        ((RefOcsp)object2).setContent(basicOCSPResp.getEncoded());
                        transientDocument.addOcspresp((RefOcsp)object2);
                    }
                    continue;
                }
                for (int j3 = 0; j3 < signedXMLEnvelope.getNumReference(i); ++j3) {
                    object = signedXMLEnvelope.getReferenceInfo(i, j3);
                    StreamInputHandler streamInputHandler = new StreamInputHandler(object.getDigestInputStream(), object.getURI());
                    j = ParserUtils.parseDoc(streamInputHandler, eventHandlerSelector, networkConfig);
                    transientDocument.addRefDoc((TransientDocument)((Object)j));
                    signatureInformation.addRefDoc(new ReferenceDoc(((TransientDocument)((Object)j)).getId(), bl2));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void a(TransientDocument transientDocument, a a2, SignatureInformation signatureInformation, DateFormat dateFormat) throws CapiException, CMSException, IOException, NoSuchAlgorithmException, FileNotFoundException, MalformedURLException, KeyStoreException, UnrecoverableKeyException, KeyManagementException, URISyntaxException, Exception {
        String[] stringArray = a2.listSigners();
        if (stringArray != null && stringArray.length > 0) {
            SignatureInformation signatureInformation2 = new SignatureInformation();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                void var9_28;
                LinkedList<X509Certificate> linkedList = a2.getCertificates(i);
                if (linkedList != null) {
                    for (X509Certificate x509Certificate : linkedList) {
                        String string = Utils.calculateDigest(new ByteArrayInputStream(x509Certificate.getEncoded()), Constants.SHA256);
                        Iterator iterator = new RefCertificate();
                        ((RefCertificate)((Object)iterator)).setId(string);
                        ((RefCertificate)((Object)iterator)).setContent(x509Certificate.getEncoded());
                        ((RefCertificate)((Object)iterator)).setCapiCertificate(new Certificate(x509Certificate));
                        transientDocument.addCert((RefCertificate)((Object)iterator));
                    }
                    Certificate certificate = new Certificate(Base64.decode((String)a2.getSignerCertificate(i)));
                    signatureInformation2.setSignerName(certificate.getName());
                } else {
                    signatureInformation2.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
                }
                signatureInformation2.setSignatureInfo(a2.getRawSignature(i));
                signatureInformation2.setCounterSignature(true);
                signatureInformation2.setFormat(SignatureFormat.XADES);
                signatureInformation2.setContainerFormat(ContainerFormat.SELF);
                signatureInformation2.setContainsGraphometricInfo(false);
                if (a2.getSigningTime(i) != null) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(a2.getSigningTime(i));
                        signatureInformation2.setSignatureDate(dateFormat.format(date));
                    }
                    catch (Exception exception) {
                        a.error(exception.getMessage(), (Throwable)exception);
                    }
                }
                String string = Utils.calculateDigest(new ByteArrayInputStream(Base64.decode((String)a2.getSignerCertificate(i))), Constants.SHA256);
                signatureInformation2.setRefsCertId(string);
                try {
                    a2.verify(i);
                    signatureInformation2.setCorrupted(false);
                }
                catch (Exception exception) {
                    signatureInformation2.setCorrupted(true);
                }
                signatureInformation.addCounterSignaturesInformation(signatureInformation2);
                try {
                    a a3 = a2.getCounterSignature(i);
                    a3.listSigners();
                }
                catch (CapiException capiException) {
                    Object var9_27 = null;
                }
                if (var9_28 != null && var9_28.listSigners().length > 0) {
                    XadesParserHelper.a(transientDocument, (a)var9_28, signatureInformation2, dateFormat);
                }
                int n = a2.getNumSignatureTimeStamp(i);
                for (int j = 0; j < n; ++j) {
                    byte[] byArray = a2.getTimeStamp(i, j);
                    if (byArray == null) continue;
                    byte[] byArray2 = a2.getSignature(i);
                    object = DataHandlerBuilder.get().setBytes(byArray2).buildInput();
                    signatureInformation2.addTimeStampToken(TSTUtils.tstToVol(transientDocument, byArray, (InputHandler)object, "", dateFormat));
                }
                for (RefCertificate refCertificate : transientDocument.getCerts()) {
                    if (linkedList.contains(refCertificate.getCapiCertificate().getInternalCert())) continue;
                    linkedList.add(refCertificate.getCapiCertificate().getInternalCert());
                }
                if (a2.getCRLS(i) != null) {
                    for (CRL cRL : a2.getCRLS(i)) {
                        CRLUtils.addRefCrl(transientDocument.getCrls(), cRL, linkedList);
                    }
                }
                if (a2.getBasicOCSPResponses(i) == null) continue;
                for (BasicOCSPResp basicOCSPResp : a2.getBasicOCSPResponses(i)) {
                    String string2 = Utils.calculateDigest(new ByteArrayInputStream(basicOCSPResp.getEncoded()), Constants.SHA256);
                    object = new RefOcsp();
                    ((RefOcsp)object).setId(string2);
                    ((RefOcsp)object).setContent(basicOCSPResp.getEncoded());
                    transientDocument.addOcspresp((RefOcsp)object);
                }
            }
        }
    }
}

