/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.BaseController;
import esecurity.desktop.DOMEvent;
import esecurity.desktop.Event;
import esecurity.desktop.JsUtils;
import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import esecurity.desktop.dom.DOMDocument;
import esecurity.desktop.swt.DragAndDropInnerArea;
import esecurity.desktop.swt.Point;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class View {
    protected static final Logger logger = LoggerFactory.getLogger(View.class);
    protected ConcurrentHashMap<Long, ArrayDeque<String>> javascriptCallsPerThread = new ConcurrentHashMap();
    protected ConcurrentHashMap<Long, Boolean> bufferedPerThread = new ConcurrentHashMap();
    private final HashMap<String, List<Listener<Event>>> events = new HashMap();

    void init(BaseController controller, View parent, String title, byte[] image, ModalType modalType, Region viewArea, Region dragArea, boolean decorated, boolean resizable, boolean onTop) throws Exception {
        this.initialize(controller, parent, title, image, modalType, viewArea, dragArea, decorated, resizable, onTop);
    }

    protected abstract void initialize(BaseController var1, View var2, String var3, byte[] var4, ModalType var5, Region var6, Region var7, boolean var8, boolean var9, boolean var10) throws Exception;

    public abstract void show();

    public abstract void close();

    public abstract Object evaluate(String var1);

    public abstract void execute(String var1);

    public abstract void registerJsMethod(String var1, BaseController var2);

    public abstract void setDimension(int var1, int var2);

    public abstract void setMinDimension(int var1, int var2);

    public void startBuffering() {
        long tid = Thread.currentThread().getId();
        this.bufferedPerThread.put(tid, Boolean.TRUE);
        this.javascriptCallsPerThread.put(tid, new ArrayDeque());
    }

    public abstract void stopBuffering();

    public DOMDocument getDocument() {
        return new DOMDocument(this);
    }

    public synchronized void setEventListenerById(String id, DOMEvent event, Listener<Event> listener, boolean replace) {
        this.execute("document.getElementById(\"" + JsUtils.escapeJs(id) + "\").addEventListener(\"" + JsUtils.escapeJs(event.name().toLowerCase()) + "\",mainEvent);");
        String listenerId = id + "_" + event.name().toLowerCase();
        if (!this.events.containsKey(listenerId) || replace) {
            this.events.put(listenerId, new ArrayList());
        }
        this.events.get(listenerId).add(listener);
    }

    public synchronized void removeEventListenerById(String id, DOMEvent event, Listener<Event> listener) {
        this.execute("document.getElementById(\"" + JsUtils.escapeJs(id) + "\").removeEventListener(\"" + JsUtils.escapeJs(event.name().toLowerCase()) + "\",mainEvent);");
        String listenerId = id + "_" + event.name().toLowerCase();
        if (this.events.get(listenerId) != null) {
            this.events.get(listenerId).remove(listener);
        }
    }

    void fireEvent(String jsonEvent) {
        try {
            Event event = new Event(jsonEvent);
            String listenerId = event.getCallerId() + "_" + event.getType();
            List<Listener<Event>> listeners = this.events.get(listenerId);
            if (listeners != null) {
                for (Listener<Event> listener : listeners.subList(0, listeners.size())) {
                    listener.notify(event);
                }
            }
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public abstract int getInnerCurrentWidth();

    public abstract int getInnerCurrentHeight();

    public abstract int getShellWidth();

    public abstract int getShellHeight();

    public abstract Object getWindow();

    public abstract void forceActive();

    public abstract void setActive();

    public abstract void setLocation(int var1, int var2);

    public abstract Point getLocation();

    public abstract void onDragEnter();

    public abstract void onDragError();

    public abstract void onDragEnd();

    public abstract void onClose(Listener<Event> var1);

    public abstract void onShow(Listener<Event> var1);

    public abstract boolean isVisible();

    public abstract void setVisible(boolean var1);

    public abstract void maximize();

    public abstract void minimize(boolean var1);

    public abstract void onResize(Runnable var1);

    public abstract void redraw();

    public abstract void setDraggableDimension(int var1, int var2);

    public abstract void setTitle(String var1);

    public abstract String getTitle();

    public abstract void toggleMaximization();

    public abstract void onMaximizationChange(Runnable var1);

    public abstract boolean isMaximized();

    public abstract void setDraggableBarDimension(int var1, int var2);

    public abstract void enableDropEvent();

    public abstract void centerOnScreen();

    public abstract void removeDragAndDropInnerArea(DragAndDropInnerArea var1);

    public abstract void addDragAndDropInnerArea(DragAndDropInnerArea var1);

    public abstract void setDragAndDropEnabled(boolean var1);

    public abstract List<String> getDocumentStyles();

    public static enum ModalType {
        NONE,
        APPLICATION_MODAL,
        PARENT_MODAL;

    }
}

