/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.ldap.afbitrux;
import esecurity.crypto.gui.ldap.cirymjsb;
import esecurity.crypto.gui.properties.AppProperties;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LdapEndPointLoader {
    private static final EllipsLogger logger = LdapEndPointLoader.YI("1qrkp35", Constants.CAPI_LOGGER_NAME);
    private static final File LDAP_DATA_FILE;
    private static final File DEFAULT_LDAP_DATA_FILE;
    private static List<LdapEndPoint> ldapDataLoader;

    public static void load() {
        ldapDataLoader = LdapEndPointLoader.loadFromFile();
    }

    public static List<LdapEndPoint> getEndPoints() {
        if (ldapDataLoader == null) {
            LdapEndPointLoader.load();
        }
        return ldapDataLoader;
    }

    public static void addEndPoint(LdapEndPoint endPoint) {
        LdapEndPointLoader.getEndPoints().add(endPoint);
    }

    public static void removeEndPoint(LdapEndPoint endPoint) {
        if (endPoint == null) {
            return;
        }
        LdapEndPointLoader.getEndPoints().remove(endPoint);
    }

    public static void removeEndPoint(String name) {
        if (name == null || LdapEndPointLoader.YI("qjup2m", name) != false) {
            return;
        }
        List<LdapEndPoint> endPoints = LdapEndPointLoader.getEndPoints();
        boolean found = false;
        for (int i = 0; !found && i < endPoints.size(); ++i) {
            if (LdapEndPointLoader.YI("-svl6t2", name, LdapEndPointLoader.YI("-isb6ug", endPoints.get(i))) == false) continue;
            endPoints.remove(i);
            found = true;
        }
    }

    public static void saveToFile() {
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.YI("foap1h", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        try {
            LdapEndPointLoader.YI("-ir76ue", om, LDAP_DATA_FILE, LdapEndPointLoader.getEndPoints());
        }
        catch (IOException ex) {
            LdapEndPointLoader.YI("1rrup34", logger, LdapEndPointLoader.YI("-vsv6ud", ex), (Object)ex);
        }
    }

    private static List<LdapEndPoint> loadFromFile() {
        ArrayList<LdapEndPoint> endpoints = new ArrayList<LdapEndPoint>();
        ObjectMapper om = new ObjectMapper();
        LdapEndPointLoader.YI("foap1h", om, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, (boolean)false);
        if (LdapEndPointLoader.YI("jk0p1c", DEFAULT_LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.YI("-a9n6ui", endpoints, (Collection)LdapEndPointLoader.YI("1t3mp1d", om, DEFAULT_LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.YI("1rrup34", logger, LdapEndPointLoader.YI("-vsv6ud", ex), (Object)ex);
            }
        }
        if (LdapEndPointLoader.YI("jk0p1c", LDAP_DATA_FILE) != false) {
            try {
                LdapEndPointLoader.YI("-a9n6ui", endpoints, (Collection)LdapEndPointLoader.YI("1t3mp1d", om, LDAP_DATA_FILE, (Object)new TypeReference<List<LdapEndPoint>>(){}));
            }
            catch (IOException ex) {
                LdapEndPointLoader.YI("1rrup34", logger, LdapEndPointLoader.YI("-vsv6ud", ex), (Object)ex);
            }
        }
        return endpoints;
    }

    static {
        char[] cArray = "\u3b38\u7b17\ue062\u63db\udbf6\u3af3\u0142\uec6c\ue111\u2df6".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x586D);
        LDAP_DATA_FILE = new File((String)LdapEndPointLoader.YI("-1qbb6so", LdapEndPointLoader.YI("-1696t1", LdapEndPointLoader.YI("-1696t1", LdapEndPointLoader.YI("-1696t1", new StringBuilder(), LdapEndPointLoader.YI("-12gv6uh", LdapEndPointLoader.YI("-ht6su"), AppProperties.WORK_FOLDER, (Object)"")), File.separator), cirymjsb.H(cArray, (short)5508, (short)3, (short)3))));
        char[] cArray2 = "\ue96d\uc38a\u70ed\ua711\uc478\u39b7\ua231\u5ad3\ue168\u3736\ud67b\u846e\u789c\u256e".toCharArray();
        cArray2[11] = (char)(cArray2[11] ^ 0x76E5);
        DEFAULT_LDAP_DATA_FILE = new File((String)LdapEndPointLoader.YI("-1qbb6so", LdapEndPointLoader.YI("-1696t1", LdapEndPointLoader.YI("-1696t1", LdapEndPointLoader.YI("-1696t1", new StringBuilder(), LdapEndPointLoader.YI("-12gv6uh", LdapEndPointLoader.YI("-ht6su"), AppProperties.BASE_FOLDER, (Object)"")), File.separator), cirymjsb.H(cArray2, (short)14725, (short)2, (short)2))));
    }

    private static Object YI(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(afbitrux.W(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

