/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.EncryptFacade$ValidationFacade;
import esecurity.crypto.gui.functionality.ValidationFacade$DecryptFacade;
import esecurity.crypto.gui.functionality.ValidationFacade$EncryptFacade;
import esecurity.crypto.gui.functionality.mlngsytl;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.SignatureRequest;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.generator.ASiCGenerator;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.pades.PadesSignatureGenerator;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOperation;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.ArubaDTSClient;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class SignatureFacade {
    private static final EllipsLogger logger = SignatureFacade.ye("1h5va0n", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static Status signatureStatus;

    private static void validate(SignatureRequest request) throws CapiException {
        if (SignatureFacade.ye("139ja19", request) == null) {
            char[] cArray = "\u19c7\uf855\uf455\u4309\u8bfa\uc759\uc8ce\uebbf\u2c51\uce0e\ue3ab\u8168\u935a\u93d2\uee6b\u5fed\uac3e\u67ad\u04b8\u7426\u0ac0\uf280\ufb73\u6a6c\uac7a\u6f3e".toCharArray();
            cArray[11] = (char)(cArray[11] ^ 0x2127);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)22088, 0, false), 1001);
        }
        if (SignatureFacade.ye("-1v80luk", request) == null) {
            char[] cArray = "\ua0b9\uc6cd\ufd3e\u4ee7\u88a6\u0c7b\u9d53\udc85\u0fba\u918e\u28ed\u11c5\uc533\ufb7e\uaaed\u75d6\uf211\ud570\u1d23\u7358\u4f42".toCharArray();
            cArray[5] = (char)(cArray[5] ^ 0x159D);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)10990, 5, false), 1001);
        }
        if (SignatureFacade.ye("-vj0lul", request) == null) {
            char[] cArray = "\uca77\u6cac\u6e34\udbfe\ue1ef\u0c76\u8cc9\u3a03\ua4b8\u7dfe\u306a\u0ab8\u985e\ud841\u8045\u8050\u4517\u6e3b".toCharArray();
            cArray[10] = (char)(cArray[10] ^ 0x64FE);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)31817, 3, true), 1001);
        }
        if (SignatureFacade.ye("-1f7olu2", request) == null) {
            char[] cArray = "\u0248\u8a3d\ua61f\u0b6d\u3a69\u718d\u45c1\u648c\ucc8d\udc63\u3c84\ud8b5\u32d8\u836d\u64e0\u8b1f\ua7e1\u6e45\ueb12\ua8b0\ucf46\u5e6d\u0adb\u6289\u40f7\u795a\u404b\u8aa3\u24ec".toCharArray();
            cArray[17] = (char)(cArray[17] ^ 0xA23);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)31724, 4, false), 1001);
        }
        if (SignatureFacade.ye("-510lu3", request).isEmpty()) {
            char[] cArray = "\ub4be\u9d09\u7ccd\u16f7C\ue37e\u4199\u862e\u5cbb\u680f\u3ac2\ue72d\ub068\ue1c3\ufc69\u9bb0\u6e56\u53e8\udbf7\ua484\u2b47\ua527\u1876\u5c4b".toCharArray();
            cArray[16] = (char)(cArray[16] ^ 0x2FE0);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)22573, 5, true), 1001);
        }
        if (SignatureFacade.ye("dt3a1g", request) == null && SignatureFacade.ye("1m2ja1f", (Object)SignatureType.ASICE, SignatureFacade.ye("139ja19", request)) != false) {
            char[] cArray = "\u3c15\u5f39\u8ea7\u94f0\uf3d1\ub81a\u6fa5\u6e63\u34ac\uf9be\uf5db\uec39\ueab4\u2202\u77dc\u83df\uad2c\u9a2e\u1828\udb2f\u4ad7\u866d\u588d\uf3c6\uc2d9\u8541\u24a3\u6425\ue993\uf7db\ua445\u7826\u344c\u917e\ue8b2\ubea0\u4b82\u04f4\u165c\u3c2b\u26fc\u6c75\uc735\u0126\u7bb2\u8ece\u4fe0\u9c4a\udc0c\u080c\u6b01\ubd5b\u54aa\uc4cb\u6515".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x793E);
            throw new CapiException(ValidationFacade$DecryptFacade.C(cArray, (short)672, 4, false), 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult sign(SignatureRequest request) {
        try {
            SignatureFacade.validate(request);
            if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.LT) != false && SignatureFacade.ye("-1ovcluc", request) == null) {
                char[] cArray = "\u51c5\uded9\u22db\u6872\ua80d\ub8a0\uac95\u3c44\u6dc6\uecbf\uadf7\ua6bb\ue503\ucdb1\u1e61\u44d9\u6155\ubb8a\u18ab\u1a04\u1570\u5843\u5939\u2308\ud788\ua7bb\u0c4d\uadb3\u3546\ud857\u3339\u8736\u5596\u3cf9\u2149\ue209\u8698\u81c8\uf011\ua16c\ud934\u689c".toCharArray();
                cArray[40] = (char)(cArray[40] ^ 0x1D7A);
                OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$DecryptFacade.C(cArray, (short)31072, 2, true)), SignatureFacade.ye("-510lu3", request), (File)SignatureFacade.ye("15t3a1j", request));
                return operationResult;
            }
            signatureStatus = null;
            boolean withError = false;
            block4 : switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.ye("-uhklvr", SignatureFacade.ye("139ja19", request))]) {
                case 1: 
                case 2: 
                case 3: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.ye("-510lu3", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.ye("thfa1n", (Object)StatusLevel.ERROR, SignatureFacade.ye("-1jk0lu8", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 4: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.ye("-510lu3", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signPAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.ye("thfa1n", (Object)StatusLevel.ERROR, SignatureFacade.ye("-1jk0lu8", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 5: {
                    ASiCGenerator asicGenerator = new ASiCGenerator();
                    MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
                    ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
                    TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
                    Iterator iterator = SignatureFacade.ye("-510lu3", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAsicS(file, request, tstOpts, aSiCGeneratorOptions, mutableASiCOptions, asicGenerator);
                        if (signatureStatus == null || SignatureFacade.ye("thfa1n", (Object)StatusLevel.ERROR, SignatureFacade.ye("-1jk0lu8", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 6: {
                    withError |= SignatureFacade.signAsicE(request);
                    break;
                }
                default: {
                    char[] cArray = "\ue92d\u3214\u34c1\u664e\u164d\ucf18\u03ae\uf07a\u2c84\u47b6\ue682\ueed9\u7c57\ueec8\u9030\u6441\u3dd8\ubf4f\ua660\ub10f\u7d92\u487c\u4fdb\u884c\u82df\uc143\ua7d5\u5098".toCharArray();
                    cArray[20] = (char)(cArray[20] ^ 0x61A);
                    OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$DecryptFacade.C(cArray, (short)29312, 4, true)), SignatureFacade.ye("-510lu3", request), (File)SignatureFacade.ye("15t3a1j", request));
                    return operationResult;
                }
            }
            if (withError && signatureStatus == null) {
                boolean allError = true;
                Iterator ftsIt = SignatureFacade.ye("-510lu3", request).iterator();
                while (ftsIt.hasNext() && allError) {
                    allError = SignatureFacade.ye("thfa1n", (Object)StatusLevel.SUCCESS, SignatureFacade.ye("-1jk0lu8", SignatureFacade.ye("-9qalu6", (FileToSign)ftsIt.next()))) == false;
                }
                signatureStatus = allError ? new Status(StatusLevel.ERROR, "") : new Status(StatusLevel.WARNING, "");
            } else if (signatureStatus == null) {
                signatureStatus = new Status(StatusLevel.SUCCESS, "");
            }
        }
        catch (Throwable ex) {
            SignatureFacade.ye("-ao8lvd", logger, SignatureFacade.ye("1eb9a1m", ex), (Object)ex);
            signatureStatus = new Status(StatusLevel.ERROR, ex);
        }
        finally {
            SignatureFacade.ye("meha06");
        }
        return new OperationResult(signatureStatus, SignatureFacade.ye("-510lu3", request), (File)SignatureFacade.ye("15t3a1j", request));
    }

    private static SignatureGenerator getAdesSignatureGenerator(SignatureRequest request) {
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.ye("-uhklvr", SignatureFacade.ye("139ja19", request))]) {
            case 1: 
            case 3: {
                return new CadesSignatureGenerator();
            }
            case 4: {
                return new PadesSignatureGenerator();
            }
            case 2: {
                return new XadesSignatureGenerator();
            }
        }
        return null;
    }

    private static TimeStampOptions getAsicTstOptions(SignatureRequest request) throws IllegalParamException {
        if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.BES) != false) {
            return null;
        }
        TimeStampOptions tstOpts = new TimeStampOptions();
        SignatureFacade.ye("10ota1p", tstOpts, true);
        SignatureFacade.ye("-1lnslu5", tstOpts, new ArubaDTSClient((TSAData)SignatureFacade.ye("-pp2lu4", request), (NetworkConfig)SignatureFacade.ye("1l93a0v", SignatureFacade.ye("hmna10"))));
        SignatureFacade.ye("-1aa4mli", tstOpts, DigestAlgorithm.SHA256);
        SignatureFacade.ye("1jot9ad", tstOpts, "");
        return tstOpts;
    }

    private static SignatureOptions getAdesSignatureOptions(SignatureRequest request) throws IllegalParamException {
        CadesSignatureOptions signatureOptions = null;
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.ye("-uhklvr", SignatureFacade.ye("139ja19", request))]) {
            case 1: 
            case 3: {
                signatureOptions = new CadesSignatureOptions();
                SignatureFacade.ye("-8m8mm1", signatureOptions, SignatureFacade.ye("1mbl9a0", request));
                break;
            }
            case 4: {
                signatureOptions = new PadesSignatureOptions();
                SignatureFacade.ye("1ne59a1", (PadesSignatureOptions)signatureOptions, SignatureFacade.ye("1ndv9a2", request));
                break;
            }
            case 2: {
                signatureOptions = new XadesSignatureOptions();
                SignatureFacade.ye("-8m8mm1", signatureOptions, SignatureFacade.ye("1mbl9a0", request));
            }
        }
        if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.BES) == false) {
            TimeStampOptions timeStampOptions = new TimeStampOptions();
            SignatureFacade.ye("10ota1p", timeStampOptions, true);
            SignatureFacade.ye("-1lnslu5", timeStampOptions, new ArubaDTSClient((TSAData)SignatureFacade.ye("-pp2lu4", request), (NetworkConfig)SignatureFacade.ye("1l93a0v", SignatureFacade.ye("hmna10"))));
            SignatureFacade.ye("-1aa4mli", timeStampOptions, DigestAlgorithm.SHA256);
            SignatureFacade.ye("1jot9ad", timeStampOptions, "");
            SignatureFacade.ye("-1d3kmls", signatureOptions, timeStampOptions);
            SignatureFacade.ye("-i3mmlt", signatureOptions, SignatureFacade.ye("1p0na1i", request));
            if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.LT) != false) {
                SignatureFacade.ye("1bop9am", signatureOptions, SignatureFacade.ye("-1ovcluc", request));
            }
        }
        SignatureFacade.ye("snb9al", signatureOptions, SignatureFacade.ye("1l93a0v", SignatureFacade.ye("hmna10")));
        SignatureFacade.ye("-c5qmlo", signatureOptions, SignatureFacade.ye("-1v80luk", request));
        SignatureFacade.ye("-ue6mlp", signatureOptions, SignatureFacade.ye("-vj0lul", request));
        SignatureFacade.ye("h3b9aa", signatureOptions, SignatureFacade.ye("-1f7olu2", request));
        return signatureOptions;
    }

    private static boolean signPAdESDocument(FileToSign file, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        boolean withAppearance;
        boolean withError = false;
        int appearancesCount = 0;
        int i = 0;
        boolean bl = withAppearance = SignatureFacade.ye("-tngmln", file) != null && !SignatureFacade.ye("-tngmln", file).isEmpty();
        if (withAppearance) {
            appearancesCount = SignatureFacade.ye("-tngmln", file).size();
        }
        File destFile = SignatureFacade.createDestinationFile(file, request);
        FileToSign convert = file;
        if (SignatureFacade.ye("oqf9ac", file) != false) {
            Object c = SignatureFacade.ye("2n59ab", file);
            convert = new FileToSign((File)c);
            SignatureFacade.ye("1uj79at", convert, SignatureFacade.ye("nsf9au", file));
            SignatureFacade.ye("191t9af", convert, SignatureFacade.ye("p5n9ag", file));
            SignatureFacade.ye("-rd6mlf", convert, SignatureFacade.ye("-1onomle", file));
        }
        ArrayDeque toDelete = new ArrayDeque();
        Object fileName = SignatureFacade.ye("-rugmlc", convert);
        do {
            File toDel;
            File tmp;
            block41: {
                if (withAppearance) {
                    SignatureFacade.setUpAppearance((PadesSignatureOptions)signatureOptions, (CapiPDFApparence)SignatureFacade.ye("-tngmln", file).get(i));
                }
                tmp = SignatureFacade.ye("-17s4mld", fileName, SignatureFacade.ye("-1onomle", convert), (FileAttribute[])new FileAttribute[0]).toFile();
                SignatureFacade.ye("ulra56", toDelete, tmp);
                try {
                    Object ih = SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), convert));
                    Throwable throwable = null;
                    try {
                        Object oh = SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), tmp), true));
                        Throwable throwable2 = null;
                        try {
                            SignatureFacade.ye("-h28lqr", signatureOptions, ih);
                            SignatureFacade.ye("pf99ao", signatureOptions, oh);
                            char[] cArray = "\u6b86\u54e3".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x29CF);
                            SignatureFacade.ye("191t9af", convert, SignatureFacade.ye("-s4ulvf", SignatureFacade.ye("5g39an", destFile), 0, (int)SignatureFacade.ye("-ghoml6", SignatureFacade.ye("5g39an", destFile), ValidationFacade$EncryptFacade.K(cArray, (short)25576, 1, (byte)0))));
                            try {
                                if (SignatureFacade.ye("uin9ap", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.ye("1t379as", signatureGenerator, signatureOptions);
                                    if (SignatureFacade.ye("1m2ja1f", SignatureFacade.ye("139ja19", request), (Object)SignatureType.TSD) != false) {
                                        SignatureFacade.ye("-16pulvs", SignatureFacade.ye("-181eml5", signatureOptions));
                                        char[] cArray2 = "\u4da8\u7a41\u1aad\u3dc2\u9910\u140d\u04a3\u619e\u8ad8\u640d\u7246\ud93b\u9a53\u8f02\ucc25\u3bf7\ue772\u16a2\u9436\ud6d8\uf2a1\u2c10\u682f".toCharArray();
                                        cArray2[14] = (char)(cArray2[14] ^ 0x3EBD);
                                        SignatureFacade.ye("1d4p9bd", SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), tmp)), SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), tmp), true)), (Object)SignatureFacade.ye("-pp2lu4", request), (Object)SignatureFacade.ye("-rugmlc", file), (Object)ValidationFacade$EncryptFacade.K(cArray2, (short)19444, 0, (byte)4), (Object)SignatureFacade.ye("-1eeimki"), (boolean)false);
                                    }
                                    break block41;
                                }
                                if (SignatureFacade.ye("uin9ap", request) == SignatureOperation.COUNTER_SIGN) {
                                    SignatureFacade.ye("-1l9sml1", signatureOptions, SignatureFacade.ye("-4cmml0", request));
                                }
                                SignatureFacade.ye("1kk99b2", signatureGenerator, signatureOptions);
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.ye("do99b1", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.ye("-8m8mm1", signatureOptions, SignatureFacade.ye("do99b1", (Object)e));
                                if (SignatureFacade.ye("uin9ap", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.ye("1t379as", signatureGenerator, signatureOptions);
                                    break block41;
                                }
                                SignatureFacade.ye("1kk99b2", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (oh != null) {
                                if (throwable2 != null) {
                                    try {
                                        SignatureFacade.ye("-16pulvs", oh);
                                    }
                                    catch (Throwable throwable4) {
                                        SignatureFacade.ye("1fina03", throwable2, throwable4);
                                    }
                                } else {
                                    SignatureFacade.ye("-16pulvs", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ih != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.ye("-3m6lva", ih);
                                }
                                catch (Throwable throwable6) {
                                    SignatureFacade.ye("1fina03", throwable, throwable6);
                                }
                            } else {
                                SignatureFacade.ye("-3m6lva", ih);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    withError = true;
                    SignatureFacade.ye("-ao8lvd", logger, SignatureFacade.ye("1eb9a1m", ex), (Object)ex);
                    if (SignatureFacade.isTokenException(ex)) {
                        signatureStatus = new Status(StatusLevel.ERROR, ex);
                    }
                    SignatureFacade.ye("-gbmmks", file, new Status(StatusLevel.ERROR, ex));
                }
            }
            if (SignatureFacade.ye("-9qalu6", file) == null) {
                char[] cArray = "\ub3fe\uf4d0\u1484".toCharArray();
                cArray[0] = (char)(cArray[0] ^ 0x2CBA);
                SignatureFacade.ye("-gbmmks", file, new Status(StatusLevel.SUCCESS, ValidationFacade$EncryptFacade.K(cArray, (short)23661, 2, (byte)5)));
            }
            convert = new FileToSign(tmp);
            SignatureFacade.ye("1uj79at", convert, SignatureFacade.ye("nsf9au", file));
            SignatureFacade.ye("-rd6mlf", convert, SignatureFacade.ye("-1onomle", file));
            ++i;
            if (SignatureFacade.ye("1h1t9b3", toDelete) <= 2 || (toDel = (File)SignatureFacade.ye("1sof9bm", toDelete)) == null) continue;
            SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", toDel));
        } while (i < appearancesCount && !withError);
        if (!withError) {
            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("rvt9b8", convert), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        Object object = SignatureFacade.ye("o7v9b7", toDelete);
        while (object.hasNext()) {
            File del = (File)object.next();
            SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", del));
        }
        return withError;
    }

    private static void setUpAppearance(PadesSignatureOptions signatureOptions, CapiPDFApparence appearance) {
        if (appearance == null) {
            return;
        }
        SignatureFacade.ye("-1u8mmkm", signatureOptions, appearance);
        SignatureFacade.ye("89l9bc", signatureOptions, SignatureFacade.ye("1bll9b9", appearance));
        SignatureFacade.ye("1vgn9bu", signatureOptions, SignatureFacade.ye("-mtcmkl", appearance));
        SignatureFacade.ye("1m499bg", signatureOptions, SignatureFacade.ye("dl99bt", appearance));
        SignatureFacade.ye("-pdgmke", signatureOptions, (boolean)SignatureFacade.ye("qbd9bf", appearance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean signAdESDocument(FileToSign fileToSign, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        block45: {
            docError = false;
            withError = false;
            destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            outTmpFile = SignatureFacade.ye("-17s4mld", SignatureFacade.ye("-rugmlc", fileToSign), SignatureFacade.ye("-1onomle", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            tsdIntTmp = null;
            defOut = SignatureFacade.ye("-qc4mkf", request) != false ? (tsdIntTmp = SignatureFacade.ye("-17s4mld", SignatureFacade.ye("-rugmlc", fileToSign), SignatureFacade.ye("-1onomle", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile()) : outTmpFile;
            try {
                block44: {
                    ih = SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), fileToSign));
                    var11_12 = null;
                    try {
                        oh = SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), defOut), true));
                        var13_16 = null;
                        try {
                            SignatureFacade.ye("-h28lqr", signatureOptions, ih);
                            SignatureFacade.ye("pf99ao", signatureOptions, oh);
                            v0 = "\u9fb0\u0d67".toCharArray();
                            v0[0] = (char)(v0[0] ^ 844);
                            SignatureFacade.ye("191t9af", fileToSign, SignatureFacade.ye("-s4ulvf", SignatureFacade.ye("5g39an", destFile), 0, (int)SignatureFacade.ye("-ghoml6", SignatureFacade.ye("5g39an", destFile), ValidationFacade$DecryptFacade.C(v0, (short)17994, 2, true))));
                            try {
                                switch (1.$SwitchMap$it$actalis$ellips$capi$signature$SignatureOperation[SignatureFacade.ye("-1lpsmkc", SignatureFacade.ye("uin9ap", request))]) {
                                    case 1: {
                                        SignatureFacade.ye("1t379as", signatureGenerator, signatureOptions);
                                        if (SignatureFacade.ye("-qc4mkf", request) == false) break;
                                        SignatureFacade.applyTsd(signatureOptions, tsdIntTmp, outTmpFile, (String)SignatureFacade.ye("-rugmlc", fileToSign));
                                        break;
                                    }
                                    case 2: {
                                        SignatureFacade.ye("-1l9sml1", signatureOptions, SignatureFacade.ye("-4cmml0", request));
                                    }
                                    case 3: {
                                        SignatureFacade.ye("1kk99b2", signatureGenerator, signatureOptions);
                                    }
                                }
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.ye("do99b1", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.ye("-8m8mm1", signatureOptions, SignatureFacade.ye("do99b1", (Object)e));
                                if (SignatureFacade.ye("uin9ap", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.ye("1t379as", signatureGenerator, signatureOptions);
                                    break block44;
                                }
                                SignatureFacade.ye("1kk99b2", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable var14_19) {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        finally {
                            if (oh != null) {
                                if (var13_16 != null) {
                                    try {
                                        SignatureFacade.ye("-16pulvs", oh);
                                    }
                                    catch (Throwable var14_18) {
                                        SignatureFacade.ye("1fina03", var13_16, var14_18);
                                    }
                                } else {
                                    SignatureFacade.ye("-16pulvs", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable var12_15) {
                        var11_12 = var12_15;
                        throw var12_15;
                    }
                    finally {
                        if (ih != null) {
                            if (var11_12 != null) {
                                try {
                                    SignatureFacade.ye("-3m6lva", ih);
                                }
                                catch (Throwable var12_14) {
                                    SignatureFacade.ye("1fina03", var11_12, var12_14);
                                }
                            } else {
                                SignatureFacade.ye("-3m6lva", ih);
                            }
                        }
                    }
                }
                if (docError) break block45;
            }
            catch (Throwable ex) {
                block46: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.ye("-ao8lvd", SignatureFacade.logger, SignatureFacade.ye("1eb9a1m", ex), (Object)ex);
                        if (SignatureFacade.isTokenException(ex)) {
                            SignatureFacade.signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.ye("-gbmmks", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block46;
                    }
                    catch (Throwable var19_24) {
                        if (!docError) {
                            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", outTmpFile), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", outTmpFile));
                        if (tsdIntTmp != null) {
                            SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tsdIntTmp));
                        }
                        throw var19_24;
                    }
                    SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", outTmpFile), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", outTmpFile));
                if (tsdIntTmp != null) {
                    SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tsdIntTmp));
                } else {
                    ** GOTO lbl108
                }
            }
            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", outTmpFile), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", outTmpFile));
        if (tsdIntTmp != null) {
            SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tsdIntTmp));
        }
        if (SignatureFacade.ye("-9qalu6", fileToSign) == null) {
            v1 = "\u4e91\ufe3e\u4cd1".toCharArray();
            v1[0] = (char)(v1[0] ^ 713);
            SignatureFacade.ye("-gbmmks", fileToSign, new Status(StatusLevel.SUCCESS, ValidationFacade$DecryptFacade.C(v1, (short)18311, 2, false)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean signAsicS(FileToSign fileToSign, SignatureRequest request, TimeStampOptions tstOpts, ASiCGeneratorOptions aSiCGeneratorOptions, MutableASiCOptions mutableASiCOptions, ASiCGenerator asicGenerator) throws IOException {
        File tmp;
        boolean withError;
        block35: {
            boolean docError = false;
            withError = false;
            File destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            tmp = SignatureFacade.ye("-17s4mld", SignatureFacade.ye("-rugmlc", fileToSign), SignatureFacade.ye("-1onomle", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            try {
                Object inDoc = SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), fileToSign));
                Throwable throwable = null;
                try {
                    Object outH = SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-rvolo7"), true), tmp));
                    Throwable throwable2 = null;
                    try {
                        SignatureOptions entry = new SignatureOptions();
                        SignatureFacade.ye("-h28lqr", entry, inDoc);
                        SignatureFacade.ye("kp79bj", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.ye("-8m8mm1", entry, SignatureMode.DETACHED);
                        SignatureFacade.ye("-c5qmlo", entry, SignatureFacade.ye("-1v80luk", request));
                        SignatureFacade.ye("h3b9aa", entry, SignatureFacade.ye("-1f7olu2", request));
                        SignatureFacade.ye("-ue6mlp", entry, SignatureFacade.ye("-vj0lul", request));
                        SignatureFacade.ye("snb9al", entry, SignatureFacade.ye("1l93a0v", SignatureFacade.ye("hmna10")));
                        if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.BES) == false) {
                            SignatureFacade.ye("-1d3kmls", entry, tstOpts);
                            SignatureFacade.ye("-i3mmlt", entry, SignatureFacade.ye("1p0na1i", request));
                            if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.LT) != false) {
                                SignatureFacade.ye("1bop9am", entry, SignatureFacade.ye("-1ovcluc", request));
                            }
                        }
                        ArrayList<SignatureOptions> signEntries = new ArrayList<SignatureOptions>();
                        signEntries.add(entry);
                        SignatureFacade.ye("-3pomlq", mutableASiCOptions, ASiCFormat.SIMPLE);
                        SignatureFacade.ye("ckr9bo", mutableASiCOptions, SignatureFacade.ye("19el9a5", request));
                        SignatureFacade.ye("1qh9bn", aSiCGeneratorOptions, mutableASiCOptions);
                        SignatureFacade.ye("161d9bq", aSiCGeneratorOptions, signEntries);
                        SignatureFacade.ye("1hh19bp", aSiCGeneratorOptions, outH);
                        char[] cArray = "\u62f0\u7583".toCharArray();
                        cArray[0] = (char)(cArray[0] ^ 0x156D);
                        SignatureFacade.ye("191t9af", fileToSign, SignatureFacade.ye("-s4ulvf", SignatureFacade.ye("5g39an", destFile), 0, (int)SignatureFacade.ye("-ghoml6", SignatureFacade.ye("5g39an", destFile), EncryptFacade$ValidationFacade.C(cArray, (short)15989, true, (byte)4))));
                        SignatureFacade.ye("cif9bs", asicGenerator, aSiCGeneratorOptions);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outH != null) {
                            if (throwable2 != null) {
                                try {
                                    SignatureFacade.ye("-16pulvs", outH);
                                }
                                catch (Throwable throwable4) {
                                    SignatureFacade.ye("1fina03", throwable2, throwable4);
                                }
                            } else {
                                SignatureFacade.ye("-16pulvs", outH);
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inDoc != null) {
                        if (throwable != null) {
                            try {
                                SignatureFacade.ye("-3m6lva", inDoc);
                            }
                            catch (Throwable throwable6) {
                                SignatureFacade.ye("1fina03", throwable, throwable6);
                            }
                        } else {
                            SignatureFacade.ye("-3m6lva", inDoc);
                        }
                    }
                }
                if (docError) break block35;
            }
            catch (Throwable ex) {
                block36: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.ye("l45a7k", logger, SignatureFacade.ye("1eb9a1m", ex));
                        if (SignatureFacade.isTokenException(ex)) {
                            signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.ye("-gbmmks", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block36;
                    }
                    catch (Throwable throwable) {
                        if (!docError) {
                            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
                        throw throwable;
                    }
                    SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
            }
            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
        if (SignatureFacade.ye("-9qalu6", fileToSign) == null) {
            char[] cArray = "\u05e8\u8896\u5e2a".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x1E);
            SignatureFacade.ye("-gbmmks", fileToSign, new Status(StatusLevel.SUCCESS, EncryptFacade$ValidationFacade.C(cArray, (short)15540, false, (byte)2)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean signAsicE(SignatureRequest request) throws IOException, IllegalParamException {
        File tmp;
        File destFile;
        ArrayList<SignatureOptions> signEntries;
        boolean withError;
        boolean docError;
        block24: {
            docError = false;
            withError = false;
            signEntries = new ArrayList<SignatureOptions>();
            destFile = SignatureFacade.createDestinationFile((FileToSign)SignatureFacade.ye("dt3a1g", request), request);
            char[] cArray = "\uf968\u8775\ue2ec\u84ac\u6235\u3991\u411b".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x7533);
            tmp = SignatureFacade.ye("-17s4mld", SignatureFacade.ye("5g39an", destFile), ValidationFacade$EncryptFacade.K(cArray, (short)21283, 1, (byte)1), (FileAttribute[])new FileAttribute[0]).toFile();
            ASiCGenerator asicGenerator = new ASiCGenerator();
            MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
            ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
            TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
            try {
                Throwable throwable;
                Iterator oh;
                block25: {
                    oh = SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), tmp), true));
                    throwable = null;
                    Iterator iterator = SignatureFacade.ye("-510lu3", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        SignatureOptions entry = new SignatureOptions();
                        Object inDoc = SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), file));
                        SignatureFacade.ye("-h28lqr", entry, inDoc);
                        SignatureFacade.ye("kp79bj", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.ye("-8m8mm1", entry, SignatureMode.DETACHED);
                        SignatureFacade.ye("-c5qmlo", entry, SignatureFacade.ye("-1v80luk", request));
                        SignatureFacade.ye("h3b9aa", entry, SignatureFacade.ye("-1f7olu2", request));
                        SignatureFacade.ye("-ue6mlp", entry, SignatureFacade.ye("-vj0lul", request));
                        if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.BES) == false) {
                            SignatureFacade.ye("-1d3kmls", entry, tstOpts);
                            SignatureFacade.ye("-i3mmlt", entry, SignatureFacade.ye("1p0na1i", request));
                            if (SignatureFacade.ye("-1ku2luf", SignatureFacade.ye("1p0na1i", request), SignatureLevel.LT) != false) {
                                SignatureFacade.ye("1bop9am", entry, SignatureFacade.ye("-1ovcluc", request));
                            }
                        }
                        signEntries.add(entry);
                    }
                    SignatureFacade.ye("-3pomlq", mutableASiCOptions, ASiCFormat.EXTENDED);
                    SignatureFacade.ye("ckr9bo", mutableASiCOptions, SignatureFacade.ye("19el9a5", request));
                    SignatureFacade.ye("1qh9bn", aSiCGeneratorOptions, mutableASiCOptions);
                    SignatureFacade.ye("161d9bq", aSiCGeneratorOptions, signEntries);
                    SignatureFacade.ye("1hh19bp", aSiCGeneratorOptions, oh);
                    SignatureFacade.ye("cif9bs", asicGenerator, aSiCGeneratorOptions);
                    if (oh == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        SignatureFacade.ye("-16pulvs", oh);
                    }
                    catch (Throwable throwable2) {
                        SignatureFacade.ye("1fina03", throwable, throwable2);
                    }
                    break block24;
                }
                SignatureFacade.ye("-16pulvs", oh);
                break block24;
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (oh != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.ye("-16pulvs", oh);
                                }
                                catch (Throwable throwable5) {
                                    SignatureFacade.ye("1fina03", throwable, throwable5);
                                }
                            } else {
                                SignatureFacade.ye("-16pulvs", oh);
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (Throwable ex) {
                try {
                    withError = true;
                    docError = true;
                    SignatureFacade.ye("l45a7k", logger, SignatureFacade.ye("1eb9a1m", ex));
                    signatureStatus = new Status(StatusLevel.ERROR, ex);
                }
                catch (Throwable throwable) {
                    for (SignatureOptions entry : signEntries) {
                        if (SignatureFacade.ye("-1n2gmk5", entry) == null) continue;
                        SignatureFacade.ye("-3m6lva", SignatureFacade.ye("-1n2gmk5", entry));
                    }
                    if (!docError) {
                        SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
                    throw throwable;
                }
                for (SignatureOptions entry : signEntries) {
                    if (SignatureFacade.ye("-1n2gmk5", entry) == null) continue;
                    SignatureFacade.ye("-3m6lva", SignatureFacade.ye("-1n2gmk5", entry));
                }
                if (!docError) {
                    SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
            }
        }
        for (SignatureOptions entry : signEntries) {
            if (SignatureFacade.ye("-1n2gmk5", entry) == null) continue;
            SignatureFacade.ye("-3m6lva", SignatureFacade.ye("-1n2gmk5", entry));
        }
        if (!docError) {
            SignatureFacade.ye("-q1glvp", SignatureFacade.ye("39ra08", tmp), SignatureFacade.ye("39ra08", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.ye("-n2amkb", SignatureFacade.ye("39ra08", tmp));
        return withError;
    }

    private static void applyTsd(SignatureOptions signatureOptions, File inputFile, File outputFile, String outFileName) throws Exception {
        TSAData tsaData = new TSAData();
        Object prop = SignatureFacade.ye("hmna10");
        SignatureFacade.ye("-1huilrj", tsaData, SignatureFacade.ye("-7qelri", prop, ServerProperties.TSA_ACCOUNT, (Object)""));
        SignatureFacade.ye("-1ssqls0", tsaData, SignatureFacade.ye("-7qelri", prop, ServerProperties.TSA_SERVER_ADDRESS, (Object)""));
        SignatureFacade.ye("1fc3a3v", tsaData, SignatureFacade.ye("-7qelri", prop, ServerProperties.TSA_POLICY, (Object)""));
        SignatureFacade.ye("-g6slru", tsaData, SignatureFacade.ye("-7qelri", prop, ServerProperties.TSA_PASSWORD, (Object)""));
        Object inputHandlerFile = SignatureFacade.ye("-1t2clo5", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), inputFile));
        Throwable throwable = null;
        try {
            Object outputHandlerFile = SignatureFacade.ye("-1faklvj", SignatureFacade.ye("-1oc8lvi", SignatureFacade.ye("-p22lo4", SignatureFacade.ye("-rvolo7"), outputFile), true));
            Throwable throwable2 = null;
            try {
                SignatureFacade.ye("-16pulvs", SignatureFacade.ye("-181eml5", signatureOptions));
                char[] cArray = "\u6682\u1194\ubfde\u911a\u2d3f\u3bc9\udbda\u19db\ue2cc\uc61e\u0bbb\uaee8\u36eb\uc970\u2fb0\u93ff\u42ee\ufef2\ub398\uc17a\uc7d1\uc9c1\u1b95".toCharArray();
                cArray[9] = (char)(cArray[9] ^ 0x784A);
                SignatureFacade.ye("1d4p9bd", inputHandlerFile, outputHandlerFile, (Object)tsaData, (Object)outFileName, (Object)ValidationFacade$EncryptFacade.K(cArray, (short)21216, 0, (byte)5), (Object)SignatureFacade.ye("-1eeimki"), (boolean)false);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (outputHandlerFile != null) {
                    if (throwable2 != null) {
                        try {
                            SignatureFacade.ye("-16pulvs", outputHandlerFile);
                        }
                        catch (Throwable throwable4) {
                            SignatureFacade.ye("1fina03", throwable2, throwable4);
                        }
                    } else {
                        SignatureFacade.ye("-16pulvs", outputHandlerFile);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (inputHandlerFile != null) {
                if (throwable != null) {
                    try {
                        SignatureFacade.ye("-3m6lva", inputHandlerFile);
                    }
                    catch (Throwable throwable6) {
                        SignatureFacade.ye("1fina03", throwable, throwable6);
                    }
                } else {
                    SignatureFacade.ye("-3m6lva", inputHandlerFile);
                }
            }
        }
    }

    private static File createDestinationFile(FileToSign src, SignatureRequest request) throws IOException {
        Object destinationFolder = SignatureFacade.ye("15t3a1j", request);
        if (destinationFolder == null) {
            destinationFolder = SignatureFacade.ye("1btda41", src);
        }
        if (SignatureFacade.ye("uin9ap", request) == SignatureOperation.NEW_SIGN) {
            return SignatureFacade.ye("887a7n", destinationFolder, SignatureFacade.ye("p5n9ag", src), (Object)SignatureFacade.ye("-1onomle", src));
        }
        if (SignatureFacade.ye("1m2ja1f", (Object)SignatureType.ASICE, SignatureFacade.ye("139ja19", request)) != false) {
            return new File((String)SignatureFacade.ye("128da01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("1i0ha44", new StringBuilder(), destinationFolder), File.separator), SignatureFacade.ye("p5n9ag", src)), SignatureFacade.ye("-1onomle", src))));
        }
        return new File((String)SignatureFacade.ye("128da01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("-1chem01", SignatureFacade.ye("-1chem01", new StringBuilder(), SignatureFacade.ye("-j6alrt", src)), File.separator), SignatureFacade.ye("p5n9ag", src)), SignatureFacade.ye("-1onomle", src))));
    }

    private static boolean isTokenException(Throwable ex) {
        if (!(ex instanceof CapiException)) {
            return false;
        }
        CapiException capiException = (CapiException)ex;
        return SignatureFacade.ye("10bfa4m", (Object)capiException) == 2014 || SignatureFacade.ye("10bfa4m", (Object)capiException) == 2001 || SignatureFacade.ye("10bfa4m", (Object)capiException) == 10013;
    }

    static /* synthetic */ I18N access$000() {
        return i18n;
    }

    static {
        char[] cArray = "\uef6c\u0717\u17be\u9eda\u05ef\u5057\u673c\u23c0\uf256\u8a04\u6091\u10fa\u0691\u301a\ubbca\u2176\ucb27\ufdc3\uf68f\ub81f\u2e38\u66ea\u88db\u6165\u3ccf\u3c7c\ua63f\u74d0\u8b55\u35cb\u933b\uc575\u43fa\u4b89\u6907\u7603\u7756".toCharArray();
        cArray[16] = (char)(cArray[16] ^ 0x5007);
        i18n = SignatureFacade.ye("-1134lrb", ValidationFacade$DecryptFacade.C(cArray, (short)32423, 3, false));
        signatureStatus = null;
    }

    private static Object ye(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mlngsytl.I(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }

    public static final class SignatureFormat
    extends Enum<SignatureFormat> {
        public static final /* enum */ SignatureFormat T;
        public static final /* enum */ SignatureFormat LT;
        public static final /* enum */ SignatureFormat TSD;
        private final SignatureLevel signatureLevel;
        private static final /* synthetic */ SignatureFormat[] $VALUES;

        public static SignatureFormat[] values() {
            return (SignatureFormat[])$VALUES.clone();
        }

        public static SignatureFormat valueOf(String name) {
            return (SignatureFormat)((Object)SignatureFormat.jX("-emuluo", SignatureFormat.class, name));
        }

        private SignatureFormat(SignatureLevel signatureLevel) {
            this.signatureLevel = signatureLevel;
        }

        public SignatureLevel getSignatureLevel() {
            return this.signatureLevel;
        }

        static {
            char[] cArray = "\u77ce\u74a5".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x6B14);
            T = new SignatureFormat(SignatureLevel.T);
            char[] cArray2 = "\u7ac8\udcb2\u038a".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x2C0F);
            LT = new SignatureFormat(SignatureLevel.LT);
            char[] cArray3 = "\u48c9\u3c5a\uac02\u40b2".toCharArray();
            cArray3[0] = (char)(cArray3[0] ^ 0x28F1);
            TSD = new SignatureFormat(SignatureLevel.BES);
            $VALUES = new SignatureFormat[]{T, LT, TSD};
        }

        private static Object jX(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mlngsytl.I(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }

    public static final class SignatureType
    extends Enum<SignatureType> {
        public static final /* enum */ SignatureType CADES;
        public static final /* enum */ SignatureType PADES;
        public static final /* enum */ SignatureType XADES;
        public static final /* enum */ SignatureType ASICS;
        public static final /* enum */ SignatureType ASICE;
        public static final /* enum */ SignatureType TSD;
        private final String extension;
        private final String name;
        private final String fullName;
        private final String description;
        private static final /* synthetic */ SignatureType[] $VALUES;

        public static SignatureType[] values() {
            return (SignatureType[])$VALUES.clone();
        }

        public static SignatureType valueOf(String name) {
            return (SignatureType)((Object)SignatureType.wq("-emuluo", SignatureType.class, name));
        }

        private SignatureType(String name, String ext, String fullName, String description) {
            this.name = name;
            this.extension = ext;
            this.fullName = fullName;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getFullName() {
            Object temp = SignatureType.wq("-1770lum", SignatureType.wq("1bpha17"), this.fullName, (Object[])new Object[0]);
            char[] cArray = "\u642b\u22b3\u38ab".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x55D7);
            char[] cArray2 = "\u47ea\uacb2\u34c8".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x391B);
            if (SignatureType.wq("1omva0g", temp, SignatureType.wq("128da01", SignatureType.wq("-1chem01", SignatureType.wq("-1chem01", SignatureType.wq("-1chem01", new StringBuilder(), ValidationFacade$EncryptFacade.K(cArray, (short)2000, 3, (byte)5)), this.fullName), ValidationFacade$EncryptFacade.K(cArray2, (short)8895, 4, (byte)3)))) != false) {
                return this.fullName;
            }
            return temp;
        }

        public String getDescription() {
            Object temp = SignatureType.wq("-1770lum", SignatureType.wq("1bpha17"), this.description, (Object[])new Object[0]);
            char[] cArray = "\u7114\u7032\u1db7".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x7CF8);
            char[] cArray2 = "\udc00\u29be\u7652".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x8D0);
            if (SignatureType.wq("1omva0g", temp, SignatureType.wq("128da01", SignatureType.wq("-1chem01", SignatureType.wq("-1chem01", SignatureType.wq("-1chem01", new StringBuilder(), EncryptFacade$ValidationFacade.C(cArray, (short)11331, true, (byte)2)), this.description), EncryptFacade$ValidationFacade.C(cArray2, (short)26633, true, (byte)0)))) != false) {
                return this.description;
            }
            return temp;
        }

        static {
            char[] cArray = "\u791c\u4aa0\uced1\u6702\u215a\u54b2".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x195B);
            char[] cArray2 = "\u9978\u1716\ueee5\u18ce\ub86f\u2e14".toCharArray();
            cArray2[0] = (char)(cArray2[0] ^ 0xAC0);
            char[] cArray3 = "\u5268\uced3\u96f9\ucf29\u33e5".toCharArray();
            cArray3[3] = (char)(cArray3[3] ^ 0x871);
            char[] cArray4 = "\uf7d1\u185b\uce10\ud00e\udcd6\u228f\uea22\ufd1e\uf1ff\u3723\udf0f\uf3dd\u906d\u063f\u861f\uaf26\u640b\ud37a\u0f2b\u1cf0\ud1a3\u6dbf\uac9c\uc96e\ue08c\u1b44\uaba8\u7d49\u88c9\u1ad8\uff69\ufb45\u4301\u3bca\u70fd\u5461\u2980".toCharArray();
            cArray4[9] = (char)(cArray4[9] ^ 0x54EB);
            char[] cArray5 = "\u9e02\u656b\uccef\ucbf2\u9f41\u1d95\u3c1b\uda5e\ua4ba\ub710\ufc93\uc6c1\u7db0\u1f68\u96d0\u77ca\uf3f3\ueee4\u31b1\uad60\u56d2\u3e9d\uf7aa\u11bf\u5992\u752d\u4c5f\u7440\u6dff\u9458\u2af7\u05c0\ucbf8\uc786\ue44f\ude1e\ue850\u7215\u5b09\u5697".toCharArray();
            cArray5[11] = (char)(cArray5[11] ^ 0x349B);
            CADES = new SignatureType(ValidationFacade$EncryptFacade.K(cArray2, (short)25021, 5, (byte)3), ValidationFacade$EncryptFacade.K(cArray3, (short)2065, 0, (byte)2), ValidationFacade$EncryptFacade.K(cArray4, (short)24805, 1, (byte)4), ValidationFacade$EncryptFacade.K(cArray5, (short)32715, 2, (byte)0));
            char[] cArray6 = "\u4b70\uf079\u1165\u2149\uf0ec\u1229".toCharArray();
            cArray6[3] = (char)(cArray6[3] ^ 0x4DBF);
            char[] cArray7 = "\uff93\uc8cb\u09d0\u8b21\u03f8\u4504".toCharArray();
            cArray7[4] = (char)(cArray7[4] ^ 0x665B);
            char[] cArray8 = "\u11fd\u9bdb\u8641\u6668\u0f76".toCharArray();
            cArray8[3] = (char)(cArray8[3] ^ 0x7A49);
            char[] cArray9 = "\u4c0d\uac15\uf28a\u76cf\u3733\u1f29\u4951\ub1d1\uc203\uc1c5\u2b48\u6cc2\ud06f\u76f3\u2e77\ue38a\ud7c1\u5951\u8d80\u390d\ue139\u23ae\u94c3\u0ecf\u936a\u9ad9\u9291\u5bd0\u9498\u8c35\u40d6\u4395\u39ca\udce6\u1718\u2f6a\u516d".toCharArray();
            cArray9[14] = (char)(cArray9[14] ^ 0x5D60);
            char[] cArray10 = "\u6553\ue7a5\ud8df\u30c6\u85af\ua981\u629b\ucf3c\ub6ef\uc9cf\uc85c\ued84\u4883\u16c4\u7593\uc843\ua995\u3323\u4008\uf3c9\u0277\u3359\ue58f\ud687\ua8da\u1342\u39e8\u9379\ufd84\uadbe\ua22a\u2355\ue432\uab85\u9e4c\u111e\u472a\u02a1\u011f\u5b51".toCharArray();
            cArray10[24] = (char)(cArray10[24] ^ 0x518D);
            PADES = new SignatureType(ValidationFacade$EncryptFacade.K(cArray7, (short)9249, 5, (byte)0), ValidationFacade$EncryptFacade.K(cArray8, (short)23264, 5, (byte)4), ValidationFacade$EncryptFacade.K(cArray9, (short)26133, 1, (byte)1), ValidationFacade$EncryptFacade.K(cArray10, (short)7042, 1, (byte)2));
            char[] cArray11 = "\u9ae8\u8f57\uefe0\u18f3\u68eb\u7751".toCharArray();
            cArray11[0] = (char)(cArray11[0] ^ 0x2E46);
            char[] cArray12 = "\u1474\udcc7\u3cf9\ufeac\udd71\u33af".toCharArray();
            cArray12[0] = (char)(cArray12[0] ^ 0x1499);
            char[] cArray13 = "\u1b6f\u673e\ue1b0\uaf3f\u0b6b".toCharArray();
            cArray13[2] = (char)(cArray13[2] ^ 0xF45);
            char[] cArray14 = "\ud05e\uaa97\ud647\ua7f7\u1fb8\ua478\u9491\ub7f8\udde4\ub9a9\u527c\u4275\u470d\uf0ee\ud325\ub992\ufaa5\u0461\uf812\ud88c\u5352\uca38\ub3cc\uf294\u2364\u3024\u543e\u93df\u3552\ud5ff\uc6f6\u11e4\uef02\u55de\u9a73\u5e53\u4f35".toCharArray();
            cArray14[11] = (char)(cArray14[11] ^ 0x582E);
            char[] cArray15 = "\u4ee4\ub1cb\u121b\ufed3\uf421\uf5ac\u4508\u9fb2\ubb6f\u0fa6\u824c\u2e90\u23db\u0a55\u8517\ud787\u645f\u62f0\ua9a9\ud755\u2c8b\u4111\u0dc4\u33ac\u6b85\ua8ad\ubfca\u42b9\ubebb\uccb6\u06c4\u1fad\ubbfb\ufdfd\u5af0\u56ae\u0a99\u8b92\u45ae\u6241".toCharArray();
            cArray15[8] = (char)(cArray15[8] ^ 0x57E8);
            XADES = new SignatureType(ValidationFacade$EncryptFacade.K(cArray12, (short)23350, 2, (byte)5), ValidationFacade$EncryptFacade.K(cArray13, (short)5878, 0, (byte)1), ValidationFacade$EncryptFacade.K(cArray14, (short)28911, 1, (byte)2), ValidationFacade$EncryptFacade.K(cArray15, (short)12569, 4, (byte)0));
            char[] cArray16 = "\u4468\u37d0\u669b\u558a\u7f70\u3a98".toCharArray();
            cArray16[0] = (char)(cArray16[0] ^ 0x60A9);
            char[] cArray17 = "\ua11f\u359c\u6b91\u21bb\ubb8a\u90a0\u4b99".toCharArray();
            cArray17[3] = (char)(cArray17[3] ^ 0x6368);
            char[] cArray18 = "\u5757\u5b1d\u38c2\u32b0\uad81\u1fdf\u56b2".toCharArray();
            cArray18[3] = (char)(cArray18[3] ^ 0x6367);
            char[] cArray19 = "\ubcb0\ue426\u7e95\u6542\uba29\uc4a7\u76f9".toCharArray();
            cArray19[2] = (char)(cArray19[2] ^ 0x1BE8);
            char[] cArray20 = "\u4604\u2b38\u1a35\u8e31\ud274\u3972\uce2e\uf28d\u6b76\u57af\u567b\u1bfd\u8c67\ud84f\uc672\ucdab\u6b29\udb1f\ub561\u7db1\u552c\u9106\u81fe\u4842\u84ed\u9d84\u99b5\u87a3\u4156\ud3a0\uf15d\udcae\u67ef\u5267\u4f6e\uc7cc\ud219\u7f10\u6855".toCharArray();
            cArray20[7] = (char)(cArray20[7] ^ 0x3CD6);
            ASICS = new SignatureType(ValidationFacade$EncryptFacade.K(cArray17, (short)29344, 4, (byte)4), ValidationFacade$EncryptFacade.K(cArray18, (short)30296, 5, (byte)5), ValidationFacade$EncryptFacade.K(cArray19, (short)15873, 4, (byte)4), ValidationFacade$EncryptFacade.K(cArray20, (short)9831, 3, (byte)4));
            char[] cArray21 = "\u8eb7\uadce\ube83\u9ee5\u514e\u4a45".toCharArray();
            cArray21[1] = (char)(cArray21[1] ^ 0x6B7D);
            char[] cArray22 = "\u353b\u1a86\u05bf\u401a\uc0db\uff08\u21e2".toCharArray();
            cArray22[4] = (char)(cArray22[4] ^ 0x285A);
            char[] cArray23 = "\ue41a\u383f\u288f\uc508\u5ca6\ua5db\u4620".toCharArray();
            cArray23[0] = (char)(cArray23[0] ^ 0x6521);
            char[] cArray24 = "\u9bf1\ud6e6\uf6a7\ufaaa\ue5f0\u1495\u10cf".toCharArray();
            cArray24[0] = (char)(cArray24[0] ^ 0x41C8);
            char[] cArray25 = "\ube9b\ud4c3\ue0c8\ue0d4\ued75\ud2f5\ucbbd\u1a08\u3bed\u5625\udef5\ud7a5\u783f\u3786\ude2c\ua1cc\ud4db\u6798\u6658\uc4d3\u6e39\ue0bc\uba73\u5aa5\u2da8\ua756\ue180\ub226\u510c\ud42a\u617f\u6764\uadb9\u2d52\ufc7b\u5047\u4ff0\u017b\u79bf".toCharArray();
            cArray25[35] = (char)(cArray25[35] ^ 0x1CC1);
            ASICE = new SignatureType(ValidationFacade$EncryptFacade.K(cArray22, (short)11926, 4, (byte)3), ValidationFacade$EncryptFacade.K(cArray23, (short)1808, 5, (byte)3), ValidationFacade$EncryptFacade.K(cArray24, (short)4946, 0, (byte)0), ValidationFacade$EncryptFacade.K(cArray25, (short)5464, 0, (byte)5));
            char[] cArray26 = "\ua3ce\uefd1\u2488\u6dd1".toCharArray();
            cArray26[1] = (char)(cArray26[1] ^ 0x565A);
            char[] cArray27 = "\u82ec\u069c\u08ec\u51d6".toCharArray();
            cArray27[1] = (char)(cArray27[1] ^ 0x545C);
            char[] cArray28 = "\u699d\u0d3d\u3f62\u141d\u61b9".toCharArray();
            cArray28[2] = (char)(cArray28[2] ^ 0x6D00);
            char[] cArray29 = "\uab54\u80d0\u83cd\u30e7".toCharArray();
            cArray29[2] = (char)(cArray29[2] ^ 0x45BE);
            TSD = new SignatureType(ValidationFacade$EncryptFacade.K(cArray27, (short)24249, 4, (byte)5), ValidationFacade$EncryptFacade.K(cArray28, (short)28598, 4, (byte)1), ValidationFacade$EncryptFacade.K(cArray29, (short)12173, 2, (byte)3), "");
            $VALUES = new SignatureType[]{CADES, PADES, XADES, ASICS, ASICE, TSD};
        }

        private static Object wq(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(mlngsytl.I(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }
}

