/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.loader;

import com.sun.jna.Pointer;
import esecurity.crypto.gui.pdf.bean.PdfAnnotation;
import esecurity.crypto.gui.pdf.loader.PdfPagesLoader$PdfPagesLoader;
import esecurity.crypto.gui.pdf.loader.fndluldi;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfPagesLoader {
    private static final EllipsLogger logger = PdfPagesLoader.BN("13ren6", Constants.CAPI_LOGGER_NAME);
    private static final Object CLOSE_LOCK = new Object();
    private static ExecutorService EXECUTOR_SERVICE;
    private static Future<PdfPagesLoader> pdfParserLoader;
    private static PDFRenderer pdfRenderer;
    static Pointer pdfDocument;
    private static PDDocument pdd;
    private static int pages;
    private static Dimension[] pagesDimensions;
    private static boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncInitialize(File pdfFile) {
        closed = false;
        EXECUTOR_SERVICE = PdfPagesLoader.BN("-11qsh7i");
        Object object = CLOSE_LOCK;
        synchronized (object) {
            pdfParserLoader = EXECUTOR_SERVICE.submit(() -> {
                try {
                    return new PdfPagesLoader(pdfFile);
                }
                catch (IOException ex) {
                    PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("maleo5", ex), (Object)ex);
                    return null;
                }
            });
        }
    }

    private PdfPagesLoader(File pdfFile) throws IOException {
        Object convertedTmp = pdfFile;
        if (PdfPagesLoader.BN("-13n0h7l", pdfFile) != false) {
            convertedTmp = PdfPagesLoader.BN("1o2veo8", pdfFile);
        }
        ScratchFile SCRATCH_FILE_TEMP = new ScratchFile((MemoryUsageSetting)PdfPagesLoader.BN("-1na6h7j", 10000000L));
        Object pdfFileBuffer = PdfPagesLoader.BN("-jquh7m", SCRATCH_FILE_TEMP, new FileInputStream((File)convertedTmp));
        PDFParser parser = new PDFParser((RandomAccessRead)pdfFileBuffer, SCRATCH_FILE_TEMP);
        PdfPagesLoader.BN("q8peo7", parser);
        pdd = PdfPagesLoader.BN("18ileo4", parser);
        pdfRenderer = new PDFRenderer(pdd);
        pages = (int)PdfPagesLoader.BN("6qteo9", pdd);
        pagesDimensions = new Dimension[pages];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadPage(int page, float zoom) throws IOException {
        if (closed) {
            return null;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        Object object = CLOSE_LOCK;
        synchronized (object) {
            Object image = null;
            try {
                image = PdfPagesLoader.BN("1mhneo6", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
                if (pagesDimensions[page] == null) {
                    PdfPagesLoader.pagesDimensions[page] = new Dimension((int)((float)PdfPagesLoader.BN("-1fd4h7t", image) / zoom), (int)((float)PdfPagesLoader.BN("1djbeo0", image) / zoom));
                }
            }
            catch (IOException ex) {
                PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("maleo5", ex), (Object)ex);
            }
            return image;
        }
    }

    public static int getPageCount() throws IOException {
        if (closed) {
            return 0;
        }
        PdfPagesLoader.getLoaderOrThrowException();
        return pages;
    }

    public static boolean isLoaded() {
        return pdfParserLoader.isDone();
    }

    public static synchronized Dimension getPageDimension(int page, float zoom) throws IOException {
        if (closed) {
            return new Dimension();
        }
        PdfPagesLoader.getLoaderOrThrowException();
        if (pagesDimensions[page] != null) {
            return pagesDimensions[page];
        }
        try {
            Object image = PdfPagesLoader.BN("1mhneo6", pdfRenderer, page, (float)zoom, (Object)ImageType.RGB);
            PdfPagesLoader.pagesDimensions[page] = new Dimension((int)PdfPagesLoader.BN("-1fd4h7t", image), (int)PdfPagesLoader.BN("1djbeo0", image));
            return pagesDimensions[page];
        }
        catch (IOException ex) {
            PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("maleo5", ex), (Object)ex);
            return new Dimension(0, 0);
        }
    }

    public static List<PdfAnnotation> getPageAnnotations(int page) throws IOException {
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        PdfPagesLoader.getLoaderOrThrowException();
        try {
            Object annotationList = PdfPagesLoader.BN("-1h5ihb1", PdfPagesLoader.BN("-if8h7u", pdd, page));
            Iterator iterator = annotationList.iterator();
            while (iterator.hasNext()) {
                Object annotationType;
                PDAnnotation annotation = (PDAnnotation)iterator.next();
                Object annotationDict = PdfPagesLoader.BN("4speks", annotation);
                if (PdfPagesLoader.BN("t7el1", annotationDict, COSName.V) != null || (annotationType = PdfPagesLoader.BN("-1dcmhb2", annotationDict, COSName.FT)) == null) continue;
                char[] cArray = "\ub4bf\ue96c\u7553\u11e0".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x6A67);
                if (PdfPagesLoader.BN("-11t8hb8", PdfPagesLoader$PdfPagesLoader.D(cArray, (short)23236, 1, 0), PdfPagesLoader.BN("1j3lekr", annotationType)) == false) continue;
                Object rect = PdfPagesLoader.BN("-1cvihb3", annotationDict, COSName.RECT);
                Object annotationName = PdfPagesLoader.BN("1ovfekq", annotationDict, COSName.T);
                Object llx = PdfPagesLoader.BN("1mlfekn", rect, 0);
                Object lly = PdfPagesLoader.BN("1mlfekn", rect, 1);
                Object urx = PdfPagesLoader.BN("1mlfekn", rect, 2);
                Object ury = PdfPagesLoader.BN("1mlfekn", rect, 3);
                annotations.add(new PdfAnnotation(new Rectangle((int)llx, (int)ury, (int)(urx - llx), (int)(ury - lly)), (String)annotationName));
            }
        }
        catch (IOException ex) {
            PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("maleo5", ex), (Object)ex);
        }
        return annotations;
    }

    public static PDDocument getPDDocument() throws IOException {
        PdfPagesLoader.getLoaderOrThrowException();
        return pdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDocument() {
        Object object = CLOSE_LOCK;
        synchronized (object) {
            closed = true;
            try {
                PdfPagesLoader.BN("1h0lekk", pdd);
            }
            catch (IOException ex) {
                PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("maleo5", ex), (Object)ex);
            }
        }
    }

    public static void shutDown() {
        EXECUTOR_SERVICE.shutdownNow();
        if (!closed) {
            PdfPagesLoader.closeDocument();
        }
    }

    private static PdfPagesLoader getLoaderOrThrowException() throws IOException {
        PdfPagesLoader loader = null;
        try {
            loader = pdfParserLoader.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            PdfPagesLoader.BN("1juhen2", logger, PdfPagesLoader.BN("-efoh8r", ex), (Object)ex);
        }
        if (loader == null) {
            char[] cArray = "\uc22c\u0bee\u1437\u5792\u5ab4\u5c3d\u3cef\uf776\ua537\u8416\u0ed7\uedf8\u78fa\u566c\u3693\u7759\u139b\ub3af\ufb57\u9e39\u9bb7\u4eed\u7a21\uc15a\u2476\u1317".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0xFA1);
            throw new IOException(PdfPagesLoader$PdfPagesLoader.D(cArray, (short)4122, 2, 0));
        }
        return loader;
    }

    static {
        pages = 0;
        closed = false;
    }

    private static Object BN(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(fndluldi.K(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

