/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.StepCertificatePresence;
import esecurity.validator.steps.core.StepSignatureDigestAlgorithmCheck;
import esecurity.validator.steps.pades.PadesStepSignatureAllRevisionsCoveredCheck;
import esecurity.validator.steps.pades.PadesStepSignatureCMSSignedDataCheck;
import esecurity.validator.steps.pades.PadesStepSignatureCertInDictionatyCheck;
import esecurity.validator.steps.pades.PadesStepSignatureSubFilterCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class PadesStepSignatureETSICompliance
extends SingleValidationSubStepImpl {
    public PadesStepSignatureETSICompliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new StepCertificatePresence());
        this.subSteps.add(new StepSignatureDigestAlgorithmCheck());
        this.subSteps.add(new PadesStepSignatureCMSSignedDataCheck());
        this.subSteps.add(new PadesStepSignatureSubFilterCheck());
        this.subSteps.add(new PadesStepSignatureCertInDictionatyCheck());
        this.subSteps.add(new PadesStepSignatureAllRevisionsCoveredCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        MessageLevel messageLevel = StepsUtils.retrieveWorstLevel(linkedList);
        if (!messageLevel.equals((Object)MessageLevel.INFO)) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.ES0009_FORMAT_NOTVALID, new Object[0]);
        }
        if (linkedList.size() > 0) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.IS0017_ADDITIONAL_INFORMATION, new Object[0]);
        }
        return null;
    }
}

