/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.ldap;

import esecurity.crypto.gui.ldap.LdapEndPoint;
import esecurity.crypto.gui.ldap.kvgxsbpg;
import esecurity.crypto.gui.ldap.rqluemtu;
import esecurity.crypto.gui.model.SourcedCertificate;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.ldap.LdapClient;
import it.actalis.ellips.capi.ldap.LdapEntry;
import it.actalis.ellips.capi.ldap.LdapException;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class LdapCertificateFinder {
    private static final EllipsLogger logger = LdapCertificateFinder.ib("dls6p0", Constants.CAPI_LOGGER_NAME);

    public static List<SourcedCertificate> find(LdapEndPoint endPoint, String fiscalCode, String email) {
        ArrayList<SourcedCertificate> ret = new ArrayList<SourcedCertificate>();
        try {
            LdapEntry[] entries;
            LdapClient client;
            URI ldapUrl = new URI((String)LdapCertificateFinder.ib("7ko6o9", endPoint));
            if (LdapCertificateFinder.ib("-s3hp7o", endPoint) != null && LdapCertificateFinder.ib("1bl06ou", LdapCertificateFinder.ib("-s3hp7o", endPoint)) == false && LdapCertificateFinder.ib("-j1pp85", endPoint) != null && LdapCertificateFinder.ib("1bl06ou", LdapCertificateFinder.ib("-j1pp85", endPoint)) == false) {
                client = new LdapClient((String)LdapCertificateFinder.ib("-1qt9p86", ldapUrl), (int)LdapCertificateFinder.ib("-c1fp7b", ldapUrl), (String)LdapCertificateFinder.ib("-s3hp7o", endPoint), (String)LdapCertificateFinder.ib("-j1pp85", endPoint), (NetworkConfig)LdapCertificateFinder.ib("1a1s6ok", LdapCertificateFinder.ib("-va7p7d")));
                LdapCertificateFinder.ib("-ic1p7a", client, LdapCertificateFinder.ib("-18p1p79", endPoint));
            } else {
                client = new LdapClient((String)LdapCertificateFinder.ib("-1qt9p86", ldapUrl), (int)LdapCertificateFinder.ib("-c1fp7b", ldapUrl), (String)LdapCertificateFinder.ib("-18p1p79", endPoint), 5000, (NetworkConfig)LdapCertificateFinder.ib("1a1s6ok", LdapCertificateFinder.ib("-va7p7d")));
            }
            char[] cArray = "\u065f\ud514\u63e0".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x21EB);
            StringBuilder query = new StringBuilder(rqluemtu.I(cArray, (short)5456, (byte)3, 4));
            if (email != null && LdapCertificateFinder.ib("1on06oo", email, "") == false) {
                char[] cArray2 = "\udd76\ue322\uf8f2\u66b8\u90d8\ua53a\u1af8".toCharArray();
                cArray2[5] = (char)(cArray2[5] ^ 0x6298);
                char[] cArray3 = "\u4c08\u1fe4".toCharArray();
                cArray3[0] = (char)(cArray3[0] ^ 0x3ED6);
                LdapCertificateFinder.ib("-1gd5p7j", LdapCertificateFinder.ib("-1gd5p7j", LdapCertificateFinder.ib("-1gd5p7j", query, rqluemtu.I(cArray2, (short)21302, (byte)2, 0)), email), rqluemtu.I(cArray3, (short)10131, (byte)0, 5));
            }
            if (fiscalCode != null && LdapCertificateFinder.ib("1on06oo", fiscalCode, "") == false) {
                char[] cArray4 = "\u566a\ucd09\ub50a\u076d\u16ab".toCharArray();
                cArray4[0] = (char)(cArray4[0] ^ 0x3BDD);
                char[] cArray5 = "\u3c5a\ucc2a\u2c26\u046c\u5281".toCharArray();
                cArray5[1] = (char)(cArray5[1] ^ 0x1C31);
                LdapCertificateFinder.ib("-1gd5p7j", LdapCertificateFinder.ib("-1gd5p7j", LdapCertificateFinder.ib("-1gd5p7j", query, rqluemtu.I(cArray4, (short)24987, (byte)5, 1)), fiscalCode), rqluemtu.I(cArray5, (short)19165, (byte)4, 2));
            }
            char[] cArray6 = "\u8f1b\uda74\u2f74".toCharArray();
            cArray6[1] = (char)(cArray6[1] ^ 0x5420);
            if (LdapCertificateFinder.ib("1on06oo", LdapCertificateFinder.ib("-37fp7k", query), rqluemtu.I(cArray6, (short)14373, (byte)2, 3)) != false) {
                char[] cArray7 = "\u3b4a\u9984\uce96\ua378\ud8bd\ud9de\u0363\ucbdc\ufdff\u6c52".toCharArray();
                cArray7[5] = (char)(cArray7[5] ^ 0x7C8D);
                LdapCertificateFinder.ib("-1gd5p7j", query, rqluemtu.I(cArray7, (short)15377, (byte)0, 5));
            } else {
                char[] cArray8 = "\u9be6\u06de".toCharArray();
                cArray8[0] = (char)(cArray8[0] ^ 0x6CDE);
                LdapCertificateFinder.ib("-1gd5p7j", query, rqluemtu.I(cArray8, (short)27630, (byte)0, 2));
            }
            for (LdapEntry entry : entries = (LdapEntry[])LdapCertificateFinder.ib("-sprp7f", client, LdapCertificateFinder.ib("-37fp7k", query), (int)30)) {
                try {
                    char[] cArray9 = "\u4cd9\ua804\u2459\u962b\u08fd\u2f61\u72b1\u87bb\ub5cb\u0c7a\uc25a\u4f5b\ueccb\u2b83\u422f\uf3c1\u9404\uf1c0\u478c\u96dc\u62f2\u8c53\u61ea".toCharArray();
                    cArray9[10] = (char)(cArray9[10] ^ 0x72D9);
                    byte[] cert = (byte[])LdapCertificateFinder.ib("-1e85p7g", entry, rqluemtu.I(cArray9, (short)2337, (byte)5, 2));
                    ret.add(new SourcedCertificate(cert, SourcedCertificate.CertificateSource.LDAP));
                }
                catch (CapiException | LdapException ex) {
                    LdapCertificateFinder.ib("1gps6p4", logger, LdapCertificateFinder.ib("14ne6o3", ex), (Object)ex);
                }
            }
        }
        catch (LdapException | URISyntaxException ex) {
            LdapCertificateFinder.ib("1gps6p4", logger, LdapCertificateFinder.ib("14ne6o3", ex), (Object)ex);
        }
        return ret;
    }

    private static Object ib(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(kvgxsbpg.m(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

