/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop;

import esecurity.desktop.BaseController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResUtils.class);
    private static final Pattern CSS_IMPORT_PATTERN = Pattern.compile("@import \".+\";");
    private static final Pattern CSS_IMPORT_PATTERN_ALT = Pattern.compile("@import url\\(\".+\"\\);");
    private static Map<String, String> cssVariables = null;
    private static Pattern cssVariablePatterns = null;

    public static void setCssVariables(Map<String, String> cssVariables) {
        ResUtils.cssVariables = cssVariables;
        if (cssVariables == null || cssVariables.isEmpty()) {
            return;
        }
        StringBuilder regex = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> variable : ResUtils.cssVariables.entrySet()) {
            if (!first) {
                regex.append("|");
            }
            regex.append("\\$\\{").append(variable.getKey()).append("\\}");
            first = false;
        }
        cssVariablePatterns = Pattern.compile(regex.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in, boolean close) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        try {
            int len;
            while ((len = in.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (close && in != null) {
                in.close();
            }
        }
        return os.toByteArray();
    }

    public static String toString(InputStream in, boolean close) {
        try {
            return new String(ResUtils.toByteArray(in, close));
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String toB64String(InputStream in, boolean close) {
        try {
            return new String(Base64.getEncoder().encode(ResUtils.toByteArray(in, close)));
        }
        catch (IOException e) {
            return "";
        }
    }

    public static Document composeHtml(BaseController controller, boolean inline, List<String> styles) throws IOException {
        int i;
        String mainReource = controller.getMainResource();
        Document html = controller.getHtmlDocument();
        Elements scripts = html.getElementsByTag("script");
        Elements csss = html.getElementsByTag("link");
        Elements imgs = html.getElementsByTag("img");
        for (i = 0; i < scripts.size(); ++i) {
            Element script = (Element)scripts.get(i);
            ResUtils.composeScript(script, controller, inline, mainReource);
        }
        for (i = 0; i < csss.size(); ++i) {
            Element css = (Element)csss.get(i);
            ResUtils.composeCss(html, css, controller, inline, mainReource, styles);
        }
        for (i = 0; i < imgs.size(); ++i) {
            Element img = (Element)imgs.get(i);
            ResUtils.composeImg(img, controller, inline, mainReource);
        }
        return html;
    }

    private static void composeScript(Element script, BaseController controller, boolean inline, String mainReource) throws UnsupportedEncodingException {
        String src = script.attributes().get("src");
        if (src != null && !src.isEmpty()) {
            String resolvedResource = ResUtils.resolveRelativePathForResource(mainReource, src);
            if (inline) {
                InputStream is = null;
                File resFile = new File(resolvedResource);
                if (resFile.exists()) {
                    try {
                        is = new FileInputStream(resFile);
                    }
                    catch (FileNotFoundException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                } else {
                    is = ResUtils.class.getResourceAsStream(resolvedResource);
                }
                if (is != null) {
                    String text = ResUtils.toString(is, true).replace("$controller$.", "controller_" + controller.getId() + "_");
                    script.attributes().remove("src");
                    DataNode dataScript = DataNode.createFromEncoded((String)text, (String)"");
                    script.appendChild((Node)dataScript);
                }
            } else {
                script.attr("src", "index?controllerId=" + controller.getId() + "&js=" + URLEncoder.encode(resolvedResource, "UTF-8"));
            }
        }
    }

    private static void composeCss(Document html, Element css, BaseController controller, boolean inline, String mainReource, List<String> styles) throws UnsupportedEncodingException {
        String href = css.attributes().get("href");
        if (href == null || href.isEmpty()) {
            return;
        }
        String resolvedResource = ResUtils.resolveRelativePathForResource(mainReource, href);
        if (styles.contains(resolvedResource)) {
            return;
        }
        if (inline) {
            InputStream is = ResUtils.class.getResourceAsStream(resolvedResource);
            if (is == null) {
                return;
            }
            css.remove();
            ResUtils.resolveCssImport(ResUtils.toString(is, true), resolvedResource, styles, html);
        } else {
            css.attr("href", "index?controllerId=" + controller.getId() + "&css=" + URLEncoder.encode(resolvedResource, "UTF-8"));
        }
    }

    public static void resolveCssImport(String css, String cssFilePath, List<String> styles, Document html) {
        int lastIndex;
        String text;
        InputStream is;
        String res;
        String fileName;
        String mat;
        if (!(css = ResUtils.replaceCssVariables(css)).contains("@import")) {
            Element newCss = html.head().appendElement("style");
            newCss.attr("id", cssFilePath);
            newCss.appendChild((Node)DataNode.createFromEncoded((String)css, (String)""));
            styles.add(cssFilePath);
            return;
        }
        StringBuilder output = new StringBuilder(css);
        Matcher matcher = CSS_IMPORT_PATTERN.matcher(css);
        int firstIndex = 0;
        boolean set = false;
        ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>> toRemove = new ArrayList<AbstractMap.SimpleImmutableEntry<Integer, Integer>>();
        while (matcher.find()) {
            mat = matcher.group();
            fileName = mat.substring(mat.indexOf("\"") + 1, mat.lastIndexOf("\""));
            if (firstIndex == 0 && !set) {
                firstIndex = matcher.start();
                set = true;
            }
            if (!styles.contains(res = ResUtils.resolveRelativePathForResource(cssFilePath, fileName)) && (is = ResUtils.class.getResourceAsStream(res)) != null) {
                styles.add(cssFilePath);
                text = ResUtils.toString(is, true);
                ResUtils.resolveCssImport(text, res, styles, html);
            }
            lastIndex = matcher.end();
            toRemove.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(matcher.start(), lastIndex));
        }
        matcher = CSS_IMPORT_PATTERN_ALT.matcher(css);
        while (matcher.find()) {
            mat = matcher.group();
            fileName = mat.substring(mat.indexOf("\"") + 1, mat.lastIndexOf("\""));
            if (firstIndex == 0 && !set || firstIndex > matcher.start()) {
                firstIndex = matcher.start();
                set = true;
            }
            if (!styles.contains(res = ResUtils.resolveRelativePathForResource(cssFilePath, fileName)) && (is = ResUtils.class.getResourceAsStream(res)) != null) {
                styles.add(cssFilePath);
                text = ResUtils.toString(is, true);
                ResUtils.resolveCssImport(text, res, styles, html);
            }
            lastIndex = matcher.end();
            toRemove.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(matcher.start(), lastIndex));
        }
        for (int i = toRemove.size() - 1; i >= 0; --i) {
            output.delete((Integer)((AbstractMap.SimpleImmutableEntry)toRemove.get(i)).getKey(), (Integer)((AbstractMap.SimpleImmutableEntry)toRemove.get(i)).getValue());
        }
        Element newCss = html.head().appendElement("style");
        newCss.attr("id", cssFilePath);
        newCss.appendChild((Node)DataNode.createFromEncoded((String)output.toString(), (String)""));
    }

    private static String replaceCssVariables(String css) {
        if (cssVariables == null || cssVariables.isEmpty() || cssVariablePatterns == null) {
            return css;
        }
        StringBuffer parsedCss = new StringBuffer();
        Matcher varMatcher = cssVariablePatterns.matcher(css);
        while (varMatcher.find()) {
            varMatcher.appendReplacement(parsedCss, cssVariables.get(varMatcher.group().substring(2, varMatcher.group().length() - 1)));
        }
        varMatcher.appendTail(parsedCss);
        return parsedCss.toString();
    }

    private static void composeImg(Element img, BaseController controller, boolean inline, String mainReource) throws IOException {
        String src = img.attributes().get("src");
        if (src != null && !src.isEmpty() && !src.startsWith("data:image/")) {
            String resolvedResource = ResUtils.resolveRelativePathForResource(mainReource, src);
            if (inline) {
                URL res = ResUtils.class.getResource(resolvedResource);
                if (res != null) {
                    URLConnection uc = res.openConnection();
                    String type = uc.getContentType();
                    String sImg = ResUtils.toB64String(uc.getInputStream(), true);
                    if (sImg != null && !sImg.isEmpty()) {
                        img.attr("src", "data:" + type + ";base64, " + sImg);
                    }
                }
            } else {
                img.attr("src", "index?controllerId=" + controller.getId() + "&img=" + URLEncoder.encode(resolvedResource, "UTF-8"));
            }
        }
    }

    private static String resolveRelativePathForResource(String mainResource, String resource) {
        File resFile = new File(resource);
        if (resFile.exists()) {
            return resFile.getAbsolutePath();
        }
        if (!resource.startsWith("/")) {
            if (mainResource.contains("/")) {
                String root = mainResource.substring(0, mainResource.lastIndexOf("/") + 1);
                return root + resource;
            }
            return resource;
        }
        return resource;
    }
}

