/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pades;

import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.pades.PadesUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class PadesDssInfo {
    private PDDocument a = null;
    private COSDictionary b = null;
    private LinkedList<X509Certificate> c = new LinkedList();
    private LinkedList<BasicOCSPResp> d = new LinkedList();
    private LinkedList<CRL> e = new LinkedList();

    public PadesDssInfo(PDDocument pDDocument, COSDictionary cOSDictionary) {
        this.a = pDDocument;
        this.b = cOSDictionary;
    }

    public COSDictionary getDicDSS() {
        return this.b;
    }

    public void setDicDSS(COSDictionary cOSDictionary) {
        this.b = cOSDictionary;
    }

    public LinkedList<X509Certificate> getCerts() {
        return this.c;
    }

    public void setCerts(LinkedList<X509Certificate> linkedList) {
        this.c = linkedList;
    }

    public LinkedList<BasicOCSPResp> getOcsps() {
        return this.d;
    }

    public void setOcsps(LinkedList<BasicOCSPResp> linkedList) {
        this.d = linkedList;
    }

    public LinkedList<CRL> getCrls() {
        return this.e;
    }

    public void setCrls(LinkedList<CRL> linkedList) {
        this.e = linkedList;
    }

    public void addCertificate(X509Certificate x509Certificate, String string) throws CertificateEncodingException, IOException {
        COSStream cOSStream = PadesDssInfo.a(this.a, false, x509Certificate.getEncoded());
        this.b.setNeedToBeUpdated(true);
        if (!this.c.contains(x509Certificate)) {
            x509Certificate = PadesDssInfo.a(this.b, "Certs");
            x509Certificate.add((COSBase)cOSStream);
        }
        if (string != null) {
            x509Certificate = PadesDssInfo.a(this.a(string), "Cert");
            x509Certificate.add((COSBase)cOSStream);
        }
    }

    public void addCrl(CRL cRL, String string) throws IOException, CRLException {
        COSStream cOSStream = PadesDssInfo.a(this.a, false, cRL.getInternalCRL().getEncoded());
        this.b.setNeedToBeUpdated(true);
        if (!this.e.contains(cRL)) {
            cRL = PadesDssInfo.a(this.b, "CRLs");
            cRL.add((COSBase)cOSStream);
        }
        if (string != null) {
            cRL = PadesDssInfo.a(this.a(string), "CRL");
            cRL.add((COSBase)cOSStream);
        }
    }

    public void addOcsp(OCSPResponse oCSPResponse, String string) throws IOException {
        COSStream cOSStream = PadesDssInfo.a(this.a, false, oCSPResponse.getFullOcspResponse().getEncoded());
        this.b.setNeedToBeUpdated(true);
        if (!this.d.contains(oCSPResponse.getBasicOcspResponse())) {
            oCSPResponse = PadesDssInfo.a(this.b, "OCSPs");
            oCSPResponse.add((COSBase)cOSStream);
        }
        if (string != null) {
            oCSPResponse = PadesDssInfo.a(this.a(string), "OCSP");
            oCSPResponse.add((COSBase)cOSStream);
        }
    }

    private COSDictionary a(String string) {
        COSDictionary cOSDictionary = (COSDictionary)this.b.getDictionaryObject("VRI");
        if (cOSDictionary == null) {
            cOSDictionary = new COSDictionary();
            this.b.setItem("VRI", (COSBase)cOSDictionary);
        } else {
            cOSDictionary.setNeedToBeUpdated(true);
        }
        COSDictionary cOSDictionary2 = (COSDictionary)cOSDictionary.getDictionaryObject(string);
        if (cOSDictionary2 == null) {
            cOSDictionary2 = new COSDictionary();
            cOSDictionary.setItem(string, (COSBase)cOSDictionary2);
        } else {
            cOSDictionary2.setNeedToBeUpdated(true);
        }
        return cOSDictionary2;
    }

    private static COSArray a(COSDictionary cOSDictionary, String string) {
        COSArray cOSArray = PadesUtils.parseArray(cOSDictionary, string);
        if (cOSArray == null) {
            cOSArray = new COSArray();
            cOSDictionary.setItem(string, (COSBase)cOSArray);
        } else {
            cOSArray.setNeedToBeUpdated(true);
        }
        return cOSArray;
    }

    private static COSStream a(PDDocument pDDocument, boolean bl, byte[] byArray) throws IOException {
        Object object = new COSArray();
        pDDocument = pDDocument.getDocument().createCOSStream();
        pDDocument.setDirect(false);
        object.add((COSBase)COSName.FLATE_DECODE);
        object = pDDocument.createOutputStream((COSBase)object);
        ((OutputStream)object).write(byArray);
        ((OutputStream)object).close();
        return pDDocument;
    }
}

