/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.Stoppable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import org.slf4j.Logger;

public class LockApplication {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static HashMap<String, LockFile> lockMap = new HashMap();

    public static boolean lockInstance(final String lockFile) {
        try {
            final File file = new File(lockFile);
            final RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            final FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                lockMap.put(lockFile, new LockFile(file, randomAccessFile, fileLock, null));
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            fileLock.release();
                            randomAccessFile.close();
                            file.delete();
                        }
                        catch (Exception e) {
                            logger.error("Unable to remove lock file: " + lockFile, (Throwable)e);
                        }
                    }
                });
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Unable to create and/or lock file: ", (Throwable)e);
        }
        return false;
    }

    public static void releaseLock(String lockFile) {
        LockFile lock = lockMap.remove(lockFile);
        try {
            if (lock.getFile().exists()) {
                lock.getFileLock().release();
                lock.getRandomAccessFile().close();
                lock.getFile().delete();
                if (lock.getStoppable() != null) {
                    lock.getStoppable().stop();
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to remove lock file: " + lockFile, (Throwable)e);
        }
    }

    public static boolean lockInstanceSocket(final String lockFile, Stoppable objThread) {
        try {
            final File file = new File(lockFile);
            final RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            final FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                lockMap.put(lockFile, new LockFile(file, randomAccessFile, fileLock, objThread));
                final Stoppable objThread2 = objThread;
                Thread objTH = new Thread(objThread2);
                objTH.setDaemon(true);
                objTH.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            fileLock.release();
                            randomAccessFile.close();
                            file.delete();
                            objThread2.stop();
                        }
                        catch (Exception e) {
                            logger.error("Unable to remove lock file: " + lockFile, (Throwable)e);
                        }
                    }
                });
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Unable to create and/or lock file: ", (Throwable)e);
        }
        return false;
    }

    private static class LockFile {
        private File file;
        private RandomAccessFile randomAccessFile;
        private FileLock fileLock;
        private Stoppable stoppable;

        public LockFile(File file, RandomAccessFile randomAccessFile, FileLock fileLock, Stoppable stoppable) {
            this.file = file;
            this.randomAccessFile = randomAccessFile;
            this.fileLock = fileLock;
            this.stoppable = stoppable;
        }

        public Stoppable getStoppable() {
            return this.stoppable;
        }

        public File getFile() {
            return this.file;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.randomAccessFile;
        }

        public FileLock getFileLock() {
            return this.fileLock;
        }
    }
}

