/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml;

import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.EventHandlerSelectorWithMatcher;
import esecurity.validator.parser.utils.FileSignatureMatcher;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.HashMap;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.parsers.DocumentBuilder;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InternalUriDereferencer
implements URIDereferencer {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    HashMap<String, InputHandler> documents = new HashMap();
    private EventHandlerSelector fileSelector;
    private HttpsClient https = null;
    private DocumentBuilder db;
    private InputHandler documentHandler;

    public InternalUriDereferencer(HttpsClient https, EventHandlerSelector fileSelector, DocumentBuilder db) {
        this.fileSelector = fileSelector;
        this.https = https;
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data dereference(URIReference ureRef, XMLCryptoContext context) throws URIReferenceException {
        InputStream docInputStream;
        String uri;
        block15: {
            if (ureRef == null) {
                throw new NullPointerException("uriRef cannot be null");
            }
            if (context == null) {
                throw new NullPointerException("context cannot be null");
            }
            DOMURIReference domRef = (DOMURIReference)ureRef;
            Node attr = domRef.getHere();
            if (attr == null && domRef.getURI() == null) {
                throw new URIReferenceException("Unable to resolve reference " + domRef.getURI());
            }
            uri = domRef.getURI().trim();
            if (uri != null && uri.length() != 0 && uri.charAt(0) == '#') {
                return this.dereferenceUriId(uri, attr, context);
            }
            if (uri != null && uri.length() != 0 && uri.startsWith("http")) {
                return this.dereferenceUriHttp(uri, ureRef);
            }
            if (uri != null && uri.equals("")) {
                return new DOMSubTreeData(attr.getOwnerDocument(), false);
            }
            docInputStream = null;
            if (this.documents.get(uri) == null) {
                try {
                    docInputStream = this.dereferenceFile(uri);
                }
                catch (Exception ex) {
                    if (this.fileSelector != null) {
                        docInputStream = this.dereferenceWithFileSelector(uri);
                    }
                    break block15;
                }
            }
            try {
                InputHandler input = this.documents.get(uri);
                docInputStream = input.getInputAsNewStream();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (docInputStream == null) {
            throw new URIReferenceException("Unable to resolve reference " + uri);
        }
        return new OctetStreamData(docInputStream);
    }

    private boolean isBase64Transform(Node attr) {
        NodeList referenceChilds = attr.getOwnerDocument().getChildNodes();
        for (int i = 0; i < referenceChilds.getLength(); ++i) {
            if (!"Transforms".equals(referenceChilds.item(i).getLocalName())) continue;
            NodeList transforms = referenceChilds.item(i).getChildNodes();
            for (int j = 0; j < transforms.getLength(); ++j) {
                NamedNodeMap attributes;
                Node transform = transforms.item(j);
                if (!"Transform".equals(transform.getLocalName()) || (attributes = transform.getAttributes()) == null) continue;
                Node alg = attributes.getNamedItem("Algorithm");
                return alg != null && "http://www.w3.org/2000/09/xmldsig#base64".equals(alg.getTextContent());
            }
            return false;
        }
        return false;
    }

    private Data dereferenceUriId(String uri, Node attr, XMLCryptoContext context) throws DOMException, URIReferenceException {
        Element document;
        boolean base64Transform = this.isBase64Transform(attr);
        boolean secureValidation = this.secureValidation(context);
        String uriPointer = uri.substring(1);
        if (uriPointer.startsWith("xmlns(") && (uriPointer = uriPointer.substring(uriPointer.indexOf(41) + 1, uriPointer.length()).trim()).startsWith("%20")) {
            uriPointer = uriPointer.substring(3);
        }
        if (uriPointer.startsWith("xpointer(id(")) {
            int var10 = uriPointer.indexOf(39);
            int var11 = uriPointer.indexOf(39, var10 + 1);
            uriPointer = uriPointer.substring(var10 + 1, var11);
        }
        Element pointerElement = attr.getOwnerDocument().getElementById(uriPointer);
        if (secureValidation && !this.protectAgainstWrappingAttack(document = pointerElement.getOwnerDocument().getDocumentElement(), pointerElement, uriPointer)) {
            String var12 = "Multiple Elements with the same ID " + pointerElement + " were detected";
            throw new URIReferenceException(var12);
        }
        if (base64Transform) {
            return new OctetStreamData(new ByteArrayInputStream(pointerElement.getTextContent().getBytes()));
        }
        if (uri.substring(1).startsWith("xpointer(id(")) {
            return new DOMSubTreeData(pointerElement, false);
        }
        return new DOMSubTreeData(pointerElement, true);
    }

    private Data dereferenceUriHttp(String uri, URIReference ureRef) throws URIReferenceException {
        if (this.https == null) {
            throw new URIReferenceException("Unable to resolge reference ", new NullPointerException(), ureRef);
        }
        try {
            byte[] data = this.https.doGet(uri, null);
            return this.parseData(data);
        }
        catch (CapiException ex) {
            throw new URIReferenceException("Unable to resolge reference ", ex, ureRef);
        }
    }

    private InputStream dereferenceFile(String uri) throws CapiException, FileNotFoundException {
        File file;
        try {
            URI parsedUri = new URI(uri);
            file = new File(parsedUri);
        }
        catch (URISyntaxException ex) {
            file = new File(uri);
        }
        if (!file.exists()) {
            throw new CapiException("Unable to find external file", 1003);
        }
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream dereferenceWithFileSelector(String uri) {
        try {
            InputHandler input;
            if (!(this.fileSelector instanceof EventHandlerSelectorWithMatcher)) {
                input = this.fileSelector.selectHandler();
            } else {
                final String finaluri = uri;
                input = ((EventHandlerSelectorWithMatcher)this.fileSelector).selectHandler(new FileSignatureMatcher(){

                    @Override
                    public boolean match(InputHandler ih) {
                        return ih.getName().equals(finaluri);
                    }

                    @Override
                    public InputHandler getCurrentHandler() {
                        return InternalUriDereferencer.this.documentHandler;
                    }

                    @Override
                    public byte[] getCurrentHash() {
                        try {
                            MessageDigest digestEngine = MessageDigest.getInstance("SHA-256", ProvUtils.bcProvider);
                            digestEngine.update(InternalUriDereferencer.this.documentHandler.getName().getBytes());
                            return digestEngine.digest();
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                            return new byte[0];
                        }
                    }
                }, this.documentHandler.getName());
            }
            if (input != null) {
                InputStream inputStream = input.getInputAsNewStream();
                return inputStream;
            }
        }
        catch (IOException iOException) {
        }
        return null;
    }

    private boolean secureValidation(XMLCryptoContext var0) {
        return var0 == null ? false : this.getBoolean(var0, "org.jcp.xml.dsig.secureValidation");
    }

    private boolean getBoolean(XMLCryptoContext xc, String name) {
        Boolean value = (Boolean)xc.getProperty(name);
        return value != null && value != false;
    }

    private boolean protectAgainstWrappingAttack(Node startNode, Element knownElement, String value) {
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        String id = value.trim();
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        while (startNode != null) {
            Element se;
            NamedNodeMap attributes;
            if (startNode.getNodeType() == 1 && (attributes = (se = (Element)startNode).getAttributes()) != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    if (!attr.isId() || !id.equals(attr.getValue()) || se == knownElement) continue;
                    return false;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return true;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return true;
    }

    private Data parseData(byte[] data) throws URIReferenceException {
        if (data != null) {
            try {
                Document doc = this.db.parse(new ByteArrayInputStream(data));
                return new DOMSubTreeData(doc.getDocumentElement(), false);
            }
            catch (SAXException ex) {
                return new OctetStreamData(new ByteArrayInputStream(data));
            }
            catch (IOException ex) {
                return new OctetStreamData(new ByteArrayInputStream(data));
            }
        }
        throw new URIReferenceException("Unable to resolge reference data null");
    }

    public void addDocument(InputHandler doc) {
        this.documents.put(doc.getName(), doc);
    }

    public void setDocument(InputHandler documentHandler) {
        this.documentHandler = documentHandler;
    }
}

