/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.DummyExternalServerHelper;
import it.actalis.ellips.capi.provider.ExternalServerHelper;
import it.actalis.vol.utils.Constants;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class ExternalServerToken
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "ExternServerToken";
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private ExternalServerHelper current_helper = new DummyExternalServerHelper();

    private String argsResolver(String[] args, int index) {
        if (args.length >= index + 1 && args[index] != null) {
            return args[index];
        }
        return null;
    }

    @Override
    public void initializeLib(String[] args) throws CapiException {
        this.initProviders(this);
    }

    @Override
    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        logger.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(args);
    }

    @Override
    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    @Override
    public String[] getLibInfo() {
        String tokenType = "External Server Token";
        String libraryName = "";
        String libraryDescription = "Ellips Remote Signature Token";
        String libraryVersion = "1.0";
        String libraryManufacturer = "Actalis S.p.A.";
        String slotDescription = "";
        String slotManufacturer = "Actalis S.p.A.";
        String tokenModel = "";
        String tokenManufacturer = "Actalis S.p.A.";
        return new String[]{tokenType, libraryName, libraryDescription, libraryVersion, libraryManufacturer, slotDescription, slotManufacturer, tokenModel, tokenManufacturer};
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    @Override
    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    @Override
    public int getFreeSpace() throws CapiException {
        return -1;
    }

    @Override
    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    @Override
    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    @Override
    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    @Override
    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    @Override
    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    @Override
    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    @Override
    public int getMinPINLen() throws CapiException {
        return 0;
    }

    @Override
    public void openSession(boolean asSO, String pin) throws CapiException {
        this.current_helper.openSession(asSO, pin);
    }

    @Override
    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    @Override
    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    @Override
    public void closeSession() throws CapiException {
        this.current_helper.closeSession();
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        return this.current_helper.isSessionOpen();
    }

    @Override
    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    @Override
    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    @Override
    public String getCert(String alias) throws CapiException {
        return this.current_helper.getCert(alias);
    }

    @Override
    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    @Override
    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    @Override
    public boolean canImport() {
        return false;
    }

    @Override
    public boolean canExport(String alias) {
        return false;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    @Override
    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    @Override
    public PublicKey getPublicKey(String alias) throws CapiException {
        return this.current_helper.getPublicKey(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) throws CapiException {
        String cert = this.getCert(alias);
        if (cert != null) {
            Certificate certf = new Certificate(Base64.decode((String)cert));
            Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
            ret.setPublicInfo((RSAPublicKey)certf.getInternalCert().getPublicKey());
            ret.setCryptoDev(this);
            return ret;
        }
        return null;
    }

    @Override
    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    @Override
    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        return this.current_helper.doSign(digest, alias, mode);
    }

    @Override
    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    @Override
    public String[] listObjects(String expr, byte filter) throws CapiException {
        return this.current_helper.listObjects(expr, filter);
    }

    @Override
    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    @Override
    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    @Override
    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    @Override
    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    @Override
    public boolean exist(String alias) throws CapiException {
        return this.current_helper.exist(alias);
    }

    @Override
    public String generateID(String[] args) {
        return this.argsResolver(args, 2) + "@" + this.argsResolver(args, 3);
    }

    public ExternalServerHelper getCurrent_helper() {
        return this.current_helper;
    }

    public void setCurrent_helper(ExternalServerHelper current_helper) {
        this.current_helper = current_helper;
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        CertificationRequestInfo reqInfo = null;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), key.getEncoded());
            reqInfo = new CertificationRequestInfo(subject, spki, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature sig = Signature.getInstance("SHA1withRSA", ActalisSingleton.getActalisProvider());
        sig.initSign(signingKey);
        try {
            sig.update(reqInfo.getEncoded("DER"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("exception encoding TBS cert request - " + e);
        }
        CertificationRequestInfo cri = new CertificationRequestInfo(subject, spki, null);
        CertificationRequest cr = new CertificationRequest(cri, new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE), new DERBitString(sig.sign()));
        return cr;
    }

    @Override
    public void initializeLib(TokenParameters param) throws CapiException {
        this.initProviders(this);
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        return this.certReq(subject, rsapk, rsask, Security.getProvider(provname));
    }

    @Override
    public String certReq(String alias, X500Name subject) throws CapiException {
        return this.certReq(subject, this.getPublicKey(alias), this.getPrivateKey(alias), ProvUtils.actalisProvider);
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        Object certReqInfo = null;
        Object cReq = null;
        PKCS10CertificationRequest p10 = null;
        try {
            logger.debug("creating and signing certreq...");
            logger.debug("subject: " + subject.toString());
            JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(subject, rsapk);
            p10 = requestBuilder.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build(rsask));
            logger.debug("certRequest ok");
        }
        catch (IllegalStateException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("IllegalStateException", 1003);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("NoSuchProviderException", 1003);
        }
        try {
            StringWriter strWriter = new StringWriter();
            PEMWriter pemWrt = new PEMWriter((Writer)strWriter);
            pemWrt.writeObject((Object)p10);
            pemWrt.close();
            String temp = new String(strWriter.getBuffer());
            return temp;
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception saving PEM certificate Requet", 1003);
        }
    }

    @Override
    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

