/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.statistics.util.StatisticKeyEnum;
import esecurity.statistics.util.StatisticsInfoUtils;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisProvider;
import it.actalis.vol.utils.Constants;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.CipherSpi;
import org.slf4j.Logger;

public class Actalis_RSACipher
extends CipherSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE_RSA_X_509 = 3;
    public static final int DECRYPT_MODE_RSA_X_509 = 4;
    public boolean isENCRYPT_MODE_RSA_X_509 = false;
    public boolean isDECRYPT_MODE_RSA_X_509 = false;
    private SecureRandom secureRandom;
    private int mode;
    private short useDevice = 0;
    private String alias = null;
    private Actalis_PrivateKey actKey = null;

    public Actalis_RSACipher() {
        super((AsymmetricBlockCipher)new RSAEngine());
        logger.debug("constructor OK");
        this.useDevice = 0;
    }

    public void engineSetMode(String mode) throws NoSuchAlgorithmException {
        switch (this.useDevice) {
            case 1: {
                logger.debug("engineSetMode device: " + mode);
                break;
            }
            case 0: {
                logger.debug("engineSetMode: " + mode);
            }
            case 2: {
                logger.debug("engineSetMode BouncyCastle  :" + mode);
                super.engineSetMode(mode);
            }
        }
    }

    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        switch (this.useDevice) {
            case 1: {
                logger.debug("engineSetPadding device: " + padding);
                break;
            }
            case 0: {
                logger.debug("engineSetPadding: " + padding);
            }
            case 2: {
                logger.debug("engineSetPadding BouncyCastle: " + padding);
                super.engineSetPadding(padding);
            }
        }
    }

    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit AlgParSpec");
        this.engineInit(opmode, key, random);
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit AlgParamet");
        this.engineInit(opmode, key, random);
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        logger.debug("engineInit check?");
        this.mode = opmode;
        this.secureRandom = random;
        try {
            if (key instanceof Actalis_PrivateKey) {
                logger.debug("engineInit is act_privatekey");
                this.useDevice = 1;
                this.actKey = (Actalis_PrivateKey)key;
                this.alias = this.actKey.getAlias();
            } else {
                logger.debug("engineInit is NOT act_privatekey");
                this.useDevice = (short)2;
                this.alias = null;
            }
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new InvalidKeyException("Unable to init RSA key: " + exception.toString());
        }
        switch (this.useDevice) {
            case 0: {
                throw new InvalidKeyException("Invalid use device.");
            }
            case 1: {
                break;
            }
            case 2: {
                logger.debug("call BouncyCastle engineInit");
                logger.debug("opmode " + opmode);
                if (key instanceof PublicKey) {
                    logger.debug("key is public");
                } else {
                    logger.debug("key is private");
                }
                try {
                    super.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new InvalidKeyException("InvalidAlgorithmParameterException: " + e.toString());
                }
                logger.debug("BouncyCastle engineInit checked");
            }
        }
    }

    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.useDevice != 1) {
            logger.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(input, inputOffset, inputLen);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        if (this.useDevice != 1) {
            logger.debug("engineUpdate call BouncyCastle");
            return super.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetBlockSize() {
        if (this.useDevice != 1) {
            logger.debug("engineGetBlockSize call BouncyCastle");
            return super.engineGetBlockSize();
        }
        throw new RuntimeException("Method not supported.");
    }

    public byte[] engineGetIV() {
        if (this.useDevice != 1) {
            logger.debug("engineGetIV call BouncyCastle");
            return super.engineGetIV();
        }
        throw new RuntimeException("Method not supported.");
    }

    public int engineGetOutputSize(int inputLen) {
        if (this.useDevice != 1) {
            logger.debug("engineGetOutputSize: BouncyCastle ");
            return super.engineGetOutputSize(inputLen);
        }
        return 0;
    }

    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws BadPaddingException, IllegalBlockSizeException {
        if (this.useDevice == 2) {
            logger.debug("engineDoFinal: BouncyCastle inpLen=" + inputLen);
            return super.engineDoFinal(input, inputOffset, inputLen);
        }
        if (this.useDevice != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        byte[] copy = new byte[inputLen];
        System.arraycopy(input, inputOffset, copy, 0, inputLen);
        logger.debug("engineDoFinal: device: MODE: " + this.mode);
        if (this.mode == 1) {
            return this.encrypt(copy);
        }
        return this.decrypt(copy);
    }

    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        if (this.useDevice == 2) {
            logger.debug("engineDoFinal-2: BouncyCastle");
            return super.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
        }
        if (this.useDevice != 1) {
            throw new RuntimeException("Use not allowed.");
        }
        logger.debug("engineDoFinal-2");
        byte[] out1 = this.engineDoFinal(input, inputOffset, inputLen);
        try {
            System.arraycopy(out1, 0, output, outputOffset, out1.length);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new IllegalBlockSizeException("Buffer to short to hold result.");
        }
        return out1.length;
    }

    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public AlgorithmParameters getParameters() {
        throw new RuntimeException("Method not supported.");
    }

    public void set_RSA_X_509_EncryptMode() {
        this.isENCRYPT_MODE_RSA_X_509 = true;
    }

    public void set_RSA_X_509_DecryptMode() {
        this.isDECRYPT_MODE_RSA_X_509 = true;
    }

    private byte[] encrypt(byte[] input) {
        return this.encrypt(input, 1);
    }

    private byte[] decrypt(byte[] input) {
        return this.decrypt(input, 2);
    }

    private byte[] encrypt(byte[] input, int mode) {
        logger.debug("[encrypt] hash.length " + input.length);
        logger.debug("[encrypt] theProv?");
        ActalisProvider theProv = (ActalisProvider)Security.getProvider("Actalis");
        logger.debug("[encrypt] theProv = " + theProv);
        logger.debug("engineSign: Actalis_RSACipher");
        StatisticsInfoUtils.start(StatisticKeyEnum.SIGN_TIME);
        byte[] sig = null;
        try {
            logger.debug("[encrypt] theProv.doSign ?");
            sig = this.isENCRYPT_MODE_RSA_X_509 ? this.actKey.getCryptoDev().doSign(input, this.alias, 3) : this.actKey.getCryptoDev().doSign(input, this.alias, mode);
            logger.debug("[encrypt] theProv.doSign ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiError(e);
        }
        finally {
            StatisticsInfoUtils.end(StatisticKeyEnum.SIGN_TIME);
        }
        if (sig == null) {
            throw new CapiError("Invalid signature", 3003);
        }
        return sig;
    }

    private byte[] decrypt(byte[] sig, int mode) {
        logger.debug("[decrypt] signature.length " + sig.length);
        ActalisProvider theProv = (ActalisProvider)Security.getProvider("Actalis");
        logger.debug("[decrypt] theProv = " + theProv);
        logger.debug("[decrypt] mode = " + mode);
        byte[] hash = null;
        try {
            logger.debug("[decrypt] theProv.doDecrypt ?");
            hash = this.isDECRYPT_MODE_RSA_X_509 ? this.actKey.getCryptoDev().doDecrypt(sig, this.alias, 4) : this.actKey.getCryptoDev().doDecrypt(sig, this.alias, mode);
            logger.debug("[decrypt] theProv.doDecrypt ok");
        }
        catch (CapiException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiError(e);
        }
        if (hash == null) {
            throw new CapiError("Invalid decryption", 3103);
        }
        logger.debug("[decrypt] hash.length " + hash.length);
        return hash;
    }
}

