/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.outputs.S3OutputHandler;
import java.io.IOException;

public class AmazonS3OutputHandler
extends S3OutputHandler {
    public AmazonS3OutputHandler(String userId, String secretKey, String bucket, String filepath, String name, Long finalSize) throws IOException {
        if (userId == null) {
            throw new IllegalArgumentException("Please specify a non-null Amazon user id!");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("Please specify a non-null Amazon secret key!");
        }
        AmazonS3ClientBuilder s3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(userId, secretKey)));
        this.initS3OutputHandler(s3ClientBuilder, bucket, filepath, name, finalSize);
        this.s3CloudType = DataHandler.S3_TYPE.AMAZON;
    }

    public AmazonS3OutputHandler(String userId, String secretKey, String bucket, String filepath, String name) throws IOException {
        this(userId, secretKey, bucket, filepath, name, null);
    }
}

