/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.DataHandlerUtils;
import it.actalis.ellips.capi.datahandlers.inputs.CloudInputHandler;
import java.io.IOException;

public class S3InputHandler
extends CloudInputHandler {
    protected DataHandler.S3_TYPE s3CloudType = null;
    protected String bucket = null;
    protected String filepath = null;
    protected AmazonS3 s3Client = null;
    protected S3Object s3Object = null;
    protected S3ObjectInputStream s3InputStream = null;

    public DataHandler.S3_TYPE getS3CloudType() {
        return this.s3CloudType;
    }

    protected S3InputHandler() {
    }

    protected final void initS3InputHandler(AmazonS3ClientBuilder s3ClientBuilder, String bucket, String filepath, String name) throws IOException {
        if (s3ClientBuilder == null) {
            throw new IllegalArgumentException("Please specify a non-null S3 client builder!");
        }
        this.s3Client = (AmazonS3)s3ClientBuilder.build();
        this.bucket = bucket;
        this.filepath = filepath == null ? "" : filepath;
        this.initCloudInputHandler(DataHandler.CLOUD_TYPE.S3, name);
        this.s3CloudType = DataHandler.S3_TYPE.GENERIC;
    }

    public S3InputHandler(AmazonS3ClientBuilder s3ClientBuilder, String bucket, String filepath, String name) throws IOException {
        this.initS3InputHandler(s3ClientBuilder, bucket, filepath, name);
    }

    @Override
    protected CloudInputHandler.CloudReadProxyInputStream getCloudReadProxyInputStream() {
        this.s3Object = this.s3Client.getObject(new GetObjectRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name)));
        this.s3InputStream = this.s3Object.getObjectContent();
        return new S3ReadProxyInputStream();
    }

    protected class S3ReadProxyInputStream
    extends CloudInputHandler.CloudReadProxyInputStream {
        protected S3ReadProxyInputStream() {
        }

        @Override
        public int available() throws IOException {
            return S3InputHandler.this.s3InputStream.available();
        }

        @Override
        public int read() throws IOException {
            return S3InputHandler.this.s3InputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return S3InputHandler.this.s3InputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return S3InputHandler.this.s3InputStream.read(b, off, len);
        }

        @Override
        public void reset() throws IOException {
            S3InputHandler.this.s3InputStream.reset();
        }

        @Override
        public void close() throws IOException {
            S3InputHandler.this.s3InputStream.close();
            S3InputHandler.this.s3Object.close();
        }

        @Override
        public long skip(long n) throws IOException {
            return S3InputHandler.this.s3InputStream.skip(n);
        }

        @Override
        public synchronized void mark(int readlimit) {
            S3InputHandler.this.s3InputStream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return S3InputHandler.this.s3InputStream.markSupported();
        }
    }
}

