/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.ocsp.OCSPCacheManager;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import org.slf4j.Logger;

public class DefaultOCSPCacheManager
implements OCSPCacheManager {
    private Logger logger;
    private final int cacheRetention;
    private final int cacheSize;
    private final LRUMap<String, OCSPResponse> responseCache;

    public DefaultOCSPCacheManager(ValidatorConfig config, Logger callerLogger) throws CapiException {
        this.cacheSize = config.getIntElement("x509StatusService.cacheSize", 300);
        this.cacheRetention = config.getIntElement("x509StatusService.cacheRetentionTime", 60000);
        this.responseCache = new LRUMap(this.cacheSize);
        this.logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (callerLogger != null) {
            this.logger = callerLogger;
        }
        this.logger.debug(String.format("OCSP cache manger created with size of %s and retention time %d", this.cacheSize, this.cacheRetention));
    }

    @Override
    public OCSPResponse get(String Id) {
        OCSPResponse ocspResponse = (OCSPResponse)this.responseCache.get(Id);
        if (ocspResponse != null && ocspResponse.getProducedAt() != null && new Date().getTime() - ocspResponse.getProducedAt().getTime() > (long)this.cacheRetention) {
            this.responseCache.remove(Id);
            ocspResponse = null;
            this.logger.debug(String.format("OCSP response for %s is expired and it was removed from cache", Id));
        }
        return ocspResponse;
    }

    @Override
    public boolean isInCache(String Id) {
        return this.get(Id) != null;
    }

    @Override
    public void addToCache(String Id, OCSPResponse response) throws CapiException {
        this.responseCache.put(Id, response);
    }

    @Override
    public void removeFromCache(String Id) throws CapiException {
        this.responseCache.remove(Id);
    }
}

