/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.tst.TimeStampStepSignatureDigestAlgoCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;

public class TimeStampStepSignatureETSICompliance
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureETSICompliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new TimeStampStepSignatureDigestAlgoCheck());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        format.setTimeZone(param.getTimeZone());
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if (validationDate.after(Constants.DPCM_AGID_121_2019)) {
            MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
            if (level != MessageLevel.INFO) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0010_TIMESTAMP_NOEIDASCOMPLIANCE, new Object[0]);
            }
            if (subMessage.size() > 0) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IS0017_ADDITIONAL_INFORMATION, new Object[0]);
            }
        }
        return null;
    }
}

