/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.parser;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.parser.utils.TSTUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.util.m7m.SimpleMimeReader;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class M7MParser
extends SignatureParser {
    private DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public M7MParser(SignatureParserBuilder builder) {
        super(builder);
        this.df.setTimeZone(Constants.DEFAULT_TIMEZONE);
    }

    public ParsedTransientDocument parse(InputHandler source, EventHandlerSelector fileSelector, NetworkConfig config, TimeZone timeZone, File tmpFolder) throws ParsingException {
        ParsedTransientDocument doc = new ParsedTransientDocument(source);
        if (timeZone != null) {
            this.df.setTimeZone(timeZone);
        }
        try {
            MimeBodyPart mbp = new MimeBodyPart(source.getInputAsNewStream());
            MimePartDataSource mpds = new MimePartDataSource((MimePart)mbp);
            MimeMultipart multipart = new MimeMultipart((DataSource)mpds);
            int pkcs7index = -1;
            int timestampIndex = -1;
            for (int i = 0; i < multipart.getCount(); ++i) {
                if (multipart.getBodyPart(i).getContentType().startsWith("time-stamp response")) {
                    timestampIndex = i;
                    continue;
                }
                if (multipart.getBodyPart(i).getContentType().startsWith("application/timestamp")) {
                    timestampIndex = i;
                    continue;
                }
                pkcs7index = i;
            }
            byte[] timestamp = null;
            InputHandler associatedDocument = null;
            if (timestampIndex == -1 && pkcs7index != -1 || pkcs7index == -1 && timestampIndex != -1) {
                SimpleMimeReader smr = new SimpleMimeReader(source.getInputAsNewStream());
                while (smr.nextPart()) {
                    if (smr.getDescription() != null && smr.getDescription().toLowerCase().contains("time-stamp response")) {
                        timestamp = smr.getPartDataAsBytes();
                    } else if (smr.getPartType() != null && smr.getPartType().startsWith("application/timestamp")) {
                        timestamp = smr.getPartDataAsBytes();
                    } else {
                        associatedDocument = smr.getPartType() != null && smr.getPartType().startsWith("application/pkcs7-mime") ? DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).setName("sub_content").buildInput() : DataHandlerBuilder.get().setBytes(smr.getPartDataAsBytes()).setName("sub_content").buildInput();
                    }
                    if (timestamp == null || associatedDocument == null) continue;
                    break;
                }
            } else {
                timestamp = Util.getBytesFromInputStream((InputStream)multipart.getBodyPart(timestampIndex).getInputStream());
                associatedDocument = DataHandlerBuilder.get().setInputStream(multipart.getBodyPart(pkcs7index).getInputStream()).setName("sub_content").buildInput();
            }
            if (timestamp == null || associatedDocument == null) {
                throw new ParsingException("La busta M7M e' corrotta o illeggibile", (Throwable)new Exception("Possibile Boundary non corretto"));
            }
            doc.setSigned(true);
            TransientDocument subDoc = ParserUtils.parseDoc((InputHandler)associatedDocument, (EventHandlerSelector)fileSelector, (NetworkConfig)config, (TimeZone)this.df.getTimeZone(), (File)tmpFolder);
            doc.addRefDoc(subDoc);
            SignatureInformation si = TSTUtils.tstToVol((TransientDocument)doc, (byte[])timestamp, (InputHandler)associatedDocument, (String)subDoc.getId(), (DateFormat)this.df);
            doc.addSignerInfo(si);
        }
        catch (Exception ex) {
            throw new ParsingException("Unable to parse file", (Throwable)ex);
        }
        finally {
            source.close();
        }
        return doc;
    }
}

