/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.cades.CadesStepSignatureDPCM45Compliance;
import esecurity.validator.steps.cades.CadesStepSignatureETSICompliance;
import esecurity.validator.steps.core.StepFormat;
import esecurity.validator.steps.core.StepSignatureDigestAlgorithmCheck;
import esecurity.validator.steps.core.StepSignatureIntegrity;
import esecurity.validator.steps.core.StepSignatureIntegrityRelaxedCheck;
import esecurity.validator.steps.core.StepValidationProfile;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
@StepContext(formats={ValidationSignatureFormats.CADES})
public class CadesStepSignatureValidity
extends SignatureValidationStep {
    public CadesStepSignatureValidity() {
        this.subSteps.add(new StepFormat());
        this.subSteps.add(new StepSignatureIntegrity());
        this.subSteps.add(new StepSignatureIntegrityRelaxedCheck());
        this.subSteps.add(new CadesStepSignatureETSICompliance());
        this.subSteps.add(new StepSignatureDigestAlgorithmCheck());
        this.subSteps.add(new CadesStepSignatureDPCM45Compliance());
        this.subSteps.add(new StepValidationProfile());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param.getSignature() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        if (level == MessageLevel.ERROR) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0001_INVALID_SIGNATURE, new Object[0]);
        }
        if (param.getSignerCertificate() != null && param.getSignerCertificate().hasMessage(ValidatorMessageEnum.EC0003_CERT_NOT_RELIABLE)) {
            level = MessageLevel.WARNING;
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IS0005_SIGN_VALID, new Object[0]);
    }
}

