/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.cades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.cades.CadesStepSignatureETSICMSSignedDataCheck;
import esecurity.validator.steps.core.StepCertificatePresence;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.CMSAttributes;

public class CadesStepSignatureETSICompliance
extends SingleValidationSubStepImpl {
    public CadesStepSignatureETSICompliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new StepCertificatePresence());
        this.subSteps.add(new CadesStepSignatureETSICMSSignedDataCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null && param.getSignature().getSignerInfoData().getSignerInfo() != null && param.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes() != null) {
            ASN1Set atab = param.getSignature().getSignerInfoData().getSignerInfo().getAuthenticatedAttributes();
            boolean haveMessageDigest = false;
            boolean haveContentType = false;
            for (int i = 0; i < atab.size(); ++i) {
                String id = null;
                id = atab.getObjectAt(i) instanceof DERSequence ? ((DERSequence)atab.getObjectAt(i)).getObjectAt(0).toString() : ((DLSequence)atab.getObjectAt(i)).getObjectAt(0).toString();
                if (id.equals(CMSAttributes.messageDigest.getId())) {
                    haveMessageDigest = true;
                }
                if (!id.equals(CMSAttributes.contentType.getId())) continue;
                haveContentType = true;
            }
            if (!param.getSignature().isCounterSignature() && !haveContentType || !haveMessageDigest) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
            }
        } else if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null && param.getSignature().getSignerInfoData().getSignerInfo() != null && param.getSignature().getSignerInfoData().getSignerInfo().getUnauthenticatedAttributes() != null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
        }
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if (level == MessageLevel.ERROR) {
            if (validationDate.before(Constants.DPCM_AGID_121_2019)) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.ES0005_NOCNIPA45, new Object[0]);
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0007_INVALIDFILEFORMAT, new Object[0]);
        }
        if (level == MessageLevel.WARNING) {
            if (validationDate.before(Constants.DPCM_AGID_121_2019)) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0001_NOCNIPA45VALID, new Object[0]);
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.WS0002_NOEIDAS, new Object[0]);
        }
        return null;
    }
}

