/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.pdf.AdditionalDictionaryInfo;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.bouncycastle.util.encoders.Base64;

public class GraphometricInfo
implements AdditionalDictionaryInfo {
    private byte[] G_blob;
    private byte[] Impronta_1 = null;
    private byte[] Impronta_2 = null;
    private byte[] Impr_signed = null;
    private String user_notice;
    private String[] personal_data;
    private long[] byte_range = null;

    public GraphometricInfo(byte[] G_blob, byte[] Impronta_1, byte[] Impronta_2, byte[] Impr_signed, String user_notice, String[] personal_data) throws CapiException {
        this(G_blob, Impronta_1, Impronta_2, Impr_signed, user_notice, personal_data, null);
    }

    public GraphometricInfo(byte[] G_blob, byte[] Impronta_1, byte[] Impronta_2, byte[] Impr_signed, String user_notice, String[] personal_data, long[] byte_range) throws CapiException {
        this.G_blob = G_blob;
        this.Impronta_1 = Impronta_1;
        this.Impronta_2 = Impronta_2;
        this.Impr_signed = Impr_signed;
        this.user_notice = user_notice;
        this.personal_data = personal_data;
        this.byte_range = byte_range;
        if (G_blob == null) {
            throw new CapiException("Null G_blob", 1001);
        }
        if (Impronta_1 == null) {
            throw new CapiException("Null Impronta_1", 1001);
        }
        if (Impr_signed == null) {
            throw new CapiException("Null Impr_signed", 1001);
        }
        if (user_notice == null) {
            throw new CapiException("Null user_notice", 1001);
        }
        if (personal_data == null) {
            throw new CapiException("Null personal_data", 1001);
        }
    }

    @Override
    public COSDictionary getDictionary(long[] arr_byte_range) {
        COSDictionary objReturn = new COSDictionary();
        objReturn.setItem(COSName.getPDFName((String)"version"), (COSBase)new COSString("2.0.0"));
        String s_g_blob = new String(Util.base64Encode((byte[])this.G_blob));
        String[] arr_g_blob = s_g_blob.split("(?<=\\G.{32766})");
        COSArray g_blob = new COSArray();
        for (int i = 0; i < arr_g_blob.length; ++i) {
            g_blob.add((COSBase)new COSString(arr_g_blob[i]));
        }
        objReturn.setItem("g_blob", (COSBase)g_blob);
        objReturn.setItem("Impronta_1", (COSBase)new COSString(new String(Base64.encode((byte[])this.Impronta_1))));
        objReturn.setItem("Impronta_2", (COSBase)new COSString(new String(Base64.encode((byte[])this.Impronta_2))));
        objReturn.setItem("Impr_signed", (COSBase)new COSString(new String(Base64.encode((byte[])this.Impr_signed))));
        objReturn.setItem("user_notice", (COSBase)new COSString(new String(this.user_notice)));
        COSArray arr_personal_data = new COSArray();
        for (int i = 0; i < this.personal_data.length; ++i) {
            arr_personal_data.add((COSBase)new COSString(this.personal_data[i]));
        }
        objReturn.setItem("personal_data", (COSBase)arr_personal_data);
        if (arr_byte_range.length == 2) {
            COSArray byte_range = new COSArray();
            byte_range.add((COSBase)COSInteger.get((long)arr_byte_range[0]));
            byte_range.add((COSBase)COSInteger.get((long)arr_byte_range[1]));
            objReturn.setItem("byte_range", (COSBase)byte_range);
        }
        return objReturn;
    }

    public long[] getByte_range() {
        return this.byte_range;
    }

    void setByte_range(long[] byte_range) {
        this.byte_range = byte_range;
    }

    public byte[] getG_blob() {
        return this.G_blob;
    }

    public byte[] getImpronta_1() {
        return this.Impronta_1;
    }

    public byte[] getImpronta_2() {
        return this.Impronta_2;
    }

    public byte[] getImpr_signed() {
        return this.Impr_signed;
    }

    public String getUser_notice() {
        return this.user_notice;
    }

    public String[] getPersonal_data() {
        return this.personal_data;
    }

    @Override
    public COSDictionary getDictionary() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

