/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.pdf.panels;

import esecurity.crypto.gui.pdf.bean.PdfDocument;
import esecurity.crypto.gui.pdf.guielements.CGAppearance;
import esecurity.crypto.gui.pdf.guielements.CGAppearanceBuilder;
import esecurity.crypto.gui.pdf.panels.bmgrzhnc;
import esecurity.crypto.gui.pdf.panels.ggspsofe;
import esecurity.crypto.gui.pdf.panels.nhlbjjuv;
import esecurity.crypto.gui.pdf.panels.srbytebd;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.utils.guielements.CGRadioButton;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.SpanContainer;
import esecurity.desktop.dom.TextInput;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.vol.utils.Constants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class PdfViewerOptionsPanel {
    private static final EllipsLogger logger = PdfViewerOptionsPanel.Hz("-eaj424", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static final String ARROW_LEFT;
    private static final String ARROW_RIGHT;
    private final View view;
    private final CGAppearanceBuilder appearanceBuilder;
    private final List<PdfDocument> pdfDocuments;
    private CGRadioButton imageYesRB;
    private CGRadioButton imageNoRB;
    private Image appearanceImage;
    private Button modifyImageBtn;
    private CGRadioButton dateYesRB;
    private CGRadioButton dateNoRB;
    private CGRadioButton locationYesRB;
    private CGRadioButton locationNoRB;
    private TextInput locationTextBox;
    private CGRadioButton reasonYesRB;
    private CGRadioButton reasonNoRB;
    private TextInput reasonTextBox;
    private CGRadioButton preservePDFAYesRB;
    private CGRadioButton preservePDFANoRB;
    private boolean isOptionsVisible = false;
    private BufferedImage bufferedImage = null;

    public PdfViewerOptionsPanel(CGAppearanceBuilder appearanceBuilder, List<PdfDocument> pdfDocuments, DOMElement parent, View view) {
        this.appearanceBuilder = appearanceBuilder;
        this.pdfDocuments = pdfDocuments;
        this.view = view;
        this.draw(parent);
    }

    private void draw(DOMElement parent) {
        char[] cArray = "\u71d5\ucb99\u77c3\u0b61\ua416\udeff\ucca6\u6424\u4b8c\udad1\ua608\u6a2a\ub7be\u2047\u82b6\u93c6\u75af\u08b7\u0874\u6731\u2086\u060d\u0c96\u9485\u584c\u3f0c\u6922\udc12\u4920\u15b4\u8972\u45f9\u781a\u386e\u2ade\ufb91\ue66f\u236c\u4ab7\ud41d\u2b89\u343c\u2232\ucbdd\u2aae\u633f".toCharArray();
        cArray[16] = (char)(cArray[16] ^ 0x881);
        DivContainer optionsContainer = new DivContainer(srbytebd.Q(cArray, (short)96, (short)4, (byte)4), parent, this.view);
        char[] cArray2 = "\u3ef9\ued93\u03d2\ued44\u5969\u67a2\u9660\ua53a\u368a\u47f0\ud589\ucc66\u17b0\uf948\u1bca\u453d\u6feb\uc792\u3f07\u57b9\uc0e1\u16fc\ue04d\u47bd\uebc4\u0e34\u4329\u98bb\u1a3c\uad27\u58bf\u3738\ud821\ufb38\u0281\u9f6a\ue1ee\ue5df\u7fc0\u13bf\u1097\u1420\u83b0\ud011\u16b8\u321c".toCharArray();
        cArray2[35] = (char)(cArray2[35] ^ 0x2F6C);
        PdfViewerOptionsPanel.Hz("1958rld", optionsContainer, srbytebd.Q(cArray2, (short)1072, (short)0, (byte)5));
        char[] cArray3 = "\uefde\u63d4\ua25d\u4c1a\uc67f\u5c44\u7239\u3bbc\u1973\ue443\u485a\u5ee1\u0816\u6d5f\u4074\ub793\u3e27\uaa54\u5ddb\u7802\ufa0a\u6a63\u40fd\u8cd9\u739e\uf548\u2d0f\ub91b\uf253\u5da8\u0179\u1a4b\uf7eb\u30cd\u3246\u5530\ue8fc\uf70b\uecc4\u155f\u9ed8\u9beb\u1be9\ue816\ua218\ufd64\u7bf4\u799a\u5bb2".toCharArray();
        cArray3[23] = (char)(cArray3[23] ^ 0x2505);
        DivContainer optionsArea = new DivContainer(srbytebd.Q(cArray3, (short)27695, (short)0, (byte)0), (DOMElement)optionsContainer, this.view);
        char[] cArray4 = "\ua7c7\u1825\uc7c6\u5591\u1da1\ua225\u08fe\ue197\ud2eb\u6e97\u7c09\ua64a\u0ae8\u1320\u8d4c\u10ab\ub4ec\u6718\ufa6f\u3f94\u98ee\u554c\u9bb0\ub241\ua362\u31c1\u8e7a\ucce7\u6851\uccd5\u6b87\u6db6\u1961\ud930\u2151\ufb00\u5506\u7e20\uc8c5\u81b9\u2aa3\ubdd9\ub855\uf7bf\u87b3\u08a4\ud5ed\u1063\u640c".toCharArray();
        cArray4[11] = (char)(cArray4[11] ^ 0x2A86);
        PdfViewerOptionsPanel.Hz("1958rld", optionsArea, srbytebd.Q(cArray4, (short)13433, (short)3, (byte)0));
        PdfViewerOptionsPanel.Hz("-15mt44t", optionsArea, false);
        char[] cArray5 = "\u483f\u4b94\ud668\u7524\u65bc\uee8e\uc512\u66a4\ub6cd\ua078\ucc07\u2fff\u8855\u7caa\uef2a\u1285\ue2a1\u76b4\u9e30\u90ab\uc57a\u47ef\u5013\ua54e\u0e13\u6f5b\uc261\u099a\u01bb\u66e5\u89a5\ufa7d\ua5bf\u5db2\u3144\uf2d4\u4074\u8c85\u09e3\u120b\u83be\u1008\u9043\u10e9\ua554\u0fc9\u61a2\uaf6c\u5e4a\ub5fa\u9dc3\u796a\ufbc1\u25da\ue677\u3599".toCharArray();
        cArray5[17] = (char)(cArray5[17] ^ 0x775C);
        DivContainer optionsAreaContent = new DivContainer(srbytebd.Q(cArray5, (short)3437, (short)2, (byte)3), (DOMElement)optionsArea, this.view);
        char[] cArray6 = "\ue3e4\u7ac8\u7656\u570f\u5a7d\u97d7\uef1f\u30d0\uc2f3\u6199\uc541\u81a1\u7a6e\ucde4\ue033\uf9ae\ud54b\uab94\uf8c9\u2911\u4d35\u4674\ubc37\u591f\u182b\u2c0d\u6441\u7f1d\ueb0b\u4768\u2462\uff5d\u7fe3\ubeb2\u8a95\u4036\u53f1\u0edd\ub9b2\u1ea2\ufb03\u7d2d\ue74c\uc47e\u3f75\u1087\u036e\u6b5e\u2bec\uc533\uf9d3\u5271\uf2bc\u2d4f\uee19\u4172".toCharArray();
        cArray6[46] = (char)(cArray6[46] ^ 0x3B0E);
        PdfViewerOptionsPanel.Hz("1958rld", optionsAreaContent, srbytebd.Q(cArray6, (short)15703, (short)1, (byte)4));
        char[] cArray7 = "\uca3a\u34a5\ub4fd\u0dad\u9621\ubbf8\udd23\u4eca\uebe1\uae8a\u7691\uf19c\ud9be\u6218\uef2e\u2c44\u69fe\u93a3\uef9b\ua741\u61a3\u813e\u720f\u95f0\udec4\u90c2\u435e\u9de9\u8875\u9036\u3961\u4a16\ua11c\ub6fb\uf805\uce81\u12fa\u854e\ucf86\u7c25\u1a29\uc1ac\ueaf2\uaa04\uea01\u1b2c\u9fb7\u2f15\u1eae\ude6f\ue085\u2f82\u27e0\u0938".toCharArray();
        cArray7[17] = (char)(cArray7[17] ^ 0x6CE2);
        Paragraph optionsInfo = new Paragraph(srbytebd.Q(cArray7, (short)28610, (short)4, (byte)2), (DOMElement)optionsArea, this.view, () -> {
            char[] cArray = "\udd63\uf866\uec2b\ue953\u1cfd\u8c23\u2519\ubc56\ucc1f\ubde4\u97db\ued67\u9f921\ud70e\u0e93\ucb46\ub994\u9430\u9c9a\ue40a\u20d7\u5476\u16c7\ud34b\uc9c8\u6034\uda15\u5893\u9a23\u115b\ucc22\u1110\ub651\u3e4f\u55e2\u85f0\u0469\u3d22".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x7750);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, nhlbjjuv.g(cArray, (short)8644, (byte)4, (short)0), (Object[])new Object[0]);
        });
        char[] cArray8 = "\u04cd\u2abd\ucd53\ufa5b\u3908\u10ad\uf36f\u846b\u0beb\u41ee\u4e22\u6b81\u15f3\u676c\u9450\u06df\u40b1\ucc30\u85d7\u2edd\ufeb3\ucaef\u6a79\ub259\u9e33\u2c94\ua041\uff10\ua1a1\ua1e4\ued91\u0459\u39dc\u5b7a\u39ff\uca79\u33c4\uf2e8\u2975\uf971\uc2fc\u2b51\ud33b\uf14e\uce10\u48f0\u259d\u8ae5\u1bae\ua8a9\u1687\uf454\u8212\u7fbe".toCharArray();
        cArray8[29] = (char)(cArray8[29] ^ 0x2D3D);
        PdfViewerOptionsPanel.Hz("1tbmrqs", optionsInfo, srbytebd.Q(cArray8, (short)5890, (short)1, (byte)2));
        this.drawImageArea((DOMElement)optionsAreaContent);
        this.drawDateArea((DOMElement)optionsAreaContent);
        this.drawLocationArea((DOMElement)optionsAreaContent);
        this.drawReasonArea((DOMElement)optionsAreaContent);
        this.drawPreservePdfAArea((DOMElement)optionsAreaContent);
        this.drawVerticalArea((DOMElement)optionsContainer, (DOMElement)optionsArea);
    }

    private void drawImageArea(DOMElement parent) {
        char[] cArray = "\uf57b\u172a\ud60e\u0bea\ufdb4\uad9e\u8b44\u30d1\uc57d\uad02\ubc8b\u8960\u1575\uc1ae\ue6ab\u19e7\ud3d6\ue82d\u4e3f\uff46\ued88\ued6c\uc4b6\uec4c\u10fa\u20f3\u18f4\u37e6\ucd35\u4690\u5cda\u2342\ude0e\u90aa\ubb01\uf69c\uff37\uf845\u8232\ufa44\u4941\u3f39\ue522\uac01\u56b4\u6582\u30ef\ubf8e\uecb8\uef3c\u1a76\uf496\u52ee\u0619\u675f\u1787\u2cbe\ueef5\ucaad\u5f1d".toCharArray();
        cArray[0] = (char)(cArray[0] ^ 0x6FD1);
        Paragraph imageTitle = new Paragraph(srbytebd.Q(cArray, (short)1408, (short)5, (byte)4), parent, this.view, () -> {
            char[] cArray = "\uabed\u6df9\ufc13\u3f90\u3da7\u57e7\u82c2\u14032\u7bac\u5340\u85a8\ub0d5\uf9fe\u3771\u56f9\u23fa\u7959\ucf6c\u55a5\u01f1\u302a\ufaaf\ufe93\u7902\uc506\u7e85\u1ccc\u65c4\udbfb\u012b\u3d35\u11ff\u4421".toCharArray();
            cArray[7] = (char)(cArray[7] ^ 0x7AC9);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, nhlbjjuv.g(cArray, (short)6897, (byte)1, (short)1), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u61a9\u9b3d\ue8d0\uc3e7\u9b18\ub9e9\uf9a7\u4cdc\ufbba\ue70d\ud84d\u5723\ud286\ud8a8\ucd6c\u594c\u1e4d\u0800\ud864\u8094\u8f85\uf81f\uc9ff\u1546\u5a5a\ud165\u8e42\u5834\ufef1\u0a34\u37ed\udd5e\u5fcd\u4040\u9090\ub1a6\u9e10\ue820\ua4d5\u56f6\u49e9\uc3fa\u5922\u64f3\u531c\u98f8\u1874\ud3a6\u4cf4\uc407\u0d4c\uf24b\uc551\u0ae5\u5d50".toCharArray();
        cArray2[23] = (char)(cArray2[23] ^ 0x2D9D);
        PdfViewerOptionsPanel.Hz("1tbmrqs", imageTitle, srbytebd.Q(cArray2, (short)18165, (short)3, (byte)1));
        char[] cArray3 = "\uf020\u5847\u3d79\uff87\u2430\u296d\u3d16\u9772\u8f4e\udd31\uaa52\u7139\u3efa\u6e33\u8a40\u1075\u9d16\u77ca\u5e9a\u2b03\u82c4\u17c9\u3b71\u9ac2\u8592\u934e\u571f\u25e1\u1147\udefd\u906a\u678a\u27ba\u92f0\u9f9a\u53c1\u2219\u56a8\u1406\u0ca3\uaafe\u822b\ua181\uf08b\u0e9d\ubb92\u243a\u4351\ub4ca\u9be4\u8663\u7cfa\u9d96\uf22c\u583d\u130f\u6428\u070d\u4b14\ue282\uf58d\u5cf4".toCharArray();
        cArray3[51] = (char)(cArray3[51] ^ 0x6BE0);
        DivContainer imageDivisor = new DivContainer(srbytebd.Q(cArray3, (short)13779, (short)5, (byte)5), parent, this.view);
        char[] cArray4 = "\u908e\u8d49\u5a78\u7aa2\u58dc\u3010\u86ba\ue9f3\u7630\ub1d6\u57fe\u098d\u22d1\u0e13\u610f\u1569\ufb41\u0e62\u69a6\ucaa8\u824f\ud599\uf30f\ud4a3\u905a\u9050\u709d\ud1a0\u4d77\u684f\u0792\u94dc\ud8f3\u4039\uaee4\u7fc0\u037d\u9636\u8157\u0537\udd59\u6e3c\uc9bb\uddae\u4e99\ub3f2\ub19e\u5fe1\u76a8\u1406\u5564\u7e1e\u8605\uf988\u5f6d\u6b2b\u1b44".toCharArray();
        cArray4[42] = (char)(cArray4[42] ^ 0xFD2);
        PdfViewerOptionsPanel.Hz("1958rld", imageDivisor, srbytebd.Q(cArray4, (short)21026, (short)0, (byte)4));
        char[] cArray5 = "\ufb7d\uccbe\u8e95\u76e8\u9dd7\u7ce8\uc027\u73bc\u83e0\uc1f9\ue341\u1596\u792f\u361b\u47a4\u2d66\u16a1\u86c9\ud269\u5fbe\ua978\u51e2\u3dc1\u55f3\u0994\u1d7d\u7efc\ucdd9\u4aab\u7dcd\u9124\u3356\ue356\uc1d4\u0861\u572e\u0aa3\ue8ac\ud775\u09f1\u9963\ue96c\ue77a\u5378\u4970\u0e3a\u33d1\u2a7a\u6bfa\uc8b9\u1384\u2ea3\ucbfb\u93a1\u3637\u1a03\u35c2\u50db".toCharArray();
        cArray5[43] = (char)(cArray5[43] ^ 0x8F9);
        char[] cArray6 = "\u3029\uc877\uf30c\u986d\u99a8\uca61\ud2ff\u4bc3\u6def\u763a\u1e89\u3f4e\u4d57\ue541\uee5d\u0348\uc451\ua2fe\ud4e5\u04f1\u8d7c\u0018\ue07d\u78e2\uf26d\u4ab7\u304c\u5025\u4c21\ua9f5\ua58a\u7f9e".toCharArray();
        cArray6[7] = (char)(cArray6[7] ^ 0x4F18);
        char[] cArray7 = "\uf815\u34c4\ua790\uad4e\u9f6d\uae22\u349e\uebfe\u8138\ub2a2\u5298\u5b5e\u338e".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0x2BB3);
        this.imageYesRB = new CGRadioButton(srbytebd.Q(cArray5, (short)27813, (short)2, (byte)3), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray6, (short)383, (short)3, (byte)5), (Object[])new Object[0]), srbytebd.Q(cArray7, (short)15637, (short)0, (byte)0));
        char[] cArray8 = "\u17ed\ua3da\u7a1e\u8a5a\u269b\ub10c\uf79b\u8209\ue7a6\ud0c8\uf2e8\u3d67\u84f3\ub620\uc97a\u909b\ucff3\ucf5b\ud788\ua2b8\uee31\u6819\u6b3d\u71be\u6f46\u93ca\u6b2b\u9c6a\ucf2a\ub609\uc6da\u363f\u9e98\u2f9e\u64bd\u5bba\uc093\u2281\ud2cf\u2584\u7156\u4f90\u8a22\u265f\u2142\ucead\u4157\u1471\ub9dd\uc428\ub3c5\u4b40\u6606\uaade\uda50\u1fbe\u3cb1".toCharArray();
        cArray8[49] = (char)(cArray8[49] ^ 0x1EE3);
        char[] cArray9 = "\u3e88\u1e11\ufbd9\ubb69\ue430\udb0c\u8de7\uc6e9\u8f87\u8512\u60fd\ucb3b\u88f5\u4993\u0384\u798a\u7ac6\u1870\ufc57\ua8b6\u7eae\ue2b3\ua592\u8e37\u9568\u82f2\u226d\u18b5\ufba4\u68e2\u6f2c".toCharArray();
        cArray9[5] = (char)(cArray9[5] ^ 0x3D3A);
        char[] cArray10 = "\u07b1\u76ea\u20f0\u0719\ub7cd\u71ac\ud8db\u7a1c\uafc7\ud53e\uc8fe\u0007\u54b8".toCharArray();
        cArray10[11] = (char)(cArray10[11] ^ 0x69E6);
        this.imageNoRB = new CGRadioButton(srbytebd.Q(cArray8, (short)30981, (short)2, (byte)5), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray9, (short)27585, (short)2, (byte)5), (Object[])new Object[0]), srbytebd.Q(cArray10, (short)30821, (short)5, (byte)1));
        char[] cArray11 = "\u8941\u534f\ubf7d\u82bf\u7077\uef3a\ud011\ude43\uf606\u7ed2\u3fd9\ubf10\u63a3\u581a\uc43b\u5409\uf836\u5809\u4d76\uac1d\uadc8\u2173\u4547\u5583\ued55\u1087\ua7ff\u9edb\ued5c\ucfd5\udf66\uf49c\uc327\ueaf2\u04a1\u7a49\u3148\uad37\ub77b\ud2e6\ue4c3\u5431\ue4a6\ub0d2\u7c7c\u12a7\uaaa5\u2248\u5bc8\u4273\u571d\u22f8\uec7e\u0576\uc1bc\u454a\ud3c0\u4455\u9727\u0878\u3565".toCharArray();
        cArray11[45] = (char)(cArray11[45] ^ 0x5153);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.imageYesRB, srbytebd.Q(cArray11, (short)10447, (short)5, (byte)3));
        char[] cArray12 = "\uf4cb\u2941\ud8bc\u13af\u9bd6\u4c5f\u8020\u2d46\ue7f3\u01ec\ub795\u9905\uc640\ued32\u93a8\u3cab\u84e9\ufee1\u304a\ud9a7\u498a\u6250\u4851\uc738\u503d\u88e4\ue4bc\ub454\ufee1\uce37\ub3b6\u7129\u0f63\u4d8d\u2197\ue5e4\u5fbb\u0f2c\uca7e\u335d\u4519\u3719\u5a8d\ude99\u0454\u5bf6\u38a4\u1ada\u1908\uda1e\u18ad\u24ca\u6ffb\ubb80\ude2e\ua017\u3cab\u6e9b\ud27b\u5d24\u5f5f".toCharArray();
        cArray12[42] = (char)(cArray12[42] ^ 0x5BAD);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.imageNoRB, srbytebd.Q(cArray12, (short)5509, (short)5, (byte)0));
        char[] cArray13 = "\u4bd2\uca91\u0d2a\ua26e\u302a\uc7a1\u7219\u32a1\u2c42\u7a79\u5621\u1ba2\ued3b\u5395\u1503\ua66e\u1750\u38a9\u1237\u7d12\u3030\ueaed\u1581\u89fa\ub909\u1bbd\u2f85\udda1\ua241\u3a2a\u6150\u0fae\ub1c6\u8242\u379e\u3aa9\u2cb0\u3d19\u6a07\ua2dc\u7065\ube4b\ud384\ue052\ua311\ue439\u45de\u308b\u93cc\u091e\u8be5\ue5b3\u2895\uefb5\u504b\u3654\u5d43\u0451\uba44\u0601\ub6c4\u9869\uc476\u2d60\u1b5c".toCharArray();
        cArray13[33] = (char)(cArray13[33] ^ 0x6F59);
        this.appearanceImage = new Image(srbytebd.Q(cArray13, (short)20158, (short)4, (byte)2), parent, this.view);
        char[] cArray14 = "\ufc8c\u1250\ub1e3\uf67e\u6e64\u173c\u3bb9\uc992\u6915\ue8aa\u7936\u313e\u1ba8\u435a\u2020\u5be3\uc3c5\udaba\u9259\u98f6\u2923\ua5d4\u5423\u6e6c\u3e89\ub442\u582d\udfe0\u7c9b\ucbaa\uf73e\u60d9\u74af\u13b1\u4c53\u0c2d\u1d94\ub78c\u3c5b\uc3e1\u9e78\u3a4c\u5d44\u2552\u2cdb\uc9a6\u8af9\ua36d\ua4d6\u3398\u015f\u45e8\u48ee\u43f8\u394f\uc648\u67b5\uae47\u3dc3\u2bd8\ua0f2\u2e6f\u8943\ub2a4\u38ec".toCharArray();
        cArray14[8] = (char)(cArray14[8] ^ 0x68FD);
        PdfViewerOptionsPanel.Hz("1mlorr2", this.appearanceImage, srbytebd.Q(cArray14, (short)15215, (short)3, (byte)0));
        if (PdfViewerOptionsPanel.Hz("1kf6rvn", PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
            PdfViewerOptionsPanel.Hz("rrerr0", this.appearanceImage, PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
        } else {
            char[] cArray15 = "\u758a\u2ac3\ufbec\ua0f0\ucb45\u7400\uda63\u9bc8\u80fc\udcc6\u3401\u8832\u933b\ubc4e\ufee0\u9231\u476e\ub837\ubdb9\ueef5\uc75f\ub59f\ub28f\ub8a3\u920c\u5d20\ub9bd\u678a\uffe4\u0e3d".toCharArray();
            cArray15[21] = (char)(cArray15[21] ^ 0x7D);
            PdfViewerOptionsPanel.Hz("rrerr0", this.appearanceImage, PdfViewerOptionsPanel.Hz("2v8rr1", srbytebd.Q(cArray15, (short)11042, (short)2, (byte)3)));
        }
        char[] cArray16 = "\u83c6\u5b93\u8cd4\u4cf1\u74c1\u44fa\u6d25\uc0be\u7be7\uddce\u3029\ud5d0\uc87f\ue928\u1432\uc526\u0a07\u8c72\ud14a\uf309\uc1d5\uaca3\u1331\u9457\u1a83\u44b3\u5fe8\u692c\u1f01\u0378\ua92c\u8eee\u587c\u967b\u12ab\u2d4b\u9998\u3e36\udd1b\u6921\u3319\ue40b\ube6e\ub070\ube17\u262b\u39f1\ud85a\u6922\ub52c\u4879\uee54\u4330\uebf5\uf5c3\ue135\ud53c\u019c\u3d96\ufd71\u978e\ud62b\uc4c5\u686b".toCharArray();
        cArray16[23] = (char)(cArray16[23] ^ 0x6120);
        this.modifyImageBtn = new Button(srbytebd.Q(cArray16, (short)9955, (short)4, (byte)4), parent, this.view, () -> {
            char[] cArray = "\u9d38\u2d78\u3ef8\u27c5\u11f3\ucd77\u4177\ue4cc\uc4f1\u09a8\uf640\u7ca5\ub993\ud83a\u1c0c\u7199\u7f19\u5b4d\u46da\ufd30\uaa16\u7481\u2640\u3694\u55a8\u0970\u87e5\ud2f2\uc8be\uf8fd\u5fae\ucc08\u394c\u2607\u3ffe".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x7058);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, nhlbjjuv.g(cArray, (short)17285, (byte)5, (short)2), (Object[])new Object[0]);
        });
        char[] cArray17 = "\u7a89\uf319\u48b2\ubf13\u9601\u68bd\uba35\u0cfb\ua44f\u2b88\u2bad\u2c64\u2461\u592a\uec06\ua263\ub3b0\uadaa\u306e\u76f1".toCharArray();
        cArray17[1] = (char)(cArray17[1] ^ 0x43A3);
        PdfViewerOptionsPanel.Hz("-139n43f", this.modifyImageBtn, srbytebd.Q(cArray17, (short)13677, (short)3, (byte)3));
        char[] cArray18 = "\ucccf\u2a5c\u8090\ua5ec\u60db\ua711\u90d6\u2068\ua554\ucfb4\u5231\u3b5b\ucb95\u479b\u9ec4\ue90e\uc9da\u87ad\udabf\u644b\u2c27\uf576\u5417\u4124\ud03c\ubdde\u8167\u2e92\udb10\u7d7b\ua21c\uff7d\ue314\ueca2\u540e\u56b0\uf0d9\uf99b\u693f\ua13c\uc8ee\u2a5f\u939f\ub677\u188f\u8c4a\u18af\u2ad5\u850d\u3a41\uf49a\ua9e3\ue569\u1aaf\u8805\u4fd6\u28be\u29eb\u319c\ue144\u8959\u1bd6\ue35d\u3632".toCharArray();
        cArray18[32] = (char)(cArray18[32] ^ 0x7EA4);
        PdfViewerOptionsPanel.Hz("-139n43f", this.modifyImageBtn, srbytebd.Q(cArray18, (short)15734, (short)1, (byte)1));
        PdfViewerOptionsPanel.Hz("-ukj40a", this.imageYesRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.imageYesRB) != false) {
                this.onImageYesSelected();
            }
        });
        PdfViewerOptionsPanel.Hz("-ukj40a", this.imageNoRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.imageNoRB) != false) {
                this.onImageNoSelected();
            }
        });
        char[] cArray19 = "\u3c45\u4170\u1993\uf853\u4abd".toCharArray();
        cArray19[0] = (char)(cArray19[0] ^ 0x4121);
        char[] cArray20 = "\uf433\u6f0d\u24ca\udcdc\u6991".toCharArray();
        cArray20[3] = (char)(cArray20[3] ^ 0x5FF2);
        if (PdfViewerOptionsPanel.Hz("-rv340b", srbytebd.Q(cArray19, (short)3435, (short)4, (byte)1), PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_IMAGE, (Object)srbytebd.Q(cArray20, (short)17130, (short)5, (byte)4))) == false) {
            PdfViewerOptionsPanel.Hz("n34rvk", this.imageNoRB, false);
            this.onImageNoSelected();
        } else {
            PdfViewerOptionsPanel.Hz("n34rvk", this.imageYesRB, false);
            this.onImageYesSelected();
        }
        PdfViewerOptionsPanel.Hz("-grh43g", this.modifyImageBtn, evt -> this.onModifyImage());
    }

    private void onImageYesSelected() {
        if (this.bufferedImage == null) {
            Object src = null;
            File srcFile = null;
            if (PdfViewerOptionsPanel.Hz("1kf6rvn", PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)"")) == false) {
                srcFile = new File((String)PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_IMAGE_CUSTOMSOURCE, (Object)""));
                src = PdfViewerOptionsPanel.Hz("-17av40d", srcFile);
            }
            if (src != null) {
                PdfViewerOptionsPanel.Hz("rrerr0", this.appearanceImage, src);
                try {
                    this.bufferedImage = PdfViewerOptionsPanel.Hz("-1eq140e", srcFile);
                }
                catch (IOException ex) {
                    PdfViewerOptionsPanel.Hz("-1c943b", logger, PdfViewerOptionsPanel.Hz("-7r343a", ex), (Object)ex);
                }
            } else {
                this.loadDefaultImage();
            }
        }
        char[] cArray = "\ue7a1\u4ef6\u5ec2\u590b\u7a17\u0aad\ua28f\uf96e\u1919\u6933\uf741\u6cd9\u2d32\u287a\u43ba".toCharArray();
        cArray[11] = (char)(cArray[11] ^ 0x611B);
        PdfViewerOptionsPanel.Hz("csirvh", this.appearanceImage, ggspsofe.R(cArray, (short)4078, 2, false));
        PdfViewerOptionsPanel.Hz("-1lef40g", this.modifyImageBtn, false);
        PdfViewerOptionsPanel.Hz("1vpirvf", this.appearanceBuilder, true);
        PdfViewerOptionsPanel.Hz("l9qrve", this.appearanceBuilder, this.bufferedImage);
        this.updateAllImages(this.bufferedImage, true);
    }

    private void loadDefaultImage() {
        char[] cArray = "\u7577\u4b01\ue4e9\u9b81\u9386\u66b2\u5e3f\ub4e6\ufc69\u4954\u384e\u3bc7\u999e\u4704\u3016\u553b\u530f\u2d34\u687f\ubd63\u2b6b\u6218\uf4b1\ufe14\u9a7b\u4790\ued26\u09a4\u00cd\u0950".toCharArray();
        cArray[20] = (char)(cArray[20] ^ 0x3456);
        PdfViewerOptionsPanel.Hz("rrerr0", this.appearanceImage, PdfViewerOptionsPanel.Hz("2v8rr1", srbytebd.Q(cArray, (short)27796, (short)4, (byte)0)));
        try {
            char[] cArray2 = "\u8d11\u8432\u790c\u290d\ud830\u7430\u4c87\u3500\ub193\ua75a\u2a35\u56de\u0cf9\u85ef\u6bb4\uc471\u2eae\ud8a1\u47ee\udb1c\u16b6\ucc0b\u278d\u701c\u8d74\ue8cd\u5c88\u9c61\ucfa2\u6d72\u02c8\u0e0f\u632b\uf99b\u6dd6\udab1\uab2b\u2b48\u597f\u1e1d\u4528\u77f6\u6ad2\u47e8\ua9ff\ua529\uc6d5\ub805\uba93\u3691\ucdec\u265f\ua6ec\ud3d6\u7f42\u36b8".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x3FA5);
            this.bufferedImage = PdfViewerOptionsPanel.Hz("1d1ervc", PdfViewerOptionsPanel.Hz("dfurvd", PdfViewerOptionsPanel.class, srbytebd.Q(cArray2, (short)26756, (short)5, (byte)1)));
        }
        catch (IOException ex) {
            PdfViewerOptionsPanel.Hz("-1c943b", logger, PdfViewerOptionsPanel.Hz("-7r343a", ex), (Object)ex);
        }
    }

    private void onImageNoSelected() {
        char[] cArray = "\u11b2\u7cc8\u03db\u0917\u23d3\uf40a\ufb0c\u4bc6\u876d\ucbea\uad4c\ub83a\uc279\u417a\u2a37".toCharArray();
        cArray[3] = (char)(cArray[3] ^ 0x797C);
        PdfViewerOptionsPanel.Hz("1mlorr2", this.appearanceImage, srbytebd.Q(cArray, (short)15460, (short)3, (byte)0));
        PdfViewerOptionsPanel.Hz("-1lef40g", this.modifyImageBtn, true);
        PdfViewerOptionsPanel.Hz("1vpirvf", this.appearanceBuilder, false);
        PdfViewerOptionsPanel.Hz("l9qrve", this.appearanceBuilder, null);
        this.updateAllImages(null, false);
    }

    private void onModifyImage() {
        char[] cArray = "\u61d1\u9498\u524a\u83df\ue356\u0550\u9c9a\u39e2\u2b92\uab18\ub7df\uda3a\uae1a\u56e2\u3232\u0d53\uaf46\u1ca2\u1c9b\ufa55\u92ab\ua2d3\u8e19\uc86f\u3723\u850f\ufb1b\ue5b5\u6208\u8730\ue7bb\u721a\u93d9\ua09e\u4316\ud64c\u1aaa\u7188\uf553\uec64\ud330\u0367".toCharArray();
        cArray[25] = (char)(cArray[25] ^ 0x390A);
        FileDialog dialog = new FileDialog(this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray, (short)3759, (short)3, (byte)2), (Object[])new Object[0]), esecurity.crypto.gui.utils.Constants.APPEARANCE_IMAGE_FORMATS);
        Object file = PdfViewerOptionsPanel.Hz("-db341l", dialog, false);
        if (file != null && !file.isEmpty()) {
            try {
                File imageFile = new File((String)file.get(0));
                PdfViewerOptionsPanel.Hz("rrerr0", this.appearanceImage, PdfViewerOptionsPanel.Hz("-17av40d", imageFile));
                PdfViewerOptionsPanel.Hz("1vpirvf", this.appearanceBuilder, true);
                this.bufferedImage = PdfViewerOptionsPanel.Hz("-1eq140e", imageFile);
                PdfViewerOptionsPanel.Hz("l9qrve", this.appearanceBuilder, this.bufferedImage);
                this.updateAllImages(this.bufferedImage, true);
            }
            catch (IOException ex) {
                PdfViewerOptionsPanel.Hz("-1c943b", logger, PdfViewerOptionsPanel.Hz("-7r343a", ex), (Object)ex);
            }
        }
    }

    private void updateAllImages(BufferedImage image, boolean useImage) {
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Hz("-lcv41n", PdfViewerOptionsPanel.Hz("10erua", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Hz("-asr42o", app, useImage);
                PdfViewerOptionsPanel.Hz("-51d42p", app, image);
                PdfViewerOptionsPanel.Hz("-11qj42q", app);
            }
        }
    }

    private void drawDateArea(DOMElement parent) {
        char[] cArray = "\u6171\ueb43\u41cd\u05e4\u7ccf\u8207\ub06b\ue772\ue4e0\u3b75\u7168\ud519\u429a\ud4f4\u8e66\uf585\u3b99\u18bf\u1295\ub625\uc053\ubde7\ub605\u9356\u6deb\u3b41\uff42\u0aa8\ubd6f\ud56b\u1304\u994e\u31a3\u7e74\u3c1a\u0c40\ue912\ua573\u17e9\uf83c\ub96c\u7a9a\ue2bb\ude2b\ua354\u5122\ub90a\u8c53\u9171\ud982\ubc49\u8ec1\u53f8\uf7c9\u54b6\u77d0\u0ccf\u5370\u5774".toCharArray();
        cArray[30] = (char)(cArray[30] ^ 0x2681);
        Paragraph dateTitle = new Paragraph(nhlbjjuv.g(cArray, (short)18182, (byte)2, (short)3), parent, this.view, () -> {
            char[] cArray = "\u6577\ua769\u0148\ua45e\u88af\u428b\uab6b\ua001\ub507\ub6fd\u75cd\u58ce\uc997\uc78c\u3db1\ub7f3\ub588\u8e61\u95ad\u5f6d\uccfc\u8dd2\uf12a\u37ca\u04cb\uc917\ubd89\u55bc\ude7e\uf097\u2e73\u52c7\u29b5".toCharArray();
            cArray[26] = (char)(cArray[26] ^ 0x1900);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray, (short)30517, 4, true), (Object[])new Object[0]);
        });
        char[] cArray2 = "\ue8c9\uf7b7\u75a8\ue153\u2b2c\u334b\ue078\ub64e\u7c48\u8e6c\ua17a\u6a9b\u0305\u33dd\ufbd5\ub7d4\uf9d1\u4ceb\u1a63\u2928\u2faf\u3377\ue563\uda96\u4505\u2345\u563c\u2665\u81e1\u0565\ub2fd\ueb91\ua6a1\ucdac\ubf76\u2e45\u2f31\u28b5\u8add\u19a1\uebee\u5af6\u030d\ufa50\u506c\uf61f\uf13a\u1545\uc0b6\uabf9\uc2ec\uea53\u5258\ub4ae\u6712".toCharArray();
        cArray2[42] = (char)(cArray2[42] ^ 0x2A1B);
        PdfViewerOptionsPanel.Hz("1tbmrqs", dateTitle, nhlbjjuv.g(cArray2, (short)16227, (byte)1, (short)4));
        char[] cArray3 = "\u5e15\u79ed\ucb4f\uec97\u0e0c\uc560\u5ad4\ufe7e\u2a34\u7632\uc5ef\ucd18\uc647\ubce4\u4b82\u968e\ub23d\u7250\ue32d\uddb7\u9187\uda08\u4143\uaf23\uc967\ufd61\ub8ac\u3f6e\u69a4\u1a8a\ua516\uacd5\u5953\u4262\u4afb\u4515\uc82f\ubc4d\u34e4\u7e4f\ua69d\uaf03\u2de1\u2499\ub14f\u254f\ua5fb\u5d3f\u55d2\u547b\u6a79\ud3cf\ud3f0\u839c\u0d27\u6d02\ub303\u26bb\ua356\u944f\u17bd".toCharArray();
        cArray3[22] = (char)(cArray3[22] ^ 0x32DB);
        DivContainer dateDivisor = new DivContainer(nhlbjjuv.g(cArray3, (short)10331, (byte)5, (short)5), parent, this.view);
        char[] cArray4 = "\u5af6\uecce\u5f43\u71bf\uf091\u28d3\uc5d2\ua169\ud372\u9e3e\u37fd\u0a89\uc4d1\u6efb\ub003\uf77d\u2acb\u6033\ueaaf\u46b3\u2721\uea23\uea08\u7396\ubdd9\ub577\uccc6\u20a6\u322a\ue0db\ued9f\ua5f9\u30ee\uee09\u6799\ueb1f\u1859\u108b\u4dde\u2b70\u6984\ucada\u8c18\udeff\u1cbb\u25c2\u7485\ua7be\u37d6\uf6e8\ud4f3\u4cc8\u73aa\ufc7f\u5d75\u9095\u5679".toCharArray();
        cArray4[1] = (char)(cArray4[1] ^ 0x68C8);
        PdfViewerOptionsPanel.Hz("1958rld", dateDivisor, nhlbjjuv.g(cArray4, (short)24212, (byte)3, (short)2));
        char[] cArray5 = "\u5dc3\ucdba\u9b4f\u77a9\u6eb9\u5b04\uc1b6\u1e41\u010a\uaa05\udf4d\uc058\udc4b\u9f7e\u2c3b\u9f1c\uc723\uc00f\u725f\u223b\u9c20\ua063\ucd4a\u5019\u42eb\u2623\ua354\u61d1\u5a92\u3460\u76bc\uc382\ub129\u4b1a\ucf1b\u60bb\u352f\u2e6b\u7a2c\ud288\u7070\u9543\uda5b\u7439\u266d\u9ee9\u3b1d\u2a61\uf8fc\u3d01\u6477\u05ad\ufa91\u862c\uc947\u0096\u7c8f".toCharArray();
        cArray5[48] = (char)(cArray5[48] ^ 0x1527);
        char[] cArray6 = "\ufcbd\uee7d\u7961\u6e05\uc010\uf95d\u9625\u92d9\ufe24\u0c50\u020c\u72e2\u7bcb\ue3d6\ue01c\ub9c9\u34fb\uec8e\u5d56\u9493\u37a7\u99d4\uf339\u0bce\u397b\u283d\u259d\u3cb9\u4010\ua938\uc7a2\u0a22".toCharArray();
        cArray6[2] = (char)(cArray6[2] ^ 0x1579);
        char[] cArray7 = "\u8631\ub611\u2681\u2d89\ud3be\u6b56\uf1be\ub99f\u6193\ue015\u58d0\u7eba".toCharArray();
        cArray7[2] = (char)(cArray7[2] ^ 0xBF4);
        this.dateYesRB = new CGRadioButton(nhlbjjuv.g(cArray5, (short)16905, (byte)2, (short)3), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, nhlbjjuv.g(cArray6, (short)29335, (byte)0, (short)5), (Object[])new Object[0]), nhlbjjuv.g(cArray7, (short)1012, (byte)3, (short)5));
        char[] cArray8 = "\u29df\u264f\u5dc0\ue339\u068d\u9458\ua108\u8978\uf0e4\ue898\ud077\ue4fe\uc122\ub24b\ue14f\u96fe\ucde4\u5dcf\uc47a\u9091\uac2f\u4fe0\uadc3\u8f32\u1072\u443c\ud0ba\u524fL\ua7a0\uf9ad\u2270\ue572\u13dd\u14a2\u2232\u6a0d\ua238\uacd2\ub3d3\ua219\u742b\u831e\u4b37\ucc40\u9029\u97c6\uadeb\u7e3c\u4bd3\ua5af\ue364\u21cd\uaded\u568a\u6516".toCharArray();
        cArray8[16] = (char)(cArray8[16] ^ 0x85C);
        char[] cArray9 = "\ue0d2\u1215\u8925\u263d\uba97\u4895\uf602\ue99c\uf7fd\u59c9\u163d\uf913\u394f\u49f4\u7e87\uaa4a\u9014\u843d\u8add\ua542\u9aed\u175b\u0dc3\u9416\u5fd6\u0493\u8c08\ua1e8\u8855\u18fe\u55a5".toCharArray();
        cArray9[22] = (char)(cArray9[22] ^ 0x7B08);
        char[] cArray10 = "\u1d07\u4a10\uabd4\uf00e\u4437\u9960\u60e8\u1f32\u4094\uf862\u8d4a\u2e23".toCharArray();
        cArray10[2] = (char)(cArray10[2] ^ 0x25ED);
        this.dateNoRB = new CGRadioButton(nhlbjjuv.g(cArray8, (short)23152, (byte)1, (short)3), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, nhlbjjuv.g(cArray9, (short)31993, (byte)5, (short)2), (Object[])new Object[0]), nhlbjjuv.g(cArray10, (short)10587, (byte)0, (short)3));
        char[] cArray11 = "\u586d\ue9d8\u2cd9\u3184\ubbec\u6d8a\uc1b9\u834e\u5d23\ud3f9\ue21a\ue9f6\u52d6\u4930\uf90a\u3a48\ucca6\ucdee\ud21d\u3cb0\u747d\u2eb2\ud825\uc5ba\uaf32\ue403\uc97b\u7db7\uca63\u9b27\u262c\u6fd6\u69e0\u6a73\u0f5a\uc787\u6826\u978b\ucb20\u009c\u5688\u5feb\uc8eb\u7774\u2066\u050b\ua6f3\uf0c7\u81a2\u1ac5\u81a6\u5c9d\u54dc\uc7ae\udff6\u0e0e\u1603\ub668\u061f\u8855\u7e36".toCharArray();
        cArray11[19] = (char)(cArray11[19] ^ 0x1DF7);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.dateYesRB, nhlbjjuv.g(cArray11, (short)28882, (byte)0, (short)1));
        char[] cArray12 = "\ua47e\u6157\u171b\u1daf\u2ad8\u85cc\ud203\u5107\u30b7\u024a\ua52e\uf505\u49c8\uae48\ue1a7\uf774\ubb50\u259d\u11d0\u8d5a\ue215\u4db7\u6429\ufd5b\u6498\udfbc\ud2cf\ua933\u1867\ueb17\udec8\u1dd9\ude7c\u42c6\u6d1d\u9e17\u8632\uc1d8\u24e0\ua5ce\u451e\u8ef4\uf4c6\u0188\u3c26\uc84c\u1fa3\u92cd\ucd00\u2070\ue9f6\u7c21\ua375\u380a\ubdd9\udfea\u5344\u1e16\u6fb3\u0252\u23f4".toCharArray();
        cArray12[42] = (char)(cArray12[42] ^ 0xBE3);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.dateNoRB, nhlbjjuv.g(cArray12, (short)25962, (byte)3, (short)2));
        PdfViewerOptionsPanel.Hz("-ukj40a", this.dateYesRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.dateYesRB) != false) {
                this.updateAllDates(true);
            }
        });
        PdfViewerOptionsPanel.Hz("-ukj40a", this.dateNoRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.dateNoRB) != false) {
                this.updateAllDates(false);
            }
        });
        char[] cArray13 = "\u4886\ud07c\uce3c\u69d0\u36bf".toCharArray();
        cArray13[2] = (char)(cArray13[2] ^ 0x4827);
        char[] cArray14 = "\u8ea4\u48ae\ud10a\u0c71\u0323".toCharArray();
        cArray14[0] = (char)(cArray14[0] ^ 0x3C66);
        if (PdfViewerOptionsPanel.Hz("-rv340b", nhlbjjuv.g(cArray13, (short)7999, (byte)4, (short)1), PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_DATE, (Object)nhlbjjuv.g(cArray14, (short)23516, (byte)5, (short)2))) == false) {
            PdfViewerOptionsPanel.Hz("n34rvk", this.dateNoRB, false);
            this.updateAllDates(false);
        } else {
            PdfViewerOptionsPanel.Hz("n34rvk", this.dateYesRB, false);
            this.updateAllDates(true);
        }
    }

    private void updateAllDates(boolean showDate) {
        PdfViewerOptionsPanel.Hz("-1atn42r", this.appearanceBuilder, showDate);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Hz("-lcv41n", PdfViewerOptionsPanel.Hz("10erua", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Hz("1d36rt4", app, showDate);
                PdfViewerOptionsPanel.Hz("-11qj42q", app);
            }
        }
    }

    private void drawLocationArea(DOMElement parent) {
        char[] cArray = "\u8f21\u5bf0\ufbad\u3be4\u480a\u0949\u256d\u984c\ubf64\u5fce\u69bf\u37a4\u4022:\u85c3\u4d6e\uc54f\u8ea4\u6ef4\u6888\ud6ad\ud5c3\u2159\ue37b\u4c41\u16de\ue0e2\u8e8b\u2fcf\u41b2\u3c2b\u5345\u0279\ua8b0\u5008\u0e78\ub475\u86cc\udce7\uefe5\u6eb6\ued20\u1e96\u6bd8\u970d\u4660\u078c\u70ab\u1c83\u514b\u79f4\u9fcc\u9bd0\uc7b8\u9085\uaab8\ubddb\ud2c4\uaa14\uf845\u3de4\udb46\u0595".toCharArray();
        cArray[20] = (char)(cArray[20] ^ 0x61BC);
        Paragraph locationTitle = new Paragraph(srbytebd.Q(cArray, (short)6001, (short)1, (byte)5), parent, this.view, () -> {
            char[] cArray = "\ude44\uf4f2\uc637\u7674\u6d34\uce79\ua250\u153d\u1c03\ud39d\u4a94\udf89\u66af\u6d43\u5558\u422e\ud574\u80c7\u3382\u5409\u9482\u0c9f\u3c07\uaf5f\u16f5\ue169\u9ea9\u0b0b\ub027\u8894\u9006\u5a25\uc7c5\ub429\u54d5\u9942\u3102".toCharArray();
            cArray[14] = (char)(cArray[14] ^ 0x34DF);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray, (short)32239, 1, true), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u9c44\ue44f\ub736\u480e\u6a0d\ufb21\uc174\u0e87\u420b\u7242\u70b7\u4dcf\u9414\u3da8\u1186\u58a4\ucc3a\ubf9d\uebc1\u08f8\uef3e\ud9ef\u5039\u8e71\ub01b\u3905\u2307\u1ce0\u4e54\uca0d\ue14a\u22ca\u2424\u04a1\u4b4e\ubae0\u2531\u912e\u971b\uc65d\ucf00\u5d90\uc549\ub09d\ub73f\u0b60\ub28a\u5c12\u09a5\u7076\u27c8\u45a7\u70d0\u29aa\u6d69".toCharArray();
        cArray2[11] = (char)(cArray2[11] ^ 0x7B9E);
        PdfViewerOptionsPanel.Hz("1tbmrqs", locationTitle, srbytebd.Q(cArray2, (short)9576, (short)4, (byte)2));
        char[] cArray3 = "\ucc43\u6f57\u086e\u4209\u0f25\ub01a\u15fd\ua97c\u7764\uf867\u58ca\ufbcc\u3a79\ua3e9\u2d61\u48ab\uc26f\u4cec\uba1b\u4641\u6788n\u582d\u89d2\u7344\uf383\u52aa\ue4e8\u1bec\u4dba\uc59e\u9d4a\ucf6f\u3a56\u95f7\ue7c8\u4f73\ud6b1\u8409\u86e0\uaa9f\uc9f2\u8ce3\uc7e1\u5b64\u8754\uae9f\u7229\u599e\u7024\uf3c6\ue9ea\u8f9e\u3794\u736d\ud98d\u912b\u064a\u866e\u7c5e\u8f69\uf66a\u56ec\u6b92\u14d7".toCharArray();
        cArray3[17] = (char)(cArray3[17] ^ 0x21D5);
        DivContainer locationDivisor = new DivContainer(srbytebd.Q(cArray3, (short)27755, (short)2, (byte)0), parent, this.view);
        char[] cArray4 = "\uf78b\udcd2\u7185\uec43\u43a7\u6adf\uf676\u453e\u0395\ue2c8\ua3f5\u1e62\u958c\u1216\u1d27\ueef3\u6f93\u7311\u6f1c\uf9fd\u5825\u8f77\u171a\uafee\u76aa\u7745\u9d3a\ube4b\ua378\uda95\u43ab\uc120\u9946\u0e18\uc050\u9d9f\u0227\u71eb\u3c7e\u2cfb\u6916\ubb1a\u3166\u0222\u7342\uf5fc\ua666\u1ce2\ub937\u6461\uc088\ue1d3\ub35e\u91fd\ub45f\ud9d7\u2888".toCharArray();
        cArray4[52] = (char)(cArray4[52] ^ 0x7B0);
        PdfViewerOptionsPanel.Hz("1958rld", locationDivisor, srbytebd.Q(cArray4, (short)17483, (short)4, (byte)0));
        char[] cArray5 = "\u504a\u4bc5\u3a1f\ub31f\ue4b2\uf272\ua38d\u42d7\u65e8\u72fd\u74c0\uc2a3\u470b\u2e5a\u7e32\u4b9d\u7b19\u8273\uc7ff\u5498\u170e\ud992\u1123\u07bd\ua392\ua1bd\uf19f\u0cef\u1a96\uda0d\u76c1\u36a8\u09ae\u5b9c\u8cf8\u3be2\ueb6d\u6721\u05d8\uf02d\uab94\udb7e\u5cef\u804e\uea2c\u6f41\u8b51\u539b\ubfd8V\u758d\uc2ea\u3677\u53c2\u0c7b\uc33f\u7b97\ub807\ua25a\u98f9\u5e06".toCharArray();
        cArray5[50] = (char)(cArray5[50] ^ 0x2BF6);
        char[] cArray6 = "\uc811\u9c41\ub11b\u8d8d\u2d7f\u33d8\ue886\uc81c\u5f26\u86b7\ua603\ue60b\u3002\ue9b8\u1a60\uc5a7\u5256\u4074\u1703\ub889\u71b7\u562c\u626f\uf604\ud176\u626a\u9dc8\uc3d4\u2355\u7eb6\udfca\u7ec0".toCharArray();
        cArray6[16] = (char)(cArray6[16] ^ 0x26DB);
        char[] cArray7 = "\u1b71\ub42e\ua8fa\u613d\ud9d8\u7eba\u8ffb\uad81\u6575\u5e24\ub3f3\ub119\u9986\ub88b\ub6aa\u55a3".toCharArray();
        cArray7[3] = (char)(cArray7[3] ^ 0x1801);
        this.locationYesRB = new CGRadioButton(srbytebd.Q(cArray5, (short)171, (short)4, (byte)4), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray6, (short)8743, (short)2, (byte)3), (Object[])new Object[0]), srbytebd.Q(cArray7, (short)20891, (short)1, (byte)5));
        char[] cArray8 = "\u094e\uf01e\u0ee0\u63e9\u66c0\ud35f\ua111\u3ead\uec45\u5776\u0c9e\u14e4\u390c\u3cff\ud2db\ud333\u0ad6\u6997\u6ccd\u0541\ua2f3\u9ee3\u8f07\uc865\u2770\u0fc4\u79de\u7bc4\ue8d7\ubac9\uf509\ua32c\u2ca6\u4614\u274b\u19c7\ub033\u2784\u84db\u96fc\u59d7\u4ea8\ue7d8\u3979\u57f3\udb83\u71ae\ub255\ueffd\uc481\u533d\ud9f5\uda97\u3a5f\u8932\u9209\u1137\u417b\u7736\u4703".toCharArray();
        cArray8[20] = (char)(cArray8[20] ^ 0x68B5);
        char[] cArray9 = "\u8033\u4bf0\ud8bf\u4246\uc7e5\u0b25\ua550\ub88d\u4b05\ud591\u7585\uac51\ue877\ub1be\ufb73\u8fb1\ud0bd\u05d9\u63e8\u71d1\u6bc1\u3111\uaed7\u9bbb\ue3d5\uef2c\u3567\u4e61\ufb8d\ubeea\u74c6".toCharArray();
        cArray9[11] = (char)(cArray9[11] ^ 0x4D3F);
        char[] cArray10 = "\ue74a\u6ec5\u592c\u3e69\u24b2\u65ea\uf3f2\uaa99\u1f64\uab66\u5287\u97aa\u633c\u7097\u2b66\u1ca8".toCharArray();
        cArray10[7] = (char)(cArray10[7] ^ 0x669C);
        this.locationNoRB = new CGRadioButton(srbytebd.Q(cArray8, (short)14363, (short)0, (byte)4), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray9, (short)13635, (short)2, (byte)1), (Object[])new Object[0]), srbytebd.Q(cArray10, (short)26418, (short)0, (byte)4));
        char[] cArray11 = "\u11f5\u7eec\uaf84\u6b9d\u2ddf\u8341\u7128\u4648\u4096\u6b03\uffbc\u6db0\ub548\u8bd4\uad63\uf383\u6e12\u912c\u9289\udd1b\u83e9\uaf76\u7eff\ued00\u848d\u9b1d\uc0ad\u4002\uae39\u22f2\u5c2c\u96d7\u2674\ub731\uf0d8\u6588\u1079\u4420\u9010\ud58d\ua95b\ud39f\uf4e3\u6888\ubeb2\u0fcd\u0adf\ubf64\u62f9\ubbf0\uacfc\ud987\u893e\u65dd\u463d\ua971\u4fbf\u5bd5\u3738\u4ee0\u3a11".toCharArray();
        cArray11[15] = (char)(cArray11[15] ^ 0x3E6D);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.locationYesRB, srbytebd.Q(cArray11, (short)15034, (short)5, (byte)3));
        char[] cArray12 = "\u5d11\u4a3c\u3b58\u2385\ueef8\u54ea\u2305\u27f0\u6a20\ua102\u525e\uc6ee\u10ab\ue58d\uba1b\u07c8\u80cb\u3fd6\u6722\u1763\u2668\u8114\uad3c\u07a4\u5214\udba2\ubca7^\u98f8\u34da\u1af1\u4dbf\u3504\uc517\uc663\udecf\u4750\uef00\ub308\u749d\u33e8\u2a56\ufd1b\u5997\ue371\u4517\u3049\u9b20\u3ef7\uddb1\u82eb\u2315\u6c38\ud01c\ua45e\u6d6a\u4923\u4520\uc493\ube44\u2bdf".toCharArray();
        cArray12[0] = (char)(cArray12[0] ^ 0x1066);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.locationNoRB, srbytebd.Q(cArray12, (short)9757, (short)3, (byte)4));
        char[] cArray13 = "\udc89\ucd0f\u5541\u4748\ubd1b\u7649\u404d\u09c7\ud145\ubbf0\ub267\u5abc\ua7f3\u1223\ud272\u31ac\uede4\ud7d6\u7051\ub8ca\ua2d3\u951b\u83a6\u1bb6\uc0b2\uc577\u8dbc\u441c\ua9ae\ue247\u805d\ue452\u2327\u841e\ucc53\u6494\uc354\u5dad\u634a\u1501\u3233\u80de\u0287\ubb69\ub2ea\ud0a9\uc31b\u26f5\ub0c9\u0488\ud19b\u5568\u5dc5\u7303\ufcd5\ua964\ua756\u1f21\u3419\ucb76\u3abe\udb5f\u947a\u53c0\u4c7e".toCharArray();
        cArray13[62] = (char)(cArray13[62] ^ 0x4F5C);
        this.locationTextBox = new TextInput(srbytebd.Q(cArray13, (short)16290, (short)4, (byte)4), parent, this.view);
        char[] cArray14 = "\ud531\uf689\u504f\u3de3\u374c\u1eb9\u1808\u90f8\u536c\u00af\uf456\u4464\u581b\ua7a4\ua541\u36ae".toCharArray();
        cArray14[11] = (char)(cArray14[11] ^ 0x7AA6);
        PdfViewerOptionsPanel.Hz("-1fj942t", this.locationTextBox, srbytebd.Q(cArray14, (short)1153, (short)5, (byte)0));
        char[] cArray15 = "\u6f76\u2efa\ucf1a\uf102\uc480\uf0e9\ufda9\uaf60\ufe43\uba90\ud0e4\ucdd5\u7db9".toCharArray();
        cArray15[10] = (char)(cArray15[10] ^ 0x5335);
        PdfViewerOptionsPanel.Hz("-1fj942t", this.locationTextBox, srbytebd.Q(cArray15, (short)23218, (short)0, (byte)2));
        PdfViewerOptionsPanel.Hz("-1bo942u", this.locationTextBox, obj -> this.updateAllLocations());
        PdfViewerOptionsPanel.Hz("-ukj40a", this.locationYesRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.locationYesRB) != false) {
                PdfViewerOptionsPanel.Hz("-1okb42v", this.locationTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Hz("-ukj40a", this.locationNoRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.locationNoRB) != false) {
                PdfViewerOptionsPanel.Hz("-1okb42v", this.locationTextBox, false);
                PdfViewerOptionsPanel.Hz("-lh5430", this.locationTextBox, "");
                PdfViewerOptionsPanel.Hz("1d0mrsv", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\u1576\u4817\u0fc5\u9066\u4f2f\u0a28".toCharArray();
        cArray16[0] = (char)(cArray16[0] ^ 0x116);
        char[] cArray17 = "\u170e\u1452\u3b55\u87e7\u4d51".toCharArray();
        cArray17[1] = (char)(cArray17[1] ^ 0x5D95);
        if (PdfViewerOptionsPanel.Hz("-rv340b", srbytebd.Q(cArray16, (short)27138, (short)3, (byte)2), PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_LOCALITA, (Object)srbytebd.Q(cArray17, (short)4335, (short)3, (byte)3))) == false) {
            PdfViewerOptionsPanel.Hz("n34rvk", this.locationYesRB, false);
            PdfViewerOptionsPanel.Hz("-1okb42v", this.locationTextBox, true);
        } else {
            PdfViewerOptionsPanel.Hz("n34rvk", this.locationNoRB, false);
            PdfViewerOptionsPanel.Hz("-1okb42v", this.locationTextBox, false);
            PdfViewerOptionsPanel.Hz("-lh5430", this.locationTextBox, "");
            PdfViewerOptionsPanel.Hz("1d0mrsv", this.appearanceBuilder, "");
        }
    }

    private void updateAllLocations() {
        Object location = PdfViewerOptionsPanel.Hz("kiirsu", this.locationTextBox);
        PdfViewerOptionsPanel.Hz("1d0mrsv", this.appearanceBuilder, location);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Hz("-lcv41n", PdfViewerOptionsPanel.Hz("10erua", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Hz("-tbf433", app, location);
            }
        }
    }

    private void drawReasonArea(DOMElement parent) {
        char[] cArray = "\u42ab\u2ba4\u2072\ub761\u8fee\udd44\u02fb\u32dc\u59fa\u4b39\u7a58\u7e6a\u800a\u4d5d\udf2a\u473b\u05fe\udca9\ud839\ua087\u6170\u8dd6\uf494\ua0ea\u1d1b\u7c9f\uade9\u60df\uae4a\uac62\u259f\u632f\ub238\u5349\u9a44\ued34\u2d19\uc764\u3e2b\udf2d\u739c\u81b3\u9a95\u409b\u512c\uec29\ua429\u6b26\u68c9\u71d5\u17fe\u7ec6\u83c6\u47b3\u1c31\ue60c\uf2af\ub1d8\ude88\u8556\u0252".toCharArray();
        cArray[16] = (char)(cArray[16] ^ 0x5E54);
        Paragraph reasonTitle = new Paragraph(ggspsofe.R(cArray, (short)30232, 1, true), parent, this.view, () -> {
            char[] cArray = "\u95a9\uddd4\ud09a\u299d\u4526\ue181\u155f\ubf76\u4aa8\u14c4\uabe2\uc190\u99fb\u9488\u13b0\u8bd9\u428b\uf2c1\u6cfc\u2c43\uaccc\u9dc3\u3a16\uf41cy\u013c\ueaf6\uf072\u03dc\ua78b\u996c\u4e3f\u45f3\uccce\u678e".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x1970);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray, (short)7436, 5, false), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u3f9e\ub73d\u85a5\ua310\u2eba\uf99a\ue9a0\u1483\ub29e\u3b67\u1adb\u0c07\u891c\u9940\uab4d\u0d14\uee3b\u6f36\u6301\u487d\uc94e\u6ca4\u7b91\u5579\u5fc0\u2d56\ua723\u15e5\u3e7f\ude05\u93eb\ua9ff\u6908\uf3ec\u4c96\u1288\ue3dd\u38d4\uc828\ud49e\u18d5\uf00b\ubb59\ud1f9\ub738\uffe0\ub662\ubf9c\u9207\u5aed\uf380\ue05f\u1c05\u8f3d\u4859".toCharArray();
        cArray2[38] = (char)(cArray2[38] ^ 0x3423);
        PdfViewerOptionsPanel.Hz("1tbmrqs", reasonTitle, ggspsofe.R(cArray2, (short)10486, 0, false));
        char[] cArray3 = "\udd53\u164c\u0232\ue221\u9f67\uebf1\u8da3\ucdad\uf268\ua25c\uca2e\uf53f\uaf23\u6b32\udef5\u608b\u9eb5\u1e7f\uc204\u5007\u19bb\u587c\u6eaf\ue4ac\ubf61\u8823\u69cc\ub9f2\u9c95\uf75e\u0c12\uc1a1\u547c\u18cb\u8917\ue8b0\ua721\ub829\u9a85\u7877\u1e23\u6a45\uf72b\ucd6b\u66d7\u8e1f\ub235\u17db\ud117\ueb89\u1e68\u338b\u2d97\u55be\u86d7\ubc4d\ueaf1\u70cd\ubce1\ue04b\uc5d0\ua0f5\u52c6".toCharArray();
        cArray3[56] = (char)(cArray3[56] ^ 0x3E1A);
        DivContainer reasonDivisor = new DivContainer(ggspsofe.R(cArray3, (short)31689, 5, true), parent, this.view);
        char[] cArray4 = "\ud0a8\u9c42\u799e\u6e9f\u9c9b\uaea7\uc4ac\uf685\u6873\uad65\u4247\ub387\ubd90\u92a8\ue814\ube5c\ubb78\uccd3\u1ec0\ue5be\u69d0\u6407\ucb7d\u1376\u8a33\uae8f\u333f\u5c6c\u578b\u5aa3\u6072\u67ba\u8ab9\u00b9\u6fd6\ua12a\u93ac\udc4b\u407b\u41a8\u6408\u47cc\u1e14\u05a3\u130b\u111e\u116f\u542a\u3d6b\ud089\ub096\u85d2\uae0b\u365a\uff3a\u618b\u0db7".toCharArray();
        cArray4[42] = (char)(cArray4[42] ^ 0x47AF);
        PdfViewerOptionsPanel.Hz("1958rld", reasonDivisor, ggspsofe.R(cArray4, (short)5244, 2, false));
        char[] cArray5 = "\u87c7\u994c\uce00\ueee0\u3d93\u99b4\ud8d1\u1455\u2782\u2d02\u7db0\ub168\ub486\u2bac\u7e1c\uc37c\u91bf\u774c\u325b\ua4f9\ud9ca\ub8f4\uef6e\u16b2\u6027\u7633\uf097\u5ad1\ucd94\uc7a8\u0a89\ua171\u2511\u85e5\u7fe7\u64cb\u1386\u6e82\u4c8f\u2336\u2eaa\uec6c\u4a6d\u7419\ub1c3\ub46e\u2404\uc76c\ub1c0\u9317\uf030\uc6ec\u76a4\u337a\uc1ec\u2215\ueaa8\u3ca1\u5fef".toCharArray();
        cArray5[43] = (char)(cArray5[43] ^ 0x20A4);
        char[] cArray6 = "\u3585\uecce\u7dea\u1eb0\ubc5b\u5700\u8679\u77f3\u7ae7\u6019\ud5b8\uee83\ubf31\ue13b\u68f0\ueaa5\u0b6b\u2de6\u2b9f\u8589\ue7e5\u4675\u3213\u4bf6\u774b\u1993\u58db\u544b\u83c4\u6053\uc64d\u02e8".toCharArray();
        cArray6[26] = (char)(cArray6[26] ^ 0x412D);
        char[] cArray7 = "\u917a\u238a\u809c\u622a\ubcf4\u1791\ucb5a\u1401\u281d\u9eb3\ud8b8\ufe88\u3891\u5714".toCharArray();
        cArray7[8] = (char)(cArray7[8] ^ 0x4403);
        this.reasonYesRB = new CGRadioButton(ggspsofe.R(cArray5, (short)28167, 2, true), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray6, (short)13140, 5, false), (Object[])new Object[0]), ggspsofe.R(cArray7, (short)25525, 4, false));
        char[] cArray8 = "\ub6d7\ue2f5\u2bc8\uab22\uc97f\udb72\ud624\u727e\uf9aa\u27ed\u97d6\u46f7\u5eb5\u30a1\ucc54\u9ecb\u077f\u26b0\u6ce2\u5d6b\u12d3\uae81\u7e5e\ub76e\ub957\u4f92\ubca4\u3163\u6fa2\uc356\u1bc7\ud8ec\u5907\u8f52\ua450\u39d6\u0526\u6b96\u7604\u4bd8\ua9a5\u79e5L\uc1cb\uf3fb\ud6c7\u012c\u45b9\u339d\u74ad\u62da\u5d31\u34e0\u9ad6\u9800\u4cc3\u7121\u2d84\u6812".toCharArray();
        cArray8[40] = (char)(cArray8[40] ^ 0x1D4A);
        char[] cArray9 = "\u993d\ucce2\u2562\ueef2\u3d42\u2b5b\u4550\u29fe\u68c9\u381f\u02f2\u7a0d\uaeca\uf457\u50f9\uef1b\uf408\ue0c2\u61ea\u6831\u6367\uc8cf\u38ea\uf3dd\u01c2\u520c\u7c9d\ud099\ue5cf\u1d74\u76b4".toCharArray();
        cArray9[25] = (char)(cArray9[25] ^ 0x411E);
        char[] cArray10 = "\ue3ab\u946a\ue2a9\u0fc6\u5f2b\u9f90\u349f\u8097\ub180\udd97\u6766\udf50\u7663\u23e9".toCharArray();
        cArray10[8] = (char)(cArray10[8] ^ 0x68B5);
        this.reasonNoRB = new CGRadioButton(ggspsofe.R(cArray8, (short)10264, 1, true), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray9, (short)23692, 2, false), (Object[])new Object[0]), ggspsofe.R(cArray10, (short)6605, 0, false));
        char[] cArray11 = "\u8e9f\u8b28\uec2e\u304d\u752d\u9a96\u8584\u762a\u49c7\u771f\uae06\udf4a\u4292\ua6e7\ubcf2\uecce\ub5d2\u655d\uf1d4\u863d\u5c8a\uf8ac\u8517\ue615\u4fc8\ucf53\u27ec\ue1a6\ue631\uab52\u8a0b\uba0c\ud364\u575f\u0b0a\u1213\ub004\uc384\u9f8a\ua54a\uc901\u72f5\u1a75\ucd0b\uf454\ud825\u2002\ue914\u2c1a\uf91d\u3512\u67d7\uf909\u2e4d\udce4\uddcf\u17df\u2149\u168b\uec02\u1a3d".toCharArray();
        cArray11[15] = (char)(cArray11[15] ^ 0x5286);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.reasonYesRB, ggspsofe.R(cArray11, (short)24596, 1, true));
        char[] cArray12 = "\u79e4\u8016\u5689\ubf26\ude23\u66b1\u6491\u5a0b\ue7bc\u16f5\ufbee\uc86b\u7002\u4023\u7c63\u4b85\u310a\u9a76\uaa4c\u3479\u94fd\u83e2\u2a2d\u8f5a\u9a60\u5575\uf262\ue4c2\ufe59\uaf21\uee22\u898c\u0481\u95ac\u256c\uadad\uaaf6\u6725\u6334\u05fc\ue563\uafae\u4a16\ud09e\uec65\ua956\udaf9\u49d8\u30bd\uee92\u122b\u1d9b\u1e50\u2e17\u9b62\u2860\u6c29\ua1ad\u0347\u8999\u63e8".toCharArray();
        cArray12[22] = (char)(cArray12[22] ^ 0x22D0);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.reasonNoRB, ggspsofe.R(cArray12, (short)20374, 1, false));
        char[] cArray13 = "\u126d\ub8dc\u495d\u20b0\udf7c\ub846\u2e0f\u1805\udc29\u8329\u74f5\ub53c\uf924\u1c33\ucd1b\ub62f\u1449\u67a1\u34f7\ucfda\u986a\ufeac\u5261\u1ba7\u4839\u84f8\u829d\u4d08\ue451\u19c7\ue1ec\u79b0\ub321\u57af\u4da9\uf739\ude93\u5b42\u5839\ua1ae\ud4af\u355c\ud402\u9f99\ub504\ud084\u97e7\ufcaa\uf7f4\u1d00\u0f4b\u9f61\u68e4\u347b\u4ccf\u99ed\ufbac\u81fe\u3824\u24c2\uba51\u3e89\u7ba5".toCharArray();
        cArray13[15] = (char)(cArray13[15] ^ 0x791B);
        this.reasonTextBox = new TextInput(ggspsofe.R(cArray13, (short)8884, 2, false), parent, this.view);
        char[] cArray14 = "\u806e\u2005\u09a6\u2c34\ub69b\u09f9\u7bcb\ufca9\u5f1f\u520d\u6cb9\ue821\u2380\ucd10\u5e4e\u7449".toCharArray();
        cArray14[2] = (char)(cArray14[2] ^ 0x300E);
        PdfViewerOptionsPanel.Hz("-1fj942t", this.reasonTextBox, ggspsofe.R(cArray14, (short)10593, 1, false));
        char[] cArray15 = "\u5b7c\u9d5c\u3434\ue559\u8420\ufc05\u8bc9\u2eb4\ua8a0\u9999\u0ca0\u6ff8\u0b5e".toCharArray();
        cArray15[5] = (char)(cArray15[5] ^ 0x1940);
        PdfViewerOptionsPanel.Hz("-1fj942t", this.reasonTextBox, ggspsofe.R(cArray15, (short)5223, 0, false));
        PdfViewerOptionsPanel.Hz("-1bo942u", this.reasonTextBox, obj -> this.updateAllReasons());
        PdfViewerOptionsPanel.Hz("-ukj40a", this.reasonYesRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.reasonYesRB) != false) {
                PdfViewerOptionsPanel.Hz("-1okb42v", this.reasonTextBox, true);
            }
        });
        PdfViewerOptionsPanel.Hz("-ukj40a", this.reasonNoRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.reasonNoRB) != false) {
                PdfViewerOptionsPanel.Hz("-1okb42v", this.reasonTextBox, false);
                PdfViewerOptionsPanel.Hz("-lh5430", this.reasonTextBox, "");
                PdfViewerOptionsPanel.Hz("-d25434", this.appearanceBuilder, "");
            }
        });
        char[] cArray16 = "\uf072\u7f13\ua4fe\u6943\ub6c3\u24fd".toCharArray();
        cArray16[4] = (char)(cArray16[4] ^ 0x1836);
        char[] cArray17 = "\u9e38\ue842\u767d\ub282\u0f01".toCharArray();
        cArray17[0] = (char)(cArray17[0] ^ 0x2F24);
        if (PdfViewerOptionsPanel.Hz("-rv340b", ggspsofe.R(cArray16, (short)10076, 1, true), PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_MOTIVO, (Object)ggspsofe.R(cArray17, (short)5280, 2, false))) == false) {
            PdfViewerOptionsPanel.Hz("n34rvk", this.reasonYesRB, false);
            PdfViewerOptionsPanel.Hz("-1okb42v", this.reasonTextBox, true);
        } else {
            PdfViewerOptionsPanel.Hz("n34rvk", this.reasonNoRB, false);
            PdfViewerOptionsPanel.Hz("-1okb42v", this.reasonTextBox, false);
            PdfViewerOptionsPanel.Hz("-lh5430", this.reasonTextBox, "");
            PdfViewerOptionsPanel.Hz("-d25434", this.appearanceBuilder, "");
        }
    }

    private void updateAllReasons() {
        Object reason = PdfViewerOptionsPanel.Hz("kiirsu", this.reasonTextBox);
        PdfViewerOptionsPanel.Hz("-d25434", this.appearanceBuilder, reason);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Hz("-lcv41n", PdfViewerOptionsPanel.Hz("10erua", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Hz("-1vm9425", app, reason);
            }
        }
    }

    private void drawPreservePdfAArea(DOMElement parent) {
        char[] cArray = "\ubff6\u100c\uc9d0\u82c3\u7ddf\u2b25\udae3\u9be2\uf160\u3db9\u7560\u78ee\u6bf8\ufcf7\u22e9\u85dd\u6c09\u4050\uc8a1\u64e2\uc305\u7c04\u7be0\ue6a6\ud195\u6382\ua0d0\uacf4\u0edc\u398c\u4975\u4d98\u1790\u9311\u04bf\uea89\ud787\uc0e2\u8895\u0307\u90d3\u765b\ud48b\u2e04\u9e0d\u42a1\uca21\u0c9d\u33f3\uab94\u5c12\u8148\uf7b7\ue287\uc8ac\ua101\ua5c1\u17a7\udecd\ud429\ub153\ufedf\ub2ac\u0a02\ucce7\u9c07\u6d6f".toCharArray();
        cArray[18] = (char)(cArray[18] ^ 0x398A);
        Paragraph preservePDFATitle = new Paragraph(ggspsofe.R(cArray, (short)29064, 2, false), parent, this.view, () -> {
            char[] cArray = "\u68b1\u71ed\u57cf\ub6e2\u01ce\u0b16\ud97f\ufa56\u9b21\uea64\u5f9e\u0135\u25ef\u7e47\ue3ee\ufc56\ue019\ucc84\ud01b\u992d\uac3c\uc2e5\u419b\u61e4\u5ab4\u9ddb\uf585\u6b4d\u6d51\u70d6\u5bf8\u1f98\u6b44\udc87\u1c92\u713b\ua0c9\u47a9\ue7a2\u93c3\u6dfd\u3aff".toCharArray();
            cArray[31] = (char)(cArray[31] ^ 0x6155);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, srbytebd.Q(cArray, (short)5535, (short)1, (byte)1), (Object[])new Object[0]);
        });
        char[] cArray2 = "\u561b\u81d7\ud1c3\u4781\ue2c8\u3dd9\u804d\u515f\ua756\u3fc8\u9b6f\ud9ba\uc6cd\uc0ce\u2c33\u9af2\ub3de\uf5d4\u815f\u2702\udc5e\u1fc7\ufc65\u45e4\u0d58\u5be2\ue0f2\u4b13\u5d02\u87f5\uce4d\u8edf\u089e\u834b\ucd7f\u9a9d\u6b4b\u5442\u787e\u9dcd\ub893\u9a00\u07c0\uab17\u82d6\ud02d\uadd9\u0bd5\u85bc\ufbd0\u9e5d\ub761\u2129\u208c\u0809".toCharArray();
        cArray2[50] = (char)(cArray2[50] ^ 0x1062);
        PdfViewerOptionsPanel.Hz("1tbmrqs", preservePDFATitle, ggspsofe.R(cArray2, (short)24234, 2, false));
        char[] cArray3 = "\u9903\u0d57\u9efc\u47bd\u7e2b\uacfa\ubbe1\u44fa\udd84\u561d\u9747\u2e4c\uf094\uee4b\u9ced\ub2fb\u7016\u874b\u59d1\u73d0\u6e28\u501c\ubd80\u6073\u0866\ue1f2\ud0fe\uc824\u1549\u0c39\u3599\uaaf8\u1e73\u4dee\u3733\u8f8d\u4386\ue668\uae4a\u6142\u90c0\ufb05\ud6f2\ubdbc\ud8e7\u3f05\ufa96\u03c4\ucf63\u5267\u3d54\ua25b\u7f92\ucd5a\u23c0\ud380\u9666\ubd40\u98c8\u5f35\ud27c\u8071\ud65a\u74ee\u7511\u81e3\uf08d\u625d\u08bf".toCharArray();
        cArray3[8] = (char)(cArray3[8] ^ 0x5572);
        DivContainer preservePDFADivisor = new DivContainer(ggspsofe.R(cArray3, (short)866, 4, false), parent, this.view);
        char[] cArray4 = "\ua6cf\u3c4a\ue5c5\u970d\ubd66\u2a7c\u5275\ue899\u7263\uac5c\u343d\u5a07\u754b\ucc8c\u926c\u4233\ue14d\u8659\u1cb0\uc131\u4339\u6ffb\ua767\ub656\u7a6c\u0b37\uc55b\uac16\ud41d\ucdf0\ub594\u348e\u0dde\u0d1f\ufd31\uaf80\u1010\u5b40\u44d2\uf32d\ub9b9\ud25a\ua28f\ub919\u091b\u612d\ufb8a\u29e6\ue7a6\u25b0\u8ee2\u7062\ubb32\ufd48\u246e\ua8b4\u1b6c".toCharArray();
        cArray4[39] = (char)(cArray4[39] ^ 0xE4A);
        PdfViewerOptionsPanel.Hz("1958rld", preservePDFADivisor, ggspsofe.R(cArray4, (short)29623, 2, false));
        char[] cArray5 = "\udaa1\u8123\u364d\u8ed3\u2730\u7aac\udd5f\u8b47\u85ac\u19cc\u69f9\u3805\u4e40\uc1b8\ufc33\uaf98\u6098\u6e5c\ub949\uc2ae\u46d8\uf90b\uae1e\u982d\u4edc\u1afe\u9139\u39bb\uc6cd\ue84d\u0f6c\u4d08\u3ef9\u5e99\ub6cf\u5404\u4e31\u70c4\u0872\u5d3f\u9592\u6ae4\uc301\ub197\u8f10\ud51f\u13be\u541d\ufc30\u0595\ub482\u59fb\u46a7\u5a4b\u79df\uc4c6\ue156\u2502\u7c10\u85ac\u58f8\u40f0\u61ea\uedbe\u621c".toCharArray();
        cArray5[32] = (char)(cArray5[32] ^ 0x40B8);
        char[] cArray6 = "\u37bb\u5af6\uef7e\uae5d\u9287\uc356\ubd1c\u6b28\udbb0\u19a1\u068a\u4a9c\uf0f0\ub11e\u052c\uf230\uc45a\u9c69\ud7ef\ueec9\ua8ea\u5b71\ufeb2\uc869\u9a3b\ua1b1\ue372\uc137\uba22\ud6bd\uf1f7\u7a7b".toCharArray();
        cArray6[25] = (char)(cArray6[25] ^ 0x6B9E);
        char[] cArray7 = "\u7c87\u720f\uee68\uc54e\u66a1\udff1\u2087\u1a28\ua47f\ufbc2\uc3a7\u6822\u6cee\u4e27\ub3ec\uef71\ua3cc\u98f8\u7aa9\u6109".toCharArray();
        cArray7[0] = (char)(cArray7[0] ^ 0x37A4);
        this.preservePDFAYesRB = new CGRadioButton(ggspsofe.R(cArray5, (short)18035, 3, true), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray6, (short)9090, 5, false), (Object[])new Object[0]), ggspsofe.R(cArray7, (short)22163, 4, true));
        char[] cArray8 = "\u5786\u98d1\u512a\u414d\u8dec\u9141\u98e1\u9e0b\u028f\u0237\u06ab\u435a\u5d62\u5a06\u32a7\u22f7\u3bb9\u8538\u4c51\u2753\u8849\uf701\u45e3\u595e\u6c86\u75d2\u7f9d\ucf56\u1eb7\ua536\uebb6\uc932\u8f14\u7416\u50a2\u5aff\u34ae\ucfa1\uaab0\ud3aa\ubdfe\uab9b\u9db9\u3f86\u019f\u94f8\ucacd\uba2e\ue398\u483e\u352e\uf3bb\u5a22\u4fba\u2c27\ub1c7\u1f26\u5b17\u6ea9\ub410\ue86c\u1348\ufd41\u0c71".toCharArray();
        cArray8[21] = (char)(cArray8[21] ^ 0x3B92);
        char[] cArray9 = "\u013b\u2e9d\u38c1\u5e55\u0d2a\u68d5\uadbe\uea7b\u45e9\u2df7\u81cb\ud1d6\ub758\uaed3\u74f87\uc38e\u7615\u2e5b\u5ee9\u648d\u5093\u8931\ucb76\ue69b\ufc10\u33df\u232c\u33a4\u0c9a\u200e".toCharArray();
        cArray9[0] = (char)(cArray9[0] ^ 0x1B8E);
        char[] cArray10 = "\u742c\u102c\u718a\u6408\u6c3a\u175f\u8c18\u15f5\u0d7d\uef65\u4ab6\u83c4\u16f2\u7895\u7503\ucda0\u7022\u89b3\udcb5\u59ff".toCharArray();
        cArray10[18] = (char)(cArray10[18] ^ 0x1E2B);
        this.preservePDFANoRB = new CGRadioButton(ggspsofe.R(cArray8, (short)27161, 0, true), parent, this.view, (String)PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray9, (short)12873, 1, false), (Object[])new Object[0]), ggspsofe.R(cArray10, (short)8824, 4, false));
        char[] cArray11 = "\ubc51\u5265\u1049\u59e6\ub124\u8dbb\u5817\u2bb2\ubca4\u6662\u977a\u5318\u73f0\ubbe4\u581d\u71f6\ud9db\u3988\uf832\u9689\uc04b\uf1ff\ubac9\uc962\u6c09\ub2ac\u8eab\ue2a5\u87fb\ud307\uceaa\u1607\u39b5\u0745\ua5be\ua394\u3489\uc510\u1ede\u18c5\ue87a\u843f\u8053\udb1f\u9d14\u76fc\u2a42\u2a0b\u7d4e\u9ff4\u7827\uf795\u0df4\u81c7\u195f\ua5a2\u13d0\u8e4f\ue42a\uabc6\u38da".toCharArray();
        cArray11[1] = (char)(cArray11[1] ^ 0xD79);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.preservePDFAYesRB, ggspsofe.R(cArray11, (short)20000, 4, false));
        char[] cArray12 = "\u7d7c\u1498\u69ca\ub451\u07c2\u8f24\u46ed\u723f\u7826\u8a02\ubb70\ud98f\uecd8\u4029\u7e25\u0b76\u5dc1\u3f05\uc43e\u7306\u5025\u3e45\ua7fe\u4eac\uc9b8\udd83\u6f6a\udac5\u1645\ua090\uab6e\u3576\u4b6a\u58ad\uc444\u2588\u7ef5\uc4ca\ude9f\u0898\u6d59\ue291\u3212\u19fd\u0f7a\u7723\u0f3c\ub58a\ud78c\u5cf9\u2b7d\uf0c9\u9bdf\u9dee\u2547\ua355\u9aa3\u4414\uade9\u0686\u19aa".toCharArray();
        cArray12[55] = (char)(cArray12[55] ^ 0x4DDF);
        PdfViewerOptionsPanel.Hz("4a0ruq", this.preservePDFANoRB, ggspsofe.R(cArray12, (short)18838, 3, true));
        PdfViewerOptionsPanel.Hz("-ukj40a", this.preservePDFAYesRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.preservePDFAYesRB) != false) {
                this.updateAllPreservePdfA(true);
            }
        });
        PdfViewerOptionsPanel.Hz("-ukj40a", this.preservePDFANoRB, () -> {
            if (PdfViewerOptionsPanel.Hz("-ddb41c", this.preservePDFANoRB) != false) {
                this.updateAllPreservePdfA(false);
            }
        });
        char[] cArray13 = "\u3a95\uef69\ua4f7\ub3bc\u36f9".toCharArray();
        cArray13[2] = (char)(cArray13[2] ^ 0x7AAE);
        char[] cArray14 = "\u2253\u5ad7\ub1f9\u2294\u24d8".toCharArray();
        cArray14[0] = (char)(cArray14[0] ^ 0x62DC);
        if (PdfViewerOptionsPanel.Hz("-rv340b", ggspsofe.R(cArray13, (short)18323, 1, false), PdfViewerOptionsPanel.Hz("1l88rvo", PdfViewerOptionsPanel.Hz("1576rup"), UserProperties.GRAPHICSIGNATURE_PRESERVEPDFA, (Object)ggspsofe.R(cArray14, (short)22054, 0, false))) == false) {
            PdfViewerOptionsPanel.Hz("n34rvk", this.preservePDFANoRB, false);
            PdfViewerOptionsPanel.Hz("q6krtq", this.appearanceBuilder, false);
        } else {
            PdfViewerOptionsPanel.Hz("n34rvk", this.preservePDFAYesRB, false);
            PdfViewerOptionsPanel.Hz("q6krtq", this.appearanceBuilder, true);
        }
    }

    private void updateAllPreservePdfA(boolean preserve) {
        PdfViewerOptionsPanel.Hz("q6krtq", this.appearanceBuilder, preserve);
        for (PdfDocument doc : this.pdfDocuments) {
            Object object = PdfViewerOptionsPanel.Hz("-lcv41n", PdfViewerOptionsPanel.Hz("10erua", doc));
            while (object.hasNext()) {
                CGAppearance app = (CGAppearance)object.next();
                PdfViewerOptionsPanel.Hz("-9e7427", app, preserve);
                PdfViewerOptionsPanel.Hz("-11qj42q", app);
            }
        }
    }

    private void drawVerticalArea(DOMElement optionsContainer, DOMElement optionsArea) {
        char[] cArray = "\u7244\u7cb7\u88b2\u8cd8\uc01c\u27c5\u7803\u8b18\u9af2\u8cf1\uf1f2\u260f\ub976\u1ac5\uef0c\ueb0b\u4861\u0241\udc42\u2704\u8d71\ub43e\u7e08\u8d31\uf0af\u612d\ubfd3\ue266\ua8a9\u907f\ubcba\u933b\u24d2\u1528\u2abd\ua714\u4721\ubdc2\ub2a4\u0ff7\u14f5\u34a2\uab17\ud4c1\ube3d\u0de3\udd11\u3695\u1657\u090c".toCharArray();
        cArray[16] = (char)(cArray[16] ^ 0x5A40);
        DivContainer verticalArea = new DivContainer(nhlbjjuv.g(cArray, (short)22411, (byte)2, (short)4), optionsContainer, this.view);
        char[] cArray2 = "\u38da\u61bc\ud644\ucb27\u4a88\u2c90\u107a\uec3e\u97f0\ufb3a\u5310\u2c6e\uf863\u4d1b\u2676\u37a3\ucf73\ubaf4\ue139\u2c78\ud626\uf617\u501f\u3c82\ub579\u06ce\u20d4\u76ab\uc27a\uab55\uaa28\uefed\u55f0\u8cb2\u163a\u917c\u18c5\u638b\ud020\u1309\u86d4\u1eec\uf8ff\u6711\u24d9\u988b\uaadd\u0131\u0f0d\u14f5".toCharArray();
        cArray2[8] = (char)(cArray2[8] ^ 0x2B57);
        PdfViewerOptionsPanel.Hz("1958rld", verticalArea, nhlbjjuv.g(cArray2, (short)22965, (byte)5, (short)4));
        char[] cArray3 = "\u308c\u34a4\ub00b\ud319\u8f58\u2ba8\u0e6c\ufe97\u99ac\uca56\uf597\u58cf\u7995\u1bbd\u5e6b\u64a2\u22c5\u483b\u9043\ud6d1\u4591\uf91c\u712d\u8836\uef6e\ub29b\u3416\u120e\uc36d\u4ac9\uab4b\u1178\u90ee\ue378\u21ae\u8455\ub290\u0e54\ue8f3\u2647\u6707\u6714\u1e98\u098e\u02fb\u9521\ue7c2\u560e\ufc21\u65fc".toCharArray();
        cArray3[32] = (char)(cArray3[32] ^ 0x1CD4);
        Paragraph optionsLabel = new Paragraph(nhlbjjuv.g(cArray3, (short)15921, (byte)0, (short)1), (DOMElement)verticalArea, this.view, () -> {
            char[] cArray = "\ub3d8\ua907\u71c6\uc40c\u4329\u0f64\uf2a5\u06f2\u45ec\u42e6\u3d02\ue66f\u597c\ue550a\u7ecd\u2d13\u0fa1\u2386\ub5e4\u4854\u9de1\u61c3\u3e21\ubce5\u31d6\u4512".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0xA85);
            return PdfViewerOptionsPanel.Hz("1joirsb", i18n, ggspsofe.R(cArray, (short)4901, 1, true), (Object[])new Object[0]);
        });
        char[] cArray4 = "\u7230\ue8e3\u4980\uf09c\u4a2e\u23f1\u2f93\u80be\u0e8d\u0c68\u0830\uf697\u54e6\u9af9\u1122\u7a34\uad05\u98c5\u2ab5\uf3ee\uef8c\ua78c\u34b8\ub90f\ud3af\u329fd\ucae5\udda6\u396c\ud3eb\udd19\ub2f0\uc9b7\u6508\ueb18\u1be2\udb38\u94e1\u50ef\uf57b\u8b77\u780c\u2f4f\ud650\u7a23\udb00\u22bc\u4b16\u55ab".toCharArray();
        cArray4[45] = (char)(cArray4[45] ^ 0x11DE);
        PdfViewerOptionsPanel.Hz("1tbmrqs", optionsLabel, nhlbjjuv.g(cArray4, (short)5826, (byte)4, (short)5));
        char[] cArray5 = "\ue9cc\u8be8\u9e35\ud8c7\u84e8\ud88e\ude6a\u812f\u43fe\u90ba\ub8f5\uac9f\uea15\u32a7\u9d22\u5ed8\u0294\uae9c\u67ad\u40a5\u0834\u0fd1\u686d\ue1f1\ue370\u5629\uf0cf\u7487\u3597\u7683\ue9a2\ua4a4\ufb7a\u0b4e\uaf74\ubf93\udecb\ubb20\ue46f\u57e8\u2b2c\ua15f\u748c\u47cd\uffca\ud60e\u44d9\ue0e8\ua8a9\ue893\u50a2\u3cf6\u6535".toCharArray();
        cArray5[35] = (char)(cArray5[35] ^ 0x686E);
        SpanContainer verticalAligner = new SpanContainer(nhlbjjuv.g(cArray5, (short)26211, (byte)3, (short)1), (DOMElement)verticalArea, this.view);
        char[] cArray6 = "\ud37d\ue417\u199b\u1d2f\uf20c\u347b\u9853\u920e\u8490\u23ff\u2e94\ue736\ue024\u0bbb\u5fdf\u7d3e\u2fc0\uaef5\u3669\u89f8\u4f81\u35b1\u7fb2\uf558\u4e65\u293b\u0473\u649a\uac1e\ud9ae\u3e0f\u5345\u962b\ua21d\ub367\udabd\u2c30\udc72\u81ec\u9da7\ub1e0\u1ae8\ub2e8\ucf6b\u5de6\u55db\ufe0f\u8cf7\uac5a\u9f17\ubfcb\u70a9\u1b39".toCharArray();
        cArray6[20] = (char)(cArray6[20] ^ 0x2A68);
        PdfViewerOptionsPanel.Hz("3guruo", verticalAligner, nhlbjjuv.g(cArray6, (short)20529, (byte)4, (short)5));
        char[] cArray7 = "\ud096\ud466\u5944\uaa1a\u6f66\u5fb9\u66d8\ua8c0\u7240\u2521\uf915\ufa08\u37f3\u0562\u5162\u2543\ued0c\u42a9\u7a87\u1bb3\ud7ec\u8db1\u94d5\uff8c\u1938\u32a8\ua318\ue649\ude65\uc344\u27e1\u87d6\u1858\u3073\ua681\u330a\u5621\ueccc\ufbf7\ua0ea\u6675\u4af6\u082c\u635d\uc3e5\u5d22\u762c\u7aab\u315e".toCharArray();
        cArray7[45] = (char)(cArray7[45] ^ 0x18AD);
        Image toggleOptions = new Image(nhlbjjuv.g(cArray7, (short)21406, (byte)4, (short)1), (DOMElement)verticalArea, this.view);
        char[] cArray8 = "\u38a0\u17c0\uf24c\u1734\u54dd\u9f32\ub3aa\u4e2b\u4bda\u9417\u12e1\u322c\u9894\u0d37\u5ca2\u4cd5\ub013\u943a\u9aa7\u88c0\u56a6\uba83\u9802\u3fab\u7761\u26fd\ud2da\u1d38\u00ba\u26cb\u39c8\u9ca1\u4258\u18e8\uea63\uf678\uf3b0\ubcfc\ud95e\u3353\uff72\ua4d9\ufd83\uda69\u25b4\u1f94\ucc9d\uca1c\u2ebe".toCharArray();
        cArray8[37] = (char)(cArray8[37] ^ 0x5596);
        PdfViewerOptionsPanel.Hz("1mlorr2", toggleOptions, nhlbjjuv.g(cArray8, (short)26951, (byte)5, (short)4));
        PdfViewerOptionsPanel.Hz("rrerr0", toggleOptions, ARROW_LEFT);
        PdfViewerOptionsPanel.Hz("gg4run", verticalArea, evt -> {
            this.isOptionsVisible = !this.isOptionsVisible;
            PdfViewerOptionsPanel.Hz("-146b41b", optionsArea, this.isOptionsVisible);
            if (this.isOptionsVisible) {
                PdfViewerOptionsPanel.Hz("rrerr0", toggleOptions, ARROW_RIGHT);
            } else {
                PdfViewerOptionsPanel.Hz("rrerr0", toggleOptions, ARROW_LEFT);
            }
        });
    }

    public void remove() {
        if (this.imageYesRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.imageYesRB);
        }
        if (this.imageNoRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.imageNoRB);
        }
        if (this.dateYesRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.dateYesRB);
        }
        if (this.dateNoRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.dateNoRB);
        }
        if (this.locationYesRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.locationYesRB);
        }
        if (this.locationNoRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.locationNoRB);
        }
        if (this.reasonYesRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.reasonYesRB);
        }
        if (this.reasonNoRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.reasonNoRB);
        }
        if (this.preservePDFAYesRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.preservePDFAYesRB);
        }
        if (this.preservePDFANoRB != null) {
            PdfViewerOptionsPanel.Hz("-veh41a", this.preservePDFANoRB);
        }
    }

    static {
        char[] cArray = "\u5ae5\u2c78\uc3ef\u66b3\u9f8f\uf5db\u19e3\u58c2\u631e\u65c5\u1a4d\u2779\ueb1f\u59df\ud34a\ua8df\u1dc0\u9063\u34d4\u323b\u0b5d\ua5c6\u18fa\uba2a\u6a0e\u1aa3\ub36a\uea8c\u8aa3\ucae0\uc032\u331c\u2639\ub35d\u116b".toCharArray();
        cArray[22] = (char)(cArray[22] ^ 0x6F0D);
        i18n = PdfViewerOptionsPanel.Hz("108mrur", nhlbjjuv.g(cArray, (short)10072, (byte)0, (short)0));
        char[] cArray2 = "\ufadd\ud8eb\uda82\ue9a4\ud7f7\udebf\u9c49\u88d1\u34f4\udf49\uea38\u1e70".toCharArray();
        cArray2[10] = (char)(cArray2[10] ^ 0x623A);
        ARROW_LEFT = PdfViewerOptionsPanel.Hz("2v8rr1", nhlbjjuv.g(cArray2, (short)25830, (byte)3, (short)5));
        char[] cArray3 = "\u8fbd\ua632\u4b51\u66aa\ufa4f\udad2\ucd00\u716f\uac2a\u6e92\uc7a1\u6f82".toCharArray();
        cArray3[1] = (char)(cArray3[1] ^ 0x4495);
        ARROW_RIGHT = PdfViewerOptionsPanel.Hz("2v8rr1", nhlbjjuv.g(cArray3, (short)1683, (byte)1, (short)5));
    }

    private static Object Hz(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(bmgrzhnc.t(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }
}

