/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.pkcs11.PKCS11Token;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pkcs11.card.Card;
import java.util.ArrayList;
import org.slf4j.Logger;

public class PData {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    String enteEmettitore;
    String dataEmissione;
    String dataScadenza;
    String cognome;
    String nome;
    String dataDiNascita;
    String sesso;
    String statura;
    String codiceFiscale;
    String cittadinanza;
    String comuneDiNascita;
    String statoEsteroDiNascita;
    String estremiAttoDiNascita;
    String comuneResidenza;
    String IndirizzoResidenza;
    String espatrio;

    private PData(String enteEmettitore, String dataEmissione, String dataScadenza, String cognome, String nome, String dataDiNascita, String sesso, String statura, String codiceFiscale, String cittadinanza, String comuneDiNascita, String statoEsteroDiNascita, String estremiAttoDiNascita, String comuneResidenza, String indirizzoResidenza, String espatrio) {
        this.enteEmettitore = enteEmettitore;
        this.dataEmissione = dataEmissione;
        this.dataScadenza = dataScadenza;
        this.cognome = cognome;
        this.nome = nome;
        this.dataDiNascita = dataDiNascita;
        this.sesso = sesso;
        this.statura = statura;
        this.codiceFiscale = codiceFiscale;
        this.cittadinanza = cittadinanza;
        this.comuneDiNascita = comuneDiNascita;
        this.statoEsteroDiNascita = statoEsteroDiNascita;
        this.estremiAttoDiNascita = estremiAttoDiNascita;
        this.comuneResidenza = comuneResidenza;
        this.IndirizzoResidenza = indirizzoResidenza;
        this.espatrio = espatrio;
    }

    public String getEnteEmettitore() {
        return this.enteEmettitore;
    }

    public String getDataEmissione() {
        return this.dataEmissione;
    }

    public String getDataScadenza() {
        return this.dataScadenza;
    }

    public String getCognome() {
        return this.cognome;
    }

    public String getNome() {
        return this.nome;
    }

    public String getDataDiNascita() {
        return this.dataDiNascita;
    }

    public String getSesso() {
        return this.sesso;
    }

    public String getStatura() {
        return this.statura;
    }

    public String getCodiceFiscale() {
        return this.codiceFiscale;
    }

    public String getCittadinanza() {
        return this.cittadinanza;
    }

    public String getComuneDiNascita() {
        return this.comuneDiNascita;
    }

    public String getStatoEsteroDiNascita() {
        return this.statoEsteroDiNascita;
    }

    public String getEstremiAttoDiNascita() {
        return this.estremiAttoDiNascita;
    }

    public String getComuneResidenza() {
        return this.comuneResidenza;
    }

    public String getIndirizzoResidenza() {
        return this.IndirizzoResidenza;
    }

    public String getEspatrio() {
        return this.espatrio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PData getInstance(Card card) {
        PKCS11Token token = null;
        try {
            token = (PKCS11Token)card.getToken();
            token.openPublicSession();
            byte[] pdata = token.getData("PDATA");
            String sPdata = new String(pdata);
            int len = Integer.parseInt(sPdata.substring(0, 6), 16);
            logger.debug("PData len {}", (Object)len);
            sPdata = sPdata.substring(6, len);
            logger.debug("PData body {}", (Object)sPdata);
            ArrayList<String> lstCampi = new ArrayList<String>();
            while (sPdata.length() > 0) {
                len = Integer.parseInt(sPdata.substring(0, 2), 16);
                if (len > 0) {
                    String strValue = sPdata.substring(2, len + 2);
                    lstCampi.add(strValue);
                    logger.debug("PData field index {} value {}", (Object)lstCampi.size(), (Object)sPdata);
                    sPdata = sPdata.substring(len + 2);
                    continue;
                }
                lstCampi.add("");
                sPdata = sPdata.substring(2);
            }
            if (lstCampi.size() == 16) {
                PData pData = new PData((String)lstCampi.get(0), (String)lstCampi.get(1), (String)lstCampi.get(2), (String)lstCampi.get(3), (String)lstCampi.get(4), (String)lstCampi.get(5), (String)lstCampi.get(6), (String)lstCampi.get(7), (String)lstCampi.get(8), (String)lstCampi.get(9), (String)lstCampi.get(10), (String)lstCampi.get(11), (String)lstCampi.get(12), (String)lstCampi.get(13), (String)lstCampi.get(14), (String)lstCampi.get(15));
                return pData;
            }
        }
        catch (Exception ex) {
            logger.info("Impossibile recuperare il PData dalla carta: {}", (Object)card.getSerial(), (Object)ex);
        }
        finally {
            if (token != null) {
                try {
                    TokenHelper.logout((TokenSpi)token);
                    TokenHelper.destroy((TokenSpi)token);
                }
                catch (CapiException capiException) {}
            }
        }
        return null;
    }
}

