/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11;

import it.actalis.pkcs11.PKCS11;

public class PKCS11TokenInfo {
    public static final int RNG = 1;
    public static final int WRITE_PROTECTED = 2;
    public static final int LOGIN_REQUIRED = 4;
    public static final int USER_PIN_INITIALIZED = 8;
    public static final int EXCLUSIVE_EXISTS = 16;
    public static final int RESTORE_KEY_NOT_NEEDED = 32;
    public static final int CLOCK_ON_TOKEN = 64;
    public static final int SUPPORTS_PARALLEL = 128;
    public static final int PROTECTED_AUTHENTICATION_PATH = 256;
    public static final int DUAL_CRYPTO_OPERATIONS = 512;
    public static final int UNAVAILABLE_INFORMATION = -1;
    public static final int EFFECTIVELY_INFINITE = 0;
    static final int[] flagList = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
    static final String[] flagNames = new String[]{"RNG", "WRITE_PROTECTED", "LOGIN_REQUIRED", "USER_PIN_INITIALIZED", "EXCLUSIVE_EXISTS", "RESTORE_KEY_NOT_NEEDED", "CLOCK_ON_TOKEN", "SUPPORTS_PARALLEL", "PROTECTED_AUTHENTICATION_PATH", "DUAL_CRYPTO_OPERATIONS"};
    private String label;
    private String manufacturer;
    private String model;
    private String serialNumber;
    private int flags;
    private int maxSessionCount;
    private int sessionCount;
    private int maxRwSessionCount;
    private int rwSessionCount;
    private int maxPinLen;
    private int minPinLen;
    private int totalPublicMemory;
    private int freePublicMemory;
    private int totalPrivateMemory;
    private int freePrivateMemory;
    private int hardwareVersion;
    private int firmwareVersion;
    private String utcTime;

    public PKCS11TokenInfo(String s, String s1, String s2, String s3, int i, int j, int k, int l, int i1, int j1, int k1, int l1, int i2, int j2, int k2, int l2, int i3, String s4) {
        this.label = s;
        this.manufacturer = s1;
        this.model = s2;
        this.serialNumber = s3;
        this.flags = i;
        this.maxSessionCount = j;
        this.sessionCount = k;
        this.maxRwSessionCount = l;
        this.rwSessionCount = i1;
        this.maxPinLen = j1;
        this.minPinLen = k1;
        this.totalPublicMemory = l1;
        this.freePublicMemory = i2;
        this.totalPrivateMemory = j2;
        this.freePrivateMemory = k2;
        this.hardwareVersion = l2;
        this.firmwareVersion = i3;
        this.utcTime = s4;
    }

    public String label() {
        return this.label;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public String model() {
        return this.model;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public int flags() {
        return this.flags;
    }

    public int maxSessionCount() {
        return this.maxSessionCount;
    }

    public int sessionCount() {
        return this.sessionCount;
    }

    public int maxRwSessionCount() {
        return this.maxRwSessionCount;
    }

    public int rwSessionCount() {
        return this.rwSessionCount;
    }

    public int maxPinLen() {
        return this.maxPinLen;
    }

    public int minPinLen() {
        return this.minPinLen;
    }

    public int totalPublicMemory() {
        return this.totalPublicMemory;
    }

    public int freePublicMemory() {
        return this.freePublicMemory;
    }

    public int totalPrivateMemory() {
        return this.totalPrivateMemory;
    }

    public int freePrivateMemory() {
        return this.freePrivateMemory;
    }

    public int hardwareVersion() {
        return this.hardwareVersion;
    }

    public int firmwareVersion() {
        return this.firmwareVersion;
    }

    public String utcTime() {
        return this.utcTime;
    }

    public String toString() {
        return "PKCS11TokenInfo:\n    Label:             " + this.label + "\n    Manufacturer:      " + this.manufacturer + "\n    Model:             " + this.model + "\n    Serial:            " + this.serialNumber + "\n    Flags:             " + this.flagsToString(" | ") + "\n    Max sessions:      " + this.infinite(this.maxSessionCount) + "\n    Sessions:          " + this.unavailable(this.sessionCount) + "\n    Max RW sessions:   " + this.infinite(this.maxRwSessionCount) + "\n    RW sessions:       " + this.unavailable(this.rwSessionCount) + "\n    Max PIN len:       " + this.maxPinLen + "\n    Min PIN len:       " + this.minPinLen + "\n    Total public mem:  " + this.unavailable(this.totalPublicMemory) + "\n    Free public mem:   " + this.unavailable(this.freePublicMemory) + "\n    Total private mem: " + this.unavailable(this.totalPrivateMemory) + "\n    Free private mem:  " + this.unavailable(this.freePrivateMemory) + "\n    Hardware version:  " + PKCS11.versionString(this.hardwareVersion) + "\n    Firmware version:  " + PKCS11.versionString(this.firmwareVersion) + (this.utcTime != null ? "\n    UTC time:           " + this.utcTime : "");
    }

    public String flagsToString(String s) {
        return PKCS11.flagsToString(this.flags, flagList, flagNames, s);
    }

    String infinite(int i) {
        if (i == 0) {
            return "EFFECTIVELY_INFINITE";
        }
        return this.unavailable(i);
    }

    String unavailable(int i) {
        if (i == -1) {
            return "UNAVAILABLE_INFORMATION";
        }
        return Integer.toString(i);
    }
}

