/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class ArubaEntityResolver
implements EntityResolver2 {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String CRLF = "\r\n";
    public static final String XML_ENTITY_JAR_MAIN_PATH = "it/actalis/ellips/capi/xml/dtd";
    public static final String XML_ENTITY_MAPPING_FILENAME = "XMLEntityMapping.properties";
    public static final String XML_ENTITY_PREFIX = "xml.entity.";
    public static final String XML_ENTITY_SYSTEMID_SUFFIX = ".systemId";
    public static final String XML_ENTITY_TIMESTAMP_SUFFIX = ".timestamp";
    public static final String PERSISTENCE_DIR = System.getProperty("user.home") + File.separator + ".arDigiSign";
    public static final String XML_RESOLVER_PERISTENCE_SUBDIR = "xmlResolver";
    public static final long EXPIRATION_DAYS = 90L;
    public static final int DOWNLOAD_BUFFER_SIZE = 4096;
    private DateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd");
    private Map<String, ArubaEntityResolverInfo> erMappings = new HashMap<String, ArubaEntityResolverInfo>();
    private Map<String, String> erSecMappings = new HashMap<String, String>();

    private String getFilepathFromUrl(String url) {
        int slashIndex;
        StringBuilder sb = new StringBuilder();
        if (url == null || url.isEmpty()) {
            return "";
        }
        String dirs = url;
        if (dirs.startsWith("http://")) {
            sb.append("http").append(File.separator);
            dirs = dirs.substring("http://".length());
        } else if (url.startsWith("https://")) {
            sb.append("https").append(File.separator);
            dirs = dirs.substring("https://".length());
        }
        while ((slashIndex = dirs.indexOf("/")) >= 0) {
            sb.append(dirs.substring(0, slashIndex)).append(File.separator);
            dirs = dirs.substring(slashIndex + 1);
        }
        sb.append(dirs);
        return sb.toString();
    }

    private String getRealSystemId(String systemId) {
        int slashIndex;
        if (systemId == null) {
            return null;
        }
        String prefixToTrim = null;
        if (systemId.startsWith("file:///")) {
            prefixToTrim = "file:///";
        } else if (systemId.startsWith("file://")) {
            prefixToTrim = "file://";
        } else if (systemId.startsWith("file:/")) {
            prefixToTrim = "file:/";
        }
        if (prefixToTrim == null) {
            return systemId;
        }
        File file = new File(systemId.substring(prefixToTrim.length()));
        File root = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR);
        String relativePath = Util.getRelativePath((String)root.getAbsolutePath(), (String)file.getAbsolutePath(), (String)File.pathSeparator);
        if (relativePath == null) {
            return null;
        }
        String relativePathString = relativePath;
        StringBuilder sb = new StringBuilder();
        if (relativePathString.startsWith("http" + File.separator)) {
            sb.append("http://");
            relativePathString = relativePathString.substring(("http" + File.separator).length());
        } else if (relativePathString.startsWith("https" + File.separator)) {
            sb.append("https://");
            relativePathString = relativePathString.substring(("https" + File.separator).length());
        }
        while ((slashIndex = relativePathString.indexOf(File.separator)) >= 0) {
            sb.append(relativePathString.substring(0, slashIndex)).append("/");
            relativePathString = relativePathString.substring(slashIndex + 1);
        }
        sb.append(relativePathString);
        return sb.toString();
    }

    private void loadMappings(Properties from, Map<String, ArubaEntityResolverInfo> toPri, Map<String, String> toSec) {
        Enumeration<?> propNames = from.propertyNames();
        while (propNames.hasMoreElements()) {
            String s;
            String dtdKey;
            int lastDotIndex;
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith(XML_ENTITY_PREFIX) || (lastDotIndex = propName.lastIndexOf(".")) < 0 || toPri.containsKey(dtdKey = propName.substring(XML_ENTITY_PREFIX.length(), lastDotIndex))) continue;
            ArubaEntityResolverInfo info = new ArubaEntityResolverInfo();
            String sysId = from.getProperty(XML_ENTITY_PREFIX + dtdKey + XML_ENTITY_SYSTEMID_SUFFIX, "null");
            sysId = sysId == null || sysId.isEmpty() ? "null" : sysId;
            String timestamp = from.getProperty(XML_ENTITY_PREFIX + dtdKey + XML_ENTITY_TIMESTAMP_SUFFIX, null);
            if (timestamp == null) {
                timestamp = this.timestampFormat.format(timestamp);
            }
            info.setSystemId(sysId);
            info.setTimestamp(timestamp);
            ArubaEntityResolverInfo v = toPri.get(dtdKey);
            if (v == null) {
                toPri.put(dtdKey, info);
            }
            if ((s = toSec.get(sysId)) != null) continue;
            toSec.put(sysId, dtdKey);
        }
    }

    private boolean isDownloadStillValid(String datestamp) {
        if (datestamp == null || datestamp.isEmpty()) {
            return false;
        }
        try {
            Date date = this.timestampFormat.parse(datestamp);
            Date dateNow = new Date();
            long diff = dateNow.getTime() - date.getTime();
            if (diff / 86400000L < 90L) {
                return true;
            }
        }
        catch (ParseException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMappingsOnDisk() throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        File outFile = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR + File.separator + XML_ENTITY_MAPPING_FILENAME);
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            for (Map.Entry<String, ArubaEntityResolverInfo> entry : this.erMappings.entrySet()) {
                prop.put(XML_ENTITY_PREFIX + entry.getKey() + XML_ENTITY_SYSTEMID_SUFFIX, entry.getValue().getSystemId());
                prop.put(XML_ENTITY_PREFIX + entry.getKey() + XML_ENTITY_TIMESTAMP_SUFFIX, entry.getValue().getTimestamp());
            }
            prop.store(out, "XML schema mappings");
        }
    }

    private InputSource downloadIfNeededAndGetXMLSchema(String publicId, String systemId) throws IOException {
        String primKey;
        String realSystemId = this.getRealSystemId(systemId);
        ArubaEntityResolverInfo info = null;
        if (this.erSecMappings.containsKey(realSystemId) && this.erMappings.containsKey(primKey = this.erSecMappings.get(realSystemId))) {
            info = this.erMappings.get(primKey);
        }
        if (info == null) {
            info = new ArubaEntityResolverInfo();
            info.setPublicId(publicId);
            info.setSystemId(realSystemId);
        }
        File xmlPersDir = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR);
        File downloadedFile = new File(xmlPersDir.getAbsolutePath() + File.separator + info.getFilename());
        if (this.isDownloadStillValid(info.getTimestamp()) && downloadedFile.exists() && downloadedFile.isFile()) {
            return new InputSource(downloadedFile.getAbsolutePath());
        }
        String downloadedFilename = this.downloadXMLSchema(realSystemId);
        if (downloadedFilename != null) {
            int extIndex = downloadedFilename.lastIndexOf(".");
            String dtdKey = extIndex >= 0 ? downloadedFilename.substring(0, extIndex) : downloadedFilename;
            info.setTimestamp(this.timestampFormat.format(new Date()));
            this.erMappings.put(dtdKey, info);
            this.erSecMappings.put(realSystemId, dtdKey);
            this.updateMappingsOnDisk();
            return new InputSource(downloadedFile.getAbsolutePath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String downloadXMLSchema(String fileUrl) {
        String res = null;
        HttpURLConnection httpConn = null;
        FileOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            URL url = new URL(fileUrl);
            httpConn = (HttpURLConnection)url.openConnection();
            inputStream = httpConn.getInputStream();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                int bytesRead;
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileUrl.substring(fileUrl.lastIndexOf("/") + 1, fileUrl.length());
                }
                String saveFilePath = PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR + File.separator + fileName;
                outputStream = new FileOutputStream(saveFilePath);
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                res = fileName;
            }
        }
        catch (MalformedURLException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (httpConn != null) {
                httpConn.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArubaEntityResolver() {
        File persDir = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR + File.separator);
        persDir.mkdirs();
        HashMap<String, ArubaEntityResolverInfo> jarMappings = new HashMap<String, ArubaEntityResolverInfo>();
        HashMap<String, String> jarSecMappings = new HashMap<String, String>();
        InputStream inJar = null;
        Properties jarProp = new Properties();
        try {
            inJar = ClassLoader.getSystemClassLoader().getResourceAsStream("it/actalis/ellips/capi/xml/dtd/XMLEntityMapping.properties");
            jarProp.load(inJar);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            if (inJar != null) {
                try {
                    inJar.close();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        this.loadMappings(jarProp, jarMappings, jarSecMappings);
        FileInputStream inDisk = null;
        Properties diskProp = new Properties();
        File inDiskFile = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR + File.separator + XML_ENTITY_MAPPING_FILENAME);
        if (inDiskFile.exists()) {
            try {
                inDisk = new FileInputStream(inDiskFile);
                diskProp.load(inDisk);
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (inDisk != null) {
                    try {
                        ((InputStream)inDisk).close();
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
        }
        this.loadMappings(diskProp, this.erMappings, this.erSecMappings);
        boolean mappingsNeedUpdate = false;
        for (Map.Entry jarEntry : jarMappings.entrySet()) {
            boolean updateFromJar = false;
            File dest = new File(PERSISTENCE_DIR + File.separator + XML_RESOLVER_PERISTENCE_SUBDIR + File.separator + ((ArubaEntityResolverInfo)jarEntry.getValue()).getFilename());
            if (!(this.erMappings.containsKey(jarEntry.getKey()) && dest.exists() && dest.isFile())) {
                updateFromJar = true;
            } else {
                ArubaEntityResolverInfo diskEntryInfo = this.erMappings.get(jarEntry.getKey());
                try {
                    Date diskDate = this.timestampFormat.parse(diskEntryInfo.getTimestamp());
                    Date jarDate = this.timestampFormat.parse(((ArubaEntityResolverInfo)jarEntry.getValue()).getTimestamp());
                    if (jarDate.after(diskDate)) {
                        updateFromJar = true;
                    }
                }
                catch (ParseException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            if (!updateFromJar) continue;
            mappingsNeedUpdate = true;
            Closeable sdest = null;
            InputStream copySchemaFrom = null;
            FileOutputStream outputStream = null;
            try {
                copySchemaFrom = ClassLoader.getSystemClassLoader().getResourceAsStream("it/actalis/ellips/capi/xml/dtd/" + ((ArubaEntityResolverInfo)jarEntry.getValue()).getFilename().replace(File.separator, "/"));
                dest.getParentFile().mkdirs();
                if (dest.exists()) {
                    dest.delete();
                }
                dest.createNewFile();
                try {
                    outputStream = new FileOutputStream(dest);
                    byte[] buffer = new byte[4096];
                    while (copySchemaFrom.read(buffer) != -1) {
                        ((OutputStream)outputStream).write(buffer);
                    }
                    outputStream.flush();
                }
                finally {
                    if (copySchemaFrom != null) {
                        copySchemaFrom.close();
                    }
                    if (outputStream != null) {
                        ((OutputStream)outputStream).close();
                    }
                }
                ArubaEntityResolverInfo info = new ArubaEntityResolverInfo();
                info.setPublicId(((ArubaEntityResolverInfo)jarEntry.getValue()).getPublicId());
                info.setSystemId(((ArubaEntityResolverInfo)jarEntry.getValue()).getSystemId());
                info.setTimestamp(((ArubaEntityResolverInfo)jarEntry.getValue()).getTimestamp());
                this.erMappings.put((String)jarEntry.getKey(), info);
                this.erSecMappings.put(((ArubaEntityResolverInfo)jarEntry.getValue()).getSystemId(), (String)jarEntry.getKey());
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (sdest == null) continue;
                Util.closeQuietly(sdest);
            }
        }
        if (mappingsNeedUpdate) {
            try {
                this.updateMappingsOnDisk();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        InputSource res = null;
        try {
            res = this.downloadIfNeededAndGetXMLSchema(publicId, systemId);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return res;
    }

    public class ArubaEntityResolverInfo {
        private String publicId;
        private String systemId;
        private String filename;
        private String timestamp;

        public String getPublicId() {
            return this.publicId;
        }

        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setSystemId(String systemId) {
            this.systemId = systemId;
            this.filename = ArubaEntityResolver.this.getFilepathFromUrl(systemId);
        }

        public String getFilename() {
            return this.filename;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }
    }
}

