/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Demo;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.provider.ECCProvider;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.GregorianCalendar;

public class CreateCert
implements Demo {
    protected String curveName_ = "P-192";

    public boolean runDemo() {
        try {
            System.out.println("Creating key pair ...");
            KeyPair keyPair = this.generateKeyPair(this.curveName_);
            X509Certificate x509Certificate = this.createCertificate(keyPair);
            System.out.println("Writing cert to file ...");
            String string = "test.der";
            new File(string).delete();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            x509Certificate.writeTo((OutputStream)fileOutputStream);
            fileOutputStream.close();
            System.out.println("Reading cert from file ...");
            FileInputStream fileInputStream = new FileInputStream(string);
            x509Certificate = new X509Certificate((InputStream)fileInputStream);
            System.out.println("Validating self signed cert ...");
            x509Certificate.verify();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public KeyPair generateKeyPair(String string) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        ECCParameterSpec eCCParameterSpec = ECCParameterFactory.getInstance().getParameterByName(string);
        ECDSAKeyPairGeneratorImpl eCDSAKeyPairGeneratorImpl = (ECDSAKeyPairGeneratorImpl)KeyPairGenerator.getInstance("ECDSA");
        eCDSAKeyPairGeneratorImpl.initialize(eCCParameterSpec);
        return eCDSAKeyPairGeneratorImpl.generateKeyPair();
    }

    public X509Certificate createCertificate(KeyPair keyPair) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException {
        Name name = new Name();
        name.addRDN(ObjectID.country, (Object)"AT");
        name.addRDN(ObjectID.organization, (Object)"TU Graz");
        name.addRDN(ObjectID.organizationalUnit, (Object)"IAIK");
        name.addRDN(ObjectID.commonName, (Object)"IAIK Test Certificate");
        X509Certificate x509Certificate = new X509Certificate();
        x509Certificate.setSerialNumber(BigInteger.valueOf(4660L));
        x509Certificate.setSubjectDN((Principal)name);
        x509Certificate.setPublicKey(keyPair.getPublic());
        x509Certificate.setIssuerDN((Principal)name);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
        gregorianCalendar.add(2, 6);
        x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
        System.out.println("Signing certificate ...");
        x509Certificate.sign(AlgorithmID.ecdsa, keyPair.getPrivate());
        return x509Certificate;
    }

    public CreateCert(String string) {
        this.curveName_ = string;
    }

    public CreateCert() {
    }

    public static void main(String[] stringArray) {
        CreateCert.init();
        CreateCert createCert = new CreateCert();
        if (createCert.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }

    public static void init() {
        IAIK.addAsJDK14Provider();
        ECCProvider.addAsProvider();
    }
}

