/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.utilities.log4j.prefpages;

import it.sogei.rcp.ui.preferences.entities.PreferenceBean;
import it.sogei.rcp.ui.preferences.entities.PreferenceComboFieldBean;
import it.sogei.rcp.ui.preferences.entities.PreferenceFieldBean;
import it.sogei.rcp.ui.preferences.entities.ScopeEnum;
import it.sogei.rcp.ui.preferences.util.AbstractPreferencePage;
import it.sogei.rcp.ui.preferences.util.PreferencesUtilRCP;
import it.sogei.utilities.log4j.LogUtil;

public class PreferencePageLog
extends AbstractPreferencePage {
    public static final String ID = "it.sogei.utilities.log4j.preferencePageLog";
    private String logLevel;

    public ScopeEnum getScope() {
        return ScopeEnum.INSTANCE;
    }

    public PreferenceFieldBean[] getPreferenceFields() {
        PreferenceFieldBean[] fields = new PreferenceFieldBean[1];
        PreferenceComboFieldBean combo = new PreferenceComboFieldBean();
        combo.setFieldType(PreferenceFieldBean.FieldTypeEnum.COMBO);
        combo.setFieldDefaultValue(LogUtil.defaultLevel);
        combo.setFieldId("level");
        combo.setFieldLabel("Livello di log");
        combo.setRadioLabelAndValues((String[][])new String[][]{{"DEBUG", "DEBUG"}, {"INFO", "INFO"}, {"WARNING", "WARN"}, {"ERROR", "ERROR"}, {"FATAL", "FATAL"}});
        fields[0] = combo;
        return fields;
    }

    public String getPageTitle() {
        return "Log";
    }

    public String getPageName() {
        return "Log";
    }

    public String getDescription() {
        return "Imposta il livello di log dell'applicazione";
    }

    public void performFinish() {
        String newLogLevel = PreferencesUtilRCP.getPreferencePageFieldValue((PreferenceBean)new PreferenceBean("it.sogei.utilities.log4j", ID, "level"), (boolean)true);
        if (newLogLevel != this.logLevel) {
            LogUtil.changeLogLevel(newLogLevel);
            LogUtil.log((Object)this, 2, "il livello di log \u00e8 stato impostato a:" + newLogLevel, true);
        }
    }
}

