/*
 * Decompiled with CFR 0.152.
 */
package iaik.smime.ess;

import iaik.DebugCMS;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.PolicyInformation;
import iaik.cms.CertificateSet;
import iaik.cms.SecurityProvider;
import iaik.smime.ess.ESSAttributeValue;
import iaik.smime.ess.ESSCertID;
import iaik.utils.CryptoUtils;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.extensions.CertificatePolicies;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Vector;

public class SigningCertificate
extends ESSAttributeValue {
    static /* synthetic */ Class e;
    private SecurityProvider c;
    private PolicyInformation[] a;
    private ESSCertID[] b;
    public static final ObjectID oid;
    private static boolean d;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Signing Certificate:\n");
        int n2 = 0;
        while (n2 < this.b.length) {
            stringBuffer.append("certID[" + n2 + "]: \n" + this.b[n2]);
            ++n2;
        }
        if (this.a != null) {
            int n3 = 0;
            while (n3 < this.a.length) {
                stringBuffer.append("policy[" + n3 + "]: \n" + this.a[n3] + "\n");
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        if (this.b != null) {
            int n2 = 0;
            while (n2 < this.b.length) {
                sEQUENCE2.addComponent(this.b[n2].toASN1Object());
                ++n2;
            }
        }
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        if (this.a != null) {
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            int n3 = 0;
            while (n3 < this.a.length) {
                sEQUENCE3.addComponent(this.a[n3].toASN1Object());
                ++n3;
            }
            sEQUENCE.addComponent((ASN1Object)sEQUENCE3);
        }
        return sEQUENCE;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.c = securityProvider;
        if (this.b != null && securityProvider != null) {
            int n2 = 0;
            while (n2 < this.b.length) {
                this.b[n2].setSecurityProvider(this.c);
                ++n2;
            }
        }
    }

    public void setPolicies(PolicyInformation[] policyInformationArray) {
        this.a = policyInformationArray;
    }

    ESSCertID a(ASN1Object aSN1Object) throws CodingException {
        return new ESSCertID(aSN1Object);
    }

    public boolean isSignerCertificate(X509Certificate x509Certificate) throws NoSuchAlgorithmException {
        if (this.b != null && this.b.length > 0) {
            return this.b[0].identifiesCert((Certificate)x509Certificate);
        }
        return true;
    }

    public int hashCode() {
        if (this.b != null && this.b.length > 0) {
            return this.b[0].hashCode();
        }
        return super.hashCode();
    }

    public SecurityProvider getSecurityProvider() {
        return this.c;
    }

    public PolicyInformation[] getPolicyInformations(Certificate certificate) {
        Object[] objectArray;
        CertificatePolicies certificatePolicies;
        Vector<Object> vector;
        block11: {
            vector = new Vector<Object>();
            certificatePolicies = null;
            try {
                if (certificate instanceof X509Certificate) {
                    certificatePolicies = (CertificatePolicies)((X509Certificate)certificate).getExtension(CertificatePolicies.oid);
                    break block11;
                }
                if (certificate instanceof AttributeCertificate) {
                    certificatePolicies = (CertificatePolicies)((AttributeCertificate)certificate).getExtension(CertificatePolicies.oid);
                    break block11;
                }
                throw new IllegalArgumentException("Only iaik.x509.X509Certificate and iaik.x509.attr.AttributeCertificate objects are allowed!");
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                return null;
            }
        }
        if (certificatePolicies != null) {
            objectArray = certificatePolicies.getPolicyInformation();
            if (this.a == null) {
                return objectArray;
            }
            if (objectArray != null) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    int n3 = 0;
                    while (n3 < this.a.length) {
                        if (objectArray[n2].getPolicyIdentifier().equals((Object)this.a[n3].getPolicyIdentifier())) {
                            vector.addElement(objectArray[n2]);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new PolicyInformation[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Certificate[] getPolicyInformationCerts(Certificate[] certificateArray) {
        if (this.a == null || certificateArray == null) {
            return certificateArray;
        }
        Certificate[] certificateArray2 = this.a(certificateArray, false);
        if (certificateArray2 == null) {
            return null;
        }
        Vector<Certificate> vector = new Vector<Certificate>();
        int n2 = 0;
        while (n2 < certificateArray2.length) {
            if (this.getPolicyInformations(certificateArray2[n2]) != null) {
                vector.addElement(certificateArray2[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public PolicyInformation[] getPolicies() {
        return this.a;
    }

    public ESSCertID[] getESSCertIDs() {
        return this.b;
    }

    private ESSCertID a(Certificate certificate, boolean bl) {
        try {
            if (this.b != null) {
                int n2;
                int n3 = n2 = bl ? 1 : 0;
                while (n3 < this.b.length) {
                    ESSCertID eSSCertID = this.b[n3];
                    if (eSSCertID.identifiesCert(certificate)) {
                        return eSSCertID;
                    }
                    ++n3;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return null;
    }

    public ESSCertID getESSCertID(Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("Certificate must not be null!");
        }
        return this.a(certificate, false);
    }

    private Certificate[] a(Certificate[] certificateArray, boolean bl) {
        if (this.b == null || this.b.length <= 1) {
            return certificateArray;
        }
        Vector<Certificate> vector = new Vector<Certificate>();
        int n2 = 0;
        while (n2 < certificateArray.length) {
            if (this.a(certificateArray[n2], bl) != null) {
                vector.addElement(certificateArray[n2]);
            }
            ++n2;
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Certificate[] getAuthorizedCertificates(Certificate[] certificateArray) {
        return this.a(certificateArray, true);
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SigningCertificate)) {
            return false;
        }
        return CryptoUtils.equalsBlock((byte[])DerCoder.encode((ASN1Object)this.toASN1Object()), (byte[])DerCoder.encode((ASN1Object)((SigningCertificate)((Object)object)).toASN1Object()));
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        int n2 = aSN1Object2.countComponents();
        this.b = new ESSCertID[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.b[n3] = this.a(aSN1Object2.getComponentAt(n3));
            ++n3;
        }
        if (aSN1Object.countComponents() == 2) {
            ASN1Object aSN1Object3 = aSN1Object.getComponentAt(1);
            n2 = aSN1Object3.countComponents();
            this.a = new PolicyInformation[n2];
            int n4 = 0;
            while (n4 < n2) {
                this.a[n4] = new PolicyInformation(aSN1Object3.getComponentAt(n4));
                ++n4;
            }
        }
    }

    ESSCertID a(Certificate certificate, AlgorithmID algorithmID, boolean bl, SecurityProvider securityProvider) throws NoSuchAlgorithmException, CertificateException {
        ESSCertID eSSCertID;
        if (certificate instanceof X509Certificate) {
            eSSCertID = new ESSCertID((Certificate)((X509Certificate)certificate), bl, securityProvider);
        } else if (certificate instanceof AttributeCertificate) {
            eSSCertID = new ESSCertID((Certificate)((AttributeCertificate)certificate), bl, securityProvider);
        } else {
            throw new IllegalArgumentException("Cannot create CertID. Certificate has to be X509Certificte or AttributeCertificate!");
        }
        return eSSCertID;
    }

    public int countPolicies() {
        if (this.a == null) {
            return 0;
        }
        return this.a.length;
    }

    void a(ESSCertID[] eSSCertIDArray) throws IllegalArgumentException {
        if (eSSCertIDArray != null) {
            int n2 = 0;
            while (n2 < eSSCertIDArray.length) {
                if (eSSCertIDArray[n2].a() != 1) {
                    throw new IllegalArgumentException("Only V1 ESSCertIDs allowed for SigningCertificate attribute");
                }
                ++n2;
            }
        }
    }

    public SigningCertificate(Certificate[] certificateArray, boolean bl, SecurityProvider securityProvider) throws CertificateException, NoSuchAlgorithmException {
        this(certificateArray, null, bl, securityProvider);
    }

    public SigningCertificate(Certificate[] certificateArray, boolean bl) throws CertificateException, NoSuchAlgorithmException {
        this(certificateArray, bl, null);
    }

    SigningCertificate(Certificate[] certificateArray, AlgorithmID algorithmID, boolean bl, SecurityProvider securityProvider) throws CertificateException, NoSuchAlgorithmException {
        this();
        if (certificateArray == null) {
            throw new NullPointerException("Cannot create SigningCertificate from null certificates!");
        }
        if (!(certificateArray[0] instanceof X509Certificate)) {
            throw new CertificateException("Cannot create SigningCertificate attribute. First cert has to be an X.509 public key certificate!");
        }
        this.c = securityProvider;
        Vector<ESSCertID> vector = new Vector<ESSCertID>();
        vector.addElement(this.a((Certificate)((X509Certificate)certificateArray[0]), algorithmID, bl, this.c));
        if (certificateArray.length > 1) {
            int n2 = 1;
            while (n2 < certificateArray.length) {
                vector.addElement(this.a(certificateArray[n2], algorithmID, bl, this.c));
                ++n2;
            }
        }
        this.b = new ESSCertID[vector.size()];
        vector.copyInto(this.b);
    }

    public SigningCertificate(Certificate[] certificateArray) throws CertificateException, NoSuchAlgorithmException {
        this(certificateArray, true, null);
    }

    public SigningCertificate(ESSCertID[] eSSCertIDArray) {
        this();
        this.a(eSSCertIDArray);
        this.b = eSSCertIDArray;
    }

    public SigningCertificate(CertificateSet certificateSet, boolean bl) throws CertificateException, NoSuchAlgorithmException {
        this(certificateSet.getCertificates(), bl);
    }

    public SigningCertificate(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public SigningCertificate() {
    }

    static {
        d = DebugCMS.getDebugMode() && d;
        Attribute.register((ObjectID)ObjectID.signingCertificate, (Class)(e != null ? e : (e = SigningCertificate.a("iaik.smime.ess.SigningCertificate"))));
        oid = ObjectID.signingCertificate;
    }
}

