/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.SecurityProvider;
import iaik.cms.f;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

class d
implements ASN1Type {
    PublicKey b;
    byte[] c;
    CertificateIdentifier a;
    private static boolean d = DebugCMS.getDebugMode() && d;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("rid: " + this.a + "\n");
        stringBuffer.append("encryptedKey: " + (this.c == null ? "not set" : Util.toString((byte[])this.c, (int)0, (int)5)) + "...");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new f(this.a).toASN1Object());
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.c));
        return sEQUENCE;
    }

    public boolean isRecipientEncryptedKeyFor(CertificateIdentifier certificateIdentifier) {
        return this.a.equals(certificateIdentifier);
    }

    public CertificateIdentifier getKeyAgreeRecipientIdentifier() {
        return this.a;
    }

    public byte[] getEncryptedKey() {
        return this.c;
    }

    public SecretKey encryptKey(SecretKey secretKey, AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmID algorithmID2, int n2, byte[] byArray, SecurityProvider securityProvider) throws CMSException {
        SecurityProvider securityProvider2 = securityProvider;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        String string = "RAW";
        int n3 = n2;
        SecretKey secretKey2 = null;
        AlgorithmParameters algorithmParameters = null;
        try {
            Object object;
            if (algorithmID2.equals((Object)AlgorithmID.cms_3DES_wrap)) {
                n3 = 192;
                string = "3DES";
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_rc2_wrap)) {
                if (n2 < 128) {
                    n3 = 128;
                }
                string = "RC2";
                object = new INTEGER(n2);
                algorithmParameters = securityProvider2.getAlgorithmParameters("RC2WrapRC2");
                algorithmParameters.init(DerCoder.encode((ASN1Object)object));
                algorithmID2.setAlgorithmParameters(algorithmParameters);
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_idea_wrap)) {
                n3 = 128;
                string = "IDEA";
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_cast5_wrap)) {
                if (n3 < 0) {
                    n3 = 128;
                }
                string = "CAST128";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_HMACwith3DES_wrap)) {
                n3 = 192;
                string = "3DES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes128_wrap)) {
                n3 = 128;
                string = "AES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes192_wrap)) {
                n3 = 192;
                string = "AES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes256_wrap)) {
                n3 = 256;
                string = "AES";
            } else {
                object = algorithmID2.getRawImplementationName();
                int n4 = ((String)object).indexOf("Wrap");
                if (n4 != -1 && n4 < ((String)object).length()) {
                    string = ((String)object).substring(0, n4);
                }
            }
            secretKey2 = securityProvider2.createSharedKeyEncryptionKey(algorithmID, privateKey, this.b, algorithmID2, n3, byArray, string);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating shared key encryption key: " + exception.getMessage());
        }
        try {
            this.c = securityProvider2.wrapKey(secretKey, algorithmID2, secretKey2, algorithmParameters);
            algorithmID.setParameter(algorithmID2.toASN1Object());
        }
        catch (Exception exception) {
            throw new CMSException("Error wrapping content encryption key: " + exception.getMessage());
        }
        return secretKey2;
    }

    public SecretKey decryptKey(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, PublicKey publicKey, byte[] byArray, String string, SecurityProvider securityProvider) throws CMSException {
        SecurityProvider securityProvider2 = securityProvider;
        if (securityProvider2 == null) {
            securityProvider2 = SecurityProvider.getSecurityProvider();
        }
        String string2 = string;
        String string3 = string;
        int n2 = -1;
        AlgorithmParameters algorithmParameters = null;
        SecretKey secretKey = null;
        try {
            Object object;
            if (algorithmID2 == null) {
                object = algorithmID.getParameter();
                if (object == null) {
                    throw new CMSException("Missing key wrap algorithm id!");
                }
                algorithmID2 = new AlgorithmID((ASN1Object)object);
            }
            algorithmParameters = securityProvider2.getAlgorithmParameters(algorithmID2);
            if (algorithmID2.equals((Object)AlgorithmID.cms_3DES_wrap)) {
                n2 = 192;
                string3 = "3DES";
                string2 = "3DES";
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_rc2_wrap)) {
                n2 = 128;
                string3 = "RC2";
                string2 = "RC2";
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_idea_wrap)) {
                n2 = 128;
                string3 = "IDEA";
                string2 = "IDEA";
            } else if (algorithmID2.equals((Object)AlgorithmID.cms_cast5_wrap)) {
                n2 = 128;
                object = algorithmID2.getParameter();
                if (object != null && object.isA(ASN.INTEGER)) {
                    n2 = ((BigInteger)object.getValue()).intValue();
                }
                string3 = "CAST128";
                string2 = "CAST128";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_HMACwith3DES_wrap)) {
                n2 = 192;
                string2 = "3DES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes128_wrap)) {
                n2 = 128;
                string2 = "AES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes192_wrap)) {
                n2 = 192;
                string2 = "AES";
            } else if (algorithmID2.equals((Object)CMSAlgorithmID.cms_aes256_wrap)) {
                n2 = 256;
                string2 = "AES";
            } else {
                object = algorithmID2.getRawImplementationName();
                int n3 = ((String)object).indexOf("Wrap");
                if (n3 != -1 && n3 < ((String)object).length()) {
                    string2 = ((String)object).substring(0, n3);
                    if (string == null || string.equalsIgnoreCase("RAW")) {
                        string3 = ((String)object).substring(n3 + 4);
                    }
                }
            }
            secretKey = securityProvider2.createSharedKeyEncryptionKey(algorithmID, privateKey, publicKey, algorithmID2, n2, byArray, string2);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating shared key encryption key: " + exception.toString());
        }
        try {
            return securityProvider2.unwrapKey(this.c, algorithmID2, secretKey, algorithmParameters, string3);
        }
        catch (Exception exception) {
            throw new CMSException("Error unwrapping content encryption key: " + exception.toString());
        }
    }

    public SecretKey decryptKey(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, PublicKey publicKey, byte[] byArray, SecurityProvider securityProvider) throws CMSException {
        return this.decryptKey(algorithmID, algorithmID2, privateKey, publicKey, byArray, "RAW", securityProvider);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = new f(aSN1Object.getComponentAt(0)).getCertificateIdentifier();
        this.c = (byte[])aSN1Object.getComponentAt(1).getValue();
    }

    public d(CertificateIdentifier certificateIdentifier, byte[] byArray) {
        this.a = certificateIdentifier;
        this.c = byArray;
    }

    public d(CertificateIdentifier certificateIdentifier, PublicKey publicKey) {
        this.a = certificateIdentifier;
        this.b = publicKey;
    }

    public d(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public d() {
    }
}

