/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSAlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.DigestInfo;
import iaik.cms.InvalidSignatureValueException;
import iaik.cms.SecurityProvider;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.cipher.CAST128ParameterSpec;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.cipher.SecretKey;
import iaik.security.dh.DHKeyPairGenerator;
import iaik.security.dh.ESDHKEKParameterSpec;
import iaik.security.dh.ESDHKeyPairGenerator;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class IaikProvider
extends SecurityProvider {
    static /* synthetic */ Class g;
    static /* synthetic */ Class h;
    static /* synthetic */ Class e;
    static /* synthetic */ Class f;
    private boolean b;
    private double a;
    private static byte[] i;
    private static boolean j;
    private static final double d = 3.1;
    private static final String c = "IAIK";
    public static final String ALG_SIGNATURE_RAWRSA = "RawRSA";

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public byte[] wrapKey(javax.crypto.SecretKey secretKey, AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray = null;
        if (algorithmID == null) {
            throw new NullPointerException("Cannot wrap key with null key encryption algorithm!");
        }
        String string = algorithmID.getImplementationName();
        if (string != null && string.equalsIgnoreCase("PWRI-KEK")) {
            ASN1Object aSN1Object = algorithmID.getParameter();
            if (aSN1Object == null) {
                throw new InvalidAlgorithmParameterException("Cannot wrap key with PWRI_WRAP! Missing kek encryption algorihtmID parameter!");
            }
            Cipher cipher = null;
            AlgorithmID algorithmID2 = null;
            AlgorithmParameters algorithmParameters2 = null;
            try {
                algorithmID2 = new AlgorithmID(aSN1Object);
                String string2 = IaikProvider.b(algorithmID2);
                algorithmParameters2 = this.getAlgorithmParameters(algorithmID2);
                if (key != null) {
                    IaikProvider.a(key, algorithmID2);
                }
                cipher = this.getCipher(string2, 1, key, algorithmParameters2);
            }
            catch (CodingException codingException) {
                throw new InvalidAlgorithmParameterException("Invalid parameter encoding: " + codingException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmException("No implementation available for kek encryption algorithm " + algorithmID2.getAlgorithm().getName() + ". " + noSuchAlgorithmException.getMessage());
            }
            int n2 = cipher.getBlockSize();
            byte[] byArray2 = secretKey.getEncoded();
            int n3 = byArray2.length;
            int n4 = 4 + n3;
            int n5 = n2 - n4 % n2;
            int n6 = n4 + n5;
            if (n6 < 2 * n2) {
                n6 = 2 * n2;
            }
            byte[] byArray3 = new byte[n6];
            byArray3[0] = (byte)n3;
            CryptoUtils.xorBlock((byte[])i, (int)0, (byte[])byArray2, (int)0, (byte[])byArray3, (int)1, (int)3);
            System.arraycopy(byArray2, 0, byArray3, 4, n3);
            CryptoUtils.zeroBlock((byte[])byArray2);
            SecureRandom secureRandom = this.getSecureRandom();
            byte[] byArray4 = new byte[n6 - n3 - 4];
            secureRandom.nextBytes(byArray4);
            System.arraycopy(byArray4, 0, byArray3, 4 + n3, byArray4.length);
            CryptoUtils.zeroBlock((byte[])byArray4);
            byte[] byArray5 = cipher.update(byArray3);
            if (algorithmParameters2 == null) {
                algorithmParameters2 = cipher.getParameters();
                if (algorithmParameters2 != null) {
                    algorithmID2.setAlgorithmParameters(algorithmParameters2);
                    algorithmID.setParameter(algorithmID2.toASN1Object());
                } else {
                    byte[] byArray6 = cipher.getIV();
                    if (byArray6 != null) {
                        algorithmID2.setParameter((ASN1Object)new OCTET_STRING(byArray6));
                        algorithmID.setParameter(algorithmID2.toASN1Object());
                    }
                }
            }
            byArray = cipher.doFinal(byArray5);
            CryptoUtils.zeroBlock((byte[])byArray5);
        } else {
            byArray = super.wrapKey(secretKey, algorithmID, key, algorithmParameters);
        }
        return byArray;
    }

    public boolean verifySignatureFromSignedAttributes(AlgorithmID algorithmID, AlgorithmID algorithmID2, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        if (algorithmID.equals((Object)CMSAlgorithmID.rsassaPss) && algorithmID.getParameter() == null) {
            AlgorithmParameters algorithmParameters = IaikProvider.a(algorithmID2);
            algorithmID = (AlgorithmID)algorithmID.clone();
            algorithmID.setAlgorithmParameters(algorithmParameters);
        }
        return super.verifySignatureFromSignedAttributes(algorithmID, algorithmID2, publicKey, byArray, byArray2);
    }

    public boolean verifySignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PublicKey publicKey, byte[] byArray, byte[] byArray2) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        boolean bl = false;
        String string = algorithmID.getImplementationName();
        if (string == "RSA" || string.endsWith("/RSA")) {
            if (algorithmID2.getParameter() == null) {
                algorithmID2.encodeAbsentParametersAsNull(false);
            }
            byte[] byArray3 = new DigestInfo(algorithmID2, byArray).toByteArray();
            Signature signature = this.getSignature(ALG_SIGNATURE_RAWRSA, 2, (Key)publicKey);
            signature.update(byArray3);
            try {
                bl = signature.verify(byArray2);
            }
            catch (SignatureException signatureException) {
                throw new InvalidSignatureValueException(signatureException.getMessage());
            }
        } else {
            if (string.equals("RSASSA-PSS") && algorithmID.getParameter() == null) {
                AlgorithmParameters algorithmParameters = IaikProvider.a(algorithmID2);
                algorithmID = (AlgorithmID)algorithmID.clone();
                algorithmID.setAlgorithmParameters(algorithmParameters);
            }
            bl = super.verifySignatureFromHash(algorithmID, algorithmID2, publicKey, byArray, byArray2);
        }
        return bl;
    }

    public javax.crypto.SecretKey unwrapKey(byte[] byArray, AlgorithmID algorithmID, Key key, AlgorithmParameters algorithmParameters, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        javax.crypto.SecretKey secretKey = null;
        if (algorithmID == null) {
            throw new NullPointerException("Cannot wrap key with null key encryption algorithm!");
        }
        String string2 = algorithmID.getImplementationName();
        if (string2 != null && string2.equalsIgnoreCase("PWRI-KEK")) {
            byte[] byArray2;
            byte[] byArray3;
            ASN1Object aSN1Object = algorithmID.getParameter();
            if (aSN1Object == null) {
                throw new InvalidAlgorithmParameterException("Cannot wrap key with PWRI_WRAP! Missing kek encryption algorihtmID parameter!");
            }
            Cipher cipher = null;
            AlgorithmID algorithmID2 = null;
            AlgorithmParameters algorithmParameters2 = null;
            String string3 = null;
            try {
                algorithmID2 = new AlgorithmID(aSN1Object);
                string3 = IaikProvider.b(algorithmID2);
                if (key != null) {
                    IaikProvider.a(key, algorithmID2);
                }
                algorithmParameters2 = this.getAlgorithmParameters(algorithmID2);
                cipher = this.getCipher(string3, 0, (Key)null, (AlgorithmParameters)null);
            }
            catch (CodingException codingException) {
                throw new InvalidAlgorithmParameterException("Invalid parameter encoding: " + codingException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmException("No implementation available for kek encryption algorithm " + algorithmID2.getAlgorithm().getName() + ". " + noSuchAlgorithmException.getMessage());
            }
            int n2 = cipher.getBlockSize();
            byte[] byArray4 = new byte[n2];
            if (byArray.length < 2 * n2) {
                throw new InvalidKeyException("Wrapped key too short!");
            }
            System.arraycopy(byArray, byArray.length - 2 * n2, byArray4, 0, n2);
            byte[] byArray5 = null;
            try {
                cipher.init(2, key, this.setIv(algorithmParameters2, byArray4));
                byte[] byArray6 = cipher.doFinal(byArray, byArray.length - n2, n2);
                cipher.init(2, key, this.setIv(algorithmParameters2, byArray6));
                byArray3 = cipher.doFinal(byArray, 0, byArray.length - n2);
                byArray2 = new byte[byArray3.length + byArray6.length];
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                System.arraycopy(byArray6, 0, byArray2, byArray3.length, byArray6.length);
                CryptoUtils.zeroBlock((byte[])byArray3);
                CryptoUtils.zeroBlock((byte[])byArray6);
                cipher.init(2, key, algorithmParameters2);
                byArray5 = cipher.doFinal(byArray2);
                CryptoUtils.zeroBlock((byte[])byArray2);
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidKeyException("Cannot unwrap key: " + badPaddingException.toString());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidKeyException("Cannot unwrap key: " + illegalBlockSizeException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Cannot set iv for kek algorithm " + algorithmID2.getAlgorithm().getName());
            }
            int n3 = byArray5[0] & i[0];
            if (n3 > byArray5.length - 4) {
                throw new InvalidKeyException("Key Unwrap error: one byte cek len count (" + n3 + ") to great!");
            }
            byArray3 = new byte[3];
            CryptoUtils.xorBlock((byte[])i, (int)0, (byte[])byArray5, (int)1, (byte[])byArray3, (int)0, (int)3);
            if (!CryptoUtils.equalsBlock((byte[])byArray3, (int)0, (byte[])byArray5, (int)4, (int)3)) {
                throw new InvalidKeyException("Key Unwrap error: invalid key check value!");
            }
            byArray2 = new byte[n3];
            System.arraycopy(byArray5, 4, byArray2, 0, n3);
            secretKey = new SecretKey(byArray2, string);
            CryptoUtils.zeroBlock((byte[])byArray2);
            CryptoUtils.zeroBlock((byte[])byArray5);
            CryptoUtils.zeroBlock((byte[])byArray3);
        } else {
            secretKey = super.unwrapKey(byArray, algorithmID, key, algorithmParameters, string);
        }
        return secretKey;
    }

    public static void turnOffIAIKProviderVersionCheck() {
        j = false;
    }

    static Key a(Key key, AlgorithmID algorithmID) {
        block3: {
            String string;
            if (key == null || (string = key.getAlgorithm()) != null && !string.equalsIgnoreCase("RAW") || !(key instanceof SecretKey)) break block3;
            try {
                string = algorithmID.getRawImplementationName();
                if (string != null) {
                    ((SecretKey)key).setAlgorithm(string);
                }
            }
            catch (Exception exception) {}
        }
        return key;
    }

    public AlgorithmParameterSpec setIv(AlgorithmParameters algorithmParameters, byte[] byArray) throws InvalidParameterSpecException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        byte[] byArray2 = (byte[])byArray.clone();
        if (algorithmParameters != null) {
            String string = algorithmParameters.getAlgorithm().toUpperCase(Locale.US);
            if (string.equals("CAST128") || string.equals("CAST5")) {
                CAST128ParameterSpec cAST128ParameterSpec = (CAST128ParameterSpec)algorithmParameters.getParameterSpec(e != null ? e : (e = IaikProvider.b("iaik.security.cipher.CAST128ParameterSpec")));
                if (cAST128ParameterSpec != null) {
                    algorithmParameterSpec = new CAST128ParameterSpec(cAST128ParameterSpec.getKeyLength(), byArray2);
                }
            } else if (string.equals("RC2")) {
                RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameters.getParameterSpec(h != null ? h : (h = IaikProvider.b("javax.crypto.spec.RC2ParameterSpec")));
                if (rC2ParameterSpec != null) {
                    algorithmParameterSpec = new RC2ParameterSpec(rC2ParameterSpec.getEffectiveKeyBits(), byArray2);
                }
            } else if (string.equals("RC5")) {
                RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)algorithmParameters.getParameterSpec(g != null ? g : (g = IaikProvider.b("javax.crypto.spec.RC5ParameterSpec")));
                if (rC5ParameterSpec != null) {
                    algorithmParameterSpec = new RC5ParameterSpec(rC5ParameterSpec.getVersion(), rC5ParameterSpec.getRounds(), rC5ParameterSpec.getWordSize(), byArray2);
                }
            } else {
                algorithmParameterSpec = new IvParameterSpec(byArray2);
            }
        }
        if (algorithmParameterSpec == null) {
            algorithmParameterSpec = new IvParameterSpec(byArray2);
        }
        return algorithmParameterSpec;
    }

    public SecureRandom getSecureRandom() {
        SecureRandom secureRandom = this.random_;
        if (secureRandom == null) {
            secureRandom = SecRandom.getDefault();
        }
        return secureRandom;
    }

    public Key getPBEKey(char[] cArray, AlgorithmID algorithmID) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (algorithmID.equals((Object)AlgorithmID.pbeWithMD5AndDES_CBC)) {
            return new PBEKey(cArray);
        }
        if (algorithmID.equals((Object)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithmID.equals((Object)AlgorithmID.pbeWithSHAAnd40BitRC2_CBC)) {
            return new PBEKeyBMP(cArray);
        }
        return super.getPBEKey(cArray, algorithmID);
    }

    private static String b(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        String string = algorithmID.getImplementationName();
        if (string == null) {
            throw new NoSuchAlgorithmException();
        }
        if (string.indexOf("/") == -1) {
            throw new NoSuchAlgorithmException("Cannot get kek encryption engine without mode/padding specification.");
        }
        if (!string.toUpperCase(Locale.US).endsWith("NOPADDING")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            String string4 = "NoPadding";
            string = String.valueOf(string2) + "/" + string3 + "/" + string4;
        }
        return string;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec(AlgorithmID algorithmID) throws InvalidParameterSpecException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if (algorithmID.equals((Object)CMSAlgorithmID.rsassaPss) && algorithmID.getParameter() != null) {
            try {
                AlgorithmParameters algorithmParameters = this.getAlgorithmParameters(algorithmID, "RSASSA-PSS");
                algorithmParameterSpec = algorithmParameters.getParameterSpec(f != null ? f : (f = IaikProvider.b("iaik.pkcs.pkcs1.RSAPssParameterSpec")));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidParameterSpecException("No AlgorithmParameters implementation available for RSASSA-PSS");
            }
        } else {
            algorithmParameterSpec = super.getAlgorithmParameterSpec(algorithmID);
        }
        return algorithmParameterSpec;
    }

    public ASN1Object getASN1OriginatorPublicKey(PublicKey publicKey) throws CMSException {
        ASN1Object aSN1Object = null;
        if (publicKey instanceof ESDHPublicKey) {
            try {
                aSN1Object = new SEQUENCE();
                aSN1Object.addComponent(((AlgorithmID)AlgorithmID.esdh.clone()).toASN1Object(false));
                ASN1 aSN1 = new ASN1((ASN1Object)new INTEGER(((ESDHPublicKey)publicKey).getY()));
                aSN1Object.addComponent((ASN1Object)new BIT_STRING(aSN1.toByteArray()));
            }
            catch (CodingException codingException) {
                throw new CMSException(codingException.toString());
            }
        } else {
            aSN1Object = super.getASN1OriginatorPublicKey(publicKey);
        }
        return aSN1Object;
    }

    private javax.crypto.SecretKey a(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        Object object;
        SecretKeySpec secretKeySpec = null;
        String string = algorithmID.getImplementationName();
        int n3 = n2;
        if (n3 <= 0) {
            object = string.toUpperCase(Locale.US);
            if (((String)object).equals("HMAC/SHA") || ((String)object).equals("HMAC/SHA1") || ((String)object).equals("HMAC/SHA-1") || ((String)object).equals("HMMACSHA") || ((String)object).equals("HMMACSHA1") || ((String)object).equals("HMAC/SHA256") || ((String)object).equals("HMMACSHA256") || ((String)object).equals("HMAC/SHA224") || ((String)object).equals("HMMACSHA224") || ((String)object).equals("HMAC/MD5") || ((String)object).equals("HMACMD5") || ((String)object).equals("HMAC/RIPEMD128") || ((String)object).equals("HMACRIPEMD128") || ((String)object).equals("HMAC/RIPEMD160") || ((String)object).equals("HMACRIPEMD160")) {
                n3 = 64;
            } else if (((String)object).equals("HMAC/SHA384") || ((String)object).equals("HMMACSHA384") || ((String)object).equals("HMAC/SHA512") || ((String)object).equals("HMMACSHA512")) {
                n3 = 128;
            }
        }
        if (n3 <= 0) {
            object = Mac.getInstance(string);
            n3 = ((Mac)object).getMacLength();
        }
        if (n3 <= 0) {
            throw new NoSuchAlgorithmException("No key generator available for MAC algorithm " + string);
        }
        object = new byte[n3];
        SecureRandom secureRandom = this.getSecureRandom();
        secureRandom.nextBytes((byte[])object);
        secretKeySpec = new SecretKeySpec((byte[])object, string);
        return secretKeySpec;
    }

    public KeyPair generateKeyAgreementKeyPair(AlgorithmID algorithmID, PublicKey publicKey) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        String string = publicKey.getAlgorithm();
        KeyPairGenerator keyPairGenerator = null;
        if (publicKey instanceof ESDHPublicKey) {
            block8: {
                try {
                    keyPairGenerator = this.getKeyPairGenerator(algorithmID);
                    if (!string.equalsIgnoreCase(keyPairGenerator.getAlgorithm())) {
                        throw new InvalidKeyException("Public key of other party does not match do key agreement algorithm!");
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (!algorithmID.equals((Object)AlgorithmID.ssdhKeyAgreement)) break block8;
                    try {
                        keyPairGenerator = this.getKeyPairGenerator(AlgorithmID.esdhKeyAgreement);
                    }
                    catch (Exception exception) {
                        throw noSuchAlgorithmException;
                    }
                }
            }
            ESDHKeyPairGenerator eSDHKeyPairGenerator = (ESDHKeyPairGenerator)keyPairGenerator;
            eSDHKeyPairGenerator.initialize((AlgorithmParameterSpec)((ESDHPublicKey)publicKey).getParams(), this.getSecureRandom());
            return eSDHKeyPairGenerator.generateKeyPair();
        }
        if (publicKey instanceof DHPublicKey) {
            keyPairGenerator = this.getKeyPairGenerator(algorithmID);
            if (!string.equalsIgnoreCase(keyPairGenerator.getAlgorithm())) {
                throw new InvalidKeyException("Public key of other party does not match do key agreement algorithm!");
            }
            DHKeyPairGenerator dHKeyPairGenerator = (DHKeyPairGenerator)keyPairGenerator;
            dHKeyPairGenerator.initialize((AlgorithmParameterSpec)((DHPublicKey)publicKey).getParams(), this.getSecureRandom());
            return dHKeyPairGenerator.generateKeyPair();
        }
        throw new NoSuchAlgorithmException("No implementation for algorithm " + algorithmID.getAlgorithm().getName());
    }

    public javax.crypto.SecretKey generateKey(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        byte[] byArray;
        Key key = null;
        String string = algorithmID.getImplementationName();
        if (string.toUpperCase(Locale.US).indexOf("HMAC") != -1) {
            try {
                key = this.a(algorithmID, n2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        if (key == null) {
            key = super.generateKey(algorithmID, n2);
        }
        if ((string = key.getAlgorithm()) != null && ((string = string.toUpperCase(Locale.US)).equals("DESEDE") || string.equals("3DES")) && (byArray = key.getEncoded()).length == 16) {
            byte[] byArray2 = new byte[24];
            System.arraycopy(byArray, 0, byArray2, 0, 16);
            System.arraycopy(byArray, 0, byArray2, 16, 8);
            key = new SecretKeySpec(byArray2, "DESede");
            CryptoUtils.zeroBlock((byte[])byArray);
        }
        return key;
    }

    public Key deriveKey(char[] cArray, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Key key = null;
        if (algorithmID == null) {
            throw new NullPointerException("Cannot derive key with null key derivation function!");
        }
        String string = algorithmID.getImplementationName();
        if (string != null && string.equalsIgnoreCase("PBKDF2")) {
            PBEKeyAndParameterSpec pBEKeyAndParameterSpec = null;
            ASN1Object aSN1Object = algorithmID.getParameter();
            int n2 = 32;
            int n3 = 1000;
            int n4 = 16;
            if (algorithmParameterSpec == null) {
                if (aSN1Object != null) {
                    try {
                        int n5 = 0;
                        int n6 = aSN1Object.countComponents();
                        byte[] byArray = (byte[])aSN1Object.getComponentAt(n5++).getValue();
                        int n7 = ((BigInteger)aSN1Object.getComponentAt(n5++).getValue()).intValue();
                        if (n6 > 4) {
                            throw new InvalidAlgorithmParameterException("Invalid PBKDF2 parameter encoding: Too many (" + n6 + ") components. Maximum 4 allowed!");
                        }
                        int n8 = n2;
                        while (n5 < n6) {
                            AlgorithmID algorithmID2;
                            ObjectID objectID;
                            ASN1Object aSN1Object2;
                            if ((aSN1Object2 = aSN1Object.getComponentAt(n5++)).isA(ASN.INTEGER)) {
                                n8 = ((BigInteger)aSN1Object2.getValue()).intValue();
                                continue;
                            }
                            if (!aSN1Object2.isA(ASN.SEQUENCE) || (objectID = (algorithmID2 = new AlgorithmID(aSN1Object2)).getAlgorithm()).equals((Object)AlgorithmID.hMAC_SHA1.getAlgorithm()) || objectID.equals((Object)AlgorithmID.hMAC_SHA1.getAlgorithm())) continue;
                            throw new InvalidAlgorithmParameterException("Prf algorithm " + objectID.getName() + " not supported for PBKDF2!");
                        }
                        pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(UTF8String.getUTF8EncodingFromCharArray((char[])cArray), byArray, n7, n8);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException("Invalid PBKDF2 parameter encoding: " + exception.toString());
                    }
                } else {
                    try {
                        byte[] byArray = new byte[n4];
                        SecureRandom secureRandom = this.getSecureRandom();
                        secureRandom.nextBytes(byArray);
                        pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(UTF8String.getUTF8EncodingFromCharArray((char[])cArray), byArray, n3, n2);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException("Error encoding password: " + exception.toString());
                    }
                }
            } else {
                if (algorithmParameterSpec instanceof PBEKeyAndParameterSpec) {
                    pBEKeyAndParameterSpec = (PBEKeyAndParameterSpec)algorithmParameterSpec;
                } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
                    PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                    byte[] byArray = pBEParameterSpec.getSalt();
                    int n9 = pBEParameterSpec.getIterationCount();
                    try {
                        pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(UTF8String.getUTF8EncodingFromCharArray((char[])cArray), byArray, n9, n2);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException("Error encoding password: " + exception.toString());
                    }
                }
                if (aSN1Object == null && pBEKeyAndParameterSpec != null) {
                    try {
                        aSN1Object = new SEQUENCE();
                        aSN1Object.addComponent((ASN1Object)new OCTET_STRING(pBEKeyAndParameterSpec.getSalt()));
                        aSN1Object.addComponent((ASN1Object)new INTEGER(pBEKeyAndParameterSpec.getIterationCount()));
                        aSN1Object.addComponent((ASN1Object)new INTEGER(pBEKeyAndParameterSpec.getDerivedKeyLength()));
                        algorithmID.setParameter(aSN1Object);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException("Cannot build ASN.1 parameters: " + exception.toString());
                    }
                }
            }
            if (pBEKeyAndParameterSpec != null) {
                KeyGenerator keyGenerator = this.getKeyGenerator(algorithmID, (AlgorithmParameterSpec)pBEKeyAndParameterSpec);
                key = keyGenerator.generateKey();
            }
        }
        if (key == null) {
            key = super.deriveKey(cArray, algorithmID, algorithmParameterSpec);
        }
        return key;
    }

    public javax.crypto.SecretKey decryptKey(byte[] byArray, AlgorithmID algorithmID, PrivateKey privateKey, String string) throws BadPaddingException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        String string2 = algorithmID.getImplementationName();
        if (string2 == "RSA") {
            try {
                Cipher cipher = this.getCipher("RSA/ECB/PKCS1Padding/Decrypt", 2, (Key)privateKey, (AlgorithmParameters)null);
                byArray2 = cipher.doFinal(byArray);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidKeyException("Invalid parameters: " + invalidAlgorithmParameterException.getMessage());
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new InvalidKeyException("Illegal block size: " + illegalBlockSizeException.getMessage());
            }
            return new SecretKey(byArray2, string);
        }
        return super.decryptKey(byArray, algorithmID, privateKey, string);
    }

    public javax.crypto.SecretKey createSharedKeyEncryptionKey(AlgorithmID algorithmID, PrivateKey privateKey, PublicKey publicKey, AlgorithmID algorithmID2, int n2, byte[] byArray, String string) throws InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException {
        if (algorithmID.equals((Object)AlgorithmID.esdhKeyAgreement) || algorithmID.equals((Object)AlgorithmID.ssdhKeyAgreement)) {
            ESDHKEKParameterSpec eSDHKEKParameterSpec = new ESDHKEKParameterSpec(algorithmID2.getAlgorithm(), n2);
            eSDHKEKParameterSpec.setPartyAInfo(byArray);
            KeyAgreement keyAgreement = null;
            if (algorithmID.equals((Object)AlgorithmID.ssdhKeyAgreement)) {
                AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone();
                algorithmID3.setParameter(algorithmID.getParameter());
                keyAgreement = this.getKeyAgreement(algorithmID3, privateKey, (AlgorithmParameterSpec)eSDHKEKParameterSpec);
                if (algorithmID3.getParameter() != null) {
                    algorithmID.setParameter(algorithmID3.getParameter());
                }
            } else {
                keyAgreement = this.getKeyAgreement(algorithmID, privateKey, (AlgorithmParameterSpec)eSDHKEKParameterSpec);
            }
            keyAgreement.doPhase(publicKey, true);
            return keyAgreement.generateSecret(string);
        }
        throw new NoSuchAlgorithmException("Key Agreement method " + algorithmID.getAlgorithm().getName() + " not supported!");
    }

    private static AlgorithmParameters a(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        Object object;
        RSAPssParameterSpec rSAPssParameterSpec = null;
        if (algorithmID == null) {
            rSAPssParameterSpec = new RSAPssParameterSpec();
        } else {
            object = (AlgorithmID)AlgorithmID.mgf1.clone();
            object.setParameter(algorithmID.toASN1Object());
            int n2 = Util.getDigestLength((AlgorithmID)algorithmID);
            if (n2 == 0) {
                n2 = 20;
            }
            rSAPssParameterSpec = new RSAPssParameterSpec(algorithmID, (AlgorithmID)object, n2);
            MessageDigest messageDigest = algorithmID.getMessageDigestInstance(c);
            rSAPssParameterSpec.setHashEngine(messageDigest);
            MaskGenerationAlgorithm maskGenerationAlgorithm = object.getMaskGenerationAlgorithmInstance(c);
            MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID);
            mGF1ParameterSpec.setHashEngine(messageDigest);
            try {
                maskGenerationAlgorithm.setParameters((AlgorithmParameterSpec)mGF1ParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init PSS params: " + invalidAlgorithmParameterException.toString());
            }
            rSAPssParameterSpec.setMGFEngine(maskGenerationAlgorithm);
        }
        object = null;
        try {
            object = AlgorithmParameters.getInstance("RSASSA-PSS", c);
            ((AlgorithmParameters)object).init((AlgorithmParameterSpec)rSAPssParameterSpec);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("RSA-PSS implementation of provider IAIK not available!");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new NoSuchAlgorithmException("Cannot init PSS params: " + invalidParameterSpecException.toString());
        }
        return object;
    }

    public void checkDomainParameters(PrivateKey privateKey, PublicKey publicKey) throws InvalidParameterException {
        String string = privateKey.getAlgorithm();
        if (string.equalsIgnoreCase("ESDH")) {
            ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)((ESDHPrivateKey)privateKey).getParams();
            ESDHParameterSpec eSDHParameterSpec2 = (ESDHParameterSpec)((ESDHPublicKey)publicKey).getParams();
            if (eSDHParameterSpec != null && eSDHParameterSpec2 != null && !eSDHParameterSpec.equals((Object)eSDHParameterSpec2)) {
                throw new InvalidParameterException("Different domain parameters for ESDH!");
            }
        } else {
            super.checkDomainParameters(privateKey, publicKey);
        }
    }

    public byte[] calculateSignatureFromSignedAttributes(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, byte[] byArray) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        if (algorithmID.equals((Object)CMSAlgorithmID.rsassaPss) && algorithmID.getParameter() == null) {
            AlgorithmParameters algorithmParameters = IaikProvider.a(algorithmID2);
            algorithmID.setAlgorithmParameters(algorithmParameters);
        }
        return super.calculateSignatureFromSignedAttributes(algorithmID, algorithmID2, privateKey, byArray);
    }

    public byte[] calculateSignatureFromHash(AlgorithmID algorithmID, AlgorithmID algorithmID2, PrivateKey privateKey, byte[] byArray) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2 = null;
        String string = algorithmID.getImplementationName();
        if (string == "RSA" || string.endsWith("/RSA")) {
            DigestInfo digestInfo = new DigestInfo(algorithmID2, byArray);
            byte[] byArray3 = digestInfo.toByteArray();
            Signature signature = this.getSignature(ALG_SIGNATURE_RAWRSA, 1, (Key)privateKey);
            signature.update(byArray3);
            byArray2 = signature.sign();
        } else {
            if (string.equals("RSASSA-PSS") && algorithmID.getParameter() == null) {
                AlgorithmParameters algorithmParameters = IaikProvider.a(algorithmID2);
                algorithmID.setAlgorithmParameters(algorithmParameters);
            }
            byArray2 = super.calculateSignatureFromHash(algorithmID, algorithmID2, privateKey, byArray);
        }
        return byArray2;
    }

    public IaikProvider() {
        super(c);
        Provider provider;
        if (Security.getProvider(c) == null) {
            IAIK.addAsJDK14Provider((boolean)false);
        }
        if ((provider = Security.getProvider(c)) == null) {
            String string = "Could not add IAIK provider!";
            System.err.println(string);
            throw new RuntimeException(string);
        }
        if (j) {
            this.a = provider.getVersion();
            if (this.a < 3.0999) {
                System.err.println();
                System.err.println("WARNING: This version of IAIK-CMS should only be used with IAIK JCE");
                System.err.println("WARNING: version " + 3.1 + " and later! You are using IAIK JCE " + this.a + ".");
                System.err.println();
            }
        }
    }

    static {
        j = true;
        i = new byte[]{-1, -1, -1};
    }
}

