/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class RIFFWriter
extends OutputStream {
    private int chunktype = 0;
    private RandomAccessWriter raf;
    private long chunksizepointer;
    private long startpointer;
    private RIFFWriter childchunk = null;
    private boolean open = true;
    private boolean writeoverride = false;

    public RIFFWriter(String string, String string2) throws IOException {
        this(new RandomAccessFileWriter(string), string2, 0);
    }

    public RIFFWriter(File file, String string) throws IOException {
        this(new RandomAccessFileWriter(file), string, 0);
    }

    public RIFFWriter(OutputStream outputStream, String string) throws IOException {
        this(new RandomAccessByteWriter(outputStream), string, 0);
    }

    private RIFFWriter(RandomAccessWriter randomAccessWriter, String string, int n) throws IOException {
        if (n == 0 && randomAccessWriter.length() != 0L) {
            randomAccessWriter.setLength(0L);
        }
        this.raf = randomAccessWriter;
        if (randomAccessWriter.getPointer() % 2L != 0L) {
            randomAccessWriter.write(0);
        }
        if (n == 0) {
            randomAccessWriter.write("RIFF".getBytes("ascii"));
        } else if (n == 1) {
            randomAccessWriter.write("LIST".getBytes("ascii"));
        } else {
            randomAccessWriter.write((string + "    ").substring(0, 4).getBytes("ascii"));
        }
        this.chunksizepointer = randomAccessWriter.getPointer();
        this.chunktype = 2;
        this.writeUnsignedInt(0L);
        this.chunktype = n;
        this.startpointer = randomAccessWriter.getPointer();
        if (n != 2) {
            randomAccessWriter.write((string + "    ").substring(0, 4).getBytes("ascii"));
        }
    }

    public void seek(long l) throws IOException {
        this.raf.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getPointer();
    }

    public void setWriteOverride(boolean bl) {
        this.writeoverride = bl;
    }

    public boolean getWriteOverride() {
        return this.writeoverride;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        int n = this.chunktype;
        long l = this.raf.getPointer();
        this.raf.seek(this.chunksizepointer);
        this.chunktype = 2;
        this.writeUnsignedInt(l - this.startpointer);
        if (n == 0) {
            this.raf.close();
        } else {
            this.raf.seek(l);
        }
        this.open = false;
        this.raf = null;
    }

    @Override
    public void write(int n) throws IOException {
        if (!this.writeoverride) {
            if (this.chunktype != 2) {
                throw new IllegalArgumentException("Only chunks can write bytes!");
            }
            if (this.childchunk != null) {
                this.childchunk.close();
                this.childchunk = null;
            }
        }
        this.raf.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.writeoverride) {
            if (this.chunktype != 2) {
                throw new IllegalArgumentException("Only chunks can write bytes!");
            }
            if (this.childchunk != null) {
                this.childchunk.close();
                this.childchunk = null;
            }
        }
        this.raf.write(byArray, n, n2);
    }

    public RIFFWriter writeList(String string) throws IOException {
        if (this.chunktype == 2) {
            throw new IllegalArgumentException("Only LIST and RIFF can write lists!");
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        this.childchunk = new RIFFWriter(this.raf, string, 1);
        return this.childchunk;
    }

    public RIFFWriter writeChunk(String string) throws IOException {
        if (this.chunktype == 2) {
            throw new IllegalArgumentException("Only LIST and RIFF can write chunks!");
        }
        if (this.childchunk != null) {
            this.childchunk.close();
            this.childchunk = null;
        }
        this.childchunk = new RIFFWriter(this.raf, string, 2);
        return this.childchunk;
    }

    public void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this.write(byArray);
    }

    public void writeString(String string, int n) throws IOException {
        byte[] byArray = string.getBytes();
        if (byArray.length > n) {
            this.write(byArray, 0, n);
        } else {
            this.write(byArray);
            for (int i = byArray.length; i < n; ++i) {
                this.write(0);
            }
        }
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void writeShort(short s) throws IOException {
        this.write(s >>> 0 & 0xFF);
        this.write(s >>> 8 & 0xFF);
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 0 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 24 & 0xFF);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l >>> 0) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 56) & 0xFF);
    }

    public void writeUnsignedByte(int n) throws IOException {
        this.writeByte((byte)n);
    }

    public void writeUnsignedShort(int n) throws IOException {
        this.writeShort((short)n);
    }

    public void writeUnsignedInt(long l) throws IOException {
        this.writeInt((int)l);
    }

    private static class RandomAccessByteWriter
    implements RandomAccessWriter {
        byte[] buff = new byte[32];
        int length = 0;
        int pos = 0;
        byte[] s;
        OutputStream stream;

        public RandomAccessByteWriter(OutputStream outputStream) {
            this.stream = outputStream;
        }

        @Override
        public void seek(long l) throws IOException {
            this.pos = (int)l;
        }

        @Override
        public long getPointer() throws IOException {
            return this.pos;
        }

        @Override
        public void close() throws IOException {
            this.stream.write(this.buff, 0, this.length);
            this.stream.close();
        }

        @Override
        public void write(int n) throws IOException {
            if (this.s == null) {
                this.s = new byte[1];
            }
            this.s[0] = (byte)n;
            this.write(this.s, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.pos + n2;
            if (n3 > this.length) {
                this.setLength(n3);
            }
            int n4 = n + n2;
            for (int i = n; i < n4; ++i) {
                this.buff[this.pos++] = byArray[i];
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public long length() throws IOException {
            return this.length;
        }

        @Override
        public void setLength(long l) throws IOException {
            this.length = (int)l;
            if (this.length > this.buff.length) {
                int n = Math.max(this.buff.length << 1, this.length);
                byte[] byArray = new byte[n];
                System.arraycopy(this.buff, 0, byArray, 0, this.buff.length);
                this.buff = byArray;
            }
        }
    }

    private static class RandomAccessFileWriter
    implements RandomAccessWriter {
        RandomAccessFile raf;

        public RandomAccessFileWriter(File file) throws FileNotFoundException {
            this.raf = new RandomAccessFile(file, "rw");
        }

        public RandomAccessFileWriter(String string) throws FileNotFoundException {
            this.raf = new RandomAccessFile(string, "rw");
        }

        @Override
        public void seek(long l) throws IOException {
            this.raf.seek(l);
        }

        @Override
        public long getPointer() throws IOException {
            return this.raf.getFilePointer();
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public void write(int n) throws IOException {
            this.raf.write(n);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.raf.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.raf.write(byArray);
        }

        @Override
        public long length() throws IOException {
            return this.raf.length();
        }

        @Override
        public void setLength(long l) throws IOException {
            this.raf.setLength(l);
        }
    }

    private static interface RandomAccessWriter {
        public void seek(long var1) throws IOException;

        public long getPointer() throws IOException;

        public void close() throws IOException;

        public void write(int var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        public void write(byte[] var1) throws IOException;

        public long length() throws IOException;

        public void setLength(long var1) throws IOException;
    }
}

