/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class PluginPrerequisite
implements IPluginPrerequisite {
    private static final Version maxVersion = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private BundleSpecification prereq = null;

    public PluginPrerequisite(BundleSpecification b) {
        this.prereq = b;
    }

    public PluginVersionIdentifier getResolvedVersionIdentifier() {
        Version actualVersion = this.prereq.getSupplier().getVersion();
        if (actualVersion == null) {
            return null;
        }
        return new PluginVersionIdentifier(actualVersion.toString());
    }

    public String getUniqueIdentifier() {
        return this.prereq.getName();
    }

    public PluginVersionIdentifier getVersionIdentifier() {
        Version specifiedVersion;
        Version version = specifiedVersion = this.prereq.getVersionRange() == null ? null : this.prereq.getVersionRange().getMinimum();
        if (specifiedVersion == null) {
            return null;
        }
        return new PluginVersionIdentifier(specifiedVersion.toString());
    }

    public boolean isExported() {
        return this.prereq.isExported();
    }

    public boolean isMatchedAsGreaterOrEqual() {
        return PluginPrerequisite.isMatchedAsGreaterOrEqual(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsCompatible() {
        return PluginPrerequisite.isMatchedAsCompatible(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsEquivalent() {
        return PluginPrerequisite.isMatchedAsEquivalent(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsPerfect() {
        return PluginPrerequisite.isMatchedAsPerfect(this.prereq.getVersionRange());
    }

    public boolean isMatchedAsExact() {
        return this.isMatchedAsEquivalent();
    }

    public boolean isOptional() {
        return this.prereq.isOptional();
    }

    private static boolean isMatchedAsGreaterOrEqual(VersionRange versionRange) {
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version maximum = versionRange.getMaximum();
        return maximum == null || maximum.compareTo(maxVersion) >= 0;
    }

    private static boolean isMatchedAsPerfect(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? maxVersion : versionRange.getMaximum();
        return minimum.equals((Object)maximum);
    }

    private static boolean isMatchedAsEquivalent(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? maxVersion : versionRange.getMaximum();
        if (!versionRange.getIncludeMinimum() || versionRange.getIncludeMaximum()) {
            return false;
        }
        if (minimum.getMajor() == maximum.getMajor() - 1) {
            return false;
        }
        if (minimum.getMajor() != maximum.getMajor()) {
            return false;
        }
        return minimum.getMinor() == maximum.getMinor() - 1;
    }

    private static boolean isMatchedAsCompatible(VersionRange versionRange) {
        Version maximum;
        if (versionRange == null || versionRange.getMinimum() == null) {
            return false;
        }
        Version minimum = versionRange.getMinimum();
        Version version = maximum = versionRange.getMaximum() == null ? maxVersion : versionRange.getMaximum();
        if (!versionRange.getIncludeMinimum() || versionRange.getIncludeMaximum()) {
            return false;
        }
        return minimum.getMajor() == maximum.getMajor() - 1;
    }
}

