// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.0.0 (2010/01/01)

#ifndef WM5IMAGICS_H
#define WM5IMAGICS_H

// BinaryOperations
#include "Wm5Binary2D.h"
#include "Wm5Binary3D.h"

// Extraction
#include "Wm5ExtractCurveSquares.h"
#include "Wm5ExtractCurveTris.h"
#include "Wm5ExtractSurfaceCubes.h"
#include "Wm5ExtractSurfaceTetra.h"

// Filters
#include "Wm5CurvatureFlow2.h"
#include "Wm5CurvatureFlow3.h"
#include "Wm5GaussianBlur2.h"
#include "Wm5GaussianBlur3.h"
#include "Wm5GradientAnisotropic2.h"
#include "Wm5GradientAnisotropic3.h"
#include "Wm5FastBlur.h"
#include "Wm5PdeFilter.h"
#include "Wm5PdeFilter2.h"
#include "Wm5PdeFilter3.h"

// Images
#include "Wm5Element.h"
#include "Wm5ImageConvert.h"
#include "Wm5Images.h"
#include "Wm5Lattice.h"
#include "Wm5TImage.h"
#include "Wm5TImage2D.h"
#include "Wm5TImage3D.h"

// RasterDrawing
#include "Wm5RasterDrawing.h"

// Segmenters
#include "Wm5FastMarch.h"
#include "Wm5FastMarch2.h"
#include "Wm5FastMarch3.h"

#endif
