static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_newsprint_pattern2)                                          \n"
"  enum_value (GEGL_NEWSPRINT_PATTERN2_LINE,     \"line\",     N_(\"Line\"))   \n"
"  enum_value (GEGL_NEWSPRINT_PATTERN2_CIRCLE,   \"circle\",   N_(\"Circle\")) \n"
"  enum_value (GEGL_NEWSPRINT_PATTERN2_DIAMOND,  \"diamond\",  N_(\"Diamond\"))\n"
"  enum_value (GEGL_NEWSPRINT_PATTERN2_PSCIRCLE, \"pssquare\", N_(\"PSSquare (or Euclidian) dot\"))\n"
"  enum_value (GEGL_NEWSPRINT_PATTERN2_CROSS,    \"cross\",    N_(\"Orthogonal Lines\"))\n"
"enum_end (GeglNewsprintPattern2)                                              \n"
"                                                                              \n"
"enum_start (gegl_newsprint_color_model2)                                      \n"
"  enum_value (GEGL_NEWSPRINT_COLOR_MODEL2_WHITE_ON_BLACK, \"white-on-black\", N_(\"White on Black\"))\n"
"  enum_value (GEGL_NEWSPRINT_COLOR_MODEL2_BLACK_ON_WHITE, \"black-on-white\", N_(\"Black on White\"))\n"
"  enum_value (GEGL_NEWSPRINT_COLOR_MODEL2_RGB,  \"rgb\",      N_(\"RGB\"))    \n"
"  enum_value (GEGL_NEWSPRINT_COLOR_MODEL2_CMYK, \"cmyk\",     N_(\"CMYK\"))   \n"
"enum_end (GeglNewsprintColorModel2)                                           \n"
"                                                                              \n"
"property_enum (color_model, _(\"Color Model\"),                               \n"
"              GeglNewsprintColorModel2, gegl_newsprint_color_model2, GEGL_NEWSPRINT_COLOR_MODEL2_BLACK_ON_WHITE)\n"
"              description (_(\"How many inks to use just black, rg, rgb(additive) or cmyk\"))\n"
"                                                                              \n"
"property_enum (pattern, _(\"Pattern\"),                                       \n"
"              GeglNewsprintPattern2, gegl_newsprint_pattern2, GEGL_NEWSPRINT_PATTERN2_LINE)\n"
"              description (_(\"halftoning/dot pattern to use\"))              \n"
"                                                                              \n"
"property_double (period, _(\"Period\"), 12.0)                                 \n"
"                 value_range (0.0, 200.0)                                     \n"
"                                                                              \n"
"property_double (turbulence, _(\"Turbulence\"), 0.0)                          \n"
"                 value_range (0.0, 1.0)  // rename to wave-pinch or period-pinch?\n"
"                 description (_(\"\"))                                        \n"
"                                                                              \n"
"property_double (blocksize, _(\"Blocksize\"), -1.0)                           \n"
"                 value_range (-1.0, 64.0)                                     \n"
"                 description (_(\"number of periods per tile, this tiling avoids high frequency anomaly that angleboost causes\"))\n"
"                                                                              \n"
"property_double (angleboost, _(\"Angleboost\"), 0.0)                          \n"
"                 value_range (0.0, 4.0)                                       \n"
"                 description (_(\"multiplication factor for desired rotation of the local space for texture, the way this is computed makes it weak for desaturated colors and possibly stronger where there is color.\"))\n"
"                                                                              \n"
"property_double (twist, _(\"Black and green angle\"), 75.0)                   \n"
"                 value_range (-180.0, 180.0)                                  \n"
"                 ui_meta (\"unit\", \"degree\")                               \n"
"                 description (_(\"angle offset for patterns\"))               \n"
"                                                                              \n"
"property_double (twist2, _(\"Red and cyan angle\"), 15.0)                     \n"
"                 value_range (-180.0, 180.0)                                  \n"
"                 ui_meta (\"unit\", \"degree\")                               \n"
"                                                                              \n"
"property_double (twist3, _(\"Blue and magenta angle\"), 45.0)                 \n"
"                 value_range (-180.0, 180.0)                                  \n"
"                 ui_meta (\"unit\", \"degree\")                               \n"
"                                                                              \n"
"property_double (twist4, _(\"Yellow angle\"), 0.0)                            \n"
"                 value_range (-180.0, 180.0)                                  \n"
"                 ui_meta (\"unit\", \"degree\")                               \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     newsprint2                                           \n"
"#define GEGL_OP_C_SOURCE newsprint2.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"CIE LCH(ab) float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static inline float dmodf(float x, float y)                                   \n"
"{                                                                             \n"
"  return x - y * floorf(x/y);                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#define fmodf dmodf                                                           \n"
"                                                                              \n"
"/* for details and more liberal licensing of the following function, see      \n"
"   https://pippin.gimp.org/spachrotyzer/ */                                   \n"
"                                                                              \n"
"static                                                                        \n"
"float spachrotyze (                                                           \n"
"    float x,                                                                  \n"
"    float y,                                                                  \n"
"    float part_white,                                                         \n"
"    float offset,                                                             \n"
"    float hue,                                                                \n"
"    int   pattern,                                                            \n"
"    float period,                                                             \n"
"    float turbulence,                                                         \n"
"    float blocksize,                                                          \n"
"    float angleboost,                                                         \n"
"    float twist)                                                              \n"
"{                                                                             \n"
"  int max_aa_samples = 16;                                                    \n"
"  float acc = 0.0;                                                            \n"
"                                                                              \n"
"  float angle  = 3.1415 / 2- ((hue * angleboost) + twist);                    \n"
"                                                                              \n"
"  float width  = (period * (1.0 - turbulence) +                               \n"
"                 (period * offset) * turbulence);                             \n"
"                                                                              \n"
"  float vec0 = cosf (angle);                                                  \n"
"  float vec1 = sinf (angle);                                                  \n"
"                                                                              \n"
"  float xi = 0.5;                                                             \n"
"  float yi = 0.2;                                                             \n"
"  int count = 0;                                                              \n"
"  int in = 0;                                                                 \n"
"  float old_acc = 0.0;                                                        \n"
"                                                                              \n"
"  x += period * 2;                                                            \n"
"  y += period * 2;                                                            \n"
"                                                                              \n"
"  for (int i = 0; i < max_aa_samples ; i++)                                   \n"
"  {                                                                           \n"
"    xi = fmodf (xi + 0.618033988749854, 1.0);                                 \n"
"    yi = fmodf (yi + (0.618033988749854/1.61235), 1.0);                       \n"
"                                                                              \n"
"    old_acc = acc;                                                            \n"
"    {                                                                         \n"
"      float u = fmodf (x + xi - 0.5 * width, blocksize * width);              \n"
"      float v = fmodf (y + yi - 0.5 * width, blocksize * width);              \n"
"                                                                              \n"
"      float w = vec0 * u + vec1 * v;                                          \n"
"      float q = vec1 * u - vec0 * v;                                          \n"
"                                                                              \n"
"      float wperiod = fmodf (w, width);                                       \n"
"      float wphase  = (wperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      float qperiod = fmodf (q, width);                                       \n"
"      float qphase  = (qperiod / width) * 2.0 - 1.0;                          \n"
"                                                                              \n"
"      if (pattern == 0)       /* line */                                      \n"
"      {                                                                       \n"
"        if (fabsf (wphase) < part_white)                                      \n"
"          in ++;                                                              \n"
"      }                                                                       \n"
"      else if (pattern == 1) /* dot */                                        \n"
"      {                                                                       \n"
"        if (qphase * qphase + wphase * wphase <                               \n"
"          part_white * part_white * 2.0)                                      \n"
"          in ++;                                                              \n"
"      }                                                                       \n"
"      else if (pattern == 2) /* diamond */                                    \n"
"      {                                                                       \n"
"        if ((fabsf(wphase) + fabsf(qphase))/2.0 < part_white )                \n"
"          in++;                                                               \n"
"      }                                                                       \n"
"      else if (pattern == 3) /* dot-to-diamond-to-dot */                      \n"
"      {                                                                       \n"
"        float ax = fabsf (wphase ) ;                                          \n"
"        float ay = fabsf (qphase ) ;                                          \n"
"        float v = 0.0;                                                        \n"
"                                                                              \n"
"        if  (ax + ay > 1.0)                                                   \n"
"        {                                                                     \n"
"          ay = 1.0 - ay;                                                      \n"
"          ax = 1.0 - ax;                                                      \n"
"          v = 2.0 - sqrtf (ay * ay + ax * ax);                                \n"
"        }                                                                     \n"
"        else                                                                  \n"
"        {                                                                     \n"
"          v = sqrtf (ay * ay + ax * ax);                                      \n"
"        }                                                                     \n"
"        v/=2.0;                                                               \n"
"        if (v < part_white)                                                   \n"
"          in++;                                                               \n"
"      }                                                                       \n"
"      else if (pattern == 4) /* cross */                                      \n"
"      {                                                                       \n"
"        float part_white2 = powf (part_white, 2.0);                           \n"
"        if (fabsf (wphase) < part_white2 ||                                   \n"
"            fabsf (qphase) < part_white2)                                     \n"
"          in++;                                                               \n"
"      }                                                                       \n"
"      count ++;                                                               \n"
"                                                                              \n"
"      acc = in * 1.0/ count;                                                  \n"
"      if (i > 3 &&                                                            \n"
"          fabs (acc - old_acc) < 0.23)                                        \n"
"        break;                                                                \n"
"      old_acc = acc;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  }                                                                           \n"
"  return acc;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static inline double degrees_to_radians (double degrees)                      \n"
"{                                                                             \n"
"  return degrees * (2 * G_PI / 360.0);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat     *in_pixel = in_buf;                                              \n"
"  gfloat     *out_pixel = out_buf;                                            \n"
"                                                                              \n"
"  gint        x = roi->x; /* initial x         */                             \n"
"  gint        y = roi->y; /* and y coordinates */                             \n"
"  gfloat blocksize = o->blocksize;                                            \n"
"  if (blocksize < 0.0)                                                        \n"
"    blocksize = 819200.0;                                                     \n"
"                                                                              \n"
"  switch (o->color_model)                                                     \n"
"  {                                                                           \n"
"    case GEGL_NEWSPRINT_COLOR_MODEL2_WHITE_ON_BLACK:                          \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           float luminance  = in_pixel[0] / 100.0;                            \n"
"           float chroma     = in_pixel[1] / 100.0;                            \n"
"           float angle      = in_pixel[2] / 360.0;                            \n"
"                                                                              \n"
"           float gray = spachrotyze (x, y,                                    \n"
"                                    luminance, chroma, angle,                 \n"
"                                    o->pattern,                               \n"
"                                    o->period / (1.0*(1<<level)),             \n"
"                                    o->turbulence,                            \n"
"                                    blocksize,                                \n"
"                                    o->angleboost,                            \n"
"                                    degrees_to_radians (o->twist));           \n"
"                                                                              \n"
"           for (int c = 0; c < 3; c++)                                        \n"
"             out_pixel[c] = gray;                                             \n"
"           out_pixel[3] = 1.0;                                                \n"
"                                                                              \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 3;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"    case GEGL_NEWSPRINT_COLOR_MODEL2_BLACK_ON_WHITE:                          \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           float luminance  = in_pixel[0] / 100.0;                            \n"
"           float chroma     = in_pixel[1] / 100.0;                            \n"
"           float angle      = in_pixel[2] / 360.0;                            \n"
"                                                                              \n"
"           float gray = 1.0-spachrotyze (x, y,                                \n"
"                                    1.0-luminance, chroma, angle,             \n"
"                                    o->pattern,                               \n"
"                                    o->period / (1.0*(1<<level)),             \n"
"                                    o->turbulence,                            \n"
"                                    blocksize,                                \n"
"                                    o->angleboost,                            \n"
"                                    degrees_to_radians (o->twist));           \n"
"                                                                              \n"
"           for (int c = 0; c < 3; c++)                                        \n"
"             out_pixel[c] = gray;                                             \n"
"           out_pixel[3] = 1.0;                                                \n"
"                                                                              \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 3;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"    case GEGL_NEWSPRINT_COLOR_MODEL2_RGB:                                     \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           float pinch      = in_pixel[1] / 100.0;                            \n"
"           float angle      = in_pixel[2] / 360.0;                            \n"
"                                                                              \n"
"           out_pixel[0] = spachrotyze (x, y,                                  \n"
"                                       in_pixel[0], pinch, angle,             \n"
"                                       o->pattern,                            \n"
"                                       o->period / (1.0*(1<<level)),          \n"
"                                       o->turbulence,                         \n"
"                                       blocksize,                             \n"
"                                       o->angleboost,                         \n"
"                                       degrees_to_radians (o->twist2));       \n"
"                                                                              \n"
"           out_pixel[1] = spachrotyze (x, y,                                  \n"
"                                       in_pixel[1], pinch, angle,             \n"
"                                       o->pattern,                            \n"
"                                       o->period / (1.0*(1<<level)),          \n"
"                                       o->turbulence,                         \n"
"                                       blocksize,                             \n"
"                                       o->angleboost,                         \n"
"                                       degrees_to_radians (o->twist));        \n"
"                                                                              \n"
"           out_pixel[2] = spachrotyze (x, y,                                  \n"
"                                   in_pixel[2], pinch, angle,                 \n"
"                                   o->pattern,                                \n"
"                                   o->period / (1.0*(1<<level)),              \n"
"                                   o->turbulence,                             \n"
"                                   blocksize,                                 \n"
"                                   o->angleboost,                             \n"
"                                   degrees_to_radians (o->twist3));           \n"
"           out_pixel[3] = 1.0;                                                \n"
"                                                                              \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 3;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"    case GEGL_NEWSPRINT_COLOR_MODEL2_CMYK:                                    \n"
"       while (n_pixels--)                                                     \n"
"         {                                                                    \n"
"           float pinch = fabs(in_pixel[0]-in_pixel[1]);                       \n"
"           float angle = fabs(in_pixel[2]-in_pixel[1]);                       \n"
"           float c = 1.0  - in_pixel[0];                                      \n"
"           float m = 1.0  - in_pixel[1];                                      \n"
"           float iy = 1.0 - in_pixel[2];                                      \n"
"           float k = 1.0;                                                     \n"
"                                                                              \n"
"           if (c < k) k = c;                                                  \n"
"           if (m < k) k = m;                                                  \n"
"           if (y < k) k = y;                                                  \n"
"                                                                              \n"
"           k = k * 0.40; /* black pull out */                                 \n"
"                                                                              \n"
"           if (k < 1.0)                                                       \n"
"           {                                                                  \n"
"             c = (c - k) / (1.0 - k);                                         \n"
"             m = (m - k) / (1.0 - k);                                         \n"
"             iy = (iy - k) / (1.0 - k);                                       \n"
"           }                                                                  \n"
"           else /* wont happen with 0.40 pullout */                           \n"
"           {                                                                  \n"
"             c = m = iy = 1.0;                                                \n"
"           }                                                                  \n"
"                                                                              \n"
"           c = spachrotyze (x, y,                                             \n"
"                            c, pinch, angle,                                  \n"
"                            o->pattern,                                       \n"
"                            o->period / (1.0*(1<<level)),                     \n"
"                            o->turbulence,                                    \n"
"                            blocksize,                                        \n"
"                            o->angleboost,                                    \n"
"                            degrees_to_radians (o->twist2));                  \n"
"                                                                              \n"
"           m = spachrotyze (x, y,                                             \n"
"                            m, pinch, angle,                                  \n"
"                            o->pattern,                                       \n"
"                            o->period / (1.0*(1<<level)),                     \n"
"                            o->turbulence,                                    \n"
"                            blocksize,                                        \n"
"                            o->angleboost,                                    \n"
"                            degrees_to_radians (o->twist3));                  \n"
"                                                                              \n"
"           iy = spachrotyze (x, y,                                            \n"
"                             iy, pinch, angle,                                \n"
"                             o->pattern,                                      \n"
"                             o->period / (1.0*(1<<level)),                    \n"
"                             o->turbulence,                                   \n"
"                             blocksize,                                       \n"
"                             o->angleboost,                                   \n"
"                             degrees_to_radians (o->twist4));                 \n"
"                                                                              \n"
"           k = spachrotyze (x, y,                                             \n"
"                            k, pinch, angle,                                  \n"
"                            o->pattern,                                       \n"
"                            o->period / (1.0*(1<<level)),                     \n"
"                            o->turbulence,                                    \n"
"                            blocksize,                                        \n"
"                            o->angleboost,                                    \n"
"                            degrees_to_radians (o->twist));                   \n"
"                                                                              \n"
"           if (k < 1.0) {                                                     \n"
"             c = c * (1.0 - k) + k;                                           \n"
"             m = m * (1.0 - k) + k;                                           \n"
"             iy= iy* (1.0 - k) + k;                                           \n"
"           } else {                                                           \n"
"             c = 1.0; iy = 1.0; m = 1.0;                                      \n"
"           }                                                                  \n"
"           out_pixel[0] = 1.0 - c;                                            \n"
"           out_pixel[1] = 1.0 - m;                                            \n"
"           out_pixel[2] = 1.0 - iy;                                           \n"
"           out_pixel[3] = in_pixel[3];                                        \n"
"           out_pixel += 4;                                                    \n"
"           in_pixel  += 3;                                                    \n"
"                                                                              \n"
"           /* update x and y coordinates */                                   \n"
"           x++; if (x>=roi->x + roi->width) { x=roi->x; y++; }                \n"
"         }                                                                    \n"
"       break;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"#include \"opencl/spachrotyze.cl.h\"                                          \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"/* OpenCL processing function */                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            int                  level)                                       \n"
"{                                                                             \n"
"  const size_t  gbl_size[2] = {roi->width, roi->height};                      \n"
"  const size_t  gbl_offs[2] = {roi->x, roi->y};                               \n"
"                                                                              \n"
"  GeglProperties   *o  = GEGL_PROPERTIES (op);                                \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"gegl_spachrotyzer\", NULL};              \n"
"      cl_data = gegl_cl_compile_and_build (spachrotyzer_cl_source, kernel_name);\n"
"    }                                                                         \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"  {                                                                           \n"
"    g_warning (\"cl fail\\n\");                                               \n"
"    CL_CHECK;                                                                 \n"
"    return 1;                                                                 \n"
"  }                                                                           \n"
"                                                                              \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (void*)&out_tex);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_int),   (void*)&o->pattern);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&o->period);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float), (void*)&o->turbulence);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 5, sizeof(cl_float), (void*)&o->blocksize);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 6, sizeof(cl_float), (void*)&o->angleboost);\n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clSetKernelArg(cl_data->kernel[0], 7, sizeof(cl_float), (void*)&o->twist);\n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        gbl_offs, gbl_size, NULL,             \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"                                                                              \n"
"error:                                                                        \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"  operation_class->prepare = prepare;                                         \n"
"#if 0                                                                         \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"#endif                                                                        \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:newsprint2\",                              \n"
"    \"title\",              _(\"Spachrotyzer\"),                              \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\" ,        \"render\",                                       \n"
"    \"reference-hash\",     \"f1ccafd42562aa0de7daeaade1a3d171\",             \n"
"    \"description\",        _(\"Digital halftoning with optional modulations. \"),\n"
"    \"position-dependent\", \"true\",                                         \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
