static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Author: Karl-Johan Andersson <t96kja@student.tdb.uu.se>                    \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (pos_x, _(\"X position\"), 0.5)                               \n"
"  description (_(\"X coordinates of the flare center\"))                      \n"
"  ui_range (0.0, 1.0)                                                         \n"
"  ui_meta  (\"unit\", \"relative-coordinate\")                                \n"
"  ui_meta  (\"axis\", \"x\")                                                  \n"
"                                                                              \n"
"property_double (pos_y, _(\"Y position\"), 0.5)                               \n"
"  description (_(\"Y coordinates of the flare center\"))                      \n"
"  ui_range (0.0, 1.0)                                                         \n"
"  ui_meta  (\"unit\", \"relative-coordinate\")                                \n"
"  ui_meta  (\"axis\", \"y\")                                                  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     lens_flare                                           \n"
"#define GEGL_OP_C_SOURCE lens-flare.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define NUMREF 19                                                             \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gdouble ccol[3];                                                            \n"
"  gfloat  size;                                                               \n"
"  gint    xp;                                                                 \n"
"  gint    yp;                                                                 \n"
"  gint    type;                                                               \n"
"} Reflect;                                                                    \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  Reflect ref[NUMREF];                                                        \n"
"  gdouble color[3];                                                           \n"
"  gdouble glow[3];                                                            \n"
"  gdouble inner[3];                                                           \n"
"  gdouble outer[3];                                                           \n"
"  gdouble halo[3];                                                            \n"
"  gfloat color_size;                                                          \n"
"  gfloat glow_size;                                                           \n"
"  gfloat inner_size;                                                          \n"
"  gfloat outer_size;                                                          \n"
"  gfloat halo_size;                                                           \n"
"  gint center_x;                                                              \n"
"  gint center_y;                                                              \n"
"} LfParamsType;                                                               \n"
"                                                                              \n"
"static inline void                                                            \n"
"fixpix (gfloat  *pixel,                                                       \n"
"        gfloat   procent,                                                     \n"
"        gdouble *colpro)                                                      \n"
"{                                                                             \n"
"  pixel[0] += (1.0 - pixel[0]) * procent * colpro[0];                         \n"
"  pixel[1] += (1.0 - pixel[1]) * procent * colpro[1];                         \n"
"  pixel[2] += (1.0 - pixel[2]) * procent * colpro[2];                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"init_params (LfParamsType   *params,                                          \n"
"             GeglProperties *o)                                               \n"
"{                                                                             \n"
"  Reflect *ref1 = params->ref;                                                \n"
"                                                                              \n"
"  params->color[0] = 0.937255;                                                \n"
"  params->color[1] = 0.937255;                                                \n"
"  params->color[2] = 0.937255;                                                \n"
"  params->glow[0] = 0.960784;                                                 \n"
"  params->glow[1] = 0.960784;                                                 \n"
"  params->glow[2] = 0.960784;                                                 \n"
"  params->inner[0] = 1.0;                                                     \n"
"  params->inner[1] = 0.149020;                                                \n"
"  params->inner[2] = 0.168627;                                                \n"
"  params->outer[0] = 0.270588;                                                \n"
"  params->outer[1] = 0.231373;                                                \n"
"  params->outer[2] = 0.250980;                                                \n"
"  params->halo[0] = 0.313726;                                                 \n"
"  params->halo[1] = 0.058824;                                                 \n"
"  params->halo[2] = 0.015686;                                                 \n"
"                                                                              \n"
"  ref1[0].type    = 1;                                                        \n"
"  ref1[0].ccol[0] = 0.0;                                                      \n"
"  ref1[0].ccol[1] = 0.054902;                                                 \n"
"  ref1[0].ccol[2] = 0.443137;                                                 \n"
"                                                                              \n"
"  ref1[1].type    = 1;                                                        \n"
"  ref1[1].ccol[0] = 0.352941;                                                 \n"
"  ref1[1].ccol[1] = 0.709804;                                                 \n"
"  ref1[1].ccol[2] = 0.556863;                                                 \n"
"                                                                              \n"
"  ref1[2].type    = 1;                                                        \n"
"  ref1[2].ccol[0] = 0.219608;                                                 \n"
"  ref1[2].ccol[1] = 0.549020;                                                 \n"
"  ref1[2].ccol[2] = 0.415686;                                                 \n"
"                                                                              \n"
"  ref1[3].type    = 2;                                                        \n"
"  ref1[3].ccol[0] = 0.035294;                                                 \n"
"  ref1[3].ccol[1] = 0.113725;                                                 \n"
"  ref1[3].ccol[2] = 0.074510;                                                 \n"
"                                                                              \n"
"  ref1[4].type    = 2;                                                        \n"
"  ref1[4].ccol[0] = 0.094118;                                                 \n"
"  ref1[4].ccol[1] = 0.054902;                                                 \n"
"  ref1[4].ccol[2] = 0.0;                                                      \n"
"                                                                              \n"
"  ref1[5].type    = 2;                                                        \n"
"  ref1[5].ccol[0] = 0.094118;                                                 \n"
"  ref1[5].ccol[1] = 0.054902;                                                 \n"
"  ref1[5].ccol[2] = 0.0;                                                      \n"
"                                                                              \n"
"  ref1[6].type    = 2;                                                        \n"
"  ref1[6].ccol[0] = 0.164706;                                                 \n"
"  ref1[6].ccol[1] = 0.074510;                                                 \n"
"  ref1[6].ccol[2] = 0.0;                                                      \n"
"                                                                              \n"
"  ref1[7].type    = 2;                                                        \n"
"  ref1[7].ccol[0] = 0.0;                                                      \n"
"  ref1[7].ccol[1] = 0.035294;                                                 \n"
"  ref1[7].ccol[2] = 0.066667;                                                 \n"
"                                                                              \n"
"  ref1[8].type    = 2;                                                        \n"
"  ref1[8].ccol[0] = 0.0;                                                      \n"
"  ref1[8].ccol[1] = 0.015686;                                                 \n"
"  ref1[8].ccol[2] = 0.039216;                                                 \n"
"                                                                              \n"
"  ref1[9].type    = 2;                                                        \n"
"  ref1[9].ccol[0] = 0.019608;                                                 \n"
"  ref1[9].ccol[1] = 0.019608;                                                 \n"
"  ref1[9].ccol[2] = 0.054902;                                                 \n"
"                                                                              \n"
"  ref1[10].type    = 2;                                                       \n"
"  ref1[10].ccol[0] = 0.035294;                                                \n"
"  ref1[10].ccol[1] = 0.015686;                                                \n"
"  ref1[10].ccol[2] = 0.0;                                                     \n"
"                                                                              \n"
"  ref1[11].type    = 2;                                                       \n"
"  ref1[11].ccol[0] = 0.035294;                                                \n"
"  ref1[11].ccol[1] = 0.015686;                                                \n"
"  ref1[11].ccol[2] = 0.0;                                                     \n"
"                                                                              \n"
"  ref1[12].type    = 3;                                                       \n"
"  ref1[12].ccol[0] = 0.133333;                                                \n"
"  ref1[12].ccol[1] = 0.074510;                                                \n"
"  ref1[12].ccol[2] = 0.0;                                                     \n"
"                                                                              \n"
"  ref1[13].type    = 3;                                                       \n"
"  ref1[13].ccol[0] = 0.054902;                                                \n"
"  ref1[13].ccol[1] = 0.101961;                                                \n"
"  ref1[13].ccol[2] = 0.0;                                                     \n"
"                                                                              \n"
"  ref1[14].type    = 3;                                                       \n"
"  ref1[14].ccol[0] = 0.039216;                                                \n"
"  ref1[14].ccol[1] = 0.098039;                                                \n"
"  ref1[14].ccol[2] = 0.050980;                                                \n"
"                                                                              \n"
"  ref1[15].type    = 4;                                                       \n"
"  ref1[15].ccol[0] = 0.035294;                                                \n"
"  ref1[15].ccol[1] = 0.0;                                                     \n"
"  ref1[15].ccol[2] = 0.066667;                                                \n"
"                                                                              \n"
"  ref1[16].type    = 4;                                                       \n"
"  ref1[16].ccol[0] = 0.035294;                                                \n"
"  ref1[16].ccol[1] = 0.062745;                                                \n"
"  ref1[16].ccol[2] = 0.019608;                                                \n"
"                                                                              \n"
"  ref1[17].type   = 4;                                                        \n"
"  ref1[17].ccol[0] = 0.066667;                                                \n"
"  ref1[17].ccol[1] = 0.015686;                                                \n"
"  ref1[17].ccol[2] = 0.0;                                                     \n"
"                                                                              \n"
"  ref1[18].type   = 4;                                                        \n"
"  ref1[18].ccol[0] = 0.066667;                                                \n"
"  ref1[18].ccol[1] = 0.015686;                                                \n"
"  ref1[18].ccol[2] = 0.0;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"update_params (gdouble sx,                                                    \n"
"               gdouble sy,                                                    \n"
"               gint    width,                                                 \n"
"               gint    height,                                                \n"
"               LfParamsType *params)                                          \n"
"{                                                                             \n"
"  gint xh, yh, dx, dy, matt;                                                  \n"
"  Reflect *ref1 = params->ref;                                                \n"
"                                                                              \n"
"  params->center_x = gegl_coordinate_relative_to_pixel(sx,                    \n"
"                                                       width);                \n"
"  params->center_y = gegl_coordinate_relative_to_pixel(sy,                    \n"
"                                                       height);               \n"
"                                                                              \n"
"  matt = width;                                                               \n"
"                                                                              \n"
"  params->color_size = (gfloat) matt * 0.0375;                                \n"
"  params->glow_size  = (gfloat) matt * 0.078125;                              \n"
"  params->inner_size = (gfloat) matt * 0.1796875;                             \n"
"  params->outer_size = (gfloat) matt * 0.3359375;                             \n"
"  params->halo_size  = (gfloat) matt * 0.084375;                              \n"
"                                                                              \n"
"  xh = width / 2;                                                             \n"
"  yh = height / 2;                                                            \n"
"  dx = xh - params->center_x;                                                 \n"
"  dy = yh - params->center_y;                                                 \n"
"                                                                              \n"
"  ref1[0].size    = (gfloat) matt * 0.027;                                    \n"
"  ref1[0].xp      = 0.6699 * dx + xh;                                         \n"
"  ref1[0].yp      = 0.6699 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[1].size    = (gfloat) matt * 0.01;                                     \n"
"  ref1[1].xp      = 0.2692 * dx + xh;                                         \n"
"  ref1[1].yp      = 0.2692 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[2].size    = (gfloat) matt * 0.005;                                    \n"
"  ref1[2].xp      = -0.0112 * dx + xh;                                        \n"
"  ref1[2].yp      = -0.0112 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[3].size    = (gfloat) matt * 0.031;                                    \n"
"  ref1[3].xp      = 0.6490 * dx + xh;                                         \n"
"  ref1[3].yp      = 0.6490 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[4].size    = (gfloat) matt * 0.015;                                    \n"
"  ref1[4].xp      = 0.4696 * dx + xh;                                         \n"
"  ref1[4].yp      = 0.4696 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[5].size    = (gfloat) matt * 0.037;                                    \n"
"  ref1[5].xp      = 0.4087 * dx + xh;                                         \n"
"  ref1[5].yp      = 0.4087 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[6].size    = (gfloat) matt * 0.022;                                    \n"
"  ref1[6].xp      = -0.2003 * dx + xh;                                        \n"
"  ref1[6].yp      = -0.2003 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[7].size    = (gfloat) matt * 0.025;                                    \n"
"  ref1[7].xp      = -0.4103 * dx + xh;                                        \n"
"  ref1[7].yp      = -0.4103 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[8].size    = (gfloat) matt * 0.058;                                    \n"
"  ref1[8].xp      = -0.4503 * dx + xh;                                        \n"
"  ref1[8].yp      = -0.4503 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[9].size    = (gfloat) matt * 0.017;                                    \n"
"  ref1[9].xp      = -0.5112 * dx + xh;                                        \n"
"  ref1[9].yp      = -0.5112 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[10].size    = (gfloat) matt * 0.2;                                     \n"
"  ref1[10].xp      = -1.496 * dx + xh;                                        \n"
"  ref1[10].yp      = -1.496 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[11].size    = (gfloat) matt * 0.5;                                     \n"
"  ref1[11].xp      = -1.496 * dx + xh;                                        \n"
"  ref1[11].yp      = -1.496 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[12].size    = (gfloat) matt * 0.075;                                   \n"
"  ref1[12].xp      = 0.4487 * dx + xh;                                        \n"
"  ref1[12].yp      = 0.4487 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[13].size    = (gfloat) matt * 0.1;                                     \n"
"  ref1[13].xp      = dx + xh;                                                 \n"
"  ref1[13].yp      = dy + yh;                                                 \n"
"                                                                              \n"
"  ref1[14].size    = (gfloat) matt * 0.039;                                   \n"
"  ref1[14].xp      = -1.301 * dx + xh;                                        \n"
"  ref1[14].yp      = -1.301 * dy + yh;                                        \n"
"                                                                              \n"
"  ref1[15].size    = (gfloat) matt * 0.19;                                    \n"
"  ref1[15].xp      = 1.309 * dx + xh;                                         \n"
"  ref1[15].yp      = 1.309 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[16].size    = (gfloat) matt * 0.195;                                   \n"
"  ref1[16].xp      = 1.309 * dx + xh;                                         \n"
"  ref1[16].yp      = 1.309 * dy + yh;                                         \n"
"                                                                              \n"
"  ref1[17].size   = (gfloat) matt * 0.20;                                     \n"
"  ref1[17].xp     = 1.309 * dx + xh;                                          \n"
"  ref1[17].yp     = 1.309 * dy + yh;                                          \n"
"                                                                              \n"
"  ref1[18].size   = (gfloat) matt * 0.038;                                    \n"
"  ref1[18].xp     = -1.301 * dx + xh;                                         \n"
"  ref1[18].yp     = -1.301 * dy + yh;                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  const Babl     *format = babl_format (\"R'G'B'A float\");                   \n"
"  LfParamsType   *params = NULL;                                              \n"
"                                                                              \n"
"  if (o->user_data == NULL)                                                   \n"
"    o->user_data = g_slice_new0 (LfParamsType);                               \n"
"                                                                              \n"
"  params = (LfParamsType *) o->user_data;                                     \n"
"                                                                              \n"
"  init_params (params, o);                                                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      g_slice_free (LfParamsType, o->user_data);                              \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  LfParamsType   *params = (LfParamsType *) o->user_data;                     \n"
"  GeglRectangle  *whole_region;                                               \n"
"                                                                              \n"
"  gint    x, y, b, idx, i;                                                    \n"
"  gfloat  hyp;                                                                \n"
"  gfloat  procent;                                                            \n"
"  gfloat *pixel;                                                              \n"
"  gfloat *input = in_buf;                                                     \n"
"  gfloat *output = out_buf;                                                   \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  update_params (o->pos_x,                                                    \n"
"                 o->pos_y,                                                    \n"
"                 whole_region->width,                                         \n"
"                 whole_region->height,                                        \n"
"                 params);                                                     \n"
"                                                                              \n"
"  pixel = g_new (gfloat, 3);                                                  \n"
"                                                                              \n"
"  for (y = 0; y < roi->height; y++)                                           \n"
"    {                                                                         \n"
"      for (x = 0; x < roi->width; x++)                                        \n"
"        {                                                                     \n"
"          idx = (x + y * roi->width) * 4;                                     \n"
"                                                                              \n"
"          for (b = 0; b < 3; b++)                                             \n"
"            pixel[b] = input[idx + b];                                        \n"
"                                                                              \n"
"          hyp = hypot (x + roi->x - params->center_x,                         \n"
"                       y + roi->y - params->center_y);                        \n"
"                                                                              \n"
"          /* center color */                                                  \n"
"          procent = params->color_size - hyp;                                 \n"
"          procent /= params->color_size;                                      \n"
"          if (procent > 0.0)                                                  \n"
"            {                                                                 \n"
"              procent *= procent;                                             \n"
"              fixpix (pixel, procent, params->color);                         \n"
"            }                                                                 \n"
"                                                                              \n"
"          /* glow color */                                                    \n"
"          procent = params->glow_size - hyp;                                  \n"
"          procent /= params->glow_size;                                       \n"
"          if (procent > 0.0)                                                  \n"
"            {                                                                 \n"
"              procent *= procent;                                             \n"
"              fixpix (pixel, procent, params->glow);                          \n"
"            }                                                                 \n"
"                                                                              \n"
"          /* inner color */                                                   \n"
"          procent = params->inner_size - hyp;                                 \n"
"          procent /= params->inner_size;                                      \n"
"          if (procent > 0.0)                                                  \n"
"            {                                                                 \n"
"              procent *= procent;                                             \n"
"              fixpix (pixel, procent, params->inner);                         \n"
"            }                                                                 \n"
"                                                                              \n"
"          /* outer color */                                                   \n"
"          procent = params->outer_size - hyp;                                 \n"
"          procent /= params->outer_size;                                      \n"
"          if (procent > 0.0)                                                  \n"
"            fixpix (pixel, procent, params->outer);                           \n"
"                                                                              \n"
"          /* halo color */                                                    \n"
"          procent = hyp - params->halo_size;                                  \n"
"          procent /= (params->halo_size * 0.07);                              \n"
"          procent  = fabs (procent);                                          \n"
"          if (procent < 1.0)                                                  \n"
"            fixpix (pixel, 1.0 - procent, params->halo);                      \n"
"                                                                              \n"
"          /* generate reflections */                                          \n"
"                                                                              \n"
"          for (i = 0; i < NUMREF; i++)                                        \n"
"            {                                                                 \n"
"              Reflect r = params->ref[i];                                     \n"
"              gdouble hyp = hypot (x + roi->x - r.xp,                         \n"
"                                   y + roi->y - r.yp);                        \n"
"              switch (r.type)                                                 \n"
"                {                                                             \n"
"                  case 1:                                                     \n"
"                    procent = r.size - hyp;                                   \n"
"                    procent /= r.size;                                        \n"
"                    if (procent > 0.0)                                        \n"
"                      {                                                       \n"
"                        procent *= procent;                                   \n"
"                        fixpix (pixel, procent, (gdouble *) &r.ccol);         \n"
"                      }                                                       \n"
"                    break;                                                    \n"
"                  case 2:                                                     \n"
"                    procent  = r.size - hyp;                                  \n"
"                    procent /= (r.size * 0.15);                               \n"
"                                                                              \n"
"                    if (procent > 0.0)                                        \n"
"                      {                                                       \n"
"                        if (procent > 1.0)                                    \n"
"                          procent = 1.0;                                      \n"
"                                                                              \n"
"                        fixpix (pixel, procent, (gdouble *) &r.ccol);         \n"
"                      }                                                       \n"
"                    break;                                                    \n"
"                  case 3:                                                     \n"
"                    procent  = r.size - hyp;                                  \n"
"                    procent /= (r.size * 0.12);                               \n"
"                                                                              \n"
"                    if (procent > 0.0)                                        \n"
"                      {                                                       \n"
"                        if (procent > 1.0)                                    \n"
"                          procent = 1.0 - (procent * 0.12);                   \n"
"                                                                              \n"
"                        fixpix (pixel, procent, (gdouble *) &r.ccol);         \n"
"                      }                                                       \n"
"                    break;                                                    \n"
"                  case 4:                                                     \n"
"                    procent  = hyp - r.size;                                  \n"
"                    procent /= (r.size * 0.04);                               \n"
"                    procent  = fabs (procent);                                \n"
"                                                                              \n"
"                   if (procent < 1.0)                                         \n"
"                     fixpix (pixel, 1.0 - procent, (gdouble *) &r.ccol);      \n"
"                   break;                                                     \n"
"                }                                                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          /* write result to output */                                        \n"
"                                                                              \n"
"          for (b = 0; b < 3; b++)                                             \n"
"            output[idx + b] = pixel[b];                                       \n"
"                                                                              \n"
"          output[idx + 3] = input[idx + 3];                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (pixel);                                                             \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass                  *object_class;                                \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:lens-flare\",                                     \n"
"    \"title\",       _(\"Lens Flare\"),                                       \n"
"    \"categories\",  \"light\",                                               \n"
"    \"reference-hash\", \"aaa25d98fa6ab089a74e026ef5cdf45b\",                 \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"Adds a lens flare effect.\"),                        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
