static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <stdlib.h>                                                           \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_object(node, _(\"Node\"), GEGL_TYPE_NODE)                            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_NAME     introspect                                           \n"
"#define GEGL_OP_C_SOURCE introspect.c                                         \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"gchar *gegl_to_dot                       (GeglNode       *node);              \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_introspect_load_cache (GeglProperties *op_introspect)                    \n"
"{                                                                             \n"
"  GeglBuffer *new_buffer   = NULL;                                            \n"
"  GeglNode   *png_load     = NULL;                                            \n"
"  GeglNode   *buffer_sink  = NULL;                                            \n"
"  gchar      *dot_string   = NULL;                                            \n"
"  gchar      *png_filename = NULL;                                            \n"
"  gchar      *dot_filename = NULL;                                            \n"
"  gchar      *dot_cmd      = NULL;                                            \n"
"                                                                              \n"
"  if (op_introspect->user_data || op_introspect->node == NULL)                \n"
"    return;                                                                   \n"
"                                                                              \n"
"  /* Construct temp filenames */                                              \n"
"  dot_filename = g_build_filename (g_get_tmp_dir (), \"gegl-introspect.dot\", NULL);\n"
"  png_filename = g_build_filename (g_get_tmp_dir (), \"gegl-introspect.png\", NULL);\n"
"                                                                              \n"
"  /* Construct the .dot source */                                             \n"
"  dot_string = gegl_to_dot (GEGL_NODE (op_introspect->node));                 \n"
"  g_file_set_contents (dot_filename, dot_string, -1, NULL);                   \n"
"                                                                              \n"
"  /* Process the .dot to a .png */                                            \n"
"  dot_cmd = g_strdup_printf (\"dot -o %s -Tpng %s\", png_filename, dot_filename);\n"
"  if (system (dot_cmd) == -1)                                                 \n"
"    g_warning (\"Error executing GraphViz dot program\");                     \n"
"                                                                              \n"
"  /* Create a graph that loads the png into a GeglBuffer and process          \n"
"   * it                                                                       \n"
"   */                                                                         \n"
"  png_load = gegl_node_new_child (NULL,                                       \n"
"                                  \"operation\", \"gegl:png-load\",           \n"
"                                  \"path\",      png_filename,                \n"
"                                  NULL);                                      \n"
"  buffer_sink = gegl_node_new_child (NULL,                                    \n"
"                                     \"operation\", \"gegl:buffer-sink\",     \n"
"                                     \"buffer\",    &new_buffer,              \n"
"                                     NULL);                                   \n"
"  gegl_node_link_many (png_load, buffer_sink, NULL);                          \n"
"  gegl_node_process (buffer_sink);                                            \n"
"                                                                              \n"
"  op_introspect->user_data= new_buffer;                                       \n"
"                                                                              \n"
"  /* Cleanup */                                                               \n"
"  g_object_unref (buffer_sink);                                               \n"
"  g_object_unref (png_load);                                                  \n"
"  g_free (dot_string);                                                        \n"
"  g_free (dot_cmd);                                                           \n"
"  g_free (dot_filename);                                                      \n"
"  g_free (png_filename);                                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_introspect_dispose (GObject *object)                                     \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data != NULL)                                                   \n"
"    {                                                                         \n"
"      g_object_unref (o->user_data);                                          \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->dispose (object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_introspect_get_bounding_box (GeglOperation *operation)                   \n"
"{                                                                             \n"
"  GeglRectangle   result = {0,0,0,0};                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gint width, height;                                                         \n"
"                                                                              \n"
"  gegl_introspect_load_cache (o);                                             \n"
"                                                                              \n"
"  g_object_get (o->user_data, \"width\", &width,                              \n"
"                               \"height\", &height, NULL);                    \n"
"                                                                              \n"
"  result.width  = width;                                                      \n"
"  result.height = height;                                                     \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_introspect_process (GeglOperation        *operation,                     \n"
"                         GeglOperationContext *context,                       \n"
"                         const gchar          *output_pad,                    \n"
"                         const GeglRectangle  *result,                        \n"
"                         gint                  level)                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  gegl_introspect_load_cache (o);                                             \n"
"                                                                              \n"
"  if (!o->user_data)                                                          \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  /* gegl_operation_context_take_object() takes the reference we have,        \n"
"   * so we must increase it since we want to keep the object                  \n"
"   */                                                                         \n"
"  g_object_ref (o->user_data);                                                \n"
"                                                                              \n"
"  gegl_operation_context_take_object (context, output_pad, G_OBJECT (o->user_data));\n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  object_class->dispose             = gegl_introspect_dispose;                \n"
"                                                                              \n"
"  operation_class->process          = gegl_introspect_process;                \n"
"  operation_class->get_bounding_box = gegl_introspect_get_bounding_box;       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:introspect\",                                     \n"
"    \"categories\" , \"render\",                                              \n"
"    \"description\", _(\"GEGL graph visualizer.\"),                           \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
