static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2016 Thomas Manni <thomas.manni@free.fr>                         \n"
" */                                                                           \n"
"                                                                              \n"
" /* compute gradient magnitude and/or direction by central differencies */    \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_imagegradient_output)                                        \n"
"   enum_value (GEGL_IMAGEGRADIENT_MAGNITUDE, \"magnitude\", N_(\"Magnitude\"))\n"
"   enum_value (GEGL_IMAGEGRADIENT_DIRECTION, \"direction\", N_(\"Direction\"))\n"
"   enum_value (GEGL_IMAGEGRADIENT_BOTH,      \"both\",      N_(\"Both\"))     \n"
"enum_end (GeglImageGradientOutput)                                            \n"
"                                                                              \n"
"property_enum (output_mode, _(\"Output mode\"),                               \n"
"               GeglImageGradientOutput, gegl_imagegradient_output,            \n"
"               GEGL_IMAGEGRADIENT_MAGNITUDE)                                  \n"
"  description (_(\"Output Mode\"))                                            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME         image_gradient                                   \n"
"#define GEGL_OP_C_SOURCE     image-gradient.c                                 \n"
"                                                                              \n"
"#define POW2(x) ((x)*(x))                                                     \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area       = GEGL_OPERATION_AREA_FILTER (operation);\n"
"  GeglProperties          *o          = GEGL_PROPERTIES (operation);          \n"
"  const Babl              *rgb_format = babl_format (\"R'G'B' float\");       \n"
"  const Babl              *out_format = babl_format_n (babl_type (\"float\"), 2);\n"
"                                                                              \n"
"  area->left   =                                                              \n"
"  area->top    =                                                              \n"
"  area->right  =                                                              \n"
"  area->bottom = 1;                                                           \n"
"                                                                              \n"
"  if (o->output_mode == GEGL_IMAGEGRADIENT_MAGNITUDE ||                       \n"
"      o->output_mode == GEGL_IMAGEGRADIENT_DIRECTION)                         \n"
"    {                                                                         \n"
"      out_format = babl_format_n (babl_type (\"float\"), 1);                  \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  rgb_format);              \n"
"  gegl_operation_set_format (operation, \"output\", out_format);              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (in_rect)                                                                \n"
"    {                                                                         \n"
"      result = *in_rect;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties  *o          = GEGL_PROPERTIES (operation);                  \n"
"  const Babl      *in_format  = babl_format (\"R'G'B' float\");               \n"
"  const Babl      *out_format = gegl_operation_get_format (operation, \"output\");\n"
"  gfloat *row1;                                                               \n"
"  gfloat *row2;                                                               \n"
"  gfloat *row3;                                                               \n"
"  gfloat *row4;                                                               \n"
"  gfloat *top_ptr;                                                            \n"
"  gfloat *mid_ptr;                                                            \n"
"  gfloat *down_ptr;                                                           \n"
"  gfloat *tmp_ptr;                                                            \n"
"  gint    x, y;                                                               \n"
"  gint    n_components;                                                       \n"
"                                                                              \n"
"  GeglRectangle row_rect;                                                     \n"
"  GeglRectangle out_rect;                                                     \n"
"                                                                              \n"
"  n_components = babl_format_get_n_components (out_format);                   \n"
"  row1 = g_new (gfloat, (roi->width + 2) * 3);                                \n"
"  row2 = g_new (gfloat, (roi->width + 2) * 3);                                \n"
"  row3 = g_new (gfloat, (roi->width + 2) * 3);                                \n"
"  row4 = g_new0 (gfloat, roi->width * n_components);                          \n"
"                                                                              \n"
"  top_ptr  = row1;                                                            \n"
"  mid_ptr  = row2;                                                            \n"
"  down_ptr = row3;                                                            \n"
"                                                                              \n"
"  row_rect.width = roi->width + 2;                                            \n"
"  row_rect.height = 1;                                                        \n"
"  row_rect.x = roi->x - 1;                                                    \n"
"  row_rect.y = roi->y - 1;                                                    \n"
"                                                                              \n"
"  out_rect.x      = roi->x;                                                   \n"
"  out_rect.width  = roi->width;                                               \n"
"  out_rect.height = 1;                                                        \n"
"                                                                              \n"
"  gegl_buffer_get (input, &row_rect, 1.0, in_format, top_ptr,                 \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                    \n"
"                                                                              \n"
"  row_rect.y++;                                                               \n"
"  gegl_buffer_get (input, &row_rect, 1.0, in_format, mid_ptr,                 \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                    \n"
"                                                                              \n"
"  for (y = roi->y; y < roi->y + roi->height; y++)                             \n"
"    {                                                                         \n"
"      row_rect.y = y + 1;                                                     \n"
"      out_rect.y = y;                                                         \n"
"                                                                              \n"
"      gegl_buffer_get (input, &row_rect, 1.0, in_format, down_ptr,            \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_CLAMP);                \n"
"                                                                              \n"
"      for (x = 1; x < row_rect.width - 1; x++)                                \n"
"        {                                                                     \n"
"          gfloat dx[3];                                                       \n"
"          gfloat dy[3];                                                       \n"
"          gfloat magnitude[3];                                                \n"
"          gint   max_index;                                                   \n"
"                                                                              \n"
"          dx[0] = (mid_ptr[(x-1) * 3] - mid_ptr[(x+1) * 3]);                  \n"
"          dy[0] = (top_ptr[x*3] - down_ptr[x*3]);                             \n"
"          magnitude[0] = sqrtf(POW2(dx[0]) + POW2(dy[0]));                    \n"
"                                                                              \n"
"          dx[1] = (mid_ptr[(x-1) * 3 + 1] - mid_ptr[(x+1) * 3 + 1]);          \n"
"          dy[1] = (top_ptr[x*3 + 1] - down_ptr[x*3 + 1]);                     \n"
"          magnitude[1] = sqrtf(POW2(dx[1]) + POW2(dy[1]));                    \n"
"                                                                              \n"
"          dx[2] = (mid_ptr[(x-1) * 3 + 2] - mid_ptr[(x+1) * 3 + 2]);          \n"
"          dy[2] = (top_ptr[x*3 + 2] - down_ptr[x*3 + 2]);                     \n"
"          magnitude[2] = sqrtf(POW2(dx[2]) + POW2(dy[2]));                    \n"
"                                                                              \n"
"          if (magnitude[0] > magnitude[1])                                    \n"
"            max_index = 0;                                                    \n"
"          else                                                                \n"
"            max_index = 1;                                                    \n"
"                                                                              \n"
"          if (magnitude[2] > magnitude[max_index])                            \n"
"            max_index = 2;                                                    \n"
"                                                                              \n"
"          if (o->output_mode == GEGL_IMAGEGRADIENT_MAGNITUDE)                 \n"
"            {                                                                 \n"
"              row4[(x-1) * n_components] = magnitude[max_index];              \n"
"            }                                                                 \n"
"          else                                                                \n"
"           {                                                                  \n"
"              gfloat direction = atan2 (dy[max_index], dx[max_index]);        \n"
"                                                                              \n"
"              if (o->output_mode == GEGL_IMAGEGRADIENT_DIRECTION)             \n"
"                {                                                             \n"
"                  row4[(x-1) * n_components] = direction;                     \n"
"                }                                                             \n"
"              else                                                            \n"
"                {                                                             \n"
"                  row4[(x-1) * n_components] = magnitude[max_index];          \n"
"                  row4[(x-1) * n_components + 1] = direction;                 \n"
"                }                                                             \n"
"           }                                                                  \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_buffer_set (output, &out_rect, level, out_format, row4,            \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      tmp_ptr = top_ptr;                                                      \n"
"      top_ptr = mid_ptr;                                                      \n"
"      mid_ptr = down_ptr;                                                     \n"
"      down_ptr = tmp_ptr;                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (row1);                                                              \n"
"  g_free (row2);                                                              \n"
"  g_free (row3);                                                              \n"
"  g_free (row4);                                                              \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process             = process;                                \n"
"  operation_class->prepare          = prepare;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->opencl_support   = FALSE;                                  \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:image-gradient\",                                 \n"
"    \"title\",       _(\"Image Gradient\"),                                   \n"
"    \"categories\",  \"edge-detect\",                                         \n"
"    \"reference-hash\", \"3bc1f4413a06969bf86606d621969651\",                 \n"
"    \"description\", _(\"Compute gradient magnitude and/or direction by \"    \n"
"                     \"central differencies\"),                               \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
